/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.editors.JCMultilineCellEditor;
import com.klg.jclass.util.swing.JCWordWrap;
import java.awt.AWTEvent;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

public class JCWordWrapCellEditor
extends JCMultilineCellEditor {
    protected JCCellInfo cellInfo;
    protected boolean editable = true;
    protected final int VERTICAL_SB_WIDTH = 25;

    public JCWordWrapCellEditor() {
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        super.initialize(aWTEvent, jCCellInfo, object);
        this.cellInfo = jCCellInfo;
        this.editable = jCCellInfo.isEditable();
    }

    public Object getCellEditorValue() {
        if (this.editable) {
            return JCWordWrap.replace(this.getText(), "\n", " ");
        }
        return this.data;
    }

    protected String unwrapText(String string) {
        return JCWordWrap.replace(string, "\n", "");
    }

    protected String wrapText(String string) {
        String string2 = "";
        if (string != null) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return string;
            }
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
            Insets insets = this.cellInfo.getBorderInsets();
            int n2 = this.cellInfo.getDrawingArea().width + insets.left + insets.right;
            string2 = JCWordWrap.wrapText(string, fontMetrics, n2 - 25, "\n", true);
        }
        return string2;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.setText(this.unwrapText(this.getText()));
    }
}

