/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCCellTextEditor;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.cell.validate.ValidateSupport;
import com.klg.jclass.util.JCEnvironment;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JCMultilineCellEditor
extends JScrollPane
implements JCCellTextEditor,
KeyListener,
FocusListener {
    protected Object data;
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected boolean selectAll = false;
    protected ValidateSupport validateSupport = new ValidateSupport();
    protected JCKeyModifier[] keys = null;
    protected JTextArea text = null;
    protected int caretPosition;
    protected AWTEvent initialEvent;

    public JCMultilineCellEditor() {
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.text = new JTextArea();
        this.getViewport().add(this.text);
        this.setDoubleBuffered(true);
        this.text.setDoubleBuffered(true);
        this.text.addKeyListener(this);
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        this.initialEvent = aWTEvent;
        this.data = object;
        this.selectAll = jCCellInfo.getSelectAll();
        this.text.setEditable(jCCellInfo.isEditable());
        if (!this.text.isEditable()) {
            this.selectAll = false;
        }
        this.caretPosition = aWTEvent instanceof KeyEvent && this.data != null ? this.data.toString().length() : -1;
        this.initData();
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
        this.requestFocus();
    }

    public Component getComponent() {
        this.validate();
        this.text.setVisible(true);
        this.text.requestFocus();
        return this;
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public String getCellEditorText() {
        return this.getText();
    }

    public void setCellEditorText(String string) {
        this.setText(string);
    }

    protected boolean fireValidated(JCValidateEvent jCValidateEvent) {
        boolean bl = this.validateSupport.fireValidateEvents(jCValidateEvent);
        if (bl) {
            this.setVisible(true);
        }
        return bl;
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        JCValidateEvent jCValidateEvent = new JCValidateEvent(this, this.data, string, true);
        boolean bl = this.fireValidated(jCValidateEvent);
        if (bl) {
            this.selectAllText();
        }
        return bl;
    }

    public boolean isModified() {
        Object object = this.getCellEditorValue();
        if (this.data == null || this.data.equals("")) {
            return object != null && !object.equals("");
        }
        return !this.data.equals(object);
    }

    public void cancelCellEditing() {
        this.initData();
        this.selectAllText();
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public String getText() {
        return this.text.getText();
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    public JTextArea getEditor() {
        return this.text;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        return this.getPreferredSize();
    }

    public JCKeyModifier[] getReservedKeys() {
        if (this.keys == null) {
            this.keys = new JCKeyModifier[9];
            this.keys[0] = new JCKeyModifier(10);
            this.keys[1] = new JCKeyModifier(40);
            this.keys[2] = new JCKeyModifier(38);
            this.keys[3] = new JCKeyModifier(37);
            this.keys[4] = new JCKeyModifier(39);
            this.keys[5] = new JCKeyModifier(33);
            this.keys[6] = new JCKeyModifier(34);
            this.keys[7] = new JCKeyModifier(36);
            this.keys[8] = new JCKeyModifier(35);
        }
        return this.keys;
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isVisible()) {
            if (JCEnvironment.getJavaVersion() >= 140) {
                super.processKeyEvent(keyEvent);
            } else {
                FocusManager focusManager = FocusManager.getCurrentManager();
                FocusManager.disableSwingFocusManager();
                super.processKeyEvent(keyEvent);
                FocusManager.setCurrentManager(focusManager);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            default: {
                if (keyEvent.getComponent() != this.text) break;
                this.processKeyEvent(new KeyEvent(this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void initData() {
        this.setText(this.data == null ? "" : this.data.toString());
    }

    public void selectAllText() {
        if (!this.isDisplayable()) {
            return;
        }
        if (this.getSelectAll()) {
            try {
                this.text.setCaretPosition(0);
                this.text.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.text.selectAll();
        }
        this.text.requestFocus();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        JTextArea jTextArea = this.getEditor();
        jTextArea.setVisible(bl);
        if (!bl) {
            return;
        }
        String string = this.getText();
        if (string == null) {
            return;
        }
        if (this.caretPosition == -1) {
            this.caretPosition = string.length();
            if (this.initialEvent != null && this.initialEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)this.initialEvent;
                Component component = (Component)mouseEvent.getSource();
                Component component2 = this.getComponent();
                Point point = new Point(0, 0);
                if (component2 != component) {
                    Container container = this.getParent();
                    point.setLocation(component2.getLocation());
                    while (container != null && container != component) {
                        point.translate(container.getLocation().x, container.getLocation().y);
                        component2 = container;
                        container = component2.getParent();
                    }
                    if (container == null) {
                        point.setLocation(0, 0);
                    }
                }
                this.caretPosition = jTextArea.viewToModel(new Point(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y));
            }
        }
        this.caretPosition = Math.min(this.caretPosition, string.length());
        jTextArea.select(this.caretPosition, this.caretPosition);
        this.selectAllText();
    }

    public void addValidateListener(JCValidateListener jCValidateListener) {
        this.validateSupport.addValidateListener(jCValidateListener);
    }

    public void removeValidateListener(JCValidateListener jCValidateListener) {
        this.validateSupport.removeValidateListener(jCValidateListener);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.text.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

