/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.beans.JCBeanInfo;
import com.klg.jclass.util.swing.JCFontChooserPane;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class FontStringEditor
implements PropertyEditor,
JCFontListener {
    public static final String FONT_EDITOR = "Font Editor";
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String target = "";
    protected JCFontChooserPane fontChooser = null;

    public void setValue(Object object) {
        this.target = (String)object;
    }

    public Object getValue() {
        return this.target;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(JCBeanInfo.getLocaleManager().getString(FONT_EDITOR), rectangle.x + 2, rectangle.y + rectangle.height - n2);
    }

    public String getAsText() {
        return this.target;
    }

    public void setAsText(String string) {
        this.target = string;
        if (this.support != null) {
            this.support.firePropertyChange("", null, this.getValue());
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.fontChooser == null) {
            this.fontChooser = new JCFontChooserPane();
            this.fontChooser.addJCFontListener(this);
            this.fontChooser.setStyleControls(3);
        }
        this.fontChooser.setSelectedFont(JCSwingTypeConverter.toFont(this.target));
        return this.fontChooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        return "\"" + this.target + "\"";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void fontChanging(JCFontEvent jCFontEvent) {
    }

    public void fontChanged(JCFontEvent jCFontEvent) {
        String string;
        if (jCFontEvent.getSource() == this.fontChooser && !this.target.equals(string = JCSwingTypeConverter.fromFont(this.fontChooser.getSelectedFont()))) {
            this.target = string;
            this.support.firePropertyChange("", null, null);
        }
    }

    static {
        JCBeanInfo.getLocaleManager().add("com.klg.jclass.beans.resources.LocaleInfo");
    }
}

