/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.packaging;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class PackageRenamer {
    protected static final int OLD = 0;
    protected static final int NEW = 1;
    protected static final int EXEMPT = 2;
    protected static String defaultSearchPrefix = "com.sun.java.";
    protected static String[][] defaultReplaceKeys = new String[][]{{"com.sun.java.swing", "javax.swing", "com.sun.java.swing.plaf.windows", "com.sun.java.swing.plaf.motif", "com.sun.java.swing.plaf.mac"}, {"com.sun.java.accessibility", "javax.accessibility", "com.sun.java.accessibility.util"}};
    protected String oldText;
    protected StringBuffer newText;
    protected int changes;

    protected static void usage() {
        System.err.println("java PackageRenamer <old> <new> [-e=<exempt> ...] <file1> [file2 ...]");
        System.exit(1);
    }

    protected static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public int replace() {
        if (this.oldText == null) {
            PackageRenamer.error("text input not initialized");
        }
        this.newText = this.replaceStrings(this.oldText, defaultSearchPrefix, defaultReplaceKeys);
        return this.changes;
    }

    protected StringBuffer replaceStrings(String source, String searchPrefix, String[][] replaceKeys) {
        StringBuffer result = new StringBuffer();
        int from = 0;
        while (from < source.length()) {
            String replaceString = null;
            int searchOffset = 0;
            int index = source.indexOf(searchPrefix, from);
            if (index != -1) {
                replaceString = searchPrefix;
                searchOffset = searchPrefix.length();
                block1: for (int i2 = 0; i2 < replaceKeys.length; ++i2) {
                    String oldString = replaceKeys[i2][0];
                    if (!source.regionMatches(index, oldString, 0, oldString.length())) continue;
                    replaceString = replaceKeys[i2][1];
                    searchOffset = replaceKeys[i2][0].length();
                    ++this.changes;
                    for (int k2 = 2; k2 < replaceKeys[i2].length; ++k2) {
                        String exempt = replaceKeys[i2][k2];
                        if (!source.regionMatches(index, exempt, 0, exempt.length())) continue;
                        replaceString = exempt;
                        searchOffset = exempt.length();
                        --this.changes;
                        break block1;
                    }
                    break;
                }
                result.append(source.substring(from, index));
                result.append(replaceString);
                from = index + searchOffset;
                continue;
            }
            result.append(source.substring(from));
            break;
        }
        return result;
    }

    public void load(File file) {
        try {
            char[] chars = new char[(int)file.length()];
            BufferedReader in = new BufferedReader(new FileReader(file));
            in.read(chars);
            in.close();
            this.oldText = new String(chars);
        }
        catch (Exception e2) {
            PackageRenamer.error("failed reading " + file.getName() + ": " + e2);
        }
    }

    public void save(File file) {
        try {
            char[] chars = this.newText.toString().toCharArray();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(chars);
            out.close();
        }
        catch (IOException e2) {
            PackageRenamer.error("failed writing " + file.getName() + ": " + e2);
        }
    }

    public static void main(String[] args) {
        int i2;
        int iArg = 0;
        int nArgs = args.length;
        if (nArgs < 3) {
            PackageRenamer.usage();
        }
        defaultSearchPrefix = args[0];
        for (i2 = 2; i2 < args.length && args[i2].startsWith("-e="); ++i2) {
        }
        defaultReplaceKeys = new String[1][i2];
        iArg = i2;
        for (i2 = 0; i2 < 2; ++i2) {
            PackageRenamer.defaultReplaceKeys[0][i2] = args[i2];
        }
        for (i2 = 2; i2 < args.length && args[i2].startsWith("-e="); ++i2) {
            PackageRenamer.defaultReplaceKeys[0][i2] = args[i2].substring(3);
        }
        Object reader = null;
        if (iArg == nArgs) {
            PackageRenamer.error("no files specified");
        }
        while (iArg < nArgs) {
            String fileName = args[iArg];
            File file = new File(fileName);
            if (!file.exists()) {
                System.err.println(fileName + " not found.");
            } else {
                System.out.print(fileName + ": ");
                System.out.flush();
                PackageRenamer renamer = new PackageRenamer();
                renamer.load(file);
                int changes = renamer.replace();
                if (changes > 0) {
                    File newFile = new File(fileName + "-new");
                    renamer.save(newFile);
                    File oldFile = new File(fileName + "-old");
                    if (oldFile.exists()) {
                        oldFile.delete();
                    }
                    file.renameTo(oldFile);
                    newFile.renameTo(new File(fileName));
                    System.out.println(Integer.toString(changes) + (changes > 1 ? " changes" : " change"));
                } else {
                    System.out.println("no changes");
                }
            }
            ++iArg;
        }
    }
}

