/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    int align;
    int hgap;
    int vgap;
    private boolean verticalFill = false;
    private boolean horizontalFill = true;

    public VerticalFlowLayout() {
        this(0, 5, 5);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public boolean isHorizontalFill() {
        return this.horizontalFill;
    }

    public void setHorizontalFill(boolean horizontalFill) {
        this.horizontalFill = horizontalFill;
    }

    public boolean isVerticalFill() {
        return this.verticalFill;
    }

    public void setVerticalFill(boolean verticalFill) {
        this.verticalFill = verticalFill;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getPreferredSize();
                dim.width = Math.max(dim.width, d2.width);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.height += this.vgap;
                }
                dim.height += d2.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getMinimumSize();
                dim.width = Math.max(dim.width, d2.width);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.height += this.vgap;
                }
                dim.height += d2.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxHeight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
            int nmembers = target.getComponentCount();
            int x = insets.left + this.hgap;
            int y = 0;
            int columnWidth = 0;
            int start = 0;
            boolean ttb = target.getComponentOrientation().isLeftToRight();
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getPreferredSize();
                m2.setSize(d2.width, d2.height);
                if (this.isVerticalFill() && i2 == nmembers - 1) {
                    d2.height = Math.max(maxHeight - y, m2.getPreferredSize().height);
                }
                if (y == 0 || y + d2.height <= maxHeight) {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d2.height;
                    columnWidth = Math.max(columnWidth, d2.width);
                    continue;
                }
                this.moveComponents(target, x, insets.top + this.vgap, columnWidth, maxHeight - y, start, i2, ttb);
                y = d2.height;
                x += this.hgap + columnWidth;
                columnWidth = d2.width;
                start = i2;
            }
            if (this.isHorizontalFill()) {
                for (Component component : target.getComponents()) {
                    component.setSize(columnWidth, component.getHeight());
                }
            }
            this.moveComponents(target, x, insets.top + this.vgap, columnWidth, maxHeight - y, start, nmembers, ttb);
        }
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int columnStart, int columnEnd, boolean ttb) {
        switch (this.align) {
            case 0: {
                y += ttb ? 0 : height;
                break;
            }
            case 1: {
                y += height / 2;
                break;
            }
            case 2: {
                y += ttb ? height : 0;
            }
        }
        for (int i2 = columnStart; i2 < columnEnd; ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            int cx = x + (width - m2.getSize().width) / 2;
            if (ttb) {
                m2.setLocation(cx, y);
            } else {
                m2.setLocation(cx, target.getSize().height - y - m2.getSize().height);
            }
            y += m2.getSize().height + this.vgap;
        }
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=top";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=bottom";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

