/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.gui;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;

public class BrowserUtil {
    private static final LogAdapter logger = LogFactory.getLogger(BrowserUtil.class);
    private static OSType osType;

    public static boolean openURL(String domain) {
        String url = "https://" + domain;
        Runtime rt = Runtime.getRuntime();
        try {
            switch (BrowserUtil.getOS()) {
                case Windows: {
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url).waitFor();
                    return true;
                }
                case MacOS: {
                    String[] cmd = new String[]{"open", url};
                    rt.exec(cmd).waitFor();
                    return true;
                }
                case Linux: 
                case Unix: {
                    String[] cmd = new String[]{"xdg-open", url};
                    rt.exec(cmd).waitFor();
                    return true;
                }
            }
            logger.warn((Serializable)((Object)("Cannot open browser on unknown operating system, URL=" + url)));
        }
        catch (IOException | InterruptedException e2) {
            logger.error("Failed to open browser for " + url + ": " + e2.getMessage(), e2);
        }
        return false;
    }

    public static OSType getOS() {
        if (osType == null) {
            String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            osType = os.contains("mac") || os.contains("darwin") ? OSType.MacOS : (os.contains("win") ? OSType.Windows : (os.contains("nux") ? OSType.Linux : (os.contains("aix") || os.contains("nix") ? OSType.Unix : OSType.Unknown)));
        }
        return osType;
    }

    public static boolean isJfxAvailable() {
        String agentppJavaFX = System.getProperty("com.agentpp.jfx", null);
        if (agentppJavaFX == null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass("javafx.embed.swing.JFXPanel");
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return Boolean.valueOf(agentppJavaFX);
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Unix,
        Unknown;

    }
}

