/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class ThreadPool {
    protected Vector<TaskManager> taskManagers;
    protected String name = "ThreadPool";
    protected volatile boolean stop = false;
    protected boolean respawnThreads = false;

    protected ThreadPool() {
    }

    protected String getTaskManagerName(String prefix, int index) {
        return prefix + "." + index;
    }

    protected void setup(String name, int size) {
        this.name = name;
        this.taskManagers = new Vector(size);
        for (int i2 = 0; i2 < size; ++i2) {
            TaskManager tm = new TaskManager(this.getTaskManagerName(name, i2));
            this.taskManagers.add(tm);
            tm.start();
        }
    }

    public static ThreadPool create(String name, int size) {
        ThreadPool pool = new ThreadPool();
        pool.setup(name, size);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task) {
        while (true) {
            for (int i2 = 0; i2 < this.taskManagers.size(); ++i2) {
                TaskManager tm = this.taskManagers.get(i2);
                if (this.respawnThreads && !tm.isAlive()) {
                    tm = new TaskManager(this.getTaskManagerName(this.name, i2));
                    this.taskManagers.set(i2, tm);
                }
                if (!tm.isIdle()) continue;
                try {
                    tm.execute(task);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean tryToExecute(Runnable task) {
        for (int i2 = 0; i2 < this.taskManagers.size(); ++i2) {
            TaskManager tm = this.taskManagers.get(i2);
            if (this.respawnThreads && !tm.isAlive()) {
                tm = new TaskManager(this.getTaskManagerName(this.name, i2));
                this.taskManagers.set(i2, tm);
            }
            if (!tm.isIdle()) continue;
            try {
                tm.execute(task);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRespawnThreads() {
        return this.respawnThreads;
    }

    public void setRespawnThreads(boolean respawnThreads) {
        this.respawnThreads = respawnThreads;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayList<TaskManager> taskManagerList;
        this.stop = true;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            taskManagerList = new ArrayList<TaskManager>(this.taskManagers);
        }
        for (TaskManager tm : taskManagerList) {
            tm.terminate();
            TaskManager taskManager = tm;
            synchronized (taskManager) {
                tm.notify();
            }
            try {
                tm.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void cancel() {
        this.stop = true;
        Iterator<TaskManager> iterator = this.taskManagers.iterator();
        while (iterator.hasNext()) {
            TaskManager taskManager;
            TaskManager tm = taskManager = iterator.next();
            tm.terminate();
            tm.interrupt();
        }
    }

    public synchronized void interrupt() {
        Iterator<TaskManager> iterator = this.taskManagers.iterator();
        while (iterator.hasNext()) {
            TaskManager taskManager;
            TaskManager tm = taskManager = iterator.next();
            tm.interrupt();
        }
    }

    public synchronized boolean isIdle() {
        for (TaskManager taskManager : this.taskManagers) {
            TaskManager tm = taskManager;
            if (tm.isIdle()) continue;
            return false;
        }
        return true;
    }

    class TaskManager
    extends Thread {
        private Runnable task;
        private volatile boolean run;

        public TaskManager(String name) {
            super(name);
            this.task = null;
            this.run = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            while (!ThreadPool.this.stop && this.run) {
                if (this.task != null) {
                    this.task.run();
                    this.task = null;
                    ThreadPool threadPool = ThreadPool.this;
                    synchronized (threadPool) {
                        ThreadPool.this.notify();
                        continue;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.run = ThreadPool.this.respawnThreads;
                    break;
                }
            }
        }

        public boolean isIdle() {
            return this.task == null && this.run;
        }

        public boolean isStopped() {
            return ThreadPool.this.stop;
        }

        public void terminate() {
            ThreadPool.this.stop = true;
        }

        public synchronized void execute(Runnable task) {
            if (this.task != null) {
                throw new IllegalStateException("TaskManager is not idle");
            }
            this.task = task;
            this.notify();
        }
    }
}

