/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Regex {
    private Pattern pattern;

    public void compile(String regex) throws ParseException {
        this.pattern = Pattern.compile("(?s)(.*)" + regex + "(.*)");
    }

    public void compileWithExactMatch(String regex) throws ParseException {
        this.pattern = Pattern.compile("(?s)" + regex);
    }

    public static String quote(String s) {
        return Pattern.quote(s);
    }

    public boolean match(String s) {
        if (this.pattern == null) {
            return false;
        }
        return this.pattern.matcher(s).matches();
    }

    public List<int[]> allMatchPositions(String s) {
        return this.allMatchPositions(s, 0);
    }

    public List<int[]> allMatchPositions(String s, int maxMatches) {
        ArrayList<int[]> matchList = new ArrayList<int[]>();
        Matcher matcher = this.pattern.matcher(s);
        int n2 = 0;
        while (matcher.find() && (maxMatches <= 0 || n2++ < maxMatches)) {
            int suffixLength = 0;
            int prefixLength = 0;
            int groupCount = matcher.groupCount();
            if (groupCount > 1) {
                String prefixGroup = matcher.group(1);
                String suffixGroup = matcher.group(groupCount);
                suffixLength = suffixGroup != null ? suffixGroup.length() : 0;
                prefixLength = prefixGroup != null ? prefixGroup.length() : 0;
            }
            matchList.add(new int[]{matcher.start() + prefixLength, matcher.end() - suffixLength});
        }
        return matchList;
    }

    public static boolean isRegex(String s) {
        try {
            Pattern.compile(s);
        }
        catch (PatternSyntaxException rex) {
            return false;
        }
        return true;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

