/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.ConfigFile;
import com.agentpp.util.UserConfigEvent;
import com.agentpp.util.UserConfigListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BaseConfig
extends ConfigFile {
    protected transient boolean allowZeroLengthValues = false;
    private transient List listeners;
    private transient boolean disableChangeEvents = false;

    public BaseConfig(boolean init) {
        super(init);
    }

    public void setConfigName(String s) {
        super.setConfigFile("" + System.getProperty("user.home") + System.getProperty("file.separator") + s);
    }

    public synchronized void addChangeListener(UserConfigListener l2) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(l2);
    }

    public synchronized boolean removeChangeListener(UserConfigListener l2) {
        if (this.listeners != null) {
            return this.listeners.remove(l2);
        }
        return false;
    }

    public void setDisableChangeEvents(boolean disableChangeEvents) {
        this.disableChangeEvents = disableChangeEvents;
    }

    public void put(String key, String s) {
        Object oldValue = this.properties.remove(key);
        if (s != null) {
            this.properties.put(key, s);
        }
        if (this.listeners != null && (s != null && !s.equals(oldValue) || oldValue != null && s == null)) {
            this.fireConfigChangedEvent(new UserConfigEvent(this, key, oldValue, s));
        }
    }

    public String get(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    public Vector getArray(String key) {
        String s = null;
        Vector<String> v = new Vector<String>();
        int i2 = 0;
        while ((s = this.get(key + i2++, null)) != null) {
            if (this.allowZeroLengthValues || s.length() > 0) {
                v.add(s);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public String[] getStringArray(String key, String[] def) {
        String s = null;
        ArrayList<String> v = new ArrayList<String>();
        int i2 = 0;
        while ((s = this.get(key + i2++, null)) != null) {
            if (this.allowZeroLengthValues || s.length() > 0) {
                v.add(s);
                continue;
            }
            v.add(null);
        }
        if (v.size() == 0) {
            return def;
        }
        return v.toArray(new String[v.size()]);
    }

    public Vector getArray(String key, int size) {
        String s = null;
        Vector<String> v = new Vector<String>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            s = this.get(key + i2, null);
            if (this.allowZeroLengthValues || s != null && s.length() > 0) {
                v.add(s);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public void putArray(String key, List v) {
        int i2 = 0;
        while (this.get(key + i2, null) != null) {
            this.remove(key + i2);
            ++i2;
        }
        if (v == null) {
            return;
        }
        for (i2 = 0; i2 < v.size(); ++i2) {
            if (v.get(i2) != null) {
                this.put(key + i2, v.get(i2).toString());
                continue;
            }
            this.remove(key + i2);
        }
        this.remove(key + i2);
    }

    public final void putTable(String[] keys, List<String[]> values) {
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String key = keys[i2];
            ArrayList<String> vlist = new ArrayList<String>(values.size());
            for (String[] row : values) {
                vlist.add(row[i2]);
            }
            this.putArray(key, vlist);
        }
    }

    public List<String[]> getTable(String[] keys) {
        ArrayList<String[]> v = new ArrayList<String[]>();
        ArrayList<Vector> cols = new ArrayList<Vector>(keys.length);
        int max = 0;
        for (int k2 = 0; k2 < keys.length; ++k2) {
            cols.add(this.getArray(keys[k2]));
            int cur = ((List)cols.get(cols.size() - 1)).size();
            if (cur <= max) continue;
            max = cur;
        }
        for (int i2 = 0; i2 < max; ++i2) {
            String[] row = new String[keys.length];
            for (int k3 = 0; k3 < keys.length; ++k3) {
                if (((List)cols.get(k3)).size() <= i2) continue;
                row[k3] = (String)((List)cols.get(k3)).get(i2);
            }
            v.add(row);
        }
        return v;
    }

    public void putInteger(String key, int value) {
        this.put(key, "" + value);
    }

    public int getInteger(String key, int defValue) {
        try {
            return Integer.parseInt(this.get(key, "" + defValue));
        }
        catch (NumberFormatException nfex) {
            return defValue;
        }
    }

    public void putLong(String key, long value) {
        this.put(key, "" + value);
    }

    public long getLong(String key, long defValue) {
        try {
            return Long.parseLong(this.get(key, "" + defValue));
        }
        catch (NumberFormatException nfex) {
            return defValue;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, "" + value);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return Boolean.valueOf(this.get(key, "" + defValue));
    }

    public void putEnumeration(String key, Enumeration e2) {
        int i2 = 0;
        while (e2.hasMoreElements()) {
            this.put(key + i2, e2.nextElement().toString());
            ++i2;
        }
        this.remove(key + i2);
    }

    public void remove(String key) {
        Object oldValue = this.properties.remove(key);
        if (this.listeners != null) {
            this.fireConfigChangedEvent(new UserConfigEvent(this, key, oldValue, null));
        }
    }

    public void removeAll(String keyPrefix) {
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(keyPrefix)) continue;
            this.remove(key);
        }
    }

    private synchronized void fireConfigChangedEvent(UserConfigEvent event) {
        if (this.listeners != null && !this.disableChangeEvents) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((UserConfigListener)it.next()).configChanged(event);
            }
        }
    }
}

