/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OctetString;

public class Principal {
    private UsmUser user;
    private byte[] authoritativeEngineID;

    public Principal(UsmUser user, byte[] engineID) {
        if (user == null || engineID == null) {
            throw new NullPointerException();
        }
        this.user = user;
        this.authoritativeEngineID = engineID;
    }

    public UsmUser getUser() {
        return this.user;
    }

    public void setUser(UsmUser newUser) {
        this.user = newUser;
    }

    public void setAuthoritativeEngineID(byte[] newAuthoritativeEngineID) {
        this.authoritativeEngineID = newAuthoritativeEngineID;
    }

    public byte[] getAuthoritativeEngineID() {
        return this.authoritativeEngineID;
    }

    private boolean compareObjects(Object a2, Object b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        if (a2 != null && b2 != null) {
            return a2.equals(b2);
        }
        return false;
    }

    public boolean equals(Object other) {
        try {
            if (other instanceof Principal) {
                Principal p2 = (Principal)other;
                OctetString aid = new OctetString(p2.authoritativeEngineID);
                OctetString bid = new OctetString(this.authoritativeEngineID);
                if (this.authoritativeEngineID.length != p2.authoritativeEngineID.length) {
                    return false;
                }
                for (int i2 = 0; i2 < this.authoritativeEngineID.length; ++i2) {
                    if (this.authoritativeEngineID[i2] == p2.authoritativeEngineID[i2]) continue;
                    return false;
                }
                if (!p2.user.getSecurityName().equals(this.user.getSecurityName())) {
                    return false;
                }
                if (p2.user.getSecurityModel() != this.user.getSecurityModel()) {
                    return false;
                }
                return this.compareObjects(p2.user.getAuthenticationProtocol(), this.user.getAuthenticationProtocol()) && this.compareObjects(p2.user.getAuthenticationPassphrase(), this.user.getAuthenticationPassphrase()) && this.compareObjects(p2.user.getPrivacyProtocol(), this.user.getPrivacyProtocol()) && this.compareObjects(p2.user.getPrivacyPassphrase(), this.user.getPrivacyPassphrase());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public String toString() {
        return this.user.getSecurityName() + "-" + new OctetString(this.authoritativeEngineID).toHexString();
    }
}

