/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.snmp.TargetStatistics;
import com.agentpp.snmp.UserProfile;
import java.io.Serializable;
import org.snmp4j.AbstractTarget;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.SecureTarget;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.util.SchedulerTask;
import org.snmp4j.util.TaskScheduler;
import org.snmp4j.util.ThreadPool;

public class GenTarget
implements Comparable,
Serializable {
    public static final long serialVersionUID = 4611240302686996959L;
    private static final LogAdapter logger = LogFactory.getLogger("SNMP");
    private String name;
    private OctetString community;
    private UserProfile user;
    private OctetString context = new OctetString();
    private OctetString contextEngineID = new OctetString();
    private int version;
    private int retries;
    private int timeout = 1000;
    private OctetString engineID = new OctetString();
    private String MIBSet;
    private volatile Address address;
    private volatile String resolvedAddress;
    private volatile boolean resolvePending;
    private String addressString;
    private String addressType;
    private volatile byte[] cachedEngineID;
    private volatile TargetStatistics targetStatistics = new TargetStatistics();
    private static TaskScheduler resolver;

    private GenTarget() {
        GenTarget.initResolver();
    }

    public GenTarget(String name, Address address) {
        this();
        this.name = name;
        this.setAddress(address);
    }

    public GenTarget(GenTarget other) {
        this();
        this.name = other.name;
        this.resolvedAddress = other.resolvedAddress;
        this.addressString = other.addressString;
        this.setAddress(other.address);
        this.addressType = other.addressType;
        this.context = other.context;
        this.contextEngineID = other.contextEngineID;
        this.version = other.version;
        this.retries = other.retries;
        this.community = other.community;
        this.timeout = other.timeout;
        this.engineID = other.engineID;
        this.user = other.user;
        this.MIBSet = other.MIBSet;
    }

    public GenTarget(Target t, String name) {
        this();
        this.name = name;
        this.addressType = t.getAddress() instanceof TcpAddress ? "TCP" : "UDP";
        this.setAddress(t.getAddress());
        this.timeout = (int)t.getTimeout();
        this.retries = t.getRetries();
        this.version = t.getVersion();
        if (t instanceof UserTarget) {
            UserTarget st = (UserTarget)t;
            this.engineID = new OctetString(st.getAuthoritativeEngineID());
        }
    }

    public GenTarget(String name, String addressType, String address) {
        this();
        this.name = name;
        this.addressType = addressType;
        this.addressString = address;
    }

    private static synchronized void initResolver() {
        if (resolver == null) {
            ThreadPool tp = ThreadPool.create("DNSResolver", 2);
            resolver = new TaskScheduler(tp);
            Thread resolverScheduler = new Thread(resolver);
            resolverScheduler.setDaemon(true);
            resolverScheduler.start();
        }
    }

    public void setCommunity(OctetString newCommunity) {
        this.community = newCommunity;
    }

    public OctetString getCommunity() {
        return this.community;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUser(UserProfile newUser) {
        this.user = newUser;
    }

    public UserProfile getUser() {
        return this.user;
    }

    public void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public void setRetries(int newRetries) {
        this.retries = newRetries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setTimeout(int newTimeout) {
        this.timeout = newTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAddress(Address newAddress) {
        this.address = newAddress;
        if (!this.resolvePending) {
            ResolveTask task = new ResolveTask();
            resolver.addTask(task);
        }
    }

    public String getHostname() {
        String hostname = this.getName();
        if (hostname.indexOf(32) > 0) {
            hostname = hostname.substring(0, hostname.indexOf(32));
        }
        return hostname;
    }

    public Address getAddress() {
        if (this.address == null) {
            String addrString = this.addressString;
            if (addrString == null) {
                addrString = "127.0.0.1";
            }
            if (!addrString.contains("/")) {
                addrString = addrString + "/161";
            }
            if (this.addressType == null) {
                this.addressType = "UDP";
            }
            this.setAddress(GenericAddress.parse(this.addressType + ":" + addrString));
        }
        return this.address;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof GenTarget) {
            return (this.getName() == null && ((GenTarget)o2).getName() == null || this.getName().equals(((GenTarget)o2).getName())) && (this.getAddressString() == null && ((GenTarget)o2).getAddressString() == null || this.getAddressString().equals(((GenTarget)o2).getAddressString()));
        }
        return false;
    }

    public Target getTarget(long maxTimeoutMillis) {
        Target t = this.getTarget();
        if (t.getTimeout() * 10L * (long)(1 + t.getRetries()) > maxTimeoutMillis) {
            t.setTimeout(maxTimeoutMillis / (long)(10 * (1 + t.getRetries())));
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Set maximum timeout for target " + t.getAddress() + " to: " + t.getTimeout() + "/100 seconds")));
            }
        }
        return t;
    }

    public Target getTarget(Snmp session) {
        AbstractTarget t;
        if (this.version == 3) {
            Address addr = this.getAddress();
            if (addr instanceof TlsAddress) {
                t = new CertifiedTarget(new OctetString(this.user.getName()));
                t.setAddress(addr);
                ((CertifiedTarget)t).setSecurityModel(4);
            } else {
                if (!(this.engineID != null && this.engineID.length() != 0 || this.getAddress() instanceof TlsAddress)) {
                    if (this.cachedEngineID == null || this.cachedEngineID.length == 0) {
                        this.cachedEngineID = session.discoverAuthoritativeEngineID(this.getAddress(), this.getTimeout());
                        if (this.cachedEngineID == null) {
                            logger.warn((Serializable)((Object)("Timeout on engine ID discovery from " + this.getAddress())));
                            return null;
                        }
                    }
                } else {
                    this.cachedEngineID = this.engineID.getValue();
                }
                t = new UserTarget(this.getAddress(), this.user.getUser().getSecurityName(), this.cachedEngineID);
                int secLevel = 2;
                if (this.user.getUser().getAuthenticationProtocol() != null) {
                    secLevel = this.user.getUser().getPrivacyProtocol() != null ? 3 : 2;
                }
                ((SecureTarget)t).setSecurityLevel(secLevel);
            }
        } else {
            CommunityTarget ct = new CommunityTarget(this.getAddress(), this.community);
            t = ct;
        }
        t.setRetries(this.retries);
        t.setTimeout(this.timeout);
        t.setVersion(this.version);
        return t;
    }

    public Target getTarget() {
        AbstractTarget t;
        if (this.version == 3) {
            if (this.engineID != null && this.engineID.length() > 0) {
                this.cachedEngineID = this.engineID.getValue();
            } else if (this.cachedEngineID == null) {
                this.cachedEngineID = new byte[0];
            }
            if (this.getAddress() instanceof TlsAddress) {
                t = new CertifiedTarget(new OctetString(this.user.getName()));
                t.setAddress(this.getAddress());
                ((CertifiedTarget)t).setSecurityModel(4);
            } else {
                t = new UserTarget(this.getAddress(), this.user.getUser().getSecurityName(), this.cachedEngineID);
                int secLevel = 1;
                if (this.user.getUser().getAuthenticationProtocol() != null && this.user.getUser().getAuthenticationProtocol().size() > 0) {
                    secLevel = this.user.getUser().getPrivacyProtocol() != null && this.user.getUser().getPrivacyProtocol().size() > 0 ? 3 : 2;
                }
                ((SecureTarget)t).setSecurityLevel(secLevel);
            }
        } else {
            CommunityTarget ct;
            t = ct = new CommunityTarget(this.getAddress(), this.community);
        }
        t.setRetries(this.retries);
        t.setTimeout(this.timeout);
        t.setVersion(this.version);
        return t;
    }

    public OctetString getEngineID() {
        if (this.engineID != null && this.engineID.length() > 0) {
            return this.engineID;
        }
        if (this.cachedEngineID != null) {
            return new OctetString(this.cachedEngineID);
        }
        return new OctetString();
    }

    public PDU makePDU() {
        PDU pdu;
        if (this.version == 3) {
            ScopedPDU scopedPdu = new ScopedPDU();
            if (this.getUser() != null) {
                if (this.getContextEngineID() != null && this.getContextEngineID().length() > 0) {
                    scopedPdu.setContextEngineID(this.getContextEngineID());
                } else if (this.engineID != null) {
                    scopedPdu.setContextEngineID(new OctetString(this.engineID));
                }
                if (this.getContext() != null) {
                    scopedPdu.setContextName(this.getContext());
                }
            }
            pdu = scopedPdu;
        } else {
            pdu = new PDU();
        }
        return pdu;
    }

    public String toString() {
        Address addr;
        String s = this.getName() + " - " + this.addressType + ":";
        s = this.address == null ? s + this.addressString : ((addr = this.getAddress()) == null ? s + "<unresolvable address>" : (this.resolvedAddress != null ? s + this.resolvedAddress : s + GenTarget.getDottedAddressString(addr)));
        return s;
    }

    private static String getDottedAddressString(Address address) {
        if (address instanceof IpAddress) {
            byte[] addr = ((IpAddress)address).getInetAddress().getAddress();
            StringBuffer buf = new StringBuffer(addr.length * 4);
            for (int i2 = 0; i2 < addr.length; ++i2) {
                buf.append("" + (addr[i2] & 0xFF));
                if (i2 + 1 >= addr.length) continue;
                buf.append(".");
            }
            return buf.toString();
        }
        return "?";
    }

    public String toDetailedString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString());
        buf.append(": ");
        buf.append(GenTarget.getVersionString(this.version));
        buf.append(", retries=");
        buf.append(this.retries);
        buf.append(", timeout=");
        buf.append(this.timeout);
        buf.append("\n");
        if (this.version == 3) {
            buf.append("engineID=");
            buf.append(this.engineID.toHexString());
            buf.append(", context=");
            buf.append(this.context);
            buf.append(", contextID=");
            if (this.getContextEngineID() != null) {
                buf.append(new OctetString(this.getContextEngineID()).toHexString());
            }
            buf.append("\n");
            if (this.user != null) {
                buf.append(this.user.toDetailedString());
            }
        } else {
            buf.append("community=");
            buf.append(this.getCommunity());
        }
        return buf.toString();
    }

    public static String getVersionString(int version) {
        switch (version) {
            case 0: {
                return "SNMPv1";
            }
            case 1: {
                return "SNMPv2c";
            }
            case 3: {
                return "SNMPv3";
            }
        }
        return "?";
    }

    public int compareTo(Object o2) {
        return this.toString().compareTo(o2.toString());
    }

    public void setContext(OctetString newContext) {
        this.context = newContext;
    }

    public OctetString getContext() {
        return this.context;
    }

    public void setContextEngineID(OctetString newContextEngineID) {
        if (newContextEngineID == null) {
            throw new NullPointerException();
        }
        this.contextEngineID = newContextEngineID;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public void setMIBSet(String newMIBSet) {
        this.MIBSet = newMIBSet;
    }

    public String getMIBSet() {
        return this.MIBSet;
    }

    public void setEngineID(OctetString engineID) {
        if (engineID == null) {
            throw new NullPointerException();
        }
        this.engineID = engineID;
    }

    public void setAddressString(String addressString) {
        this.addressString = addressString;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public String getAddressString() {
        if (this.addressString == null && this.address != null) {
            this.addressString = this.address.toString();
        }
        return this.addressString;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public TargetStatistics getTargetStatistics() {
        return this.targetStatistics;
    }

    public class ResolveTask
    implements SchedulerTask {
        private ResolveTask() {
            GenTarget.this.resolvePending = true;
        }

        @Override
        public void run() {
            Address addr = GenTarget.this.getAddress();
            if (addr != null) {
                GenTarget.this.resolvedAddress = addr.toString();
            }
            GenTarget.this.resolvePending = false;
        }

        @Override
        public boolean isReadyToRun() {
            return GenTarget.this.resolvePending;
        }

        @Override
        public boolean isDone() {
            return GenTarget.this.resolvedAddress != null;
        }

        @Override
        public void terminate() {
        }

        @Override
        public void join() throws InterruptedException {
        }

        @Override
        public void interrupt() {
        }
    }
}

