/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.repository.ProgressCallback;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ExtRepsitoryListener;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.FindImportsVisitor;
import com.agentpp.smiparser.LenientSMI2Java;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ParseException;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.TokenMgrError;
import com.objectspace.jgl.OrderedMap;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class DefaultRepositoryManager
implements RepositoryManager {
    public static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    protected static String resClassName = "com.agentpp.repository.DefaultRepositoryManagerRes";
    protected RepositoryManager rm = this;
    protected File path = null;
    protected static ResourceBundle res = null;
    public boolean verbose = false;
    protected int options = 4;
    private transient Vector a;
    private boolean b = false;
    private int c = 0;
    public static final int DEFAULT_MODE = 0;
    public static final int LENIENT_MODE = 1;
    public static final int LENIENT_MODE_MODULE_INFO = Integer.MAX_VALUE;
    protected int maxErrors = 20;
    private boolean d;
    private int e = 20;
    private static boolean f;
    private Map g = Collections.synchronizedMap(new LinkedHashMap(this, this.e){
        private /* synthetic */ DefaultRepositoryManager a;
        {
            this.a = defaultRepositoryManager;
            super(n2, 0.75f, true);
        }

        protected final boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= this.a.e;
        }
    });
    private boolean h;

    public DefaultRepositoryManager() {
        try {
            this.c = Integer.parseInt(System.getProperty("com.agentpp.smi.initialModuleID", "0"));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
    }

    public static void setResourceClassName(String resourceClassName) {
        resClassName = resourceClassName;
    }

    public static String getResourceClassName() {
        return resClassName;
    }

    /*
     * WARNING - void declaration
     */
    public void open(File directory) throws IOException {
        void var1_1;
        this.g.clear();
        this.path = var1_1;
        if (!this.path.exists() || !this.path.isDirectory()) {
            throw new IOException("Repository path is not a directory");
        }
    }

    public File getRepositoryDirectory() {
        return this.path;
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    protected ModuleInfo[] updateRepository(SMIRepository rep, List parseErrors, boolean lenient, String path) throws SMIParseException {
        void var3_3;
        Vector vector;
        Object object = lenient ? new LenientSMI2Java(rep, this.options) : new SMI2Java(rep, this.options);
        ((SMI2Java)object).setErrors(vector);
        ((SMI2Java)object).setMaxErrors(this.maxErrors);
        vector = new Vector();
        try {
            rep.jjtAccept((SMIParserVisitor)object, vector);
        }
        catch (Exception exception) {
            if (((SMI2Java)object).getErrors().size() > 0) {
                SMIParseException sMIParseException = (SMIParseException)((SMI2Java)object).getErrors().get(0);
                sMIParseException.setErrorList(((SMI2Java)object).getErrors());
                throw sMIParseException;
            }
            exception.printStackTrace();
            throw new SMIParseException(exception.getMessage(), 0);
        }
        if (((SMI2Java)object).getErrors().size() > 0) {
            SMIParseException sMIParseException = (SMIParseException)((SMI2Java)object).getErrors().get(0);
            sMIParseException.setErrorList(((SMI2Java)object).getErrors());
            throw sMIParseException;
        }
        MIBRepository mIBRepository = ((SMI2Java)object).getRepository();
        mIBRepository.structureChanged();
        boolean bl = Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
        if (var3_3 != false) {
            Iterator<MIBModule> iterator = mIBRepository.modulesIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ((MIBModule)object).setParseMode(Integer.MAX_VALUE);
                if (!bl || path == null) continue;
                ((MIBModule)object).setFileName(new File(path).getName());
            }
        } else if (bl && path != null) {
            Iterator<MIBModule> iterator = mIBRepository.modulesIterator();
            while (iterator.hasNext()) {
                iterator.next().setFileName(new File(path).getName());
            }
        }
        try {
            this.saveModulesFromRepository(mIBRepository);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            throw new SMIParseException("Could not write to repository: " + iOException2.getMessage(), 20);
        }
        ModuleInfo[] moduleInfoArray = new ModuleInfo[vector.size()];
        vector.toArray(moduleInfoArray);
        if (this.h && !vector.isEmpty()) {
            void var1_1;
            moduleInfoArray[0].userObject = var1_1;
        }
        return moduleInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    protected MIBRepository createRepository(SMIRepository rep, List parseErrors, boolean lenient, boolean ignoreErrors) throws SMIParseException {
        void var3_3;
        MIBRepository mIBRepository;
        Object object;
        void var6_7 = object;
        Object object2 = rep;
        object = this;
        object2 = lenient ? new LenientSMI2Java((SMIRepository)object2, ((DefaultRepositoryManager)object).options) : new SMI2Java((SMIRepository)object2, ((DefaultRepositoryManager)object).options);
        ((SMI2Java)object2).setErrors((List)var6_7);
        ((SMI2Java)object2).setMaxErrors(((DefaultRepositoryManager)object).maxErrors);
        object = object2;
        object2 = new Vector();
        ((SimpleNode)((Object)mIBRepository)).jjtAccept((SMIParserVisitor)object, object2);
        mIBRepository = ((SMI2Java)object).getRepository();
        mIBRepository.freeUserObjects();
        mIBRepository.structureChanged();
        if (!ignoreErrors && ((SMI2Java)object).getErrors().size() > this.maxErrors) {
            SMIParseException sMIParseException = (SMIParseException)((SMI2Java)object).getErrors().get(0);
            sMIParseException.setErrorList(((SMI2Java)object).getErrors());
            throw sMIParseException;
        }
        if (var3_3 != false) {
            Iterator<MIBModule> iterator = mIBRepository.modulesIterator();
            while (iterator.hasNext()) {
                iterator.next().setParseMode(1);
            }
        }
        return mIBRepository;
    }

    /*
     * WARNING - void declaration
     */
    protected ModuleInfo[] getModuleInfo(SMIRepository rep) throws SMIParseException {
        ModuleInfo[] moduleInfoArray = new FindImportsVisitor(rep);
        Vector vector = new Vector();
        rep.jjtAccept((SMIParserVisitor)moduleInfoArray, vector);
        moduleInfoArray = new ModuleInfo[vector.size()];
        vector.toArray(moduleInfoArray);
        if (this.h && !vector.isEmpty()) {
            void var1_1;
            moduleInfoArray[0].userObject = var1_1;
        }
        return moduleInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void checkModules(InputStream file) throws SMIParseException {
        void var1_1;
        this.checkModules((InputStream)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized ModuleInfo[] checkModules(InputStream file, boolean lenient, boolean ignoreErrorLimit) throws SMIParseException {
        SMI2Java sMI2Java;
        Serializable serializable;
        SMIParser sMIParser = new SMIParser(file);
        SMIRepository sMIRepository = null;
        if (lenient) {
            sMIParser.setLenient(1);
        }
        if (!ignoreErrorLimit) {
            sMIParser.setMaxErrors(this.maxErrors);
        }
        try {
            sMIRepository = sMIParser.Input("");
            sMIRepository.setImporter(this);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                ((InputStream)((Object)serializable)).close();
            }
            catch (IOException iOException) {}
            if (this.verbose) {
                System.out.println("failed.");
            }
            serializable = new SMIParseException(parseException.getMessage(), parseException.getShortMessage(), parseException.errorType, parseException);
            ((SMIParseException)serializable).setErrorList(sMIParser.getErrors());
            if (this.h) {
                ((SMIParseException)serializable).setSmiRepository(sMIRepository);
            }
            throw serializable;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            try {
                ((InputStream)((Object)serializable)).close();
            }
            catch (IOException iOException) {}
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                serializable = (TokenMgrError)throwable;
                throw new SMIParseException(((TokenMgrError)serializable).getMessage(), null, 50, (FileError)((Object)serializable));
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (this.maxErrors > 0 && sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = (SMIParseException)sMIParser.getErrors().get(0);
            if (this.h) {
                sMIParseException.setSmiRepository(sMIRepository);
            }
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            void var3_7;
            void var2_2;
            sMI2Java = var2_2 != false ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options);
            sMI2Java.setErrors(sMIParser.getErrors());
            if (var3_7 == false) {
                sMI2Java.setMaxErrors(this.maxErrors);
            }
            serializable = new Vector();
            sMIRepository.jjtAccept(sMI2Java, serializable);
        }
        catch (SMIParseException sMIParseException) {
            serializable = sMIParseException;
            sMIParseException.setSmiRepository(sMIRepository);
            throw serializable;
        }
        if (sMI2Java.getErrors().size() > 0) {
            serializable = (SMIParseException)sMI2Java.getErrors().get(0);
            ((SMIParseException)serializable).setErrorList(sMIParser.getErrors());
            ((SMIParseException)serializable).setSmiRepository(sMIRepository);
            throw serializable;
        }
        return this.getModuleInfo(sMIRepository);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ModuleInfo[] getModuleInfo(File file) throws SMIParseException {
        void var1_1;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SMIParseException(file.getPath(), 10);
        }
        if (this.verbose) {
            System.out.print("Loading IMPORTS from file [" + file.getPath() + "]...");
        }
        return this.getModuleInfo(fileInputStream, var1_1.getPath());
    }

    @Override
    public ModuleInfo[] getModuleInfo(ZipFile file) throws SMIParseException {
        try {
            Vector<ModuleInfo> vector = new Vector<ModuleInfo>();
            ModuleInfo[] moduleInfoArray = file.entries();
            while (moduleInfoArray.hasMoreElements()) {
                Object[] objectArray;
                ZipEntry zipEntry = moduleInfoArray.nextElement();
                ModuleInfo[] moduleInfoArray2 = file.getInputStream(zipEntry);
                if (this.verbose) {
                    System.out.print("Loading IMPORTS from file [" + zipEntry.getName() + "]...");
                }
                try {
                    moduleInfoArray2 = this.getModuleInfo((InputStream)moduleInfoArray2, zipEntry.getName());
                }
                catch (SMIParseException sMIParseException) {
                    ModuleInfo[] moduleInfoArray3 = new ModuleInfo[1];
                    moduleInfoArray2 = moduleInfoArray3;
                    moduleInfoArray3[0] = new ModuleInfo("invalid ");
                    moduleInfoArray2[0].path = new File(zipEntry.getName());
                    Object[] objectArray2 = new Object[2];
                    objectArray = objectArray2;
                    objectArray2[0] = file;
                    objectArray[1] = zipEntry;
                    moduleInfoArray2[0].userObject = objectArray;
                }
                for (int i2 = 0; i2 < moduleInfoArray2.length; ++i2) {
                    Object[] objectArray3 = new Object[2];
                    objectArray = objectArray3;
                    objectArray3[0] = file;
                    objectArray[1] = zipEntry;
                    moduleInfoArray2[i2].userObject = objectArray;
                }
                vector.addAll(Arrays.asList(moduleInfoArray2));
            }
            moduleInfoArray = new ModuleInfo[vector.size()];
            vector.toArray(moduleInfoArray);
            return moduleInfoArray;
        }
        catch (IOException iOException) {
            throw new SMIParseException(iOException.getMessage(), 20);
        }
    }

    public ModuleInfo[] getModuleInfo(ZipInputStream file) throws SMIParseException {
        try {
            ModuleInfo[] moduleInfoArray;
            ZipEntry zipEntry;
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
            while ((zipEntry = file.getNextEntry()) != null) {
                Object[] objectArray;
                moduleInfoArray = file;
                if (this.verbose) {
                    System.out.print("Loading IMPORTS from file [" + zipEntry.getName() + "]...");
                }
                try {
                    moduleInfoArray = this.getModuleInfo((InputStream)moduleInfoArray, zipEntry.getName());
                }
                catch (SMIParseException sMIParseException) {
                    ModuleInfo[] moduleInfoArray2 = new ModuleInfo[1];
                    moduleInfoArray = moduleInfoArray2;
                    moduleInfoArray2[0] = new ModuleInfo("invalid ");
                    moduleInfoArray[0].path = new File(zipEntry.getName());
                    Object[] objectArray2 = new Object[2];
                    objectArray = objectArray2;
                    objectArray2[0] = file;
                    objectArray[1] = zipEntry;
                    moduleInfoArray[0].userObject = objectArray;
                }
                for (int i2 = 0; i2 < moduleInfoArray.length; ++i2) {
                    Object[] objectArray3 = new Object[2];
                    objectArray = objectArray3;
                    objectArray3[0] = file;
                    objectArray[1] = zipEntry;
                    moduleInfoArray[i2].userObject = objectArray;
                }
                arrayList.addAll(Arrays.asList(moduleInfoArray));
            }
            moduleInfoArray = new ModuleInfo[arrayList.size()];
            arrayList.toArray(moduleInfoArray);
            return moduleInfoArray;
        }
        catch (IOException iOException) {
            throw new SMIParseException(iOException.getMessage(), 20);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ModuleInfo[] getModuleInfo(InputStream fi, String path) throws SMIParseException {
        ModuleInfo[] moduleInfoArray = new SMIParser(fi);
        moduleInfoArray.setLenient(Integer.MAX_VALUE);
        try {
            moduleInfoArray = moduleInfoArray.Input(path);
            moduleInfoArray.setImporter(this);
            moduleInfoArray.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException iOException) {}
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(parseException.getMessage(), parseException.errorType);
        }
        catch (Throwable throwable) {
            try {
                fi.close();
            }
            catch (IOException iOException) {}
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), throwable.getMessage(), 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            moduleInfoArray = this.getModuleInfo((SMIRepository)moduleInfoArray);
        }
        catch (SMIParseException sMIParseException) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            throw new SMIParseException(throwable2.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            void var1_1;
            var1_1.close();
        }
        catch (IOException iOException) {}
        for (int i2 = 0; i2 < moduleInfoArray.length; ++i2) {
            moduleInfoArray[i2].path = new File(path);
        }
        return moduleInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized MIBRepository createRepository(InputStream fi, ImportModuleListener l2) throws SMIParseException {
        void var2_2;
        void var1_1;
        return this.createRepository((InputStream)var1_1, (ImportModuleListener)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized MIBRepository createRepository(InputStream fi, ImportModuleListener l2, boolean ignoreErrors) throws SMIParseException {
        void var3_6;
        SMIParseException sMIParseException;
        Serializable serializable;
        SMIRepository sMIRepository;
        SMIParser sMIParser = new SMIParser(fi);
        sMIParser.setMaxErrors(ignoreErrors ? Integer.MAX_VALUE : this.maxErrors);
        try {
            sMIRepository = sMIParser.Input(fi.toString());
            sMIRepository.setImporter((ImportModuleListener)((Object)serializable));
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                ((InputStream)((Object)sMIParseException)).close();
            }
            catch (IOException iOException) {}
            if (this.verbose) {
                System.out.println("failed.");
            }
            sMIParseException = new SMIParseException(parseException.getMessage(), parseException.getShortMessage(), parseException.errorType, parseException);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)((Object)sMIParseException)).close();
            }
            catch (IOException iOException) {}
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), null, 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            serializable = this.createRepository(sMIRepository, sMIParser.getErrors(), false, ignoreErrors);
        }
        catch (SMIParseException sMIParseException2) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw sMIParseException2;
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throwable.printStackTrace();
            throw new SMIParseException(serializable.getMessage(), 0);
        }
        if (var3_6 == false && sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            serializable = (SMIParseException)sMIParser.getErrors().get(0);
            ((SMIParseException)serializable).setErrorList(sMIParser.getErrors());
            throw serializable;
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            ((InputStream)((Object)sMIParseException)).close();
        }
        catch (IOException iOException) {}
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ModuleInfo[] addModules(File file) throws SMIParseException {
        void var1_1;
        return this.addModules((File)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized ModuleInfo[] addModules(File file, ImportModuleListener importer) throws SMIParseException {
        try {
            void var2_2;
            return this.addModules(new FileInputStream(file), file.getPath(), (ImportModuleListener)var2_2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var1_1;
            throw new SMIParseException(var1_1.getPath(), 10);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ModuleInfo[] addModules(InputStream fi, String path) throws SMIParseException {
        void var2_2;
        void var1_1;
        return this.addModules((InputStream)var1_1, (String)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized ModuleInfo[] addModules(InputStream fi, String path, ImportModuleListener importer) throws SMIParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.a((InputStream)var1_1, (String)var2_2, (ImportModuleListener)var3_3, false);
    }

    private ModuleInfo[] a(InputStream object, String moduleInfoArray, ImportModuleListener importModuleListener, boolean bl) throws SMIParseException {
        if (this.verbose) {
            System.out.print("Loading MIB file [" + (String)moduleInfoArray + "]...");
        }
        SMIParser sMIParser = new SMIParser((InputStream)object);
        if (bl) {
            sMIParser.setLenient(1);
        }
        sMIParser.setMaxErrors(this.maxErrors);
        SMIRepository sMIRepository = null;
        try {
            sMIRepository = sMIParser.Input((String)moduleInfoArray);
            sMIRepository.setImporter(importModuleListener);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
            if (this.verbose) {
                System.out.println("failed.");
            }
            object = new SMIParseException(parseException.getMessage(), parseException.getShortMessage(), parseException.errorType, parseException);
            if (this.h) {
                ((SMIParseException)object).setSmiRepository(sMIRepository);
            }
            ((SMIParseException)object).setErrorList(sMIParser.getErrors());
            throw object;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), null, 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            moduleInfoArray = (SMIParseException)sMIParser.getErrors().get(0);
            if (this.h) {
                moduleInfoArray.setSmiRepository(sMIRepository);
            }
            moduleInfoArray.setErrorList(sMIParser.getErrors());
            throw moduleInfoArray;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            moduleInfoArray = this.updateRepository(sMIRepository, sMIParser.getErrors(), bl, (String)moduleInfoArray);
        }
        catch (SMIParseException sMIParseException) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            if (this.h) {
                sMIParseException.setSmiRepository(sMIRepository);
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            moduleInfoArray = throwable;
            throwable.printStackTrace();
            throw new SMIParseException(moduleInfoArray.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            ((InputStream)object).close();
        }
        catch (IOException iOException) {}
        return moduleInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized ModuleInfo[] addModulesLeniently(InputStream fi, String path) throws SMIParseException {
        void var2_2;
        void var1_1;
        return this.a((InputStream)var1_1, (String)var2_2, this, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized ModuleInfo[] addModulesLeniently(File file) throws SMIParseException {
        try {
            return this.a(new FileInputStream(file), file.getPath(), this, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var1_1;
            throw new SMIParseException(var1_1.getPath(), 10);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void freeModuleID(Integer moduleID, String moduleName) {
        try {
            void var1_1;
            this.freeModuleID((Integer)var1_1);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeModule(String moduleName) throws IOException {
        void var1_1;
        block4: {
            try {
                MIBModule mIBModule = this.loadModuleFromFile(moduleName, true);
                if (mIBModule == null) break block4;
                RepositoryEvent repositoryEvent = new RepositoryEvent(this, moduleName);
                this.fireDeleteModule(repositoryEvent);
                if (!repositoryEvent.isModuleDeleted()) {
                    if (repositoryEvent.isUseDefaults()) {
                        this.freeModuleID(mIBModule.getModuleID(), moduleName);
                        break block4;
                    }
                    return false;
                }
                return true;
            }
            catch (Exception exception) {}
        }
        return new File(this.path.getPath() + File.separatorChar + (String)var1_1).delete();
    }

    @Override
    public Integer createModuleID(String moduleName) {
        try {
            return this.createModuleID();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized Integer createModuleID() throws IOException {
        Integer n2 = new Integer(this.c);
        try {
            Integer n3;
            if (this.path != null) {
                Closeable closeable;
                File file = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
                Vector vector = new Vector();
                if (file.exists()) {
                    closeable = new FileInputStream(file);
                    closeable = new ObjectInputStream((InputStream)closeable);
                    n2 = (Integer)((ObjectInputStream)closeable).readObject();
                    vector = (Vector)((ObjectInputStream)closeable).readObject();
                    ((ObjectInputStream)closeable).close();
                }
                if (vector.size() > 0) {
                    n3 = (Integer)vector.firstElement();
                    vector.removeElementAt(0);
                } else {
                    if ((n2 = new Integer(n2 + 1)) < 0) {
                        n2 = new Integer(this.c);
                    }
                    n3 = n2;
                }
                closeable = new FileOutputStream(file);
                closeable = new ObjectOutputStream((OutputStream)closeable);
                ((ObjectOutputStream)closeable).writeObject(n2);
                ((ObjectOutputStream)closeable).writeObject(vector);
                ((ObjectOutputStream)closeable).flush();
                ((ObjectOutputStream)closeable).close();
            } else {
                n3 = new Integer(this.c++);
            }
            return n3;
        }
        catch (Exception exception) {
            throw new IOException("Could not create unique module id: " + exception.getMessage());
        }
    }

    public void freeModuleID(Integer freedID) throws IOException {
        if (freedID <= this.c) {
            return;
        }
        try {
            if (this.path != null) {
                File file = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
                new Integer(this.c);
                new Vector();
                if (file.exists()) {
                    OutputStream outputStream;
                    Object object = new FileInputStream(file);
                    ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                    object = (Integer)objectInputStream.readObject();
                    Vector vector = (Vector)objectInputStream.readObject();
                    objectInputStream.close();
                    vector.addElement(outputStream);
                    outputStream = new FileOutputStream(file);
                    outputStream = new ObjectOutputStream(outputStream);
                    ((ObjectOutputStream)outputStream).writeObject(object);
                    ((ObjectOutputStream)outputStream).writeObject(vector);
                    ((ObjectOutputStream)outputStream).flush();
                    ((ObjectOutputStream)outputStream).close();
                }
            }
            return;
        }
        catch (Exception exception) {
            throw new IOException("Could not free module id: " + exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MIBObject[] getImportedObjects(Hashtable visited, String moduleName) throws IOException {
        void var2_2;
        void var1_1;
        return this.getImportedObjects((Map)var1_1, (String)var2_2, false, false);
    }

    @Override
    public MIBObject[] getImportedObjects(Map visited, String moduleName, boolean includeModule, boolean includeImportedModules) throws IOException {
        try {
            int n2;
            MIBModule mIBModule;
            mIBModule = this.loadModuleFromFile((String)((Object)mIBModule), true);
            visited.put(mIBModule.getModuleName(), mIBModule.getModuleID());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (mIBModule.getImports() == null) {
                return new MIBObject[0];
            }
            if (n2 != 0) {
                arrayList.add(mIBModule);
            }
            for (n2 = 0; n2 < mIBModule.getImports().length; ++n2) {
                Object object;
                Object object22;
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                for (int i2 = 0; i2 < mIBModule.getImports()[n2].getImports().length; ++i2) {
                    hashMap2.put(mIBModule.getImports()[n2].getImports()[i2], mIBModule.getImports()[n2].getImports()[i2]);
                }
                MIBObject[] mIBObjectArray = this.getObjects(mIBModule.getImports()[n2].getSource());
                if (includeImportedModules && mIBObjectArray != null && mIBObjectArray.length > 0) {
                    arrayList.add(mIBObjectArray[0]);
                }
                HashMap<String, MIBObject> hashMap3 = new HashMap<String, MIBObject>(mIBObjectArray.length + 10);
                for (int i3 = 0; i3 < mIBObjectArray.length; ++i3) {
                    int n3;
                    object22 = mIBObjectArray[i3];
                    hashMap3.put(object22.getName(), (MIBObject)object22);
                    if (hashMap2.get(object22.getName()) == null && !(object22 instanceof MIBTextualConvention)) continue;
                    arrayList.add(object22);
                    if (!this.isImportTableDependencies() || !(object22 instanceof MIBObjectType) || !((MIBObjectType)(object = (MIBObjectType)object22)).isTable()) continue;
                    object22 = ((MIBObjectType)object).getIndexPart().getIndexPart();
                    for (n3 = 0; n3 < ((Object[])object22).length; ++n3) {
                        hashMap.put(object22[n3], object22[n3]);
                    }
                    object22 = ((MIBObjectType)object).getTableEntries();
                    for (n3 = 0; n3 < ((Object[])object22).length; ++n3) {
                        hashMap.put(object22[n3], object22[n3]);
                    }
                }
                for (Object object22 : hashMap.keySet()) {
                    object = hashMap3.get(object22);
                    if (object == null) continue;
                    arrayList.add((MIBObject)object);
                }
                String string = mIBModule.getImports()[n2].getSource();
                if (visited.get(string) != null) continue;
                visited.put(string, string);
                object22 = this.getImportedObjects(visited, string, includeImportedModules, includeImportedModules);
                for (int i4 = 0; i4 < ((MIBObject[])object22).length; ++i4) {
                    if (!(object22[i4] instanceof MIBTextualConvention) && hashMap.get(((MIBObject)object22[i4]).getName()) == null) continue;
                    arrayList.add(object22[i4]);
                }
            }
            return arrayList.toArray(new MIBObject[arrayList.size()]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Incompatible repository format: " + classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MIBObject[] getImportedObjects(String moduleName) throws IOException {
        void var1_1;
        return this.getImportedObjects(new Hashtable(), (String)var1_1);
    }

    @Override
    public void saveModule(MIBModule m2) throws IOException {
        MIBRepository mIBRepository;
        m2.setLastChange(new Date(System.currentTimeMillis()));
        mIBRepository = new MIBRepository(((MIBModule)((Object)mIBRepository)).getObjects());
        this.saveModulesFromRepository(mIBRepository);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveModulesFromRepository(MIBRepository rep) throws IOException {
        boolean bl = true;
        Iterator<MIBModule> iterator = rep.modulesIterator();
        while (iterator.hasNext()) {
            Object object;
            MIBModule mIBModule = iterator.next();
            Object object2 = new RepositoryEvent(this, mIBModule.getModuleName(), mIBModule);
            this.fireWriteModule((RepositoryEvent)object2);
            if (((RepositoryEvent)object2).getOutputStream() == null) {
                if (!((RepositoryEvent)object2).isUseDefaults()) return false;
                object = new File(this.path.getPath(), mIBModule.getModuleName());
                if (((File)object).exists()) {
                    bl = false;
                }
                object = new FileOutputStream(((File)object).getPath());
                object2 = new ObjectOutputStream((OutputStream)object);
            } else {
                object2 = new ObjectOutputStream(((RepositoryEvent)object2).getOutputStream());
            }
            if (this.d) {
                ((ObjectOutputStream)object2).writeInt(-1);
                object = new GZIPOutputStream((OutputStream)object2);
                object = new ObjectOutputStream((OutputStream)object);
                DefaultRepositoryManager.a(rep, mIBModule, (ObjectOutputStream)object);
                ((ObjectOutputStream)object).flush();
                ((ObjectOutputStream)object).close();
            } else {
                DefaultRepositoryManager.a(rep, mIBModule, (ObjectOutputStream)object2);
            }
            ((ObjectOutputStream)object2).flush();
            ((ObjectOutputStream)object2).close();
            this.g.put(mIBModule.getModuleName(), new b((MIBModule)mIBModule.getClone()));
        }
        return bl;
    }

    private static void a(MIBRepository mIBRepository, MIBModule mIBModule, ObjectOutputStream objectOutputStream) throws IOException {
        int n2 = mIBModule.size();
        if (mIBModule.getName() != null && mIBModule.objectsByName().get(mIBModule.getName()) == null) {
            ++n2;
        }
        objectOutputStream.writeInt(n2);
        objectOutputStream.writeObject(mIBModule);
        Enumeration enumeration = mIBModule.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (mIBObject instanceof MIBModule) continue;
            try {
                objectOutputStream.writeObject(mIBObject);
            }
            catch (Exception exception) {
                System.err.println("Failed to serialize object: " + mIBObject.toSMI(1, mIBModule.getSMIVersion(), mIBRepository, "\n"));
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected MIBModule loadModuleFromFile(String moduleName, boolean moduleOnly) throws IOException, ClassNotFoundException {
        block13: {
            block11: {
                block12: {
                    var3_3 = new RepositoryEvent(this, moduleName);
                    this.fireReadModule((RepositoryEvent)var3_3);
                    var4_4 = null;
                    var5_5 = true;
                    if (var3_3.getInputStream() != null) break block11;
                    if (!var3_3.isUseDefaults() || !(var3_3 = new File(this.path.getPath(), moduleName)).exists()) break block12;
                    var8_6 = var3_3.lastModified();
                    var6_7 = moduleName;
                    var4_4 = this;
                    var7_12 = (b)var4_4.g.get(var6_7);
                    if (var7_12 == null) ** GOTO lbl19
                    if (com.agentpp.repository.DefaultRepositoryManager$b.a((b)var7_12) >= var8_6) {
                        v0 = (MIBModule)com.agentpp.repository.DefaultRepositoryManager$b.b((b)var7_12).getClone();
                    } else {
                        if (var4_4.verbose) {
                            System.out.println("MIB module '" + var6_7 + "' changed on disk");
                        }
                        var4_4.g.remove(var6_7);
lbl19:
                        // 2 sources

                        v0 = var6_7 = null;
                    }
                    if (v0 != null) {
                        return var6_7;
                    }
                    var4_4 = new FileInputStream((File)var3_3);
                }
                if (var4_4 == null) {
                    var5_5 = false;
                    var3_3 = "modules/" + moduleName + ".cmib";
                    var4_4 = IModule.class.getResourceAsStream((String)var3_3);
                    if (var4_4 == null) {
                        throw new FileNotFoundException(moduleName);
                    }
                }
                break block13;
            }
            var4_4 = var3_3.getInputStream();
        }
        if ((var6_8 = (var3_3 = new ObjectInputStream((InputStream)var4_4)).readInt()) == -1) {
            var6_9 = new GZIPInputStream((InputStream)var3_3);
            var7_12 = new ObjectInputStream(var6_9);
            var6_10 = var7_12.readInt();
            var6_11 = DefaultRepositoryManager.a(moduleOnly, (ObjectInputStream)var7_12, var6_10);
        } else {
            var6_11 = DefaultRepositoryManager.a(moduleOnly, (ObjectInputStream)var3_3, var6_8);
        }
        try {
            var3_3.close();
            var4_4.close();
        }
        catch (IOException v1) {}
        var3_3 = new RepositoryEvent(this, moduleName, var6_11);
        this.fireAfterReadModule((RepositoryEvent)var3_3);
        if (var2_2 == false && var5_5) {
            this.g.put(var1_1, new b(var6_11));
        }
        return var6_11;
    }

    @Override
    public String[] getBuiltinModuleNames() {
        Object object = "modules/builtin-modules.properties";
        if ((object = IModule.class.getResourceAsStream((String)object)) != null) {
            Properties properties = new Properties();
            try {
                properties.load((InputStream)object);
                return properties.values().toArray(new String[0]);
            }
            catch (IOException iOException) {}
        }
        return new String[0];
    }

    private static MIBModule a(boolean n2, ObjectInputStream objectInputStream, int n3) throws ClassNotFoundException, IOException {
        MIBModule mIBModule = (MIBModule)objectInputStream.readObject();
        mIBModule.reinit();
        if (n2 == 0) {
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                try {
                    MIBObject mIBObject = (MIBObject)objectInputStream.readObject();
                    mIBModule.add(mIBObject);
                    continue;
                }
                catch (EOFException eOFException) {
                    if (n2 + 1 >= n3 - 1) continue;
                    System.err.println("MIB module " + mIBModule.getModuleName() + " should have had " + n3 + " MIB objects, but actually has only " + (n2 + 1));
                }
            }
        }
        return mIBModule;
    }

    @Override
    public void initialize() throws IOException {
        String[] stringArray = this.path.list();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            new File(this.path.getPath() + File.separator + stringArray[i2]).delete();
        }
    }

    @Override
    public ModuleInfo[] getModuleInfos() throws IOException {
        return this.getModuleInfos(null);
    }

    public ModuleInfo[] getModuleInfos(ProgressCallback progress) throws IOException {
        MIBModule[] mIBModuleArray;
        if ((mIBModuleArray = this.getModules(true, (ProgressCallback)mIBModuleArray)) == null) {
            return null;
        }
        ModuleInfo[] moduleInfoArray = new ModuleInfo[mIBModuleArray.length];
        for (int i2 = 0; i2 < mIBModuleArray.length; ++i2) {
            moduleInfoArray[i2] = new ModuleInfo(mIBModuleArray[i2].getModuleName(), mIBModuleArray[i2].getImportSources());
            String string = mIBModuleArray[i2].getLastUpdated();
            if (string == null) continue;
            try {
                moduleInfoArray[i2].setLastUpdated(MIBModule.getDateFromUTC(MIBObject.getUnquotedString(string)));
                continue;
            }
            catch (Exception exception) {}
        }
        return moduleInfoArray;
    }

    public MIBModule[] getModules(boolean withoutObjects, ProgressCallback progress) throws IOException {
        String[] stringArray = null;
        if (this.a != null) {
            stringArray = this.fireListModules();
        }
        if ((stringArray == null || stringArray.length == 0) && this.path != null) {
            stringArray = this.getModuleNames();
        }
        OrderedMap orderedMap = new OrderedMap(LexicographicPredicate.instance);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                if (progress != null && progress.progressEvent(i2, stringArray.length, stringArray[i2])) {
                    return null;
                }
                MIBModule mIBModule = this.loadModuleFromFile(stringArray[i2], withoutObjects);
                orderedMap.add(mIBModule.getModuleName(), mIBModule);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        MIBModule[] mIBModuleArray = new MIBModule[orderedMap.size()];
        int n2 = 0;
        Enumeration enumeration = orderedMap.elements();
        while (enumeration.hasMoreElements()) {
            mIBModuleArray[n2] = (MIBModule)enumeration.nextElement();
            ++n2;
        }
        return mIBModuleArray;
    }

    @Override
    public MIBModule[] getModules() throws IOException {
        return this.getModules(true, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MIBModule getModule(String moduleName) throws IOException {
        try {
            void var1_1;
            return this.loadModuleFromFile((String)var1_1, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MIBModule getModule(String moduleName, boolean includingObjects) throws IOException {
        try {
            void var2_2;
            void var1_1;
            return this.loadModuleFromFile((String)var1_1, var2_2 == false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MIBObject[] getObjects(String moduleName) throws IOException {
        try {
            Object object = this.loadModuleFromFile(moduleName, false);
            MIBObject[] mIBObjectArray = new MIBObject[1 + ((MIBModule)object).size()];
            MIBObject[] mIBObjectArray2 = mIBObjectArray;
            mIBObjectArray[0] = object;
            int n2 = 1;
            object = ((MIBModule)object).objects();
            while (object.hasMoreElements()) {
                mIBObjectArray2[n2] = (MIBObject)object.nextElement();
                ++n2;
            }
            return mIBObjectArray2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            void var1_1;
            throw new IOException("File format error while loading objects from " + (String)var1_1 + ": " + classNotFoundException.getMessage());
        }
    }

    @Override
    public String[] getModuleNames() throws IOException {
        if (this.a != null && !this.a.isEmpty()) {
            return this.fireListModules();
        }
        return this.getModuleNamesFromDirectory();
    }

    public String[] getModuleNamesFromDirectory() throws IOException {
        return this.path.list(new a());
    }

    /*
     * WARNING - void declaration
     */
    public void setRepManForImports(RepositoryManager rm) {
        void var1_1;
        this.rm = var1_1;
    }

    public static String getErrorText(SMIParseException pex) {
        return DefaultRepositoryManager.getErrorText(pex, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String getErrorText(SMIParseException pex, boolean showErrorNumber) {
        void var1_1;
        return DefaultRepositoryManager.getErrorText(pex, (boolean)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String getErrorText(SMIParseException pex, boolean showErrorNumber, boolean showLocation) {
        void var2_2;
        void var1_1;
        return DefaultRepositoryManager.getErrorText(pex, (boolean)var1_1, (boolean)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String getErrorText(SMIParseException pex, boolean showErrorNumber, boolean showLocation, int lineOffset) {
        void var1_1;
        String string;
        int n2;
        Object[] objectArray;
        String string2;
        Object object;
        if (res == null) {
            object = Locale.getDefault();
            res = ResourceBundle.getBundle(resClassName, new Locale(((Locale)object).getLanguage(), ((Locale)object).getCountry(), ((Locale)object).getVariant()));
        }
        if ((object = showLocation ? pex.getMessage() : pex.getShortMessage()) == null) {
            object = "";
        }
        switch (pex.errorType) {
            case 0: {
                if (DefaultRepositoryManager.isForwardUnknownErrors()) {
                    string2 = res.getString("errUnknownWithMessageText");
                    break;
                }
                string2 = res.getString("errUnknown");
                break;
            }
            case 1000: {
                string2 = res.getString("errParser");
                break;
            }
            case 1001: {
                string2 = res.getString("errParserDisplayHint");
                break;
            }
            case 1002: {
                string2 = res.getString("errParserUTCTime");
                break;
            }
            case 1100: {
                string2 = res.getString("errImportUnknown");
                break;
            }
            case 10: {
                string2 = res.getString("errFileOpenError");
                break;
            }
            case 1101: {
                string2 = res.getString("errImportCyclic");
                break;
            }
            case 1502: {
                string2 = res.getString("errUndefName");
                break;
            }
            case 1501: {
                string2 = res.getString("errUndefObject");
                break;
            }
            case 1500: {
                string2 = res.getString("errUndefSyntax");
                break;
            }
            case 1150: {
                string2 = res.getString("errModuleOrder");
                break;
            }
            case 1201: {
                string2 = res.getString("errInconsistentStatus");
                break;
            }
            case 1200: {
                string2 = res.getString("errInconsistentSyntax");
                break;
            }
            case 1202: {
                string2 = res.getString("errInconsistentAccess");
                break;
            }
            case 5000: {
                string2 = res.getString("errNotInGroup");
                break;
            }
            case 1700: {
                string2 = res.getString("errWrongType");
                break;
            }
            case 50: {
                string2 = res.getString("errLexical");
                break;
            }
            case 1810: {
                string2 = res.getString("errInvalidIndex");
                break;
            }
            case 1813: {
                string2 = res.getString("errInvalidImpliedLengthIndex");
                break;
            }
            case 6000: {
                string2 = res.getString("errPibIndexNotInstanceId");
                break;
            }
            case 1812: {
                string2 = res.getString("errInvalidIndexLength");
                break;
            }
            case 4010: {
                string2 = res.getString("errInvalidRange");
                break;
            }
            case 1850: {
                string2 = res.getString("errScalarIndex");
                break;
            }
            case 2000: {
                string2 = res.getString("errDuplicateRegistration");
                break;
            }
            case 2010: {
                string2 = res.getString("errIllegalRegistration");
                break;
            }
            case 1110: {
                string2 = res.getString("errWrongImport");
                break;
            }
            case 1111: {
                string2 = res.getString("errMissingImport");
                break;
            }
            case 1112: {
                string2 = res.getString("errInconsistentImport");
                break;
            }
            case 1113: {
                string2 = res.getString("errDuplicateImport");
                break;
            }
            case 1102: {
                string2 = res.getString("errDuplicateImportSource");
                break;
            }
            case 1114: {
                string2 = res.getString("errIllegalImport");
                break;
            }
            case 1820: {
                string2 = res.getString("errNegativeIndex");
                break;
            }
            case 1800: {
                string2 = res.getString("errInconsistentTable");
                break;
            }
            case 1801: {
                string2 = res.getString("errInconsistentTableDef");
                break;
            }
            case 5100: {
                string2 = res.getString("errNoAccessInGroup");
                break;
            }
            case 5101: {
                string2 = res.getString("errNoAccessInNotification");
                break;
            }
            case 3000: {
                string2 = res.getString("errDefaultValueOutOfRange");
                break;
            }
            case 3001: {
                string2 = res.getString("errDefaultValueSizeOutOfRange");
                break;
            }
            case 3002: {
                string2 = res.getString("errDefaultValueInvalid");
                break;
            }
            case 3003: {
                string2 = res.getString("errDefaultValueIllegal");
                break;
            }
            case 4000: {
                string2 = res.getString("errInvalidSyntaxRefinement");
                break;
            }
            case 1050: {
                string2 = res.getString("errIllegalClause");
                break;
            }
            case 1851: {
                string2 = res.getString("errScalarWithIndex");
                break;
            }
            case 1600: {
                string2 = res.getString("errRefIsNotATable");
                break;
            }
            case 1210: {
                string2 = res.getString("errCondGroupIsAlsoManadatory");
                break;
            }
            case 1601: {
                string2 = res.getString("errRefIsNotAGroup");
                break;
            }
            case 1602: {
                string2 = res.getString("errRefIsNotObjectType");
                break;
            }
            case 1211: {
                string2 = res.getString("errVariationNotInGroup");
                break;
            }
            case 1212: {
                string2 = res.getString("errIllegalAccessForNotifyVariation");
                break;
            }
            case 1220: {
                string2 = res.getString("errCreationRequiresNotAllowed");
                break;
            }
            case 1221: {
                string2 = res.getString("errCreationRequiresReadCreateCols");
                break;
            }
            case 1010: {
                string2 = res.getString("errIdentifierTooLong");
                break;
            }
            case 1020: {
                string2 = res.getString("errDuplicateIdentifier");
                break;
            }
            case 1811: {
                string2 = res.getString("errMissingIndex");
                break;
            }
            case 4100: {
                string2 = res.getString("errInvalidSyntax4DisplayHint");
                break;
            }
            case 4101: {
                string2 = res.getString("errDisplayHintWrongType");
                break;
            }
            case 6003: {
                string2 = res.getString("errMissingPibTag");
                break;
            }
            case 6004: {
                string2 = res.getString("errMissingPibReference");
                break;
            }
            case 6001: {
                string2 = res.getString("errInvalidPibTag");
                break;
            }
            case 6002: {
                string2 = res.getString("errInvalidPibReference");
                break;
            }
            case 6005: {
                string2 = res.getString("errUniquenessContainsPibIndex");
                break;
            }
            case 6006: {
                string2 = res.getString("errUniquenessDuplicateAttribute");
                break;
            }
            case 6007: {
                string2 = res.getString("errInstallErrorNumberOutofRange");
                break;
            }
            default: {
                string2 = res.getString("errUnknown");
            }
        }
        String string3 = res.getString("txtLocation");
        if (pex.objects == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
            if (pex.fileError instanceof SemanticError) {
                object = pex.fileError;
                objectArray = new Object[1 + object.getExpected().length];
                objectArray[0] = n2 != 0 ? MessageFormat.format(string3, object.getFound(), object.getLine() + lineOffset, object.getColumn()) : object.getFound();
                for (n2 = 0; n2 < object.getExpected().length; ++n2) {
                    objectArray[n2 + 1] = object.getExpected()[n2];
                }
            }
        } else {
            objectArray = new Object[pex.objects.size()];
            pex.objects.toArray(objectArray);
            if (pex.fileError instanceof SemanticError) {
                object = pex.fileError;
                if (objectArray.length <= 0) {
                    void var3_4;
                    objectArray = new Object[]{n2 != 0 ? MessageFormat.format(string3, object.getFound(), object.getLine() + var3_4, object.getColumn()) : object.getFound()};
                }
            }
        }
        object = new DecimalFormat("0000").format(((SMIParseException)((Object)string)).errorType);
        String string4 = "";
        if (var1_1 != false) {
            string = res.getString("txtErrNum");
            string4 = string4 + MessageFormat.format(string, object);
        }
        return string4 + MessageFormat.format(string2, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setOptions(int newOptions) {
        void var1_1;
        this.options = var1_1;
    }

    public int getOptions() {
        return this.options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void importModule(ImportModuleEvent e2) {
        try {
            void var1_1;
            IObject[] iObjectArray = this.getObjects(e2.getModuleName());
            var1_1.setObjects(iObjectArray);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public boolean isModuleAvailable(String moduleName) {
        File file;
        return (file = new File(this.path, (String)((Object)file))).exists() && file.isFile();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeRepositoryListener(RepositoryListener l2) {
        if (this.a != null && this.a.contains(l2)) {
            void var1_1;
            Vector vector = (Vector)this.a.clone();
            vector.removeElement(var1_1);
            this.a = vector;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addRepositoryListener(RepositoryListener l2) {
        Vector vector = this.a == null ? new Vector(2) : (Vector)this.a.clone();
        if (!vector.contains(l2)) {
            void var1_1;
            vector.addElement(var1_1);
            this.a = vector;
        }
    }

    protected void fireWriteModule(RepositoryEvent e2) {
        if (this.a != null) {
            Vector vector = this.a;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RepositoryListener)vector.elementAt(i2)).writeModule(e2);
            }
        }
    }

    protected void fireReadModule(RepositoryEvent e2) {
        if (this.a != null) {
            Vector vector = this.a;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RepositoryListener)vector.elementAt(i2)).readModule(e2);
            }
        }
    }

    protected void fireAfterReadModule(RepositoryEvent e2) {
        if (this.a != null) {
            Vector vector = this.a;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                RepositoryListener repositoryListener = (RepositoryListener)vector.get(i2);
                if (!(repositoryListener instanceof ExtRepsitoryListener)) continue;
                ((ExtRepsitoryListener)repositoryListener).afterReadModule(e2);
            }
        }
    }

    protected void fireDeleteModule(RepositoryEvent e2) {
        if (this.a != null) {
            Vector vector = this.a;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RepositoryListener)vector.elementAt(i2)).deleteModule(e2);
            }
        }
    }

    protected String[] fireListModules() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.a != null) {
            Vector vector = this.a;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray = ((RepositoryListener)vector.get(i2)).listModuleNames();
                if (stringArray == null) continue;
                hashSet.addAll(Arrays.asList(stringArray));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public void setImportTableDependencies(boolean importTableDependencies) {
        void var1_1;
        this.b = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxErrors(int maxErrors) {
        void var1_1;
        this.maxErrors = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUseCompression(boolean useCompression) {
        void var1_1;
        this.d = var1_1;
    }

    public static void setForwardUnknownErrors(boolean forwardUnknownErrors) {
        f = forwardUnknownErrors;
    }

    public boolean isImportTableDependencies() {
        return this.b;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public boolean isUseCompression() {
        return this.d;
    }

    public static boolean isForwardUnknownErrors() {
        return f;
    }

    public static void main(String[] args) {
        String[] stringArray = new DefaultRepositoryManager();
        try {
            stringArray.open(new File(args[0]));
            stringArray = stringArray.verifyRepository(null);
            if (stringArray.length == 0) {
                String[] stringArray2;
                System.out.println("Repository '" + stringArray2[0] + "' is OK.");
                return;
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                System.out.println("File '" + stringArray[i2] + "' is invalid.");
            }
            System.exit(1);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Failed to open repository: " + iOException.getMessage());
            System.exit(2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MIBObject parseObject(String object, String objectName, MIBModule module, boolean parseModuleIdentity, int parseLevel) throws SMIParseException {
        Object object2;
        Serializable serializable;
        Serializable serializable2;
        Object object3;
        Object object4;
        object4 = new StringReader((String)object4);
        object4 = new SMIParser((Reader)object4);
        boolean bl = parseLevel == 2;
        if (bl) {
            ((SMIParser)object4).setLenient(1);
        }
        ((SMIParser)object4).setMaxErrors(this.maxErrors);
        SMIRepository sMIRepository = null;
        try {
            int n2;
            object3 = new HashSet<String>(module.size());
            serializable2 = null;
            Iterator<MIBObject> iterator = module.objectsIterator();
            while (iterator.hasNext()) {
                serializable = iterator.next();
                object2 = serializable.getName();
                if (objectName.equals(object2)) {
                    serializable2 = serializable;
                    continue;
                }
                object3.add(object2);
            }
            int n3 = module.getSMIVersion() == 1 ? 1 : (n2 = module.getSMIVersion() == -1 ? 16 : 2);
            if (parseModuleIdentity) {
                n2 |= 4;
            }
            if (serializable2 instanceof MIBObjectType && ((MIBObjectType)serializable2).isTable()) {
                n2 |= 8;
            }
            sMIRepository = ((SMIParser)object4).InputObject(n2, (Set)object3);
            sMIRepository.addScope(module.getName());
            sMIRepository.setImporter(this);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            SMIParseException sMIParseException = new SMIParseException(parseException.getMessage(), parseException.getShortMessage(), parseException.errorType, parseException);
            if (this.h) {
                sMIParseException.setSmiRepository(sMIRepository);
            }
            sMIParseException.setErrorList(((SMIParser)object4).getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            if (throwable instanceof TokenMgrError) {
                throw new SMIParseException(throwable.getMessage(), null, 50, (TokenMgrError)throwable);
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (((SMIParser)object4).getErrors().size() >= this.maxErrors) {
            object3 = (SMIParseException)((SMIParser)object4).getErrors().get(0);
            if (this.h) {
                ((SMIParseException)object3).setSmiRepository(sMIRepository);
            }
            ((SMIParseException)object3).setErrorList(((SMIParser)object4).getErrors());
            throw object3;
        }
        try {
            void var3_3;
            void var2_2;
            object3 = bl ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options){

                @Override
                public final void checkModule() {
                    this.smiRep.resolveSyntaxes();
                }
            };
            ((SMI2Java)object3).setErrors(((SMIParser)object4).getErrors());
            ((SMI2Java)object3).setMaxErrors(this.maxErrors);
            sMIRepository.setErrorHandler((SMIParseExceptionHandler)object3);
            serializable2 = new HashSet<void>(1);
            serializable2.add(var2_2);
            ((SMI2Java)object3).setParseContext((MIBModule)var3_3, (Set)((Object)serializable2));
            Vector vector = new Vector();
            sMIRepository.jjtAccept((SMIParserVisitor)object3, vector);
            ((SMI2Java)object3).checkModule();
            if (((SMI2Java)object3).getErrors().size() > 0) {
                serializable = (SMIParseException)((SMI2Java)object3).getErrors().get(0);
                ((SMIParseException)serializable).setErrorList(((SMIParser)object4).getErrors());
                throw serializable;
            }
            ((SMI2Java)object3).getRepository().structureChanged();
            serializable = ((SMI2Java)object3).getCurrentObject();
            if (serializable != null) {
                ((SMI2Java)object3).recheckObject((MIBObject)serializable);
            }
            if (((SMI2Java)object3).getErrors().size() > 0) {
                object2 = (SMIParseException)((SMI2Java)object3).getErrors().get(0);
                ((SMIParseException)object2).setErrorList(((SMIParser)object4).getErrors());
                throw object2;
            }
            if (this.h && serializable != null) {
                serializable.userObject = sMIRepository;
            }
            return serializable;
        }
        catch (SMIParseException sMIParseException) {
            if (this.h) {
                sMIParseException.setSmiRepository(sMIRepository);
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throwable.printStackTrace();
            throw new SMIParseException(((Throwable)object3).getMessage(), 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String[] verifyRepository(ProgressCallback progress) {
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        File file = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
        Integer n2 = new Integer(this.c);
        Vector vector = new Vector();
        try {
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                object = new ObjectInputStream(fileInputStream);
                n2 = (Integer)((ObjectInputStream)object).readObject();
                vector = (Vector)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
            }
        }
        catch (Exception exception) {
            linkedList.add(file.getPath());
        }
        boolean bl = false;
        try {
            object = this.getModuleNames();
            HashSet<Integer> hashSet = new HashSet<Integer>(((String[])object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                Object object2;
                block21: {
                    try {
                        if (progress != null && progress.progressEvent(i2, ((Object)object).length, (String)object[i2])) {
                            return null;
                        }
                        object2 = this.loadModuleFromFile((String)object[i2], false);
                        if (((MIBObject)object2).getModuleID() > n2) {
                            if (progress == null) {
                                System.out.println("Warning: Module ID " + ((MIBObject)object2).getModuleID() + " of MIB file " + (String)object[i2] + " is greater than next module ID " + n2 + " (will be corrected)");
                            }
                            n2 = ((MIBObject)object2).getModuleID();
                            bl = true;
                        }
                        if (vector.contains(((MIBObject)object2).getModuleID())) {
                            vector.remove(((MIBObject)object2).getModuleID());
                            bl = true;
                            if (progress == null) {
                                System.out.println("Verification of " + (String)object[i2] + " with ID " + ((MIBObject)object2).getModuleID() + " OK, but using using free ID (will be corrected)");
                            }
                        } else if (hashSet.contains(((MIBObject)object2).getModuleID())) {
                            linkedList.add(object[i2]);
                            if (progress == null) {
                                System.out.println("Verification of " + (String)object[i2] + " failed, because its module ID " + ((MIBObject)object2).getModuleID() + " is alread used by another MIB module (rebuild of the MIB repository is needed)");
                            }
                        } else {
                            hashSet.add(((MIBObject)object2).getModuleID());
                            if (progress == null) {
                                System.out.println("Verified " + (String)object[i2] + " with ID " + ((MIBObject)object2).getModuleID());
                            }
                        }
                    }
                    catch (Exception exception) {
                        linkedList.add(object[i2]);
                        if (progress != null) break block21;
                        System.out.println("Verification of " + (String)object[i2] + " failed: " + exception.getMessage());
                    }
                }
                if (!bl) continue;
                try {
                    object2 = new FileOutputStream(file);
                    object2 = new ObjectOutputStream((OutputStream)object2);
                    ((ObjectOutputStream)object2).writeObject(n2);
                    ((ObjectOutputStream)object2).writeObject(vector);
                    ((ObjectOutputStream)object2).flush();
                    ((ObjectOutputStream)object2).close();
                    continue;
                }
                catch (Exception exception) {
                    if (progress != null) continue;
                    System.err.println("Failed to adjust free module ID list: " + exception.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            void var1_1;
            if (var1_1 == null) {
                System.err.println("Failed to verify repository: " + iOException.getMessage());
            }
            return null;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean refresh(MIBRepository rep, List updated, List removed, boolean simulateOnly) {
        void var3_3;
        void var2_2;
        for (String string : rep.getModuleNames()) {
            MIBModule mIBModule = rep.getModule(string);
            if (mIBModule == null) continue;
            Date date = mIBModule.getLastChange();
            MIBModule mIBModule2 = null;
            try {
                mIBModule2 = this.loadModuleFromFile(string, true);
            }
            catch (Exception exception) {}
            if (mIBModule2 == null) {
                if (removed == null) continue;
                removed.add(string);
                if (simulateOnly) continue;
                rep.remove(mIBModule);
                continue;
            }
            if (mIBModule2 == null || !date.before(mIBModule2.getLastChange())) continue;
            updated.add(string);
            if (simulateOnly) continue;
            rep.remove(mIBModule);
            try {
                mIBModule2 = null;
                mIBModule2 = this.loadModuleFromFile(string, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (mIBModule2 == null) continue;
            rep.addObject(mIBModule2);
            rep.addAllObjects(mIBModule2.getObjects());
        }
        if (!simulateOnly && updated.size() > 0) {
            void var1_1;
            var1_1.structureChanged();
        }
        return var2_2.size() > 0 || removed != null && var3_3.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setExtendedParserInfoEnabled(boolean extendedParserInfoEnabled) {
        void var1_1;
        this.h = var1_1;
    }

    public boolean isExtendedParserInfoEnabled() {
        return this.h;
    }

    static final class b {
        private long a;
        private MIBModule b;

        public b(MIBModule mIBModule) {
            this.b = mIBModule;
            this.a = System.currentTimeMillis();
        }

        static /* synthetic */ long a(b b2) {
            return b2.a;
        }

        static /* synthetic */ MIBModule b(b b2) {
            return b2.b;
        }
    }

    static final class a
    implements FilenameFilter {
        @Override
        public final boolean accept(File path, String name) {
            return name.indexOf(46) < 0;
        }
    }
}

