/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.notepad;

import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.print.SmiTextPrintable;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBModule;
import com.agentpp.notepad.ElementTreePanel;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class SMIEditorPanel
extends JPanel
implements JCSelectListener {
    private static final String CFG_SEARCH = "agentpp.notepad.searchExpression";
    private static final String CFG_REPLACE = "agentpp.notepad.substitution";
    private static ResourceBundle resources;
    private FlexListTable errorTable = new FlexListTable();
    private JCVectorDataSource errorModel = new JCVectorDataSource();
    private TableSorter tableSorter;
    private JScrollPane scroller;
    JFrame myFrame;
    String lastSearch = "";
    private MIBImporter importer = null;
    private UserConfigFile config = new UserConfigFile();
    PatternMatcher matcher = new Perl5Matcher();
    PatternCompiler compiler = new Perl5Compiler();
    Pattern lastPattern;
    PatternMatcherInput input;
    MatchResult result;
    JSplitPane splitPane = new JSplitPane(0);
    private String title = "";
    private MIBModule lookupData;
    private JDialog ccPopup;
    private LinkedList propertyChangeListeners = new LinkedList();
    static final String[] COLUMN_NAMES;
    static final int COL_NR = 0;
    static final int COL_ERROR = 1;
    static final int COL_TEXT = 2;
    private JEditorPane editor;
    private Hashtable commands;
    private Hashtable menuItems;
    private JToolBar toolbar;
    protected StatusBar status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String accelSuffix = "Accelerator";
    public static final String tipSuffix = "Tooltip";
    public static final String printAction = "print";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private ImportAction importAction = new ImportAction();
    private Action[] defaultActions = new Action[]{new FindAction(), new ReplaceAction(), this.importAction, new CheckAccurateAction(), new FindNextAction(), new PrintAction(), this.undoAction, this.redoAction, new PasteAction(), new CutAction()};
    private int parserMode;
    private int tabSize = 8;

    public SMIEditorPanel(JFrame frame) {
        this.myFrame = frame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateEditorState();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setLookupModule(MIBModule lookup) {
        this.lookupData = lookup;
    }

    public void setConfig(UserConfigFile config) {
        this.config = config;
        SmiContext s = ((SmiEditorKit)this.getEditor().getEditorKit()).getStylePreferences();
        Vector v = SmiContext.getStyles(config);
        s.setSyntaxHighlighting(SmiContext.loadSyntaxHighlighting(config));
        s.setStyles(v);
    }

    private void jbInit() {
        this.createErrorTable();
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.setFont(new Font("monospaced", 0, 12));
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            Action a2 = actions[i2];
            this.commands.put(a2.getValue("Name"), a2);
        }
        this.scroller = new JScrollPane();
        JViewport port = this.scroller.getViewport();
        port.add(this.editor);
        port.setScrollMode(1);
        this.menuItems = new Hashtable();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        panel.add("Center", this.splitPane);
        this.splitPane.setBottomComponent(this.scroller);
        this.splitPane.setTopComponent(this.errorTable);
        this.splitPane.setOneTouchExpandable(true);
        this.add("Center", panel);
        this.status = this.createStatusbar();
        this.editor.addCaretListener(this.status);
        this.add("South", this.status);
        panel.setPreferredSize(new Dimension(600, 600));
        this.splitPane.setDividerLocation(0.2);
    }

    public SMIEditorPanel(JFrame f2, String text, int row, int col, int sel) {
        this(f2);
        this.setText(text, row, col, sel);
    }

    public int getCaretPosition() {
        return this.getEditor().getCaretPosition();
    }

    public boolean replace(Pattern pattern, String s) {
        int numSubs = 1;
        Perl5Substitution substitution = new Perl5Substitution(s);
        int r2 = -1;
        int start = -1;
        int stop = -1;
        block8: while (r2 != 1 && this.searchPattern(pattern)) {
            start = this.getEditor().getSelectionStart();
            stop = this.getEditor().getSelectionEnd();
            StringBuffer buf = new StringBuffer();
            String[] text = new String[]{"Replace?"};
            Object[] options = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            r2 = JOptionPane.showOptionDialog(this, text, "Confirm Substitution", 1, 3, null, options, options[0]);
            switch (r2) {
                case 0: {
                    break;
                }
                case 1: {
                    stop = ((SmiDocument)this.editor.getDocument()).getEndPosition().getOffset();
                    numSubs = -1;
                    break;
                }
                case 2: {
                    continue block8;
                }
                case 3: {
                    return false;
                }
            }
            SmiDocument doc = (SmiDocument)this.editor.getDocument();
            int length = stop - start;
            Segment seg = new Segment();
            try {
                doc.getText(start, length, seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.input = new PatternMatcherInput(new String(seg.array, seg.offset, seg.count));
            Util.substitute(buf, this.matcher, pattern, (Substitution)substitution, this.input, numSubs);
            this.getEditor().setSelectionStart(start);
            this.getEditor().setSelectionEnd(stop);
            this.getEditor().replaceSelection(buf.toString());
            this.getEditor().setCaretPosition(start + buf.toString().length());
        }
        if (r2 == 0 || r2 == 1) {
            this.setCaretPosition(start);
        }
        return true;
    }

    public boolean searchPattern(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        this.lastPattern = pattern;
        int start = 0;
        if (this.getEditor().getCaretPosition() > 0) {
            start = this.getEditor().getCaretPosition();
        }
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        int length = doc.getEndPosition().getOffset() - start;
        Segment seg = new Segment();
        try {
            doc.getText(start, length, seg);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        this.input = new PatternMatcherInput(new String(seg.array, seg.offset, length));
        if (this.matcher.contains(this.input, pattern)) {
            int pos = this.input.getMatchBeginOffset() + start;
            int len = this.input.getMatchEndOffset() - this.input.getMatchBeginOffset();
            this.editor.getCaret().setSelectionVisible(true);
            this.editor.setCaretPosition(pos);
            this.editor.moveCaretPosition(pos + len);
            return true;
        }
        this.status.setText("Search complete!");
        return false;
    }

    private Pattern makePattern(String s, boolean quite) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this.compiler.compile(s);
            }
            catch (MalformedPatternException e2) {
                if (quite) break block2;
                JOptionPane.showMessageDialog(this, e2.getMessage(), "Malformed Expression", 0);
            }
        }
        return pattern;
    }

    public boolean searchString(String s) {
        Pattern p2 = this.makePattern(s, true);
        if (p2 != null) {
            return this.searchPattern(p2);
        }
        return false;
    }

    public void setCaretPosition(int pos) {
        this.getEditor().setCaretPosition(pos);
    }

    public boolean setCaretPosition(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            this.editor.setCaretPosition(smidoc.getLineStartOffset(row - 1) + col - 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public boolean setSelectionEnd(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            int startPos = this.editor.getCaret().getDot();
            int endPos = smidoc.getLineStartOffset(row - 1) + col - 1;
            this.setSelectionLength(endPos - startPos + 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public void setSelectionLength(int sel) {
        this.editor.getCaret().setSelectionVisible(true);
        int len = sel;
        while (true) {
            try {
                this.editor.moveCaretPosition(this.editor.getCaretPosition() + len);
            }
            catch (IllegalArgumentException iaex) {
                if (--len > 0) continue;
            }
            break;
        }
    }

    public void setText(String text, int row, int col, int sel) {
        this.setEnabled(false);
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Document doc = this.editor.getDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.setCaretPosition(row, col);
            this.setSelectionLength(sel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.elementTreeFrame != null) {
            this.elementTreePanel.setEditor(this.getEditor());
        }
        doc.addUndoableEditListener(this.undoHandler);
        this.status.removeAll();
        this.status.revalidate();
        this.resetUndoManager();
        this.setEnabled(true);
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected void createErrorTable() {
        this.errorModel.setNumColumns(COLUMN_NAMES.length);
        this.errorModel.setNumRows(0);
        this.errorModel.setColumnLabels(COLUMN_NAMES);
        this.tableSorter = new TableSorter(this.errorTable, this.errorModel);
        this.errorTable.setDataSource(this.errorModel);
        this.errorTable.setPixelHeight(-997, 33001);
        this.errorTable.setRowLabelDisplay(false);
        for (int i2 = 0; i2 < this.errorModel.getNumColumns(); ++i2) {
            this.errorTable.setPixelWidth(i2, 33001);
        }
        this.errorTable.addSelectListener(this);
    }

    protected JEditorPane createEditor() {
        try {
            final JEditorPane editor = new JEditorPane();
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKit(kit);
            editor.setBackground(Color.white);
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            editor.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e2) {
                }

                @Override
                public void keyReleased(KeyEvent e2) {
                    if (SMIEditorPanel.this.importer != null && editor.isEditable() && e2.getModifiers() == 2) {
                        if (e2.getKeyCode() == 90) {
                            if (SMIEditorPanel.this.undo.canUndo()) {
                                SMIEditorPanel.this.undoAction.undo();
                            }
                        } else if (e2.getKeyCode() == 89 && SMIEditorPanel.this.undo.canRedo()) {
                            SMIEditorPanel.this.redoAction.redo();
                        }
                    }
                }

                @Override
                public void keyTyped(KeyEvent e2) {
                    if (SMIEditorPanel.this.importer != null && editor.isEditable() && (e2.getModifiers() & 2) != 0) {
                        if (e2.getKeyChar() == ' ') {
                            SMIEditorPanel.this.codeCompletion();
                        } else if (e2.getKeyCode() == 27 && SMIEditorPanel.this.ccPopup != null) {
                            SMIEditorPanel.this.disposeCodeCompletionPopup();
                        }
                    }
                }
            });
            return editor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JEditorPane getEditor() {
        return this.editor;
    }

    private void disposeCodeCompletionPopup() {
        this.ccPopup.setVisible(false);
        this.ccPopup.dispose();
        this.ccPopup = null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        String sstr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((sstr = this.getResourceString(cmd + accelSuffix)) != null) {
            mi.setAccelerator(KeyStroke.getKeyStroke(sstr));
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a2 = this.getAction(astr);
        if (a2 != null) {
            mi.addActionListener(a2);
            a2.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a2.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected StatusBar createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        for (int i2 = 0; i2 < toolKeys.length; ++i2) {
            if (toolKeys[i2].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createTool(toolKeys[i2]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        ToolBarUtils.setMinimumButtonSize(this.toolbar);
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        Action a2;
        URL url = this.getResource(key + imageSuffix);
        JButton b2 = new JButton((Icon)new ImageIcon(url)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b2.setRequestFocusEnabled(false);
        b2.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a2 = this.getAction(astr)) != null) {
            b2.setActionCommand(astr);
            a2.addPropertyChangeListener(this.createActionChangeListener(b2));
            b2.addActionListener(a2);
            b2.setEnabled(a2.isEnabled());
        } else {
            b2.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b2.setToolTipText(tip);
        }
        return b2;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i2 = 0; i2 < cmd.length; ++i2) {
            cmd[i2] = (String)v.elementAt(i2);
        }
        return cmd;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b2) {
        ActionChangedListener listener = new ActionChangedListener(b2);
        this.propertyChangeListeners.add(listener);
        return listener;
    }

    protected PropertyChangeListener createActionChangeListener(JButton b2) {
        ButtonActionChangedListener listener = new ButtonActionChangedListener(b2);
        this.propertyChangeListeners.add(listener);
        return listener;
    }

    public void setImporter(MIBImporter newImporter) {
        this.importer = newImporter;
        this.updateEditorState();
    }

    private void updateEditorState() {
        if (this.importer == null) {
            this.editor.setEditable(false);
            this.setNonReadOnlyActionsEnabled(false);
        } else {
            this.editor.setEditable(true);
            this.setNonReadOnlyActionsEnabled(true);
            this.redoAction.setEnabled(this.undo.canRedo());
            this.undoAction.setEnabled(this.undo.canUndo());
            this.importAction.setEnabled(this.undo.canUndo());
        }
    }

    private void setNonReadOnlyActionsEnabled(boolean enabled) {
        Action[] actions = this.getActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            if (!(actions[i2] instanceof ModifyAction)) continue;
            actions[i2].setEnabled(enabled);
        }
    }

    public MIBImporter getImporter() {
        return this.importer;
    }

    public void setParserMode(int newParserMode) {
        this.parserMode = newParserMode;
    }

    public int getParserMode() {
        return this.parserMode;
    }

    private boolean importAction() {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getDocumentBytes());
        try {
            this.importer.importMIB(this, bis, "", this.parserMode);
            bis.close();
            this.clearErrors();
            this.status.setText("SMI saved.");
            return true;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return false;
        }
        catch (SMIParseException pex) {
            this.setError(pex);
            this.displayErrorStatus(pex);
            return false;
        }
    }

    public void setSelectionColor(Color c2) {
        this.editor.setSelectionColor(c2);
    }

    public int checkText() {
        try {
            this.clearErrors();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.getDocumentBytes());
            this.importer.checkMIB(this, bis, 1);
            bis.close();
            this.status.setText("SMI check OK.");
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        catch (SMIParseException pex) {
            this.setError(pex);
            return this.displayErrorStatus(pex);
        }
    }

    private int displayErrorStatus(SMIParseException pex) {
        int errCount = pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1;
        this.status.setText("Detected " + errCount + " SMI syntax error" + (errCount > 1 ? "s" : "") + ", see error list above for details.");
        return errCount;
    }

    public void clearErrors() {
        this.errorModel.setNumRows(0);
        this.splitPane.setDividerLocation(0.0);
    }

    public boolean hasUncommitedChanges() {
        return this.undo.canUndo();
    }

    public void setError(SMIParseException pex) {
        this.errorModel.setNumRows(0);
        int n2 = 0;
        if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
            int i2 = 0;
            for (SMIParseException lpex : pex.getErrorList()) {
                if (lpex == pex) {
                    n2 = i2;
                }
                this.addRow(lpex);
                ++i2;
            }
        } else {
            this.addRow(pex);
        }
        this.errorTable.setRowSelection(n2, n2);
        this.splitPane.setDividerLocation(0.2);
    }

    protected void setCurrentErrorLocation(int rowIndex) {
        SMIParseException pex = (SMIParseException)this.errorModel.getTableRowLabel(rowIndex);
        if (pex.hasLocationInfo()) {
            this.setCaretPosition(pex.fileError.getLine(), pex.fileError.getColumn());
            this.setSelectionEnd(pex.fileError.getEndLine(), pex.fileError.getEndColumn());
        } else if (pex.objects != null) {
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (!this.searchString(pex.objects.get(0).toString())) {
                this.setCaretPosition(pos);
            }
        } else {
            StringTokenizer st = new StringTokenizer(pex.getMessage(), ", ");
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (st.hasMoreTokens() && !this.searchString(st.nextToken())) {
                this.setCaretPosition(pos);
            }
        }
    }

    public void print() {
        SmiContext ctx = new SmiContext();
        ctx.setSyntaxHighlighting(true);
        ctx.setStyles(ctx.getDefaultStyles());
        SmiTextPrintable smiPrintable = new SmiTextPrintable((SmiDocument)this.getEditor().getDocument(), new Font("SansSerif", 0, 10), this.config.getBoolean("print.header", true) ? this.getTitle() : null, this.config.getBoolean("print.footer", true) ? this.config.get("print.footerText", "{0} -- page {1}") : null, this.config.getBoolean("print.colored", false), this.config.getBoolean("print.lineNumbers", true), ctx, this.getTabSize());
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(this.getTitle());
        PageFormat pf = new PageFormat();
        pj.pageDialog(pf);
        pj.setPrintable(smiPrintable, pf);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException ex) {
            System.out.println(ex);
        }
    }

    protected byte[] getDocumentBytes() {
        Segment s = new Segment();
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        try {
            doc.getText(0, doc.getLength(), s);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        return String.valueOf(s.array, 0, doc.getLength()).getBytes();
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public String getText() {
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    protected void addRow(SMIParseException pex) {
        Vector<Object> row = new Vector<Object>(COLUMN_NAMES.length);
        row.add(new Integer(this.errorModel.getNumRows() + 1));
        row.add(new Integer(pex.errorType));
        row.add(DefaultRepositoryManager.getErrorText(pex, false).replace('\r', ' '));
        this.errorModel.addRow(Integer.MAX_VALUE, pex, row);
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int row = TableUtils.getFirstSelectedRow(this.errorTable);
        if (row >= 0) {
            this.setCurrentErrorLocation(row);
        }
    }

    public boolean importText() {
        boolean importOK = this.importAction();
        if (importOK) {
            this.undo.discardAllEdits();
            this.undoAction.update();
            this.redoAction.update();
            this.importAction.update();
        }
        return importOK;
    }

    private static boolean isTokenSeparator(char c2) {
        return Character.isWhitespace(c2) || c2 == ',';
    }

    private SMIParseException getCompletion(String text, int maxLength) {
        try {
            int size = Math.min(maxLength, this.getCaretPosition());
            for (int i2 = size - 1; i2 >= 0; --i2) {
                if (Character.isWhitespace(text.charAt(i2))) continue;
                size = i2 + 1;
                break;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(text.substring(0, size).getBytes());
            this.importer.checkMIB(this, bis, 1);
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (SMIParseException pex) {
            return pex;
        }
    }

    public void codeCompletion() {
        SMIParseException pex;
        String text = this.getText();
        int startPos = this.getCaretPosition();
        for (int i2 = startPos - 1; i2 >= 1; --i2) {
            if (SMIEditorPanel.isTokenSeparator(text.charAt(i2))) {
                this.editor.setCaretPosition(i2 + 1);
                break;
            }
            if (i2 != 1) continue;
            this.editor.setCaretPosition(1);
            break;
        }
        if ((pex = this.getCompletion(text, this.editor.getDocument().getLength())) != null) {
            if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                boolean found = false;
                for (SMIParseException ip : pex.getErrorList()) {
                    if (!ip.hasLocationInfo() || ip.fileError.getEndPosition() < this.getCaretPosition()) continue;
                    pex = ip;
                    found = true;
                    break;
                }
                if (!found) {
                    pex = pex.getErrorList().get(0);
                }
            }
            if (pex == null || pex.fileError == null) {
                return;
            }
            if (pex.hasLocationInfo()) {
                for (int i3 = startPos; i3 < text.length(); ++i3) {
                    if (!SMIEditorPanel.isTokenSeparator(text.charAt(i3))) continue;
                    this.editor.moveCaretPosition(i3);
                    break;
                }
            } else {
                return;
            }
            HashSet completions = new HashSet();
            String[] exp = pex.fileError.getLastExpectedImages();
            for (int i4 = 0; i4 < exp.length; ++i4) {
                String s = exp[i4];
                StringTokenizer st = new StringTokenizer(s, "\"", true);
                boolean lastWasQuote = false;
                StringBuffer buf = new StringBuffer(s.length());
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("\"".equals(token)) {
                        if (!lastWasQuote) continue;
                        lastWasQuote = true;
                    } else {
                        lastWasQuote = false;
                    }
                    buf.append(token);
                }
                this.addCompletions(buf.toString(), completions);
            }
            if (this.ccPopup != null) {
                this.ccPopup.setVisible(false);
                this.ccPopup.dispose();
            }
            if (completions.isEmpty()) {
                return;
            }
            if (completions.size() == 1) {
                boolean addSpace = false;
                this.replaceCurrentSelection((String)completions.iterator().next(), addSpace);
            } else {
                this.ccPopup = new JDialog(this.myFrame);
                this.ccPopup.setTitle("SMI Completion");
                Vector completionVector = new Vector(completions);
                Collections.sort(completionVector);
                this.ccPopup.getContentPane().setLayout(new BorderLayout(5, 5));
                JScrollPane spane = new JScrollPane(20, 31);
                JList completionSelection = new JList(completionVector){

                    @Override
                    public void setSelectedIndex(int selectionIndex) {
                        super.setSelectedIndex(selectionIndex);
                        super.ensureIndexIsVisible(selectionIndex);
                    }
                };
                completionSelection.setSelectedIndex(0);
                boolean addSpace = false;
                CodeCompletionListener ccl = new CodeCompletionListener(pex, this.ccPopup, completionSelection, addSpace);
                completionSelection.addMouseListener(ccl);
                completionSelection.addKeyListener(ccl);
                spane.getViewport().add(completionSelection);
                this.ccPopup.getContentPane().add((Component)spane, "Center");
                Rectangle pos = null;
                try {
                    pos = this.editor.modelToView(this.getCaretPosition());
                    Point loc = pos.getLocation();
                    loc.translate(this.editor.getLocationOnScreen().x, this.editor.getLocationOnScreen().y + 12);
                    this.ccPopup.setLocation(loc);
                }
                catch (BadLocationException ex1) {
                    ex1.printStackTrace();
                }
                this.ccPopup.pack();
                this.ccPopup.setVisible(true);
            }
        }
    }

    private void replaceCurrentSelection(String replacement, boolean addSpace) {
        String r2 = addSpace ? " " : "";
        r2 = r2 + replacement;
        this.editor.replaceSelection(r2);
    }

    private static boolean isTokenImage(String s, int id) {
        return s.startsWith(SMIParserConstants.tokenImage[id]);
    }

    private void addCompletions(String string, Set completions) {
        if (string.trim().length() == 0) {
            return;
        }
        if (this.lookupData != null) {
            if (SMIEditorPanel.isTokenImage(string, 120)) {
                completions.addAll(this.lookupData.getLowerCaseNames());
                return;
            }
            if (SMIEditorPanel.isTokenImage(string, 119)) {
                completions.addAll(this.lookupData.getUpperCaseNames());
                return;
            }
        } else {
            if (SMIEditorPanel.isTokenImage(string, 120)) {
                completions.add("lowerCaseName");
                return;
            }
            if (SMIEditorPanel.isTokenImage(string, 119)) {
                completions.add("UpperCaseName");
                return;
            }
        }
        if (SMIEditorPanel.isTokenImage(string, 8)) {
            completions.add("OBJECT IDENTIFIER");
        } else if (SMIEditorPanel.isTokenImage(string, 9)) {
            completions.add("OCTET STRING");
        } else if (SMIEditorPanel.isTokenImage(string, 11)) {
            completions.add("''h");
        } else if (SMIEditorPanel.isTokenImage(string, 10)) {
            completions.add("''b");
        } else if (SMIEditorPanel.isTokenImage(string, 16)) {
            completions.add("-1");
        } else if (SMIEditorPanel.isTokenImage(string, 15)) {
            completions.add("1");
        } else if (SMIEditorPanel.isTokenImage(string, 13)) {
            completions.add("\"\"");
        } else if (SMIEditorPanel.isTokenImage(string, 12)) {
            completions.add("\"\"");
        } else {
            completions.add(string);
        }
    }

    static {
        COLUMN_NAMES = new String[]{"Number", "Error", "Description"};
        try {
            resources = ResourceBundle.getBundle("com.agentpp.notepad.SMIEditorPanel", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("Notepad.properties not found");
        }
    }

    private class CodeCompletionListener
    implements MouseListener,
    KeyListener {
        private SMIParseException pex;
        private JDialog popup;
        private JList list;
        private boolean addSpace;

        public CodeCompletionListener(SMIParseException pex, JDialog popup, JList list, boolean addSpace) {
            this.pex = pex;
            this.popup = popup;
            this.list = list;
            this.addSpace = addSpace;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                this.replace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                this.replace();
            } else if (e2.getKeyCode() == 27) {
                this.popup.setVisible(false);
                this.popup.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        private void replace() {
            String s = (String)this.list.getSelectedValue();
            if (s == null) {
                return;
            }
            SMIEditorPanel.this.replaceCurrentSelection(s, this.addSpace);
            this.popup.setVisible(false);
            this.popup.dispose();
        }
    }

    static interface ModifyAction {
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super(SMIEditorPanel.printAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SMIEditorPanel.this.print();
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(SMIEditorPanel.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SMIEditorPanel.this.elementTreeFrame == null) {
                try {
                    String title = resources.getString("ElementTreeFrameTitle");
                    SMIEditorPanel.this.elementTreeFrame = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    SMIEditorPanel.this.elementTreeFrame = new JFrame();
                }
                SMIEditorPanel.this.elementTreeFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent weeee) {
                        SMIEditorPanel.this.elementTreeFrame.setVisible(false);
                    }
                });
                Container fContentPane = SMIEditorPanel.this.elementTreeFrame.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                SMIEditorPanel.this.elementTreePanel = new ElementTreePanel(SMIEditorPanel.this.getEditor());
                fContentPane.add(SMIEditorPanel.this.elementTreePanel);
                SMIEditorPanel.this.elementTreeFrame.pack();
            }
            SMIEditorPanel.this.elementTreeFrame.setVisible(true);
        }
    }

    class CheckAccurateAction
    extends AbstractAction {
        CheckAccurateAction() {
            super("CheckAccurate");
        }

        CheckAccurateAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SMIEditorPanel.this.importer != null) {
                int errCount = SMIEditorPanel.this.checkText();
                if (errCount == 0) {
                    SMIEditorPanel.this.status.setText("SMI check OK.");
                } else {
                    SMIEditorPanel.this.status.setText("Detected " + errCount + " SMI syntax error" + (errCount > 1 ? "s" : "") + ", see error list above for details.");
                }
            }
        }
    }

    static class PasteAction
    extends TextAction
    implements ModifyAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.paste();
            }
        }
    }

    public static class CutAction
    extends TextAction
    implements ModifyAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.cut();
            }
        }
    }

    class ImportAction
    extends AbstractAction
    implements ModifyAction {
        ImportAction() {
            super("Import");
        }

        ImportAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SMIEditorPanel.this.importText();
        }

        public void update() {
            if (SMIEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class FindNextAction
    extends AbstractAction {
        FindNextAction() {
            super("FindNext");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SMIEditorPanel.this.searchPattern(SMIEditorPanel.this.lastPattern);
        }
    }

    class ReplaceAction
    extends AbstractAction
    implements ModifyAction {
        ReplaceAction() {
            super("Replace");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(true);
            sp.setSearchExpressions(SMIEditorPanel.this.config.getArray(SMIEditorPanel.CFG_SEARCH));
            sp.setSubstitutionStrings(SMIEditorPanel.this.config.getArray(SMIEditorPanel.CFG_REPLACE));
            StandardDialog sd = new StandardDialog((Frame)SMIEditorPanel.this.myFrame, "Replace", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(SMIEditorPanel.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = SMIEditorPanel.this.makePattern(sp.getSearchExpression(), false)) == null) continue;
                SMIEditorPanel.this.config.putArray(SMIEditorPanel.CFG_SEARCH, sp.getSearchExpressions());
                SMIEditorPanel.this.config.putArray(SMIEditorPanel.CFG_REPLACE, sp.getSubstitutionStrings());
                SMIEditorPanel.this.replace(p2, sp.getSubstitutionString());
                break;
            } while (sd.getResult() == 0);
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction() {
            super("Find");
        }

        private String getSelection() {
            if (SMIEditorPanel.this.getEditor().getSelectedText() != null) {
                return SMIEditorPanel.this.getEditor().getSelectedText();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(false);
            Vector v = SMIEditorPanel.this.config.getArray(SMIEditorPanel.CFG_SEARCH);
            if (this.getSelection() != null) {
                v.insertElementAt(this.getSelection(), 0);
            }
            sp.setSearchExpressions(v);
            StandardDialog sd = new StandardDialog((Frame)SMIEditorPanel.this.myFrame, "Find", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(SMIEditorPanel.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = SMIEditorPanel.this.makePattern(sp.getSearchExpression(), false)) == null) continue;
                SMIEditorPanel.this.config.putArray(SMIEditorPanel.CFG_SEARCH, sp.getSearchExpressions());
                SMIEditorPanel.this.searchPattern(p2);
                break;
            } while (sd.getResult() == 0);
        }
    }

    class RedoAction
    extends AbstractAction
    implements ModifyAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.redo();
        }

        public void redo() {
            if (SMIEditorPanel.this.undo.canRedo()) {
                try {
                    SMIEditorPanel.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            SMIEditorPanel.this.undoAction.update();
            SMIEditorPanel.this.importAction.update();
        }

        protected void update() {
            if (SMIEditorPanel.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", SMIEditorPanel.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction
    implements ModifyAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.undo();
        }

        protected void update() {
            if (SMIEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", SMIEditorPanel.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        public void undo() {
            if (SMIEditorPanel.this.undo.canUndo()) {
                try {
                    SMIEditorPanel.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            SMIEditorPanel.this.redoAction.update();
            SMIEditorPanel.this.importAction.update();
        }
    }

    class StatusBar
    extends JLabel
    implements CaretListener {
        public StatusBar() {
            super(" ");
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void caretUpdate(CaretEvent e2) {
            int dot = e2.getDot();
            SmiDocument smidoc = (SmiDocument)SMIEditorPanel.this.editor.getDocument();
            int line = smidoc.getLineOfOffset(dot) + 1;
            int col = dot + 1 - smidoc.getLineStartOffset(smidoc.getLineOfOffset(dot));
            this.setText(line + ":" + col);
            this.setToolTipText("Cursor is located at row " + line + ", column " + col);
        }

        @Override
        public void paint(Graphics g2) {
            super.paint(g2);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e2) {
            SMIEditorPanel.this.undo.addEdit(e2.getEdit());
            SMIEditorPanel.this.undoAction.update();
            SMIEditorPanel.this.redoAction.update();
            SMIEditorPanel.this.importAction.update();
        }
    }

    private class ButtonActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ButtonActionChangedListener(JButton b2) {
            this.button = b2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (e2.getPropertyName().equals("Name")) {
                String text = (String)e2.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }
}

