/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBComplianceObject;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.mib.pib.PIBModule;
import com.agentpp.mib.pib.PIBObjectType;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.SMI;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class MIBModule2PDF {
    private static final String STYLE_COMMENT = "Comments";
    private static final String STYLE_KEYWORD = "Keywords";
    private static final String STYLE_IDENTIFIER = "Identifier";
    private static final String STYLE_VALUE = "Values";
    private static final String STYLE_TYPE = "Types";
    private static final String STYLE_CLAUSE = "Clauses";
    private static final String STYLE_TEXT = "Text";
    private static final int TREE_MODE = 160;
    private static final int FLAT_MODE = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository rep;
    private Vector fontStyles;
    private int tabSize = 8;
    private int smiversion = 2;
    private int mode = 160;
    private float leading = 11.0f;
    private float fontSize = 10.0f;
    private String moduleName = "";
    private Rectangle pageSize;
    private Date currentDate;
    private Font defaultFont = FontFactory.getFont("Courier", this.fontSize, 0);
    private Hashtable fonts = new Hashtable();
    private boolean keepTogether;
    private boolean displayPageNumbers;
    private boolean outlineTree = true;
    private boolean showBookmarks = true;
    private Vector bookmarks = new Vector();
    private int lastBookmark = 0;
    private boolean displayCurrentDate;

    public MIBModule2PDF(MIBRepository rep, Vector fontStyles, int tabSize) {
        this.rep = rep;
        this.fontStyles = fontStyles;
        this.tabSize = tabSize;
        this.initFonts(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this.defaultFont.setSize(fontSize);
    }

    private void initFonts(Vector fontStyles) {
        for (int i2 = 0; i2 < fontStyles.size(); ++i2) {
            FontStyle style = (FontStyle)fontStyles.elementAt(i2);
            int s = 0;
            if (style.isBold() && style.isItalic()) {
                s = 3;
            } else if (style.isBold()) {
                s = 1;
            } else if (style.isItalic()) {
                s = 2;
            }
            Font f2 = FontFactory.getFont(this.defaultFont.getFamilyname(), this.defaultFont.getSize(), s, style.getColor());
            this.fonts.put(style.getName(), f2);
        }
    }

    private String tab(int num) {
        StringBuffer buf = new StringBuffer(num);
        for (int i2 = 0; i2 < num * this.tabSize; ++i2) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m2, OutputStream os, String creator, Rectangle pageSize) throws DocumentException {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        this.currentDate = new Date();
        this.smiversion = m2.getSMIVersion();
        this.moduleName = m2.getModuleName();
        this.pageSize = pageSize;
        Document doc = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance(doc, os);
        doc.addAuthor(System.getProperty("user.name"));
        doc.addKeywords(m2.getModuleName() + ", " + (m2.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", MIB specification");
        doc.addTitle(m2.getModuleName());
        doc.addCreator(creator);
        this.initBookmarks(m2);
        MyPageEvents events = new MyPageEvents();
        writer.setPageEvent(events);
        doc.open();
        if (m2.hasCopyrightComment()) {
            this.bookmarks.add(null);
            doc.add(new Paragraph(this.leading, m2.getCopyrightComment(), (Font)this.fonts.get(STYLE_COMMENT)));
        }
        doc.add(this.normal("\n"));
        this.writeModule(doc, m2);
        if (m2.hasCopyrightCommentEnd()) {
            this.bookmarks.add(null);
            doc.add(new Paragraph(this.leading, m2.getCopyrightCommentEnd(), (Font)this.fonts.get(STYLE_COMMENT)));
        }
        try {
            doc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initBookmarks(MIBModule m2) {
        this.bookmarks = new Vector(m2.size() + 1);
        this.lastBookmark = 0;
    }

    private Chunk keyWord(String keyword) {
        return new Chunk(keyword, (Font)this.fonts.get(STYLE_KEYWORD));
    }

    private Chunk normal(String text) {
        return new Chunk(text, this.defaultFont);
    }

    private Chunk comment(String text) {
        return new Chunk(text, (Font)this.fonts.get(STYLE_COMMENT));
    }

    private Chunk text(String text) {
        return new Chunk(text, (Font)this.fonts.get(STYLE_TEXT));
    }

    private Phrase text(int ident, String lines) {
        String prefix = this.tab(ident);
        if (lines == null) {
            return new Phrase(prefix + "\"\"", (Font)this.fonts.get(STYLE_TEXT));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Phrase p2 = new Phrase();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                p2.add(this.text(s));
                continue;
            }
            if (s.equals("\r")) continue;
            p2.add(this.text(prefix + s));
        }
        return p2;
    }

    private Chunk clause(String text) {
        return new Chunk(text, (Font)this.fonts.get(STYLE_CLAUSE));
    }

    private Chunk type(String text) {
        return new Chunk(text, (Font)this.fonts.get(STYLE_TYPE));
    }

    private Chunk value(String value) {
        return new Chunk(value, (Font)this.fonts.get(STYLE_VALUE));
    }

    private Chunk identifier(String value) {
        return new Chunk(value, (Font)this.fonts.get(STYLE_IDENTIFIER));
    }

    private Chunk objectLink(String objectName) {
        Chunk chunk = new Chunk(objectName, (Font)this.fonts.get(STYLE_IDENTIFIER));
        chunk.setLocalGoto(objectName);
        return chunk;
    }

    private void writeRange(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add(this.value(range.getUpper().toString()));
        } else {
            doc.add(this.value(range.getLower().toString()));
            doc.add(this.normal(".."));
            doc.add(this.value(range.getUpper().toString()));
        }
    }

    private void writeEnum(Paragraph doc, IEnum enumeration) {
        doc.add(this.identifier(enumeration.getLabel()));
        doc.add(this.normal("("));
        doc.add(this.value(enumeration.getValue()));
        doc.add(this.normal(")"));
    }

    private void writeSyntax(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add(this.keyWord("SEQUENCE OF "));
                doc.add(this.value(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this.rep.getObject(syn.getSyntax()) != null) {
                    doc.add(this.objectLink(syn.getSyntax()));
                } else {
                    doc.add(this.type(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this.rep.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add(this.normal(" ("));
                    doc.add(this.keyWord("SIZE"));
                }
                doc.add(this.normal(" ("));
                Enumeration<MIBRange> en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this.writeRange(doc, en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add(this.normal(" | "));
                }
                doc.add(this.normal(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add(this.normal(")"));
            }
        }
        if (syn.hasEnums()) {
            this.writeEnums(doc, syn.getEnumsVector());
        }
    }

    private void writeEnums(Paragraph doc, List<MIBEnum> enums) {
        doc.add(this.normal(" {\n" + this.tab(3)));
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum enumeration = en.next();
            this.writeEnum(doc, enumeration);
            if (enumeration.hasComment()) {
                if (en.hasNext()) {
                    doc.add(this.normal(","));
                } else {
                    doc.add(this.normal(" "));
                }
                String space = MIBObject.space(max - enumeration.toString().length() + 1);
                doc.add(this.normal(space));
                String lines = enumeration.getComment();
                String first = enumeration.getComment();
                int suffix = lines.indexOf(10);
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                doc.add(this.comment(this.tab(1) + first));
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n");
                    while (st.hasMoreTokens()) {
                        doc.add(this.normal("\n" + this.tab(4) + MIBObject.space(max)));
                        doc.add(this.comment(st.nextToken()));
                    }
                }
                doc.add(this.normal("\n" + this.tab(3)));
                continue;
            }
            if (en.hasNext()) {
                doc.add(this.normal(",\n" + this.tab(3)));
                continue;
            }
            doc.add(this.normal(" "));
        }
        doc.add(this.normal("}"));
    }

    private void writeSmiDefBegin(Paragraph doc, MIBObject o2) {
        doc.add(this.normal(this.tab(1)));
        doc.add(this.clause("STATUS      "));
        if (!o2.hasStatus()) {
            doc.add(this.normal("current"));
        } else {
            doc.add(this.normal(o2.getStatus()));
        }
        doc.add(this.normal("\n" + this.tab(1)));
        doc.add(this.clause("DESCRIPTION"));
        if (!o2.hasDescription()) {
            doc.add(this.text(" \"\"\n"));
        } else {
            doc.add(this.normal("\n"));
            doc.add(this.text(2, o2.getDescription()));
            doc.add(this.normal("\n"));
        }
        if (o2 instanceof PIBObjectType) {
            doc.add(this.normal(this.tab(1)));
            doc.add(this.clause("INSTALL-ERRORS"));
            this.writeEnums(doc, ((PIBObjectType)o2).getInstallErrors());
            doc.add(this.normal("\n"));
        }
        if (o2.hasReference()) {
            doc.add(this.normal(this.tab(1)));
            doc.add(this.clause("REFERENCE"));
            doc.add(this.text(2, o2.getReference()));
            doc.add(this.normal("\n"));
        }
    }

    private void writeObjectID(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add(this.normal("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                if (qualified != null) {
                    doc.add(this.objectLink(qualified + "." + parent.getName()));
                } else {
                    doc.add(this.objectLink(parent.getName()));
                }
            }
            doc.add(this.normal(" "));
            for (int i2 = oid.size() - diff; i2 < oid.size(); ++i2) {
                String oname = null;
                if (i2 + 1 < oid.size()) {
                    this.rep.getObjectName(oid.getPrefix(i2 + 1));
                }
                if (oname != null) {
                    doc.add(this.identifier(oname));
                    doc.add(this.normal("("));
                    doc.add(this.value(oid.getSubID(i2)));
                    doc.add(this.normal(")"));
                } else {
                    doc.add(this.value(oid.getSubID(i2)));
                }
                doc.add(this.normal(" "));
            }
            doc.add(this.normal("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add(this.normal("{ " + oid.toString() + " }"));
        }
    }

    private void writeSmiOidDef(Paragraph doc, MIBObject o2, MIBObject parent) {
        MIBObject[] parents = this.rep.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this.writeObjectID(doc, o2.getOid(), parent, null);
        } else {
            String m2 = this.rep.getModuleName(parent.getModuleID());
            if (m2 == null) {
                this.writeObjectID(doc, o2.getOid(), parent, null);
            } else {
                this.writeObjectID(doc, o2.getOid(), parent, m2);
            }
        }
    }

    private void writeSmiDefEnd(Paragraph doc, MIBObject o2) {
        if ((this.mode & 0x20) > 0) {
            if ((this.mode & 0x400) > 0) {
                doc.add(this.comment(" -- " + o2.getPrintableOid() + " --  "));
            } else {
                doc.add(this.normal(this.tab(1)));
                doc.add(this.comment("-- " + o2.getPrintableOid()));
                doc.add(this.normal("\n"));
                doc.add(this.normal(this.tab(1)));
            }
        } else {
            doc.add(this.normal(this.tab(1)));
        }
        doc.add(this.keyWord("::= "));
        MIBObject parent = this.rep.getParent(o2);
        if (parent == null) {
            doc.add(this.normal(o2.getOid().toSMI()));
        } else if (o2 instanceof MIBModule && parent.getModuleID() == o2.getModuleID()) {
            while (parent != null && parent.getModuleID() == o2.getModuleID()) {
                parent = this.rep.getParent(parent);
            }
            if (parent == null) {
                this.writeObjectID(doc, o2.getOid(), parent, null);
            } else {
                this.writeSmiOidDef(doc, o2, parent);
            }
        } else {
            this.writeSmiOidDef(doc, o2, parent);
        }
    }

    private void writeIndex(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            if (index instanceof PIBIndexPart) {
                doc.add(this.clause("PIB-INDEX "));
            } else {
                doc.add(this.clause("INDEX "));
            }
        } else if (index.getType() == 3) {
            doc.add(this.clause("EXTENDS "));
        } else {
            doc.add(this.clause("AUGMENTS "));
        }
        doc.add(this.normal("{\n"));
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this.normal(this.tab(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add(this.keyWord("IMPLIED "));
            }
            doc.add(this.objectLink(element));
            if (en.hasMoreElements()) {
                doc.add(this.normal(",\n"));
                continue;
            }
            doc.add(this.normal("\n"));
        }
        doc.add(this.normal(this.tab(1) + "}\n"));
    }

    private void writeObjectIdentity(Document doc, MIBObject o2) throws DocumentException {
        Paragraph para = this.buildObject(doc, o2);
        if (o2.getType() == 0 && o2.hasStatus()) {
            para.add(this.keyWord(" OBJECT-IDENTITY\n"));
            this.writeSmiDefBegin(para, o2);
        } else {
            para.add(this.keyWord(" OBJECT IDENTIFIER"));
        }
        para.add(this.normal("\n"));
        this.writeSmiDefEnd(para, o2);
        doc.add(para);
    }

    private void writeObjectType(Document doc, MIBObjectType ot) throws DocumentException {
        Paragraph p2 = this.buildObject(doc, ot);
        p2.add(this.keyWord(" OBJECT-TYPE"));
        p2.add(this.normal("\n" + this.tab(1)));
        p2.add(this.clause("SYNTAX      "));
        this.writeSyntax(p2, ot.getSyntax());
        p2.add(this.normal("\n"));
        if (ot.hasUnits()) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p2.add(this.normal("\n"));
                p2.add(this.text(2, ot.getUnits()));
            } else {
                p2.add(this.text(ot.getUnits()));
            }
            p2.add(this.normal("\n"));
        }
        p2.add(this.normal(this.tab(1)));
        if (ot.getAccess() != null) {
            if (this.smiversion == 1) {
                p2.add(this.clause("ACCESS      "));
            } else {
                p2.add(this.clause("MAX-ACCESS  "));
            }
            p2.add(this.normal(ot.getAccess()));
            p2.add(this.normal("\n"));
        }
        this.writeSmiDefBegin(p2, ot);
        if (ot.hasIndexPart()) {
            p2.add(this.normal(this.tab(1)));
            this.writeIndex(p2, ot.getIndexPart());
        }
        if (ot instanceof PIBObjectType) {
            p2.add(this.normal(this.tab(1)));
            this.writeIndex(p2, ((PIBObjectType)ot).getMibIndexPart());
            if (((PIBObjectType)ot).getUniqueObjects() != null) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("UNIQUENESS  "));
                p2.add("{\n");
                Iterator<String> it = ((PIBObjectType)ot).getUniqueObjects().iterator();
                while (it.hasNext()) {
                    String element = it.next();
                    doc.add(this.normal(this.tab(2)));
                    doc.add(this.objectLink(element));
                    if (it.hasNext()) {
                        doc.add(this.normal(",\n"));
                        continue;
                    }
                    doc.add(this.normal("\n"));
                }
                doc.add(this.normal(this.tab(1) + "}\n"));
            }
        }
        if (ot.hasDefaultValue()) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("DEFVAL      "));
            p2.add(this.normal("{ "));
            p2.add(this.value(ot.getDefaultValue()));
            p2.add(this.normal(" }\n"));
        }
        this.writeSmiDefEnd(p2, ot);
        if (this.rep != null && ot.isTable()) {
            p2.add(this.normal("\n\n"));
            p2.add(this.identifier(ot.getSyntax().getSyntax()));
            p2.add(this.normal(" ::= "));
            p2.add(this.keyWord("SEQUENCE"));
            p2.add(this.normal(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().iterator());
            if (ot.getTableEntriesVector().size() == 0) {
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                p2.add(this.normal(this.tab(2)));
                p2.add(this.objectLink(s));
                p2.add(this.normal(MIBObject.space(max - s.length() + 1)));
                MIBObjectType o2 = (MIBObjectType)this.rep.getObject(s);
                if (o2 == null) continue;
                p2.add(this.identifier(o2.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p2.add(this.normal(",\n"));
                    continue;
                }
                p2.add(this.normal("\n" + this.tab(1) + "}\n"));
            }
            p2.add(this.normal("\n"));
        }
        doc.add(p2);
    }

    private Paragraph buildObject(Document doc, MIBObject o2) throws DocumentException {
        if (o2.hasComment()) {
            this.bookmarks.add(null);
            doc.add(new Paragraph(this.leading, this.comment(o2.getComment())));
        }
        Chunk chunk = new Chunk(o2.getName(), (Font)this.fonts.get(STYLE_IDENTIFIER));
        chunk.setLocalDestination(o2.getName());
        this.bookmarks.add(o2);
        Paragraph para = new Paragraph(this.leading, "\n");
        para.add(chunk);
        para.setKeepTogether(this.keepTogether);
        return para;
    }

    private Phrase objectRefs(int indent, Enumeration en, boolean link) {
        Phrase doc = new Phrase();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this.normal(this.tab(indent)));
            if (link) {
                doc.add(this.objectLink(element));
            } else {
                doc.add(this.identifier(element));
            }
            if (en.hasMoreElements()) {
                doc.add(this.normal(",\n"));
                continue;
            }
            doc.add(this.normal("\n"));
        }
        return doc;
    }

    private void writeNotifyType(Document doc, MIBNotifyType o2) throws DocumentException {
        Paragraph p2 = this.buildObject(doc, o2);
        if (o2.isV1Trap()) {
            p2.add(this.keyWord(" TRAP-TYPE"));
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("ENTERPRISE "));
            p2.add(this.normal(o2.getEnterprise() + "\n"));
            if (o2.hasVariables()) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("VARIABLES"));
                p2.add(this.normal(" {\n"));
                p2.add(this.objectRefs(2, o2.getVariablesVector().elements(), true));
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            if (o2.hasDescription()) {
                p2.add(this.normal("\n" + this.tab(1)));
                p2.add(this.clause("DESCRIPTION "));
                p2.add(this.normal("\n"));
                if (!o2.hasDescription()) {
                    p2.add(this.text(" \"\"\n"));
                } else {
                    p2.add(this.normal("\n"));
                    p2.add(this.text(2, o2.getDescription()));
                    p2.add(this.normal("\n"));
                }
            }
        } else {
            p2.add(this.clause(" NOTIFICATION-TYPE"));
            p2.add(this.normal("\n"));
            if (o2.hasVariables()) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("OBJECTS"));
                p2.add(this.normal(" {\n"));
                p2.add(this.objectRefs(2, o2.getVariablesVector().elements(), true));
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            this.writeSmiDefBegin(p2, o2);
        }
        if (o2.isV1Trap()) {
            try {
                p2.add(this.normal(" ::= "));
                p2.add(this.value("" + o2.getOid().getLastSubID()));
                p2.add(this.normal("\n"));
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        } else {
            this.writeSmiDefEnd(p2, o2);
        }
        doc.add(p2);
    }

    private void writeGroup(Document doc, MIBGroup o2) throws DocumentException {
        Paragraph p2 = this.buildObject(doc, o2);
        p2.add(this.keyWord(" " + SMI.ENTRY_TYPES[o2.getType()]));
        p2.add(this.normal("\n"));
        if (o2.getType() == 7) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("NOTIFICATIONS"));
            p2.add(this.normal(" {\n"));
        } else {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("OBJECTS"));
            p2.add(this.normal(" {\n"));
        }
        p2.add(this.objectRefs(2, o2.getObjectsVector().elements(), true));
        p2.add(this.normal(this.tab(1) + "}\n"));
        this.writeSmiDefBegin(p2, o2);
        this.writeSmiDefEnd(p2, o2);
        doc.add(p2);
    }

    private void writeVariation(Paragraph p2, MIBVariation o2) {
        p2.add(this.normal(this.tab(1)));
        if (o2 instanceof MIBException) {
            p2.add(this.clause("OBJECT         "));
        } else {
            p2.add(this.clause("VARIATION      "));
        }
        p2.add(this.normal(o2.getVariation()));
        if (o2.hasSyntax()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("SYNTAX       "));
            this.writeSyntax(p2, o2.getSyntax());
        }
        if (o2.hasWriteSyntax()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("WRITE-SYNTAX "));
            this.writeSyntax(p2, o2.getWriteSyntax());
        }
        if (o2.hasAccess()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            if (o2 instanceof MIBException) {
                if (o2 instanceof PIBComplianceObject) {
                    p2.add(this.clause("PIB-MIN-ACCESS "));
                } else {
                    p2.add(this.clause("MIN-ACCESS   "));
                }
            } else {
                p2.add(this.clause("ACCESS       "));
            }
            p2.add(this.normal(o2.getAccess()));
        }
        if (o2.hasCreationRequires()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("CREATION-REQUIRES"));
            p2.add(this.normal(" {\n"));
            p2.add(this.objectRefs(3, o2.getCreationRequiresVector().elements(), false));
            p2.add(this.normal(" }"));
        }
        if (o2.hasDefaultValue()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("DEFVAL       "));
            p2.add(this.normal(" { "));
            p2.add(this.normal(o2.getDefval()));
            p2.add(this.normal(" }"));
        }
        p2.add(this.normal("\n" + this.tab(1) + "  "));
        p2.add(this.clause("DESCRIPTION "));
        if (o2.getDescription() != null) {
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getDescription()));
        } else {
            p2.add(this.text("\"\""));
        }
        p2.add(this.normal("\n"));
    }

    private void writeComplianceModule(Paragraph p2, MIBComplianceModule o2) {
        p2.add(this.normal(this.tab(1)));
        p2.add(this.clause("MODULE "));
        if (o2.hasModuleName()) {
            p2.add(this.identifier(o2.getModuleName()));
        }
        p2.add(this.normal("\n"));
        if (o2.hasMandatory()) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("MANDATORY-GROUPS"));
            p2.add(this.normal(" {\n"));
            p2.add(this.objectRefs(3, o2.getMandatoryVector().elements(), false));
            p2.add(this.normal(this.tab(1) + "}\n"));
        }
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this.writeVariation(p2, v);
            }
        }
    }

    private void writeCompliance(Document doc, MIBCompliance o2) throws DocumentException {
        if (this.smiversion > 1) {
            Paragraph p2 = this.buildObject(doc, o2);
            p2.add(this.keyWord(" MODULE-COMPLIANCE"));
            p2.add(this.normal("\n"));
            this.writeSmiDefBegin(p2, o2);
            Enumeration<MIBComplianceModule> en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this.writeComplianceModule(p2, en.nextElement());
            }
            this.writeSmiDefEnd(p2, o2);
            doc.add(p2);
        }
    }

    private void writeSupportedModule(Paragraph p2, MIBSupportedModule o2) {
        p2.add(this.normal("\n\n" + this.tab(1)));
        p2.add(this.clause("SUPPORTS "));
        p2.add(this.normal(o2.getSupports()));
        p2.add(this.normal("\n" + this.tab(1)));
        p2.add(this.clause("INCLUDES"));
        p2.add(this.normal(" {\n"));
        p2.add(this.objectRefs(2, o2.getIncludes().elements(), false));
        p2.add(this.normal(this.tab(1) + "}\n"));
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this.writeVariation(p2, v);
            }
        }
    }

    private void writeAgentCaps(Document doc, MIBAgentCaps o2) throws DocumentException {
        if (this.smiversion > 1) {
            Paragraph p2 = this.buildObject(doc, o2);
            p2.setKeepTogether(false);
            p2.add(this.keyWord(" AGENT-CAPABILITIES"));
            p2.add(this.normal("\n\n" + this.tab(1)));
            p2.add(this.clause("PRODUCT-RELEASE"));
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getProductRelease()));
            p2.add(this.normal("\n"));
            this.writeSmiDefBegin(p2, o2);
            Enumeration en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this.writeSupportedModule(p2, (MIBSupportedModule)en.nextElement());
            }
            this.writeSmiDefEnd(p2, o2);
            doc.add(p2);
        }
    }

    private void writeTextualConvention(Document doc, MIBTextualConvention o2) throws DocumentException {
        Paragraph p2 = this.buildObject(doc, o2);
        if (!o2.hasStatus() || SMI.statusType(o2.getStatus()) == 0) {
            p2.add(this.normal(" ::= "));
            this.writeSyntax(p2, o2.getSyntax());
        } else {
            p2.add(this.normal(" ::= "));
            p2.add(this.keyWord("TEXTUAL-CONVENTION"));
            p2.add(this.normal("\n"));
            if (o2.hasDisplayHint()) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("DISPLAY-HINT "));
                p2.add(this.text(o2.getDisplayHint()));
                p2.add(this.normal("\n"));
            }
            this.writeSmiDefBegin(p2, o2);
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("SYNTAX      "));
            this.writeSyntax(p2, o2.getSyntax());
        }
        doc.add(p2);
    }

    private void writeObject(Document doc, MIBObject o2) throws DocumentException {
        if (o2 instanceof MIBObjectType) {
            this.writeObjectType(doc, (MIBObjectType)o2);
        } else if (o2 instanceof MIBTextualConvention) {
            this.writeTextualConvention(doc, (MIBTextualConvention)o2);
        } else if (o2 instanceof MIBNotifyType) {
            this.writeNotifyType(doc, (MIBNotifyType)o2);
        } else if (o2 instanceof MIBGroup) {
            this.writeGroup(doc, (MIBGroup)o2);
        } else if (o2 instanceof MIBCompliance) {
            this.writeCompliance(doc, (MIBCompliance)o2);
        } else if (o2 instanceof MIBAgentCaps) {
            this.writeAgentCaps(doc, (MIBAgentCaps)o2);
        } else {
            this.writeObjectIdentity(doc, o2);
        }
    }

    private void writeObjects(Document doc, MIBModule m2) throws DocumentException {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this.mode));
        Enumeration en = m2.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o2 : orderedObjects.values()) {
            if (!(o2 instanceof MIBModule)) {
                this.writeObject(doc, o2);
                continue;
            }
            if (!(o2 instanceof MIBModule) || m2.getSMIVersion() != 1 || !o2.getOid().isValid()) continue;
            this.writeObject(doc, o2);
        }
    }

    private Chunk objectRef(String moduleName, String objectName) {
        Chunk anchor;
        if (moduleName != null) {
            anchor = new Chunk(moduleName + "." + objectName, (Font)this.fonts.get(STYLE_IDENTIFIER));
            anchor.setLocalDestination(moduleName + "." + objectName);
        } else {
            anchor = new Chunk(objectName, (Font)this.fonts.get(STYLE_IDENTIFIER));
            anchor.setLocalDestination(objectName);
        }
        return anchor;
    }

    private void writeImport(Paragraph doc, MIBImport imports) {
        Enumeration<String> en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add(this.normal(this.tab(1)));
            String name = en.nextElement().toString();
            MIBObject[] o2 = this.rep.getObjectsByName(name);
            if (o2 != null && o2.length > 1) {
                doc.add(this.objectRef(imports.getSource(), name));
            } else {
                doc.add(this.objectRef(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add(this.normal(",\n"));
        }
        doc.add(this.normal("\n" + this.tab(2)));
        doc.add(this.keyWord("FROM "));
        doc.add(this.identifier(imports.getSource()));
        if (imports.hasComment()) {
            doc.add(this.normal(this.tab(2)));
            doc.add(this.comment(imports.getComment()));
        }
    }

    private void writeModuleObject(Document doc, MIBModule o2) throws DocumentException {
        if (this.smiversion > 1 && o2.getOid().size() > 0) {
            String d2;
            Paragraph p2 = this.buildObject(doc, o2);
            p2.add(this.keyWord(" MODULE-IDENTITY"));
            if (o2 instanceof PIBModule) {
                p2.add(this.normal("\n" + this.tab(1)));
                p2.add(this.clause("SUBJECT-CATEGORIES {"));
                p2.add(this.normal("\n"));
                Iterator<? extends IEnum> it = ((PIBModule)o2).getCategories().iterator();
                while (it.hasNext()) {
                    IEnum element = it.next();
                    p2.add(this.normal(this.tab(2)));
                    this.writeEnum(p2, element);
                    if (it.hasNext()) {
                        p2.add(this.normal(",\n"));
                        continue;
                    }
                    p2.add(this.normal("\n"));
                }
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("LAST-UPDATED "));
            p2.add(this.text(o2.getLastUpdated()));
            if ((this.mode & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o2.getLastUpdated()))) != null) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.comment("-- " + d2));
            }
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("ORGANIZATION "));
            p2.add(this.text(o2.getOrganization()));
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("CONTACT-INFO"));
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getContactInfo()));
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("DESCRIPTION"));
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getDescription()));
            p2.add(this.normal("\n"));
            if (o2.hasRevisions()) {
                Enumeration en = o2.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d3;
                    MIBRevision r2 = (MIBRevision)en.nextElement();
                    p2.add(this.normal("\n" + this.tab(1)));
                    p2.add(this.clause("REVISION "));
                    p2.add(this.text(r2.getRevision()));
                    if ((this.mode & 0x20) > 0 && (d3 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r2.getRevision()))) != null) {
                        p2.add(this.normal(this.tab(1)));
                        p2.add(this.comment("-- " + d3));
                    }
                    p2.add(this.normal("\n" + this.tab(1)));
                    p2.add(this.clause("DESCRIPTION"));
                    p2.add(this.normal("\n"));
                    p2.add(this.text(2, r2.getDescription()));
                    p2.add(this.normal("\n"));
                }
            }
            this.writeSmiDefEnd(p2, o2);
            doc.add(p2);
        }
    }

    private void writeModule(Document doc, MIBModule m2) throws DocumentException {
        this.bookmarks.add(m2.getModuleName());
        Paragraph top = new Paragraph(this.leading, this.normal(m2.getModuleName()));
        if (m2 instanceof PIBModule) {
            top.add(this.keyWord(" PIB-DEFINITIONS ::= BEGIN"));
        } else {
            top.add(this.keyWord(" DEFINITIONS ::= BEGIN"));
        }
        top.add(this.normal("\n\n"));
        doc.add(top);
        if (m2.hasImports()) {
            this.bookmarks.add("IMPORTS");
            Paragraph p2 = new Paragraph(this.leading, "IMPORTS\n", (Font)this.fonts.get(STYLE_KEYWORD));
            Enumeration<MIBImport> en = m2.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = en.nextElement();
                this.writeImport(p2, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                p2.add(this.normal("\n"));
            }
            p2.add(this.normal(";"));
            doc.add(p2);
        }
        this.writeModuleObject(doc, m2);
        this.writeObjects(doc, m2);
        doc.add(this.normal("\n"));
        this.bookmarks.add("END");
        doc.add(new Paragraph("END", (Font)this.fonts.get(STYLE_KEYWORD)));
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this.keepTogether = keepTogether;
    }

    public boolean isKeepTogether() {
        return this.keepTogether;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this.displayPageNumbers = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this.displayPageNumbers;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this.outlineTree = outlineTree;
        if (outlineTree) {
            this.mode = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this.outlineTree;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this.showBookmarks = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this.showBookmarks;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this.displayCurrentDate = displayCurrentDate;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this.displayCurrentDate;
    }

    public int getMode() {
        return this.mode;
    }

    class MyPageEvents
    extends PdfPageEventHelper {
        PdfContentByte cb;
        PdfTemplate template;
        BaseFont bf = null;

        MyPageEvents() {
        }

        @Override
        public void onParagraph(PdfWriter writer, Document document, float position) {
            try {
                PdfContentByte cb = writer.getDirectContent();
                PdfOutline root = null;
                String title = null;
                if (MIBModule2PDF.this.bookmarks.elementAt(MIBModule2PDF.this.lastBookmark) == null) {
                    MIBModule2PDF.this.lastBookmark++;
                    return;
                }
                MIBObject o2 = null;
                if (MIBModule2PDF.this.bookmarks.elementAt(MIBModule2PDF.this.lastBookmark) instanceof MIBObject) {
                    o2 = (MIBObject)MIBModule2PDF.this.bookmarks.elementAt(MIBModule2PDF.this.lastBookmark);
                    title = o2.getName();
                    MIBObject parent = MIBModule2PDF.this.rep.getParent(o2);
                    if (parent != null) {
                        root = (PdfOutline)parent.userObject;
                    }
                } else {
                    title = MIBModule2PDF.this.bookmarks.elementAt(MIBModule2PDF.this.lastBookmark).toString();
                }
                if (!MIBModule2PDF.this.outlineTree || root == null) {
                    root = cb.getRootOutline().getKids().size() > 0 ? (PdfOutline)cb.getRootOutline().getKids().get(0) : cb.getRootOutline();
                }
                PdfDestination destination = new PdfDestination(2, position);
                PdfOutline outline = new PdfOutline(root, destination, title);
                if (o2 != null) {
                    o2.userObject = outline;
                }
                MIBModule2PDF.this.lastBookmark++;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void onOpenDocument(PdfWriter writer, Document document) {
            try {
                this.bf = BaseFont.createFont("Courier", "Cp1252", false);
                this.cb = writer.getDirectContent();
                this.template = this.cb.createTemplate(50.0f, 50.0f);
            }
            catch (DocumentException documentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void onEndPage(PdfWriter writer, Document document) {
            if (!MIBModule2PDF.this.displayPageNumbers) {
                return;
            }
            int pageN = writer.getPageNumber();
            String text = "Page " + pageN + " of     ";
            float lenNum = this.bf.getWidthPoint("8888", 8.0f);
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(MIBModule2PDF.this.pageSize.getWidth() - 30.0f - len, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, MIBModule2PDF.this.pageSize.getWidth() - 30.0f - lenNum, 30.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(30.0f, 30.0f);
            this.cb.showText(MIBModule2PDF.this.moduleName);
            this.cb.endText();
            if (MIBModule2PDF.this.displayCurrentDate) {
                this.cb.beginText();
                this.cb.setFontAndSize(this.bf, 8.0f);
                String date = df.format(MIBModule2PDF.this.currentDate);
                len = this.bf.getWidthPoint(date, 8.0f);
                this.cb.setTextMatrix(MIBModule2PDF.this.pageSize.getWidth() / 2.0f - len / 2.0f, 30.0f);
                this.cb.showText(date);
                this.cb.endText();
            }
        }

        @Override
        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

