/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.ext.SMIObjectID;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectID
implements SMIObjectID,
Serializable,
Comparable {
    public static final long serialVersionUID = 1000L;
    protected String oid;
    protected int hash = -1;
    protected int size = -1;
    protected long[] subIDs = null;

    public ObjectID() {
        this.oid = "";
        this.size = 0;
        this.hash = 0;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID(String oid) {
        void var1_1;
        this.set((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID(ObjectID other) {
        this.oid = other.oid;
        if (other.subIDs != null) {
            void var1_1;
            this.subIDs = new long[other.subIDs.length];
            System.arraycopy(other.subIDs, 0, this.subIDs, 0, other.subIDs.length);
            this.size = this.subIDs.length;
            this.hash = var1_1.hash;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID(IObjectID other) {
        this(var1_1.toString());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID(long[] newOid) {
        void var1_1;
        this.subIDs = newOid;
        this.oid = ObjectID.fromLongArray(newOid);
        this.size = ((void)var1_1).length;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID(int[] newOid) {
        void var1_1;
        this.subIDs = new long[newOid.length];
        for (int i2 = 0; i2 < newOid.length; ++i2) {
            this.subIDs[i2] = 0xFFFFFFFFFFFFFFFFL & (long)newOid[i2];
        }
        this.oid = ObjectID.fromLongArray(this.subIDs);
        this.size = ((void)var1_1).length;
    }

    public String get() {
        return this.oid;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(String oid) {
        void var1_1;
        this.oid = oid == null ? "" : var1_1;
        this.hashCode();
        this.size = -1;
        this.subIDs = null;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
            this.size = stringTokenizer.countTokens();
        }
        return this.size;
    }

    private void a() throws ObjectIDFormatException {
        if (this.subIDs == null) {
            this.subIDs = ObjectID.toLongArray(this.oid);
            this.size = this.subIDs.length;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(long subid) throws ObjectIDFormatException {
        void var1_1;
        this.a();
        if (this.subIDs != null) {
            long[] lArray = new long[++this.size];
            System.arraycopy(this.subIDs, 0, lArray, 0, this.size - 1);
            lArray[this.size - 1] = subid;
            this.subIDs = lArray;
        }
        if (this.oid.length() == 0) {
            this.oid = String.valueOf(subid);
            return;
        }
        this.oid = this.oid + "." + (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void append(ObjectID other) {
        void var1_1;
        if (other == null || other.size() == 0) {
            return;
        }
        if (this.subIDs != null && other.subIDs != null) {
            long[] lArray = new long[this.size + other.subIDs.length];
            System.arraycopy(this.subIDs, 0, lArray, 0, this.subIDs.length);
            System.arraycopy(other.subIDs, 0, lArray, this.subIDs.length, other.subIDs.length);
            this.subIDs = lArray;
            this.size = lArray.length;
        }
        if (this.oid.length() == 0) {
            this.oid = other.oid;
            return;
        }
        this.oid = this.oid + "." + var1_1.oid;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getPrefix(int len) throws ObjectIDFormatException {
        void var1_1;
        if (len <= 0) {
            return new ObjectID();
        }
        this.a();
        long[] lArray = new long[len];
        System.arraycopy(this.subIDs, 0, lArray, 0, (int)var1_1);
        return new ObjectID(lArray);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getSuffix(int len) throws ObjectIDFormatException {
        void var1_1;
        this.a();
        if (this.subIDs.length - len <= 0) {
            return new ObjectID();
        }
        long[] lArray = new long[len];
        System.arraycopy(this.subIDs, this.subIDs.length - len, lArray, 0, (int)var1_1);
        return new ObjectID(lArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setSubID(int n2, String subid) {
        void var2_2;
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        if (n2 >= stringArray.length) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2 && i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(".");
        }
        stringBuffer.append((String)var2_2);
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(".");
            stringBuffer.append(stringTokenizer.nextToken());
        }
        this.oid = stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSubID(int n2, long id) {
        void var2_2;
        void var1_1;
        if (this.subIDs != null) {
            this.subIDs[n2] = id;
            this.oid = ObjectID.fromLongArray(this.subIDs);
            return;
        }
        this.setSubID((int)var1_1, String.valueOf((long)var2_2));
    }

    @Override
    public String getSubID(int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        if (n2 >= stringTokenizer.countTokens()) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            stringTokenizer.nextToken();
        }
        return stringTokenizer.nextToken();
    }

    /*
     * WARNING - void declaration
     */
    public long getSubIDAsLong(int n2) throws ObjectIDFormatException {
        void var1_1;
        this.a();
        return this.subIDs[var1_1];
    }

    public static String fromArray(String[] array) {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i2 = 0; i2 < array.length; ++i2) {
            stringBuffer.append(array[i2]);
            if (i2 + 1 >= array.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String fromArrayToSMI(String[] array) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < array.length; ++i2) {
            stringBuffer.append(array[i2]);
            if (i2 + 1 >= array.length) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String fromLongArray(long[] array) {
        StringBuffer stringBuffer = new StringBuffer(array.length * 3);
        for (int i2 = 0; i2 < array.length; ++i2) {
            stringBuffer.append(array[i2]);
            if (i2 + 1 >= array.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public long[] toLongArray() throws ObjectIDFormatException {
        return ObjectID.toLongArray(this.oid);
    }

    @Override
    public long[] getLongArray() {
        try {
            return this.toLongArray();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
    }

    public static String[] toArray(String s) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray, ".", false);
        stringArray = new String[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static long[] toLongArray(String s) throws ObjectIDFormatException {
        Object object;
        StringTokenizer stringTokenizer;
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), ".", true);
        long[] lArray = new long[stringTokenizer.countTokens()];
        int n2 = 0;
        Comparable<StringBuffer> comparable = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (comparable == null && ((String)object).startsWith("'")) {
                comparable = new StringBuffer();
                object = ((String)object).substring(1);
            }
            if (comparable != null && ((String)object).endsWith("'")) {
                ((StringBuffer)comparable).append(((String)object).substring(0, ((String)object).length() - 1));
                comparable = ObjectID.asOID(((StringBuffer)comparable).toString());
                object = lArray;
                lArray = new long[stringTokenizer.countTokens() + ((Object)object).length + ((ObjectID)comparable).size()];
                System.arraycopy(object, 0, lArray, 0, n2);
                System.arraycopy(((ObjectID)comparable).getLongArray(), 0, lArray, n2, ((ObjectID)comparable).size());
                n2 += ((ObjectID)comparable).size();
                comparable = null;
                continue;
            }
            if (comparable != null) {
                ((StringBuffer)comparable).append((String)object);
                continue;
            }
            if (".".equals(object)) continue;
            try {
                lArray[n2++] = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ObjectIDFormatException();
            }
        }
        if (n2 < lArray.length) {
            object = lArray;
            lArray = new long[n2];
            System.arraycopy(object, 0, lArray, 0, n2);
        }
        return lArray;
    }

    public static String trim(String s) {
        int n2 = s.lastIndexOf(".");
        if (n2 >= 0) {
            String string;
            return string.substring(0, n2);
        }
        return "";
    }

    public static ObjectID trim(ObjectID id) {
        int n2 = id.toString().lastIndexOf(46);
        if (n2 >= 0) {
            ObjectID objectID;
            return new ObjectID(objectID.toString().substring(0, n2));
        }
        return new ObjectID();
    }

    @Override
    public IObjectID trim() {
        return ObjectID.trim(this);
    }

    public static String toNumSeq(String oid) {
        String string;
        return new String(string).replace('.', '0');
    }

    public long getLastSubID() throws ObjectIDFormatException {
        this.a();
        return this.subIDs[this.subIDs.length - 1];
    }

    public static String getLastSubID(String oid) {
        String string;
        int n2 = oid.lastIndexOf(".");
        if (n2 >= 0) {
            return oid.substring(n2 + 1);
        }
        return string;
    }

    public static ObjectID getLastSubID(ObjectID oid) {
        ObjectID objectID;
        int n2 = oid.toString().lastIndexOf(".");
        if (n2 >= 0) {
            return new ObjectID(oid.toString().substring(n2 + 1));
        }
        return objectID;
    }

    public static long longHashCode(String oid) throws ObjectIDFormatException {
        BigInteger bigInteger;
        if (ObjectID.toNumSeq(oid).length() == 0) {
            return 0L;
        }
        try {
            bigInteger = new BigInteger(ObjectID.toNumSeq((String)((Object)bigInteger)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ObjectIDFormatException();
        }
        return bigInteger.mod(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
    }

    public static int intHashCode(String oid) throws ObjectIDFormatException {
        BigInteger bigInteger;
        if (ObjectID.toNumSeq(oid).length() == 0) {
            return 0;
        }
        try {
            bigInteger = new BigInteger(ObjectID.toNumSeq((String)((Object)bigInteger)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ObjectIDFormatException();
        }
        return bigInteger.mod(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
    }

    public int hashCode() {
        if (this.hash >= 0) {
            return this.hash;
        }
        try {
            this.hash = ObjectID.intHashCode(this.oid);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return 0;
        }
        return this.hash;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        if (o2 instanceof ObjectID) {
            void var1_1;
            return this.oid.equals(((ObjectID)var1_1).oid);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLessThan(ObjectID o2) throws ObjectIDFormatException {
        void var1_1;
        this.a();
        o2.a();
        int n2 = this.subIDs.length > o2.subIDs.length ? o2.subIDs.length : this.subIDs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.subIDs[i2] == o2.subIDs[i2]) continue;
            return this.subIDs[i2] < o2.subIDs[i2];
        }
        return this.subIDs.length < var1_1.subIDs.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isLessThan(IObjectID oid) {
        try {
            void var1_1;
            return this.isLessThan((ObjectID)var1_1);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.oid.length() == 0 || this.oid.equals(".");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isParentOf(IObjectID id) {
        void var1_1;
        return id.size() - 1 == this.size() && var1_1.toString().startsWith(this.oid + ".");
    }

    @Override
    public boolean isRootOf(IObjectID id) {
        return id.toString().startsWith(this.oid + ".");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isDescendantOf(IObjectID id, int level) {
        void var1_1;
        void var2_2;
        return id.size() + var2_2 == this.size() && this.oid.startsWith(var1_1.toString() + ".");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isChildOf(IObjectID id) {
        void var1_1;
        return this.isDescendantOf((IObjectID)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compare(ObjectID a2, ObjectID b2) {
        void var1_1;
        ObjectID objectID;
        return ObjectIDPredicate.instance.execute(objectID, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(Object o2) {
        if (o2 instanceof ObjectID) {
            void var1_1;
            if (this.oid.equals(((ObjectID)o2).oid)) {
                return 0;
            }
            if (ObjectID.compare(this, (ObjectID)var1_1)) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public ObjectID nextPeer() throws ObjectIDFormatException {
        return this.nextPeer(1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID nextPeer(int increment) throws ObjectIDFormatException {
        void var1_1;
        this.a();
        long[] lArray = new long[this.subIDs.length];
        System.arraycopy(this.subIDs, 0, lArray, 0, this.subIDs.length);
        lArray[this.subIDs.length - 1] = lArray[this.subIDs.length - 1] + (long)var1_1;
        return new ObjectID(lArray);
    }

    @Override
    public boolean isValid() {
        if (this.oid == null || this.oid.trim().length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.oid.length(); ++i2) {
            if (Character.isDigit(this.oid.charAt(i2)) || this.oid.charAt(i2) == '.') continue;
            if (this.oid.indexOf(39) >= 0) {
                try {
                    this.a();
                    return true;
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public String getFirstUnresolvedSubId() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.length() <= 0 || Character.isDigit(string.charAt(0))) continue;
            return string;
        }
        return null;
    }

    public ObjectID getValidPrefix() {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        Vector<Long> vector = new Vector<Long>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            for (int i2 = 0; i2 < ((String)object).length() && Character.isDigit(((String)object).charAt(i2)); ++i2) {
            }
            try {
                long l2 = Long.parseLong((String)object);
                vector.addElement(new Long(l2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {}
            break;
        }
        object = new long[vector.size()];
        for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
            object[i3] = (Long)vector.elementAt(i3);
        }
        return new ObjectID((long[])object);
    }

    public String toSMI() {
        StringBuffer stringBuffer = new StringBuffer("{");
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(" " + stringTokenizer.nextToken() + " ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(String parent) {
        void var1_1;
        StringBuffer stringBuffer = new StringBuffer("{ ");
        stringBuffer.append((String)var1_1 + " ");
        stringBuffer.append(this.oid.substring(this.oid.lastIndexOf(".") + 1));
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(MIBRepository rep, int mode, MIBObject parent, String qualified) {
        try {
            int n2;
            this.a();
            int n3 = this.size - parent.getOid().size();
            StringBuffer stringBuffer = new StringBuffer("{ ");
            if (qualified != null) {
                MIBObject.addObjectLink(mode, stringBuffer, qualified + "." + parent.getName());
            } else {
                void var3_3;
                MIBObject.addObjectLink(n2, stringBuffer, var3_3.getName());
            }
            stringBuffer.append(' ');
            for (n2 = this.size - n3; n2 < this.size; ++n2) {
                if (n2 + 1 < this.size) {
                    rep.getObjectName(this.getPrefix(n2 + 1));
                }
                stringBuffer.append(this.subIDs[n2]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return "{ " + this.oid + " }";
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, MIBObject parent, String qualified) {
        try {
            int n2;
            this.a();
            int n3 = this.size - parent.getOid().size();
            StringBuffer stringBuffer = new StringBuffer("{ ");
            if (qualified != null) {
                void var3_3;
                MIBObject.addObjectLink(mode, stringBuffer, (String)var3_3 + "." + parent.getName());
            } else {
                void var2_2;
                MIBObject.addObjectLink(n2, stringBuffer, var2_2.getName());
            }
            stringBuffer.append(' ');
            for (n2 = this.size - n3; n2 < this.size; ++n2) {
                stringBuffer.append(this.subIDs[n2]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return "{ " + this.oid + " }";
        }
    }

    @Override
    public String toString() {
        return this.oid;
    }

    public static boolean isIdentifier(String lastName) {
        Object object;
        if (lastName.length() <= 0 || !Character.isLetter(lastName.charAt(0)) || lastName.indexOf("--") >= 0) {
            return false;
        }
        object = ((String)object).toCharArray();
        for (int i2 = 1; i2 < ((Object)object).length; ++i2) {
            if (Character.isLetterOrDigit((char)object[i2]) || i2 < ((Object)object).length && object[i2] == 45) continue;
            return false;
        }
        return true;
    }

    public static ObjectID asOID(String aString) {
        long[] lArray = new long[aString.length()];
        for (int i2 = 0; i2 < aString.length(); ++i2) {
            lArray[i2] = aString.charAt(i2) & 0xFF;
        }
        return new ObjectID(lArray);
    }

    public static ObjectID asOID(byte[] aString) {
        long[] lArray = new long[aString.length];
        for (int i2 = 0; i2 < aString.length; ++i2) {
            lArray[i2] = aString[i2] & 0xFF;
        }
        return new ObjectID(lArray);
    }

    public String asString() throws ObjectIDFormatException {
        this.a();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.subIDs.length; ++i2) {
            stringBuffer.append((char)this.subIDs[i2]);
        }
        return stringBuffer.toString();
    }

    public byte[] asByteArray() throws ObjectIDFormatException {
        this.a();
        byte[] byArray = new byte[this.subIDs.length];
        for (int i2 = 0; i2 < this.subIDs.length; ++i2) {
            byArray[i2] = (byte)this.subIDs[i2];
        }
        return byArray;
    }

    public int[] asIntArray() throws ObjectIDFormatException {
        this.a();
        int[] nArray = new int[this.subIDs.length];
        for (int i2 = 0; i2 < this.subIDs.length; ++i2) {
            nArray[i2] = (int)this.subIDs[i2];
        }
        return nArray;
    }

    public boolean isPeerOf(ObjectID other) {
        if (this.size() == other.size()) {
            if (this.size <= 1) {
                return true;
            }
            for (int i2 = 0; i2 < this.size - 1; ++i2) {
                if (this.subIDs[i2] == other.subIDs[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List getSubIdentifiers() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens() + 1);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    @Override
    public String getLastSubIdentifier() {
        if (this.subIDs != null) {
            try {
                return "" + this.getLastSubID();
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.size() > 0) {
            return ObjectID.getLastSubID(this.oid);
        }
        return null;
    }
}

