/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smi.IEnum;
import com.agentpp.smi.IRange;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIRange;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIBSyntax
implements SMISyntax,
Serializable {
    public static final long serialVersionUID = 1000L;
    protected String syntax;
    protected int type;
    protected Vector<MIBRange> ranges = null;
    protected Vector<MIBEnum> enums = null;
    public transient Object userObject;

    public MIBSyntax() {
        this.syntax = null;
        this.type = 0;
    }

    /*
     * WARNING - void declaration
     */
    public MIBSyntax(String syntax, int type) {
        void var2_2;
        void var1_1;
        this.syntax = var1_1;
        this.type = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public MIBSyntax(ISyntax other) {
        this.syntax = other.getSyntax();
        this.type = other.getType();
        if (other.hasEnums()) {
            this.setEnums((MIBEnum[])other.getEnums());
        }
        if (other.hasRanges()) {
            void var1_1;
            this.setRanges((MIBRange[])var1_1.getRanges());
        }
    }

    @Override
    public final String getSyntax() {
        return this.syntax;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setSyntax(String syntax) {
        void var1_1;
        this.syntax = var1_1;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setType(int t) {
        void var1_1;
        this.type = var1_1;
    }

    @Override
    public final boolean hasRanges() {
        return this.ranges != null && this.ranges.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void addRange(MIBRange range) {
        void var1_1;
        if (this.ranges == null) {
            this.ranges = new Vector(5);
        }
        this.ranges.addElement((MIBRange)var1_1);
    }

    @Override
    public IRange[] getRanges() {
        if (this.ranges == null) {
            return null;
        }
        Object[] objectArray = new MIBRange[this.ranges.size()];
        this.ranges.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public void setRanges(MIBRange[] ranges) {
        void var1_1;
        this.ranges = MIBRepository.buildVector(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setRanges(SMIRange[] ranges) {
        void var1_1;
        Vector<MIBRange> vector = new Vector<MIBRange>();
        new Vector(ranges.length + 1);
        for (void var5_5 : var1_1) {
            vector.add(new MIBRange(var5_5.getLower(), var5_5.getUpper()));
        }
        this.ranges = vector;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRangesVector(Vector<MIBRange> v) {
        void var1_1;
        this.ranges = var1_1;
    }

    public final Vector<MIBRange> getRangesVector() {
        return this.ranges;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsRange(MIBRange range) {
        void var1_1;
        if (!this.hasRanges()) {
            return false;
        }
        return this.ranges.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRestrictiveRange(MIBRange range) {
        void var1_1;
        if (!this.hasRanges()) {
            return true;
        }
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MAX_VALUE;
        Enumeration<MIBRange> enumeration = this.ranges.elements();
        while (enumeration.hasMoreElements()) {
            MIBRange mIBRange = enumeration.nextElement();
            if (mIBRange.getLowerValue() <= range.getLowerValue() && mIBRange.getUpperValue() >= range.getUpperValue()) {
                return true;
            }
            if (mIBRange.getLowerValue() < l3) {
                l3 = mIBRange.getLowerValue();
            }
            if (mIBRange.getUpperValue() <= l2) continue;
            l2 = mIBRange.getUpperValue();
        }
        return range.getLowerValue() > l3 || var1_1.getUpperValue() < l2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRestrictiveOrSubset(Vector restrictions) {
        void var1_1;
        if (!this.hasRanges()) {
            return true;
        }
        if (restrictions == null) {
            return false;
        }
        Vector vector = (Vector)this.ranges.clone();
        Vector vector2 = new Vector(vector.size() + 1);
        Vector vector3 = new Vector(restrictions.size() + 1);
        MIBRange.normalizeRanges(vector, vector2);
        MIBRange.normalizeRanges((Vector)var1_1, vector3);
        return MIBRange.compareRanges(vector2, vector3) >= 0;
    }

    public final long getMinOfEnums() {
        if (!this.hasEnums()) {
            return Long.MIN_VALUE;
        }
        long l2 = Long.MAX_VALUE;
        Enumeration<MIBEnum> enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = enumeration.nextElement();
            if (mIBEnum.getLongValue() >= l2) continue;
            l2 = mIBEnum.getLongValue();
        }
        return l2;
    }

    public final long getMaxOfEnums() {
        if (!this.hasEnums()) {
            return Long.MIN_VALUE;
        }
        long l2 = Long.MIN_VALUE;
        Enumeration<MIBEnum> enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = enumeration.nextElement();
            if (mIBEnum.getLongValue() <= l2) continue;
            l2 = mIBEnum.getLongValue();
        }
        return l2;
    }

    public final long getMinOfRanges() {
        if (!this.hasRanges()) {
            return Long.MIN_VALUE;
        }
        long l2 = Long.MAX_VALUE;
        Enumeration<MIBRange> enumeration = this.ranges.elements();
        while (enumeration.hasMoreElements()) {
            MIBRange mIBRange = enumeration.nextElement();
            if (mIBRange.getLowerValue() >= l2) continue;
            l2 = mIBRange.getLowerValue();
        }
        return l2;
    }

    public final long getMaxOfRanges() {
        if (!this.hasRanges()) {
            return Long.MAX_VALUE;
        }
        long l2 = Long.MIN_VALUE;
        Enumeration<MIBRange> enumeration = this.ranges.elements();
        while (enumeration.hasMoreElements()) {
            MIBRange mIBRange = enumeration.nextElement();
            if (mIBRange.getLowerValue() <= l2) continue;
            l2 = mIBRange.getUpperValue();
        }
        return l2;
    }

    public boolean isIncludedInRanges(long value) {
        if (this.hasRanges()) {
            for (int i2 = 0; i2 < this.ranges.size(); ++i2) {
                MIBRange mIBRange = this.ranges.get(i2);
                if (value < mIBRange.getLowerValue() || value > mIBRange.getUpperValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final boolean hasEnums() {
        return this.enums != null && this.enums.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void addEnum(MIBEnum e2) {
        void var1_1;
        if (this.enums == null) {
            this.enums = new Vector(5);
        }
        this.enums.addElement((MIBEnum)var1_1);
    }

    public int getMaxEnumLabelLength() {
        int n2 = 0;
        for (MIBEnum mIBEnum : this.enums) {
            if (mIBEnum.getLabel() == null || mIBEnum.getLabel().length() <= n2) continue;
            n2 = mIBEnum.getLabel().length();
        }
        return n2;
    }

    public int getMinEnumLabelLength() {
        int n2 = Integer.MAX_VALUE;
        for (MIBEnum mIBEnum : this.enums) {
            if (mIBEnum.getLabel() == null || mIBEnum.getLabel().length() >= n2) continue;
            n2 = mIBEnum.getLabel().length();
        }
        return n2;
    }

    @Override
    public IEnum[] getEnums() {
        if (this.enums == null) {
            return null;
        }
        Object[] objectArray = new MIBEnum[this.enums.size()];
        this.enums.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnums(MIBEnum[] enumerations) {
        void var1_1;
        this.enums = MIBRepository.buildVector(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnums(SMIEnum[] enumerations) {
        void var1_1;
        Vector<MIBEnum> vector = new Vector<MIBEnum>();
        for (void var5_5 : var1_1) {
            vector.add(new MIBEnum((SMIEnum)var5_5));
        }
        this.enums = vector;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnumsVector(Vector<MIBEnum> v) {
        void var1_1;
        this.enums = var1_1;
    }

    public final Vector<MIBEnum> getEnumsVector() {
        return this.enums;
    }

    public byte[] getBitsEnum(String labelList) {
        StringTokenizer stringTokenizer;
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), "{}, ");
        long l2 = this.getMaxOfEnums();
        byte[] byArray = new byte[l2 >= 0L ? (int)(l2 / 8L) + 1 : 0];
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            boolean bl = false;
            Object object = this.enums.elements();
            while (object.hasMoreElements()) {
                MIBEnum mIBEnum = object.nextElement();
                if (!mIBEnum.getLabel().equals(string)) continue;
                bl = true;
                try {
                    int n2 = (int)Long.parseLong(mIBEnum.getValue());
                    if (n2 / 8 >= byArray.length) {
                        object = byArray;
                        byArray = new byte[n2 / 8 + 1];
                        System.arraycopy(object, 0, byArray, 0, ((Object)object).length);
                    }
                    int n3 = n2 / 8;
                    byArray[n3] = (byte)(byArray[n3] | 1 << 7 - n2 % 8);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            if (bl) continue;
            return null;
        }
        return byArray;
    }

    public String getBitsEnum(byte[] bits) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append('{');
        boolean bl = true;
        for (int i2 = 0; i2 < bits.length << 3; ++i2) {
            if ((bits[i2 / 8] & 1 << 7 - i2 % 8) <= 0) continue;
            String string = this.getLabel(i2);
            if (!bl) {
                stringBuffer.append(',');
            }
            bl = false;
            if (string != null) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(String.valueOf(i2));
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public final int getEnumValue(String label) {
        Enumeration<MIBEnum> enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = enumeration.nextElement();
            if (!mIBEnum.getLabel().equals(label) && !mIBEnum.toString().equals(label)) continue;
            return Integer.parseInt(mIBEnum.getValue());
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public String getEnum(String label) {
        void var1_1;
        if (this.syntax.equals(SMI.SMI_SYNTAX[12])) {
            byte[] byArray = this.getBitsEnum((String)var1_1);
            if (byArray == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                String string = Integer.toHexString(byArray[i2] & 0xFF);
                for (int i3 = 0; i3 < 2 - string.length(); ++i3) {
                    string = "0" + string;
                }
                stringBuffer.append("\\x" + string);
            }
            return stringBuffer.toString();
        }
        Enumeration<MIBEnum> enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = enumeration.nextElement();
            if (!mIBEnum.getLabel().equals(var1_1)) continue;
            return mIBEnum.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final String getLabel(long num) {
        void var1_1;
        MIBEnum mIBEnum = this.getEnum((long)var1_1);
        if (mIBEnum == null) {
            return null;
        }
        return mIBEnum.getLabel();
    }

    public final MIBEnum getEnum(long num) {
        Enumeration<MIBEnum> enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = enumeration.nextElement();
            if (mIBEnum.getLongValue() != num) continue;
            return mIBEnum;
        }
        return null;
    }

    protected final String getSMIv2Syntax() {
        if (this.syntax.equals(SMI.SMI_SYNTAX[0]) && !this.hasEnums()) {
            return SMI.SMI_SYNTAX[8];
        }
        if (this.syntax.equals(SMI.SMI_SYNTAX[3])) {
            return SMI.SMI_SYNTAX[5];
        }
        if (this.syntax.equals(SMI.SMI_SYNTAX[4])) {
            return SMI.SMI_SYNTAX[7];
        }
        return this.syntax;
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, MIBRepository rep, MIBSyntax c2, String lineSeparator) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 2: {
                MIBObject.addKeyWord(mode, stringBuffer, "SEQUENCE OF ");
                MIBObject.addString(mode, stringBuffer, this.syntax, c2 == null ? null : c2.syntax);
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                Enumeration<MIBRange> enumeration;
                if (mode == 8) {
                    stringBuffer.append(this.getSMIv2Syntax());
                } else if (rep != null) {
                    if (rep.getObject(this.syntax) != null) {
                        MIBObject.addObjectLink(mode, stringBuffer, this.syntax, c2 == null ? null : c2.syntax);
                    } else {
                        MIBObject.addString(mode, stringBuffer, this.syntax, c2 == null ? null : c2.syntax);
                    }
                } else {
                    MIBObject.addString(mode, stringBuffer, this.syntax, c2 == null ? null : c2.syntax);
                }
                if ((mode & 1) <= 0 && (mode & 2) <= 0 || !this.hasRanges()) break;
                boolean bl = false;
                Object object = null;
                if (rep != null) {
                    object = ((MIBRepository)((Object)enumeration)).resolveTC(this.syntax);
                }
                if (object == null) {
                    object = this;
                }
                if (((MIBSyntax)object).getSyntax().equals(SMI.SMI_SYNTAX[1]) || ((MIBSyntax)object).getSyntax().equals(SMI.SMI_SYNTAX[10]) || ((MIBSyntax)object).getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    bl = true;
                    stringBuffer.append(" (");
                    MIBObject.addKeyWord(mode, stringBuffer, "SIZE");
                }
                stringBuffer.append(" (");
                enumeration = null;
                if (c2 != null) {
                    enumeration = c2.hasRanges() ? c2.ranges.elements() : new Vector().elements();
                }
                object = this.ranges.elements();
                while (object.hasMoreElements()) {
                    MIBRange mIBRange = null;
                    if (enumeration != null) {
                        mIBRange = enumeration.hasMoreElements() ? enumeration.nextElement() : new MIBRange(0L, -1L);
                    }
                    MIBObject.addString(mode, stringBuffer, ((MIBRange)object.nextElement()).toSMI(mode), mIBRange == null ? null : mIBRange.toSMI(mode));
                    if (!object.hasMoreElements()) continue;
                    stringBuffer.append(" | ");
                }
                stringBuffer.append(")");
                if (!bl) break;
                stringBuffer.append(")");
            }
        }
        if (this.hasEnums()) {
            void var1_1;
            stringBuffer.append(" {");
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t\t\t");
            Iterator<MIBEnum> iterator = null;
            if (c2 != null) {
                void var3_3;
                iterator = c2.hasEnums() ? var3_3.enums.iterator() : new Vector().iterator();
            }
            MIBSyntax.toSMIEnums((int)var1_1, lineSeparator, stringBuffer, iterator, this.enums);
            stringBuffer.append("}");
        }
        stringBuffer.append(lineSeparator);
        return stringBuffer.toString();
    }

    public static void toSMIEnums(int mode, String lineSeparator, StringBuffer buf, Iterator<MIBEnum> cen, List<MIBEnum> enums) {
        int n2 = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> iterator = enums.iterator();
        while (iterator.hasNext()) {
            Object object = null;
            if (cen != null) {
                object = cen.hasNext() ? cen.next() : new MIBEnum("", "0");
            }
            Object object2 = iterator.next();
            MIBObject.addString(mode, buf, ((MIBEnum)object2).toSMI(mode), object == null ? null : ((MIBEnum)object).toSMI(mode));
            if (((MIBEnum)object2).hasComment()) {
                if (iterator.hasNext()) {
                    buf.append(",");
                }
                object = MIBObject.space(n2 - ((MIBEnum)object2).toString().length() + 1);
                buf.append((String)object);
                object = ((MIBEnum)object2).getComment();
                object2 = ((MIBEnum)object2).getComment();
                int n3 = ((String)object).indexOf("\n");
                if (n3 < 0) {
                    object = null;
                } else {
                    object2 = ((String)object).substring(0, n3);
                    object = ((String)object).substring(n3);
                }
                MIBObject.addComment(mode, buf, "\t" + (String)object2, lineSeparator);
                if (object != null) {
                    object = new StringTokenizer((String)object, "\n", true);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        object2 = ((StringTokenizer)object).nextToken();
                        if ("\n".indexOf((String)object2) >= 0) continue;
                        if ((mode & 2) > 0) {
                            buf.append("\n");
                        } else {
                            buf.append(lineSeparator);
                        }
                        buf.append("\t\t\t\t" + MIBObject.space(n2));
                        MIBObject.addComment(mode, buf, (String)object2, lineSeparator);
                    }
                }
                buf.append(lineSeparator);
                buf.append("\t\t\t");
                continue;
            }
            if (iterator.hasNext()) {
                buf.append(",");
                buf.append(lineSeparator);
                buf.append("\t\t\t");
                continue;
            }
            buf.append(' ');
        }
    }

    public boolean isRestrictiveSyntax(MIBRepository rep) {
        MIBObject mIBObject;
        if (this.getType() != 3) {
            return true;
        }
        if (!((mIBObject = ((MIBRepository)((Object)mIBObject)).getObject(this.getSyntax())) instanceof MIBTextualConvention)) {
            return false;
        }
        mIBObject = (MIBTextualConvention)mIBObject;
        if (this.hasRanges() && !((MIBTextualConvention)mIBObject).getSyntax().isRestrictiveOrSubset(this.getRangesVector())) {
            return false;
        }
        if (this.hasEnums() && ((MIBTextualConvention)mIBObject).getSyntax().hasEnums()) {
            if (this.getEnumsVector().size() > ((MIBTextualConvention)mIBObject).getSyntax().getEnumsVector().size()) {
                return false;
            }
            for (MIBEnum mIBEnum : this.getEnumsVector()) {
                if (((MIBTextualConvention)mIBObject).getSyntax().getEnum(mIBEnum.getLongValue()) != null) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRestrictiveSyntax(MIBRepository rep, MIBSyntax refinement) {
        block6: {
            void var2_3;
            MIBTextualConvention mIBTextualConvention;
            block5: {
                Object object;
                mIBTextualConvention = rep.getEffectiveSyntax(this);
                if (!((MIBTextualConvention)(object = ((MIBRepository)object).getEffectiveSyntax(refinement))).getSyntax().getSyntax().equals(mIBTextualConvention.getSyntax().getSyntax()) || ((MIBTextualConvention)object).getSyntax().hasEnums() != mIBTextualConvention.getSyntax().hasEnums() && mIBTextualConvention.getSyntax().hasEnums() || ((MIBTextualConvention)object).getSyntax().hasRanges() != mIBTextualConvention.getSyntax().hasRanges() && mIBTextualConvention.getSyntax().hasRanges()) {
                    return false;
                }
                if (!refinement.hasRanges()) break block5;
                for (int i2 = 0; i2 < refinement.getRangesVector().size(); ++i2) {
                    MIBRange mIBRange = refinement.getRangesVector().get(i2);
                    if (mIBTextualConvention.getSyntax().isRestrictiveRange(mIBRange)) continue;
                    return false;
                }
                break block6;
            }
            if (!refinement.hasEnums()) break block6;
            if (!mIBTextualConvention.getSyntax().hasEnums()) {
                return false;
            }
            if (refinement.getEnumsVector().size() > mIBTextualConvention.getSyntax().getEnumsVector().size()) {
                return false;
            }
            for (MIBEnum mIBEnum : var2_3.getEnumsVector()) {
                if (mIBTextualConvention.getSyntax().getEnum(mIBEnum.getLongValue()) != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBSyntax) {
            MIBSyntax mIBSyntax;
            mIBSyntax = mIBSyntax;
            return MIBObject.saveCompare(this.syntax, mIBSyntax.syntax) && this.type == mIBSyntax.type && MIBObject.saveCompare(this.enums, mIBSyntax.enums) && MIBObject.saveCompare(this.ranges, mIBSyntax.ranges);
        }
        return false;
    }

    public int hashCode() {
        return this.syntax.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.syntax = SMI.getCommonIdentifier(this.syntax);
    }
}

