/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.INotificationType;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class MIBRepository
implements Serializable {
    public static final long serialVersionUID = 100L;
    private transient ConcurrentHashMap<String, MIBModule> a = null;
    private transient ConcurrentHashMap<Integer, MIBModule> b = null;
    private transient ConcurrentHashMap<Integer, String> c = null;
    private transient OrderedMap d = null;
    private transient OrderedMap e = null;

    public MIBRepository() {
        this.a(false);
    }

    /*
     * WARNING - void declaration
     */
    public MIBRepository(boolean addIETFObjects) {
        void var1_1;
        this.a((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBRepository(MIBObject[] objects) {
        void var1_1;
        this.a(false);
        this.addAllObjects((MIBObject[])var1_1);
    }

    public Object clone() {
        MIBRepository mIBRepository = new MIBRepository();
        new MIBRepository().e = (OrderedMap)this.e.clone();
        mIBRepository.d = (OrderedMap)this.d.clone();
        mIBRepository.a = new ConcurrentHashMap<String, MIBModule>(this.a);
        mIBRepository.b = new ConcurrentHashMap<Integer, MIBModule>(this.b);
        mIBRepository.c = new ConcurrentHashMap<Integer, String>(this.c);
        return mIBRepository;
    }

    private void a(boolean bl) {
        new Vector(5);
        this.e = new OrderedMap(ObjectIDPredicate.instance, true);
        this.d = new OrderedMap(LexicographicPredicate.instance, true);
        this.a = new ConcurrentHashMap(150);
        this.b = new ConcurrentHashMap(150);
        this.c = new ConcurrentHashMap(100);
        if (bl) {
            this.addIETFObjectIDs();
        }
        this.structureChanged();
    }

    public int size() {
        return this.e.size();
    }

    public int moduleCount() {
        return this.a.size();
    }

    protected void addIETFObjectIDs() {
        for (int i2 = 0; i2 < SMI.rootOids.length; ++i2) {
            MIBObject mIBObject = new MIBObject(new ObjectID(SMI.rootOids[i2][1]), SMI.rootOids[i2][0]);
            this.e.add(mIBObject.getOid(), mIBObject);
            this.d.add(mIBObject.getName(), mIBObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addObject(MIBObject o2) {
        this.removeObject(o2.getModuleID(), o2);
        if (o2.getOid().size() > 0) {
            this.e.add(o2.getOid(), o2);
        }
        this.d.add(o2.getName(), o2);
        if (o2 instanceof MIBModule) {
            MIBModule mIBModule = (MIBModule)o2;
            MIBRepository mIBRepository = this;
            mIBRepository.a.put(mIBModule.getModuleName(), mIBModule);
            mIBRepository.b.put(mIBModule.getModuleID(), mIBModule);
            ((MIBModule)o2).add(o2);
            return;
        }
        MIBModule mIBModule = this.b.get(o2.getModuleID());
        if (mIBModule != null) {
            void var1_1;
            mIBModule.add((MIBObject)var1_1);
        }
    }

    public synchronized void addObject(MIBObject o2, boolean addModuleObjects) {
        this.addObject(o2);
        if (o2 instanceof MIBModule) {
            Iterator<MIBObject> iterator;
            for (MIBObject mIBObject : ((MIBModule)((Object)iterator)).objects.values()) {
                this.addObject(mIBObject);
            }
        }
    }

    public void addAllObjects(MIBObject[] objects) {
        for (int i2 = 0; i2 < objects.length; ++i2) {
            this.addObject(objects[i2]);
        }
        this.structureChanged();
    }

    public String getObjectName(ObjectID oid) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.e.get(mIBObject)) != null) {
            return mIBObject.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getUniqueObjectName(MIBObject o2) {
        void var1_1;
        Object object = this.getObjectsByName(o2.getName());
        if (object == null || ((MIBObject[])object).length <= 1) {
            return o2.getName();
        }
        object = this.getModuleName(o2.getModuleID());
        if (object == null) {
            return o2.getName();
        }
        return (String)object + "." + var1_1.getName();
    }

    public ObjectID getObjectID(String name) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.d.get(mIBObject)) != null) {
            return mIBObject.getOid();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getObjectID(String moduleName, String name) {
        void var2_2;
        MIBObject mIBObject;
        if ((mIBObject = this.getModule((String)((Object)mIBObject))) == null) {
            return null;
        }
        if ((mIBObject = ((MIBModule)mIBObject).getObjectByName((String)var2_2)) != null) {
            return mIBObject.getOid();
        }
        return null;
    }

    public MIBObject getObject(String moduleName, String name) {
        MIBObject[] mIBObjectArray;
        MIBModule mIBModule = this.getModule(moduleName);
        if (mIBModule == null) {
            mIBObjectArray = this.getObjectsByName((String)mIBObjectArray);
            for (int i2 = 0; i2 < mIBObjectArray.length; ++i2) {
                if (!moduleName.equals(this.getModuleName(mIBObjectArray[i2].getModuleID()))) continue;
                return mIBObjectArray[i2];
            }
            return null;
        }
        return mIBModule.getObjectByName((String)mIBObjectArray);
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getScopedObject(String moduleName, String name) {
        void var2_2;
        if (name.length() == 0) {
            return null;
        }
        if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            return this.getObject(name);
        }
        MIBModule mIBModule = this.getModule(moduleName);
        if (mIBModule == null) {
            MIBObject[] mIBObjectArray = this.getObjectsByName((String)var2_2);
            for (int i2 = 0; i2 < mIBObjectArray.length; ++i2) {
                if (!moduleName.equals(this.getModuleName(mIBObjectArray[i2].getModuleID()))) continue;
                return mIBObjectArray[i2];
            }
            return null;
        }
        String string = mIBModule.getImportSource((String)var2_2);
        if (string != null) {
            return this.getObject(string, (String)var2_2);
        }
        return mIBModule.getObjectByName((String)var2_2);
    }

    public Vector<? extends MIBObject> getChildren(String objectName) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.d.get(mIBObject)) == null) {
            return null;
        }
        return this.getChildren(mIBObject);
    }

    /*
     * WARNING - void declaration
     */
    public Vector<? extends MIBObject> getChildren(ObjectID oid) {
        void var1_1;
        return this.getChildren((ObjectID)var1_1, true);
    }

    public Vector<? extends MIBObject> getChildren(ObjectID oid, boolean uniqueOIDs) {
        Vector<MIBObject> vector = new Vector<MIBObject>();
        OrderedMapIterator orderedMapIterator = this.e.find(oid);
        if (orderedMapIterator.atEnd()) {
            return vector;
        }
        if (!((MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(oid)) {
            return vector;
        }
        orderedMapIterator.advance();
        while (!orderedMapIterator.atEnd()) {
            block7: {
                MIBObject mIBObject;
                block9: {
                    block8: {
                        mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
                        if (mIBObject.getOid().equals(oid) || uniqueOIDs && vector.size() > 0 && mIBObject.getOid().equals(((MIBObject)vector.lastElement()).getOid())) break block7;
                        if (!mIBObject.getOid().isChildOf(oid)) break block8;
                        vector.add(mIBObject);
                        break block9;
                    }
                    if (!oid.isRootOf(mIBObject.getOid())) break block9;
                    if (vector.size() > 0 && ((MIBObject)vector.lastElement()).getOid().isRootOf(mIBObject.getOid())) break block7;
                    vector.addElement(mIBObject);
                }
                if (!oid.isRootOf(mIBObject.getOid())) {
                    return vector;
                }
            }
            orderedMapIterator.advance();
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<? extends MIBObject> getChildren(MIBObject o2) {
        void var1_1;
        return this.getChildren(var1_1.getOid());
    }

    public void removeChildren(MIBObject o2) {
        Object object;
        if ((object = this.getChildren((MIBObject)object)) == null) {
            return;
        }
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            this.removeObject(mIBObject);
        }
    }

    public Vector<? extends MIBObject> getDescendants(MIBObject o2) {
        Object object;
        Vector<MIBObject> vector = new Vector<MIBObject>(10, 10);
        if ((object = this.getChildren((MIBObject)object)) == null) {
            return vector;
        }
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            Object object2 = (MIBObject)object.nextElement();
            vector.addElement((MIBObject)object2);
            object2 = this.getDescendants((MIBObject)object2).elements();
            while (object2.hasMoreElements()) {
                vector.addElement((MIBObject)object2.nextElement());
            }
        }
        return vector;
    }

    public boolean hasDescendants(MIBObject o2) {
        ObjectID objectID;
        if (o2.getOid() == null) {
            return false;
        }
        OrderedMapIterator orderedMapIterator = this.e.find(objectID = ((MIBObject)((Object)objectID)).getOid());
        if (orderedMapIterator.atEnd()) {
            return false;
        }
        if (!((MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(objectID)) {
            return false;
        }
        orderedMapIterator.advance();
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(objectID)) {
                if (mIBObject.getOid().isChildOf(objectID)) {
                    return true;
                }
                if (objectID.isRootOf(mIBObject.getOid())) {
                    return true;
                }
                if (!objectID.isRootOf(mIBObject.getOid())) {
                    return false;
                }
            }
            orderedMapIterator.advance();
        }
        return false;
    }

    public MIBObject getParent(String objectName) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.d.get(mIBObject)) == null) {
            return null;
        }
        return this.getParent(mIBObject);
    }

    public MIBObject getNextParent(ObjectID oid) {
        ObjectID objectID;
        if (oid.size() <= 1 || this.e.find(oid) == null) {
            return null;
        }
        MIBObject mIBObject = null;
        objectID = ObjectID.trim(objectID);
        while (mIBObject == null && objectID.size() > 0) {
            mIBObject = (MIBObject)this.e.get(objectID);
            objectID = ObjectID.trim(ObjectID.trim(objectID));
        }
        return mIBObject;
    }

    public MIBObject getParent(MIBObject o2) {
        ObjectID objectID;
        if (this.e.find(o2.getOid()) == null || o2.getOid().size() == 0) {
            return null;
        }
        objectID = ObjectID.trim(((MIBObject)((Object)objectID)).getOid());
        MIBObject mIBObject = null;
        while (mIBObject == null && objectID.size() > 0) {
            mIBObject = (MIBObject)this.e.get(objectID);
            objectID = ObjectID.trim(objectID);
        }
        return mIBObject;
    }

    public MIBObject getParentInSameModule(MIBObject o2) {
        if (this.e.find(o2.getOid()) == null || o2.getOid().size() == 0) {
            return null;
        }
        ObjectID objectID = ObjectID.trim(o2.getOid());
        MIBObject mIBObject = null;
        while (objectID.size() > 0) {
            for (MIBObject mIBObject2 : this.getObjectsByOid(objectID)) {
                if (!mIBObject2.getModuleID().equals(o2.getModuleID())) continue;
                mIBObject = mIBObject2;
                break;
            }
            objectID = ObjectID.trim(objectID);
        }
        return mIBObject;
    }

    /*
     * WARNING - void declaration
     */
    public Pair getSplittedObjectID(ObjectID oid) throws ObjectIDFormatException {
        void var1_1;
        Pair pair = new Pair();
        Object object = this.e.lowerBound(oid);
        if (((OrderedMapIterator)object).atEnd()) {
            return new Pair(oid, new ObjectID());
        }
        if (((Pair)((OrderedMapIterator)object).get()).first.equals(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        ((OrderedMapIterator)object).retreat();
        if (((OrderedMapIterator)object).atBegin() || ((OrderedMapIterator)object).get() == null) {
            return new Pair(oid, new ObjectID());
        }
        object = (MIBObject)((Pair)((OrderedMapIterator)object).get()).second;
        if (!((MIBObject)object).getOid().isRootOf(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        pair.first = ((MIBObject)object).getOid();
        pair.second = oid.getSuffix(var1_1.size() - ((MIBObject)object).getOid().size());
        return pair;
    }

    public ObjectID[] getIndexObjectIDs(ObjectID oid) {
        try {
            Serializable serializable;
            serializable = this.getSplittedObjectID((ObjectID)serializable);
            Comparable comparable = ObjectID.trim((ObjectID)serializable.first);
            serializable = (ObjectID)serializable.second;
            comparable = (MIBObjectType)this.getObject((ObjectID)comparable);
            if (comparable == null || !((MIBObjectType)comparable).hasIndexPart()) {
                return null;
            }
            comparable = ((MIBObjectType)comparable).getIndexPart().getIndexStruct(this);
            return this.getIndexObjectIDs((ObjectID)serializable, (IndexStruct[])comparable);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
    }

    public ObjectID[] getIndexObjectIDs(ObjectID index, IndexStruct[] is) {
        try {
            ObjectID[] objectIDArray = new ObjectID[is.length];
            for (int i2 = 0; i2 < is.length; ++i2) {
                if (is[i2].impliedLength) {
                    objectIDArray[i2] = index;
                    break;
                }
                objectIDArray[i2] = !is[i2].impliedLength && is[i2].minLength != is[i2].maxLength ? index.getPrefix((int)index.getSubIDAsLong(0) + 1) : index.getPrefix(is[i2].maxLength);
                index = index.getSuffix(index.size() - objectIDArray[i2].size());
            }
            return objectIDArray;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public MIBObject[] getObjectsByName(String name) {
        OrderedMapIterator orderedMapIterator;
        MIBObject[] mIBObjectArray = new MIBObject[this.d.count(name)];
        if (mIBObjectArray.length == 0) {
            return mIBObjectArray;
        }
        orderedMapIterator = this.d.lowerBound(orderedMapIterator);
        for (int i2 = 0; !orderedMapIterator.atEnd() && i2 < mIBObjectArray.length; ++i2) {
            mIBObjectArray[i2] = (MIBObject)((Pair)orderedMapIterator.get()).second;
            orderedMapIterator.advance();
        }
        return mIBObjectArray;
    }

    public MIBObject[] getObjectsByNamePrefix(String namePrefix, int maxCount) {
        MIBObject mIBObject;
        ArrayList<MIBObject> arrayList = new ArrayList<MIBObject>();
        OrderedMapIterator orderedMapIterator = this.d.lowerBound(namePrefix);
        for (int i2 = 0; !orderedMapIterator.atEnd() && (maxCount > 0 || i2 < maxCount) && (mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getName().startsWith(namePrefix); ++i2) {
            arrayList.add(mIBObject);
            orderedMapIterator.advance();
        }
        return arrayList.toArray(new MIBObject[arrayList.size()]);
    }

    public MIBObject[] getObjectsByOid(ObjectID oid) {
        OrderedMapIterator orderedMapIterator;
        MIBObject[] mIBObjectArray = new MIBObject[this.e.count(oid)];
        if (mIBObjectArray.length == 0) {
            return mIBObjectArray;
        }
        orderedMapIterator = this.e.lowerBound(orderedMapIterator);
        for (int i2 = 0; !orderedMapIterator.atEnd() && i2 < mIBObjectArray.length; ++i2) {
            mIBObjectArray[i2] = (MIBObject)((Pair)orderedMapIterator.get()).second;
            orderedMapIterator.advance();
        }
        return mIBObjectArray;
    }

    public synchronized void remove(MIBModule m2) {
        MIBObject mIBObject;
        this.a.remove(m2.getModuleName());
        this.b.remove(m2.getModuleID());
        OrderedMapIterator orderedMapIterator = this.e.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && mIBObject.getModuleID().equals(m2.getModuleID())) {
                this.e.remove(orderedMapIterator);
                orderedMapIterator = this.e.lowerBound(mIBObject.getOid());
                continue;
            }
            orderedMapIterator.advance();
        }
        orderedMapIterator = this.d.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && mIBObject.getModuleID().equals(m2.getModuleID())) {
                this.d.remove(orderedMapIterator);
                orderedMapIterator = this.d.lowerBound(mIBObject.getName());
                continue;
            }
            orderedMapIterator.advance();
        }
    }

    public Map<String, String> getImportDependencies(Collection<String> importingModules, String importedModuleFilter) {
        Iterator iterator;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.getModule(string);
            if (object == null) continue;
            if (importedModuleFilter != null) {
                if ((object = ((MIBModule)object).getImports(importedModuleFilter)) == null) continue;
                for (String string2 : ((MIBImport)object).getImportsVector()) {
                    hashMap.put(string2, string);
                }
                continue;
            }
            if (((MIBModule)object).getImportsVector() == null) continue;
            for (MIBImport mIBImport : ((MIBModule)object).getImportsVector()) {
                if (mIBImport == null) continue;
                for (String string3 : mIBImport.getImportsVector()) {
                    hashMap.put(string3, string);
                }
            }
        }
        return hashMap;
    }

    public synchronized int remove(MIBModule moduleToRemove, Collection<String> modulesToRetain) {
        MIBObject mIBObject;
        Map<String, String> map;
        int n2 = 0;
        this.a.remove(moduleToRemove.getModuleName());
        this.b.remove(moduleToRemove.getModuleID());
        map = this.getImportDependencies((Collection<String>)((Object)map), null);
        OrderedMapIterator orderedMapIterator = this.e.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && !map.containsKey(mIBObject.getName())) {
                if (mIBObject.getModuleID().equals(moduleToRemove.getModuleID()) || moduleToRemove.imports(mIBObject.getName()) && !map.containsKey(mIBObject.getName())) {
                    this.e.remove(orderedMapIterator);
                    orderedMapIterator = this.e.lowerBound(mIBObject.getOid());
                    continue;
                }
                orderedMapIterator.advance();
                continue;
            }
            orderedMapIterator.advance();
        }
        orderedMapIterator = this.d.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && !map.containsKey(mIBObject.getName())) {
                if (mIBObject.getModuleID().equals(moduleToRemove.getModuleID()) || moduleToRemove.imports(mIBObject.getName())) {
                    this.d.remove(orderedMapIterator);
                    ++n2;
                    orderedMapIterator = this.d.lowerBound(mIBObject.getName());
                    continue;
                }
                orderedMapIterator.advance();
                continue;
            }
            orderedMapIterator.advance();
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public void removeObject(Object moduleID, MIBObject o2) {
        MIBObject mIBObject;
        Object object;
        if (moduleID != null && (object = this.b.get(moduleID)) != null) {
            ((MIBModule)object).remove(o2);
        }
        if (o2.getOid().size() > 0) {
            object = this.e.lowerBound(o2.getOid());
            while (!((OrderedMapIterator)object).atEnd() && (mIBObject = (MIBObject)((Pair)((OrderedMapIterator)object).get()).second).getOid().equals(o2.getOid())) {
                if (mIBObject.getModuleID().equals(moduleID) && mIBObject.getName().equals(o2.getName())) {
                    this.e.remove((Enumeration)object);
                    break;
                }
                ((OrderedMapIterator)object).advance();
            }
        }
        object = this.d.lowerBound(o2.getName());
        while (!((OrderedMapIterator)object).atEnd() && (mIBObject = (MIBObject)((Pair)((OrderedMapIterator)object).get()).second).getName().equals(o2.getName())) {
            if (mIBObject.getModuleID().equals(moduleID) && (o2.getOid() == null && mIBObject.getOid() == null || o2.getOid() != null && o2.getOid().equals(mIBObject.getOid()))) {
                this.d.remove((Enumeration)object);
                break;
            }
            ((OrderedMapIterator)object).advance();
        }
        if (o2 instanceof MIBModule) {
            void var2_2;
            this.a.remove(((MIBModule)o2).getModuleName());
            this.b.remove(var2_2.getModuleID());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeObject(MIBObject o2) {
        void var1_1;
        if (o2.getModuleID() != null) {
            this.removeObject(o2.getModuleID(), o2);
            return;
        }
        this.e.remove(o2.getOid());
        this.d.remove(var1_1.getName());
    }

    public synchronized boolean removeModule(String moduleName) {
        MIBModule mIBModule;
        if ((mIBModule = this.a.get(mIBModule)) != null) {
            this.remove(mIBModule);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule getModule(String moduleName) {
        void var1_1;
        return this.a.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule getModule(Object moduleID) {
        void var1_1;
        return this.b.get(var1_1);
    }

    public MIBObject getObject(String name) {
        String[] stringArray = MIBRepository.a(name);
        if (stringArray[0] != null) {
            return this.getObject(stringArray[0], stringArray[1]);
        }
        return (MIBObject)this.d.get(stringArray[1]);
    }

    private static String[] a(String string) {
        if (string != null && string.length() > 2 && Character.isUpperCase(string.charAt(0)) && string.indexOf(46) > 0) {
            String string2 = string.substring(0, string.indexOf(46));
            string = string.substring(string.indexOf(46) + 1);
            return new String[]{string2, string};
        }
        return new String[]{null, string};
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getObject(ObjectID oid) {
        void var1_1;
        return (MIBObject)this.e.get(var1_1);
    }

    public Enumeration<MIBModule> modules() {
        return new EnumerationIterator<MIBModule>(this.a.values().iterator());
    }

    public Iterator<MIBModule> modulesIterator() {
        return this.a.values().iterator();
    }

    public Enumeration<? extends MIBModule> getModulesSortedByName() {
        OrderedMap orderedMap = new OrderedMap(LexicographicPredicate.instance);
        Enumeration<MIBModule> enumeration = this.modules();
        while (enumeration.hasMoreElements()) {
            MIBModule mIBModule = enumeration.nextElement();
            orderedMap.put(mIBModule.getModuleName(), mIBModule);
        }
        return orderedMap.elements();
    }

    public Vector<String> getModuleNames() {
        Vector<String> vector = new Vector<String>(this.a.size() + 1);
        for (MIBModule mIBModule : this.a.values()) {
            vector.add(mIBModule.getModuleName());
        }
        return vector;
    }

    public Enumeration<? extends MIBObject> objects() {
        return this.e.elements();
    }

    public Enumeration<? extends MIBObject> objectsByName() {
        return this.d.elements();
    }

    /*
     * WARNING - void declaration
     */
    public OrderedMapIterator find(ObjectID oid) {
        void var1_1;
        return this.e.find(var1_1);
    }

    public OrderedMapIterator firstOID() {
        return this.e.begin();
    }

    private void a(MIBObject object) throws ObjectIDFormatException {
        MIBObject mIBObject = this.b.get(((MIBObject)((Object)object)).getModuleID());
        if (mIBObject != null) {
            ((MIBModule)mIBObject).add((MIBObject)((Object)object));
        }
        if (object instanceof MIBObjectType && ((MIBObjectType)(mIBObject = (MIBObjectType)((Object)object))).isTable()) {
            mIBObject = ((MIBObjectType)mIBObject).getTableEntries();
            Arrays.sort((Object[])mIBObject);
            for (MIBObject mIBObject2 : this.getChildren((MIBObject)((Object)object))) {
                MIBObjectType mIBObjectType;
                if (!(mIBObject2 instanceof MIBObjectType)) continue;
                mIBObjectType.setColumnarObject(Arrays.binarySearch((Object[])mIBObject, (mIBObjectType = (MIBObjectType)mIBObject2).getName()) >= 0);
            }
        }
    }

    public synchronized void structureChanged() {
        Object object;
        Object object2 = this.e.elements();
        while (object2.hasMoreElements()) {
            object = (MIBObject)object2.nextElement();
            try {
                this.a((MIBObject)object);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.out.println("Repository: could not add object " + ((MIBObject)object).getName() + " because of invalid oid " + ((MIBObject)object).getOid().toString() + ".");
            }
        }
        object2 = new MIBObject();
        object = this.d.elements();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            if (!(mIBObject instanceof MIBTextualConvention) && !mIBObject.getClass().equals(object2.getClass())) continue;
            try {
                this.a(mIBObject);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.out.println("Repository: could not add object " + mIBObject.getName() + " because of invalid oid " + mIBObject.getOid().toString() + ".");
            }
        }
    }

    public String getPath(ObjectID oid, boolean withID) {
        StringTokenizer stringTokenizer;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (oid == null) {
            return "";
        }
        stringTokenizer = new StringTokenizer(((ObjectID)((Object)stringTokenizer)).toString(), ".", false);
        int n2 = stringTokenizer.countTokens();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(".");
                stringBuffer2.append(".");
            }
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            String string3 = this.getObjectName(new ObjectID(string2));
            if (string3 == null && "1".equals(string2)) {
                string3 = "iso";
            }
            if (string3 == null) {
                stringBuffer2.append(string);
                continue;
            }
            if (withID) {
                stringBuffer2.append(string3);
                stringBuffer2.append('(');
                stringBuffer2.append(string);
                stringBuffer2.append(')');
                continue;
            }
            stringBuffer2.append(string3);
        }
        return stringBuffer2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getPath(ObjectID oid) {
        void var1_1;
        return this.getPath((ObjectID)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String getPathSuffix(ObjectID oid) {
        void var1_1;
        return this.getPathSuffix((ObjectID)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String getPathSuffix(ObjectID oid, boolean unique) {
        MIBObject mIBObject;
        void var2_2;
        Object object;
        MIBObject[] mIBObjectArray;
        StringTokenizer stringTokenizer;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (oid == null) {
            return "";
        }
        ObjectID objectID = null;
        stringTokenizer = new StringTokenizer(((ObjectID)((Object)stringTokenizer)).toString(), ".", false);
        int n2 = stringTokenizer.countTokens();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(".");
                stringBuffer2.append(".");
            }
            mIBObjectArray = stringTokenizer.nextToken();
            stringBuffer.append((String)mIBObjectArray);
            object = new ObjectID(stringBuffer.toString());
            String string = this.getObjectName((ObjectID)object);
            if (string == null) {
                stringBuffer2.append((String)mIBObjectArray);
                continue;
            }
            stringBuffer2 = new StringBuffer(string);
            objectID = object;
        }
        if (var2_2 != false && objectID != null && (mIBObject = this.getObject(objectID)) != null && (mIBObjectArray = this.getObjectsByName(mIBObject.getName())) != null && mIBObjectArray.length > 1 && (object = this.getModuleName(mIBObject.getModuleID())) != null) {
            stringBuffer2 = new StringBuffer((String)object + "." + stringBuffer2.toString());
        }
        return stringBuffer2.toString();
    }

    public static MIBRepository loadFromFile(File path) {
        MIBRepository mIBRepository = null;
        try {
            InputStream inputStream = new FileInputStream(path);
            inputStream = new ObjectInputStream(inputStream);
            mIBRepository = new MIBRepository();
            int n2 = ((ObjectInputStream)inputStream).readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                MIBObject mIBObject = (MIBObject)((ObjectInputStream)inputStream).readObject();
                if (mIBObject instanceof MIBModule) {
                    ((MIBModule)mIBObject).reinit();
                }
                mIBRepository.addObject(mIBObject);
            }
            ((ObjectInputStream)inputStream).close();
            mIBRepository.structureChanged();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("MIB repository " + path + " not found.");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            System.out.println("MIB repository " + path + " corrupted.");
        }
        catch (IOException iOException) {
            System.out.println("IO error while reading MIB repository " + path + ".");
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file;
            System.out.println("Class not found (" + classNotFoundException.getMessage() + ") while reading MIB repository " + file + ".");
        }
        return mIBRepository;
    }

    public static boolean saveToFile(MIBRepository rep, File path) {
        try {
            MIBRepository mIBRepository;
            OutputStream outputStream;
            outputStream = new FileOutputStream((File)((Object)outputStream));
            outputStream = new ObjectOutputStream(outputStream);
            Object object = rep.getTextualConventions();
            ((ObjectOutputStream)outputStream).writeInt(rep.e.size() + ((Vector)object).size());
            object = ((Vector)object).elements();
            while (object.hasMoreElements()) {
                ((ObjectOutputStream)outputStream).writeObject(object.nextElement());
            }
            object = mIBRepository.e.elements();
            while (object.hasMoreElements()) {
                ((ObjectOutputStream)outputStream).writeObject(object.nextElement());
            }
            ((ObjectOutputStream)outputStream).flush();
            ((ObjectOutputStream)outputStream).close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public Vector<? extends MIBTextualConvention> getTextualConventions() {
        return this.getNonOidObjects(true);
    }

    public Vector<? extends MIBObject> getNonOidObjects(boolean textualConventionsOnly) {
        Vector<MIBObject> vector = new Vector<MIBObject>(this.d.size() / 50, 50);
        Enumeration enumeration = this.d.elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if ((textualConventionsOnly || mIBObject.getOid().size() != 0) && !(mIBObject instanceof MIBTextualConvention)) continue;
            vector.add(mIBObject);
        }
        return vector;
    }

    public MIBSyntax resolveTC(String name) {
        Object object;
        MIBSyntax mIBSyntax = null;
        while ((object = (MIBObject)this.d.get(object)) != null) {
            if (object instanceof MIBTextualConvention) {
                if (((MIBTextualConvention)(object = (MIBTextualConvention)object)).getSyntax().getType() == 3) {
                    mIBSyntax = ((MIBTextualConvention)object).getSyntax();
                    object = ((MIBTextualConvention)object).getSyntax().getSyntax();
                    continue;
                }
                return ((MIBTextualConvention)object).getSyntax();
            }
            return mIBSyntax;
        }
        return mIBSyntax;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID resolveOID(ObjectID oid) {
        String string = oid.getFirstUnresolvedSubId();
        if (string == null) {
            return oid;
        }
        Object object = this.getObjectID(string);
        if (object != null) {
            int n2 = oid.toString().indexOf(string) + string.length();
            object = ((ObjectID)object).toString();
            if (n2 >= 0 && n2 < oid.toString().length()) {
                void var1_1;
                object = (String)object + var1_1.toString().substring(n2);
            }
            return new ObjectID((String)object);
        }
        return null;
    }

    public MIBSyntax getBaseSyntax(MIBSyntax syntax) {
        MIBSyntax mIBSyntax = syntax;
        if (mIBSyntax.getType() == 3) {
            try {
                MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)this.getObject(mIBSyntax.getSyntax());
                if (mIBTextualConvention != null) {
                    mIBSyntax = mIBTextualConvention.getSyntax();
                }
            }
            catch (ClassCastException classCastException) {
                return mIBSyntax;
            }
        }
        return mIBSyntax;
    }

    /*
     * WARNING - void declaration
     */
    public MIBTextualConvention getEffectiveSyntax(MIBSyntax syntax) {
        void var1_1;
        return this.getEffectiveSyntax((ISyntax)var1_1);
    }

    public MIBTextualConvention getEffectiveSyntax(ISyntax syntax) {
        MIBTextualConvention mIBTextualConvention;
        Object object;
        MIBSyntax mIBSyntax;
        block16: {
            block17: {
                Serializable serializable;
                mIBSyntax = new MIBSyntax();
                object = syntax;
                mIBTextualConvention = new MIBTextualConvention();
                if (syntax.hasEnums()) {
                    mIBSyntax.setEnums((MIBEnum[])object.getEnums());
                }
                if (serializable.hasRanges()) {
                    mIBSyntax.setRanges((MIBRange[])object.getRanges());
                }
                mIBTextualConvention.setSyntax(mIBSyntax);
                while (true) {
                    Serializable serializable2;
                    Object object2 = object.getSyntax();
                    serializable = this;
                    Range range = ((MIBRepository)serializable).d.equalRange(object2);
                    if (range == null || range.begin.atEnd()) {
                        serializable2 = null;
                    } else {
                        MIBObject mIBObject = null;
                        MIBObject mIBObject2 = null;
                        while (range.begin.hasMoreElements()) {
                            if (((Pair)range.begin.get()).first.equals(object2)) {
                                MIBObject mIBObject3 = (MIBObject)((Pair)range.begin.get()).second;
                                MIBModule mIBModule = ((MIBRepository)serializable).getModule(mIBObject3.getModuleID());
                                if (mIBModule != null && mIBModule.getSMIVersion() > 1) {
                                    mIBObject = mIBObject3;
                                    break;
                                }
                                mIBObject2 = mIBObject3;
                            }
                            range.begin.advance();
                        }
                        serializable2 = serializable = mIBObject != null ? mIBObject : mIBObject2;
                    }
                    if (serializable2 == null) break block16;
                    if (!(serializable instanceof MIBTextualConvention)) break block17;
                    serializable = (MIBTextualConvention)serializable;
                    if (mIBTextualConvention.getName() == null) {
                        mIBTextualConvention.setName(((MIBObject)serializable).getName());
                    }
                    if (((MIBTextualConvention)serializable).hasDisplayHint()) {
                        mIBTextualConvention.setDisplayHint(((MIBTextualConvention)serializable).getDisplayHint());
                    }
                    if (((MIBTextualConvention)serializable).getSyntax().hasEnums()) {
                        object = ((MIBTextualConvention)serializable).getSyntax().getEnumsVector().elements();
                        while (object.hasMoreElements()) {
                            object2 = (MIBEnum)((Object)object.nextElement());
                            if (!mIBSyntax.hasEnums()) {
                                mIBSyntax.addEnum(new MIBEnum((SMIEnum)object2));
                                continue;
                            }
                            mIBSyntax.getEnumsVector().removeElement(object2);
                            mIBSyntax.addEnum(new MIBEnum((SMIEnum)object2));
                        }
                    } else if (((MIBTextualConvention)serializable).getSyntax().hasRanges()) {
                        object = ((MIBTextualConvention)serializable).getSyntax().getRangesVector().elements();
                        while (object.hasMoreElements()) {
                            object2 = (MIBRange)object.nextElement();
                            if (mIBSyntax.containsRange((MIBRange)object2) || !mIBSyntax.isRestrictiveRange((MIBRange)object2)) continue;
                            mIBSyntax.addRange((MIBRange)object2);
                        }
                    }
                    if (((MIBTextualConvention)serializable).getSyntax().getType() != 3) break;
                    object = ((MIBTextualConvention)serializable).getSyntax();
                }
                mIBSyntax.setSyntax(((MIBTextualConvention)serializable).getSyntax().getSyntax());
                mIBSyntax.setType(((MIBTextualConvention)serializable).getSyntax().getType());
                return mIBTextualConvention;
            }
            return mIBTextualConvention;
        }
        mIBSyntax.setSyntax(object.getSyntax());
        mIBSyntax.setType(object.getType());
        return mIBTextualConvention;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReferencedBy(String objectName, MIBModule module, MIBComplianceModule complianceModule) {
        void var2_2;
        Object object = MIBRepository.a(objectName);
        Iterator iterator = object[0];
        object = object[1];
        if (iterator != null && (module.getModuleName() != null ? !((String)((Object)iterator)).equals(module.getModuleName()) : !((String)((Object)iterator)).equals(module.getModuleName()))) {
            return false;
        }
        if (complianceModule.hasMandatory()) {
            for (Object object2 : complianceModule.getMandatoryVector()) {
                if (!((object2 = var2_2.getObject((String)object2)) instanceof MIBGroup) || !((MIBGroup)object2).contains((String)object)) continue;
                return true;
            }
        }
        if (complianceModule.hasVariations()) {
            void var3_3;
            for (Object object2 : var3_3.getVariationsVector()) {
                if (!(object2 instanceof MIBCondGroup) || !((object2 = var2_2.getObject(((MIBVariation)object2).getVariation())) instanceof MIBGroup) || !((MIBGroup)object2).contains((String)object)) continue;
                return true;
            }
        }
        return false;
    }

    public String printModule(String moduleName) {
        MIBModule mIBModule;
        if ((mIBModule = this.getModule((String)((Object)mIBModule))) == null) {
            return "";
        }
        return mIBModule.toSMI(1, this, MIBObject.getLineSeparator());
    }

    public static <T> Vector<T> buildVector(T[] objects) {
        T[] TArray;
        if (objects == null) {
            return null;
        }
        Vector<T> vector = new Vector<T>(objects.length > 0 ? objects.length : 1);
        vector.addAll(Arrays.asList(TArray));
        return vector;
    }

    public static String buildStringEnumeration(Enumeration en, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        while (en.hasMoreElements()) {
            stringBuilder.append(prefix + en.nextElement().toString());
            if (!en.hasMoreElements()) continue;
            stringBuilder.append(",\n");
        }
        return stringBuilder.toString();
    }

    public static String buildStringEnumeration(Iterator it, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        while (it.hasNext()) {
            stringBuilder.append(prefix + it.next().toString());
            if (!it.hasNext()) continue;
            stringBuilder.append(",\n");
        }
        return stringBuilder.toString();
    }

    public static String buildStringEnumeration(Enumeration en) {
        StringBuilder stringBuilder = new StringBuilder();
        while (en.hasMoreElements()) {
            stringBuilder.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void renameModule(MIBModule oldModule, String newModuleName) {
        void var1_1;
        void var2_2;
        this.a.remove(oldModule.getModuleName());
        oldModule.setModuleName(newModuleName);
        this.a.put((String)var2_2, (MIBModule)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void renameObject(MIBObject oldObject, ObjectID newObjectID, String newObjectName) {
        Object object;
        if (!oldObject.getName().equals(newObjectName)) {
            void var3_3;
            if (oldObject.getModuleID() != null) {
                object = this.b.get(oldObject.getModuleID());
                if (object != null) {
                    ((MIBModule)object).remove(oldObject);
                    if (!oldObject.getName().equals(newObjectName)) {
                        ((MIBModule)object).changeObjectReferences(oldObject.getName(), newObjectName);
                    }
                }
                object = this.d.begin();
                while (((OrderedMapIterator)object).hasMoreElements()) {
                    if (((MIBObject)((Pair)((OrderedMapIterator)object).get()).second).equals(oldObject)) {
                        this.d.remove((Enumeration)object);
                        break;
                    }
                    ((OrderedMapIterator)object).advance();
                }
            }
            oldObject.setName(newObjectName);
            this.d.add(var3_3, oldObject);
        }
        if (!oldObject.getOid().equals(newObjectID)) {
            void var1_1;
            void var2_2;
            object = this.e.begin();
            while (((OrderedMapIterator)object).hasMoreElements()) {
                if ((MIBObject)((Pair)((OrderedMapIterator)object).get()).second == oldObject) {
                    this.e.remove((Enumeration)object);
                    break;
                }
                ((OrderedMapIterator)object).advance();
            }
            oldObject.setOid(newObjectID);
            this.e.add(var2_2, var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Vector<MIBObjectType> getColumnarObjectsOfTable(MIBModule m2, MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        Object object;
        void var3_3;
        if (ot == null || !ot.isTable()) {
            return null;
        }
        Vector<MIBObjectType> vector = new Vector<MIBObjectType>();
        if (m2 == null) {
            return null;
        }
        if (var3_3 != false) {
            Object object2 = ot;
            if (ot.getIndexPart().isAugment()) {
                int n2;
                object = this.getObjectsByName(ot.getIndexPart().getIndexPart()[0]);
                object2 = null;
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    if (!((MIBObject)object[n2]).getModuleID().equals(ot.getModuleID())) continue;
                    object2 = object[n2];
                    break;
                }
                if (object2 == null) {
                    for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                        String string = this.getModuleName(((MIBObject)object[n2]).getModuleID());
                        if (string == null || !m2.imports(((MIBObject)object[n2]).getName(), string)) continue;
                        object2 = object[n2];
                        break;
                    }
                } else if (((Object)object).length == 1) {
                    object2 = object[0];
                }
                object2 = (MIBObjectType)object2;
            }
            if (object2 != null && object2.hasIndexPart()) {
                object = object2.getIndexPart().getIndexPartVector().elements();
                while (object.hasMoreElements()) {
                    object2 = this.getObjectsByName((String)object.nextElement());
                    MIBObject mIBObject = null;
                    if (((MIBObject[])object2).length > 1) {
                        int n3;
                        for (n3 = 0; n3 < ((MIBObject[])object2).length; ++n3) {
                            if (!object2[n3].getModuleID().equals(ot.getModuleID()) || !(object2[n3] instanceof MIBObjectType)) continue;
                            mIBObject = object2[n3];
                            break;
                        }
                        if (mIBObject == null) {
                            for (n3 = 0; n3 < ((MIBObject[])object2).length; ++n3) {
                                MIBModule mIBModule = this.getModule(object2[n3].getModuleID());
                                if (mIBModule == null || !m2.imports(object2[n3].getName(), mIBModule.getModuleName()) || !(object2[n3] instanceof MIBObjectType)) continue;
                                mIBObject = object2[n3];
                                break;
                            }
                        }
                    } else if (((MIBObject[])object2).length == 1) {
                        mIBObject = object2[0];
                    }
                    if (mIBObject == null) continue;
                    vector.add((MIBObjectType)mIBObject);
                }
            } else {
                return null;
            }
        }
        if (includeColumns) {
            void var2_2;
            Enumeration enumeration = var2_2.getTableEntriesVector().elements();
            while (enumeration.hasMoreElements()) {
                object = (MIBObjectType)this.getObject(m2.getModuleName(), (String)enumeration.nextElement());
                if (object == null || SMI.accessType(((MIBObjectType)object).getAccess()) == 0) continue;
                vector.add((MIBObjectType)object);
            }
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<? extends MIBObjectType> getColumnarObjectsOfTable(MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        void var3_3;
        void var2_2;
        void var1_1;
        MIBModule mIBModule = this.getModule(ot.getModuleID());
        return this.getColumnarObjectsOfTable(mIBModule, (MIBObjectType)var1_1, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public List<? extends MIBNotifyType> getNotificatioObjects(INotificationType nt) {
        void var1_1;
        MIBModule mIBModule = this.getModule(nt.getModuleID());
        return this.getNotificatioObjects(mIBModule, (INotificationType)var1_1);
    }

    public List<? extends MIBNotifyType> getNotificatioObjects(MIBModule module, INotificationType nt) {
        ArrayList<MIBObject> arrayList = new ArrayList<MIBObject>();
        if (nt.getVariablesVector() == null) {
            return arrayList;
        }
        Iterator iterator = nt.getVariablesVector().iterator();
        while (iterator.hasNext()) {
            MIBObject[] mIBObjectArray = this.getObjectsByName((String)iterator.next());
            MIBObject mIBObject = null;
            if (mIBObjectArray.length > 1) {
                int n2;
                for (n2 = 0; n2 < mIBObjectArray.length; ++n2) {
                    if (!mIBObjectArray[n2].getModuleID().equals(nt.getModuleID())) continue;
                    mIBObject = mIBObjectArray[n2];
                    break;
                }
                if (mIBObject == null) {
                    for (n2 = 0; n2 < mIBObjectArray.length; ++n2) {
                        MIBModule mIBModule = this.getModule(mIBObjectArray[n2].getModuleID());
                        if (mIBModule == null || !module.imports(mIBObjectArray[n2].getName(), mIBModule.getModuleName())) continue;
                        mIBObject = mIBObjectArray[n2];
                        break;
                    }
                }
            } else if (mIBObjectArray.length == 1) {
                mIBObject = mIBObjectArray[0];
            }
            if (mIBObject != null) {
                arrayList.add(mIBObject);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public Vector<? extends MIBObjectType> getAugmentingTables(MIBObjectType table) {
        MIBModule mIBModule = this.getModule(table.getModuleID());
        Vector<MIBObject> vector = new Vector<MIBObject>();
        Enumeration<? extends MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType) || !((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).isTable() || !((MIBObjectType)mIBObject).hasIndexPart() || !((MIBObjectType)mIBObject).getIndexPart().isAugment() || !((MIBObjectType)mIBObject).getIndexPart().getIndexPart()[0].equals(table.getName())) continue;
            MIBModule mIBModule2 = this.getModule(mIBObject.getModuleID());
            if (mIBModule != null && mIBModule2 != null) {
                if (!mIBModule2.getModuleID().equals(mIBModule.getModuleID()) && !mIBModule2.imports(table.getName(), mIBModule.getModuleName())) continue;
                vector.addElement(mIBObject);
                continue;
            }
            vector.addElement(mIBObject);
        }
        return vector;
    }

    public boolean isExpandingIndex(MIBIndexPart parent, MIBIndexPart expansion) {
        Vector vector;
        Vector vector2;
        if (parent == null || expansion == null) {
            return false;
        }
        vector2 = ((MIBIndexPart)((Object)vector2)).getIndexPartVector();
        if ((vector = ((MIBIndexPart)((Object)vector)).getIndexPartVector()).size() < vector2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            if (vector2.elementAt(i2).equals(vector.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public Vector<? extends MIBObjectType> getParentTables(MIBObjectType table) {
        MIBModule mIBModule = this.getModule(table.getModuleID());
        Vector<MIBObject> vector = new Vector<MIBObject>();
        Enumeration<? extends MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType)) continue;
            if (((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).isTable() && ((MIBObjectType)mIBObject).hasIndexPart() && ((MIBObjectType)mIBObject).getIndexPart().isAugment() && ((MIBObjectType)mIBObject).getIndexPart().getIndexPart()[0].equals(table.getName())) {
                MIBModule mIBModule2 = this.getModule(mIBObject.getModuleID());
                if (mIBModule != null && mIBModule2 != null) {
                    if (!mIBModule2.getModuleID().equals(mIBModule.getModuleID()) && !mIBModule2.imports(table.getName(), mIBModule.getModuleName())) continue;
                    vector.addElement(mIBObject);
                    continue;
                }
                vector.addElement(mIBObject);
                continue;
            }
            if (!((MIBObjectType)mIBObject).isTable() || !((MIBObjectType)mIBObject).hasIndexPart() || mIBObject.getName().equals(table.getName()) || !this.isExpandingIndex(((MIBObjectType)mIBObject).getIndexPart(), table.getIndexPart())) continue;
            vector.addElement(mIBObject);
        }
        return vector;
    }

    public MIBObjectType getObjectType(ObjectID instanceID) {
        try {
            Serializable serializable;
            serializable = this.getSplittedObjectID((ObjectID)serializable);
            if (serializable == null) {
                return null;
            }
            serializable = (ObjectID)serializable.first;
            if ((serializable = this.getObject((ObjectID)serializable)) instanceof MIBObjectType) {
                return (MIBObjectType)serializable;
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {}
        return null;
    }

    public MIBObjectType getTableEntry(MIBObject o2) {
        if (o2 instanceof MIBObjectType) {
            Serializable serializable;
            if (((MIBObjectType)(serializable = (MIBObjectType)serializable)).isTable()) {
                return serializable;
            }
            if (((Vector)(serializable = this.getChildren((MIBObject)serializable))).size() == 0) {
                return null;
            }
            if ((serializable = (MIBObject)((Vector)serializable).firstElement()) instanceof MIBObjectType && ((MIBObjectType)serializable).isTable()) {
                return (MIBObjectType)serializable;
            }
        }
        return null;
    }

    public MIBObject getNextObject(ObjectID oid) {
        OrderedMapIterator orderedMapIterator = this.e.lowerBound(oid);
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid)) {
                return mIBObject;
            }
            orderedMapIterator.advance();
        }
        return null;
    }

    public MIBObject getPrevObject(ObjectID oid) {
        OrderedMapIterator orderedMapIterator = this.e.upperBound(oid);
        while (!(orderedMapIterator.atBegin() || orderedMapIterator.get() != null && ((MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(oid))) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atEnd() && !orderedMapIterator.atBegin()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid)) {
                return mIBObject;
            }
            orderedMapIterator.retreat();
        }
        return null;
    }

    public MIBObject getNextSibblingObject(ObjectID oid) {
        OrderedMapIterator orderedMapIterator = this.e.lowerBound(oid);
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid) && mIBObject.getOid().isPeerOf(oid)) {
                return mIBObject;
            }
            orderedMapIterator.advance();
        }
        return null;
    }

    public MIBObject getPrevSibblingObject(ObjectID oid) {
        OrderedMapIterator orderedMapIterator = this.e.upperBound(oid);
        if (!orderedMapIterator.atBegin() && orderedMapIterator.atEnd()) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atBegin() && !((MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(oid)) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atBegin()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid) && mIBObject.getOid().isPeerOf(oid)) {
                return mIBObject;
            }
            orderedMapIterator.retreat();
        }
        return null;
    }

    public Map<Integer, String> getImportedModuleIDs() {
        return this.c;
    }

    public Map<String, Integer> addImportedModuleIDsInverse(Map<Integer, String> moduleIDs) {
        HashMap<Integer, String> hashMap;
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(hashMap.size());
        for (Object k2 : hashMap.keySet()) {
            hashMap2.put((Integer)hashMap.get(k2), (String)k2);
        }
        hashMap = hashMap2;
        this.addImportedModuleIDs(hashMap);
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public void removeImportedModuleID(Object moduleID) {
        void var1_1;
        this.c.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addImportedModuleIDs(Map<Integer, String> moduleIDs) {
        void var1_1;
        this.c.putAll((Map<Integer, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getModuleName(Object moduleID) {
        void var1_1;
        MIBModule mIBModule = this.b.get(moduleID);
        if (mIBModule != null) {
            return mIBModule.getModuleName();
        }
        return this.c.get(var1_1);
    }

    public void freeUserObjects() {
        Enumeration<? extends MIBObject> enumeration = this.objectsByName();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().freeUserObjects();
        }
    }
}

