/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smi.ext.SMINotificationType;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBNotifyType
extends MIBObject
implements SMINotificationType,
Serializable {
    public static final long serialVersionUID = 1000L;
    protected String enterprise;
    protected Vector variables = null;
    public static final int ID = 3;
    protected int trapType = 3;

    public MIBNotifyType() {
        this(3);
    }

    /*
     * WARNING - void declaration
     */
    public MIBNotifyType(int type) {
        void var1_1;
        this.trapType = var1_1 == 2 ? 2 : 3;
        this.enterprise = null;
    }

    /*
     * WARNING - void declaration
     */
    public MIBNotifyType(ObjectID oid, String name, Integer moduleID, int type) {
        super((ObjectID)var1_1, (String)var2_2, (Integer)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.trapType = type == 2 ? 2 : 3;
    }

    /*
     * WARNING - void declaration
     */
    public MIBNotifyType(MIBNotifyType other) {
        super(other);
        void var1_1;
        this.enterprise = other.enterprise;
        if (other.hasVariables()) {
            Enumeration enumeration = other.variables.elements();
            while (enumeration.hasMoreElements()) {
                this.addVariable((String)enumeration.nextElement());
            }
        }
        this.trapType = var1_1.trapType;
    }

    @Override
    public MIBObject getClone() {
        return new MIBNotifyType(this);
    }

    @Override
    public final String getTypeString() {
        return SMI.ENTRY_TYPES[this.trapType];
    }

    @Override
    public final int getType() {
        return this.trapType;
    }

    @Override
    public final boolean isV1Trap() {
        return this.trapType == 2;
    }

    public final int getTrapType() {
        return this.trapType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTrapType(int trapType) {
        void var1_1;
        this.trapType = var1_1;
    }

    @Override
    public boolean hasVariables() {
        return this.variables != null && this.variables.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVariables(String[] objects) {
        void var1_1;
        this.variables = MIBRepository.buildVector(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addVariable(String variable) {
        void var1_1;
        if (this.variables == null) {
            this.variables = new Vector(5);
        }
        this.variables.addElement(var1_1);
    }

    @Override
    public String[] getVariables() {
        if (this.variables == null) {
            return null;
        }
        Object[] objectArray = new String[this.variables.size()];
        this.variables.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void setVariablesVector(Vector v) {
        void var1_1;
        this.variables = var1_1;
    }

    @Override
    public final Vector getVariablesVector() {
        return this.variables;
    }

    @Override
    public final String getEnterprise() {
        return this.enterprise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setEnterprise(String enterprise) {
        void var1_1;
        this.enterprise = var1_1;
    }

    public String getVariableList() {
        if (!this.hasVariables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBNotifyType mIBNotifyType = (MIBNotifyType)this.comparable(mode);
        StringBuffer stringBuffer = new StringBuffer(lineSeparator);
        MIBNotifyType.addNavigationLinks(this, mode, stringBuffer, rep, lineSeparator);
        if (this.hasComment()) {
            MIBNotifyType.addComment(mode, stringBuffer, this.asn1Comment, lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        MIBNotifyType.addObjectRef(null, mode, stringBuffer, this.name, mIBNotifyType == null ? null : mIBNotifyType.name);
        if (this.isV1Trap() && mode != 8 || mode == 16) {
            String string;
            MIBNotifyType.addKeyWord(mode, stringBuffer, " TRAP-TYPE");
            stringBuffer.append(lineSeparator + "\t");
            MIBNotifyType.addKeyWord(mode, stringBuffer, "ENTERPRISE ");
            MIBObject.addString(mode, stringBuffer, this.enterprise, mIBNotifyType == null ? null : mIBNotifyType.enterprise);
            stringBuffer.append(lineSeparator);
            if (this.hasVariables()) {
                stringBuffer.append('\t');
                MIBNotifyType.addKeyWord(mode, stringBuffer, "VARIABLES");
                stringBuffer.append(" {" + lineSeparator);
                string = null;
                if (mIBNotifyType != null) {
                    string = mIBNotifyType.hasVariables() ? MIBObject.formatObjectRefs(mode, "\t\t", mIBNotifyType.getVariablesVector().iterator(), lineSeparator) : "";
                }
                MIBObject.addString(mode, stringBuffer, MIBObject.formatObjectRefs(mode, "\t\t", this.getVariablesVector().iterator(), lineSeparator), string);
                stringBuffer.append("}");
                stringBuffer.append(lineSeparator);
            }
            if (this.descr != null) {
                stringBuffer.append('\t');
                MIBNotifyType.addKeyWord(mode, stringBuffer, "DESCRIPTION ");
                stringBuffer.append(lineSeparator);
                string = null;
                if (mIBNotifyType != null) {
                    string = mIBNotifyType.descr != null ? MIBObject.formatLines("\t\t", mIBNotifyType.descr) : "";
                }
                MIBNotifyType.addText(lineSeparator, mode, stringBuffer, MIBObject.formatLines("\t\t", this.descr), string);
                stringBuffer.append(lineSeparator);
            }
        } else {
            MIBNotifyType.addKeyWord(mode, stringBuffer, " NOTIFICATION-TYPE");
            stringBuffer.append(lineSeparator);
            if (this.hasVariables()) {
                stringBuffer.append('\t');
                MIBNotifyType.addKeyWord(mode, stringBuffer, "OBJECTS");
                stringBuffer.append(" {");
                stringBuffer.append(lineSeparator);
                String string = null;
                if (mIBNotifyType != null) {
                    string = mIBNotifyType.hasVariables() ? MIBObject.formatObjectRefs(mode, "\t\t", mIBNotifyType.getVariablesVector().iterator(), lineSeparator) : "";
                }
                MIBObject.addString(mode, stringBuffer, MIBObject.formatObjectRefs(mode, "\t\t", this.getVariablesVector().iterator(), lineSeparator), string);
                stringBuffer.append("}");
                stringBuffer.append(lineSeparator);
            }
            stringBuffer.append(this.getSMIDefBegin(mode, lineSeparator));
        }
        if (this.isV1Trap() && mode != 8 || mode == 16) {
            try {
                stringBuffer.append(" ::= ");
                stringBuffer.append(this.oid.getLastSubID());
                stringBuffer.append(lineSeparator);
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        } else {
            void var3_4;
            void var1_1;
            stringBuffer.append(this.getSMIDefEnd((int)var1_1, (MIBRepository)var3_4, this.asn1CommentInline, lineSeparator));
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isStructural() {
        return false;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof MIBNotifyType && super.equals(o2)) {
            MIBNotifyType mIBNotifyType;
            mIBNotifyType = mIBNotifyType;
            return MIBNotifyType.saveCompare(this.variables, mIBNotifyType.variables) && MIBNotifyType.saveCompare(this.enterprise, mIBNotifyType.enterprise) && this.trapType == mIBNotifyType.trapType;
        }
        return false;
    }
}

