/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.smi.ext.SMIIndexPart;
import java.io.Serializable;
import java.util.Vector;

public class MIBIndexPart
implements SMIIndexPart,
Serializable {
    public static final long serialVersionUID = 1000L;
    protected Vector indecies = new Vector(1);
    protected int type = 1;
    protected boolean implied = false;
    public static final int INDEX = 1;
    public static final int AUGMENT = 2;

    public MIBIndexPart() {
        this.setType(1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBIndexPart(int type) {
        void var1_1;
        this.setType((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBIndexPart(int type, Vector indexes) {
        void var2_2;
        void var1_1;
        this.setType((int)var1_1);
        this.indecies = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public MIBIndexPart(MIBIndexPart other) {
        void var1_1;
        this.setIndexPart(other.getIndexPart());
        this.implied = other.implied;
        this.type = var1_1.type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean isAugment() {
        return this.type == 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setType(int type) {
        void var1_1;
        this.type = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addIndexPart(String index) {
        void var1_1;
        if (this.indecies == null) {
            this.indecies = new Vector(3);
        }
        this.indecies.addElement(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIndexPart(String[] indexes) {
        void var1_1;
        this.indecies = MIBRepository.buildVector(var1_1);
    }

    @Override
    public String[] getIndexObjects() {
        return this.getIndexPart();
    }

    public String[] getIndexPart() {
        if (this.indecies == null) {
            return null;
        }
        Object[] objectArray = new String[this.indecies.size()];
        this.indecies.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public Vector getIndexPartVector() {
        return this.indecies;
    }

    /*
     * WARNING - void declaration
     */
    public void setIndexPartVector(Vector v) {
        void var1_1;
        this.indecies = var1_1;
    }

    @Override
    public boolean isImplied() {
        return this.implied;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setImplied(boolean implied) {
        void var1_1;
        this.implied = var1_1;
    }

    public boolean getImplied() {
        return this.isImplied();
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, String lineSeparator) {
        void var2_2;
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getType()) {
            case 1: {
                MIBObject.addKeyWord(mode, stringBuffer, "INDEX ");
                break;
            }
            case 2: {
                MIBObject.addKeyWord(mode, stringBuffer, "AUGMENTS ");
            }
        }
        stringBuffer.append("{");
        stringBuffer.append(lineSeparator);
        Vector vector = (Vector)this.indecies.clone();
        if (this.implied) {
            vector.removeElementAt(vector.size() - 1);
        }
        stringBuffer.append(MIBObject.formatObjectRefs(mode, "\t\t", vector.iterator(), lineSeparator));
        if (this.implied) {
            void var1_1;
            if (vector.size() > 0) {
                stringBuffer.append(",");
                stringBuffer.append(lineSeparator);
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("\t\t");
            MIBObject.addKeyWord((int)var1_1, stringBuffer, "IMPLIED ");
            stringBuffer.append(this.indecies.get(this.indecies.size() - 1).toString());
        }
        stringBuffer.append(" }");
        stringBuffer.append((String)var2_2);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toSMI(1, "\n");
    }

    public IndexStruct[] getIndexStruct(MIBRepository repository) {
        Object object;
        boolean bl = this.isImplied();
        String[] stringArray = this.getIndexPart();
        if (this.getType() == 2) {
            object = (MIBObjectType)repository.getObject(stringArray[0]);
            stringArray = ((MIBObjectType)object).getIndexPart().getIndexPart();
            bl = ((MIBObjectType)object).getIndexPart().isImplied();
        }
        object = new IndexStruct[stringArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            MIBObjectType mIBObjectType = (MIBObjectType)repository.getObject(stringArray[i2]);
            if (mIBObjectType == null || mIBObjectType.getSyntax() == null) {
                return null;
            }
            MIBSyntax mIBSyntax = repository.getEffectiveSyntax(mIBObjectType.getSyntax()).getSyntax();
            if (mIBSyntax == null) {
                mIBSyntax = mIBObjectType.getSyntax();
            }
            if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("TruthValue") || mIBSyntax.getSyntax().equals("Integer32") || mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32") || mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32") || mIBSyntax.getSyntax().equals("TimeTicks") || mIBSyntax.getSyntax().equals("TimeStamp")) {
                object[i2] = new IndexStruct(stringArray[i2], 0, false, 1, 1);
                ++n2;
                continue;
            }
            if (mIBSyntax.getSyntax().equals("IpAddress")) {
                object[i2] = new IndexStruct(stringArray[i2], 5, false, 4, 4);
                n2 += 4;
                continue;
            }
            if (mIBSyntax.getSyntax().equals("NetworkAddress")) {
                object[i2] = new IndexStruct(stringArray[i2], 12, false, 5, 5);
                n2 += 5;
                continue;
            }
            if (mIBSyntax.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                object[i2] = new IndexStruct(stringArray[i2], 3, bl && i2 + 1 == stringArray.length, 2, 128 - n2);
                continue;
            }
            if (mIBSyntax.getSyntax().startsWith("OCTET") || mIBSyntax.getSyntax().startsWith("BITS") || mIBSyntax.getSyntax().startsWith("Opaque")) {
                if (mIBSyntax.hasRanges() && mIBSyntax.getRanges().length > 0) {
                    try {
                        int n3 = (int)mIBSyntax.getMinOfRanges();
                        int n4 = (int)mIBSyntax.getMaxOfRanges();
                        n2 += n3;
                        if (bl && i2 + 1 == stringArray.length) {
                            object[i2] = new IndexStruct(stringArray[i2], 1, true, n3, Math.min(n4, 128 - n2));
                            continue;
                        }
                        object[i2] = new IndexStruct(stringArray[i2], 1, false, n3, Math.min(n4, 128 - n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object[i2] = null;
                    }
                    continue;
                }
                object[i2] = new IndexStruct(stringArray[i2], 1, bl && i2 + 1 == stringArray.length, 0, 128 - n2);
                continue;
            }
            mIBSyntax.getSyntax().equals("Counter64");
        }
        return object;
    }
}

