/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.spelling;

import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.commons.mib.editor.AnnotationMark;
import com.agentpp.designer.spelling.SpellExceptionProvider;
import com.wintertree.ssce.EditableLexicon;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.PropSpellingSession;
import com.wintertree.ssce.StringWordParser;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.WordParser;
import com.wintertree.util.UniCharacter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

public class BackgroundChecker
implements CaretListener,
DocumentListener {
    private TreeMap<Integer, Integer> a;
    private SpellExceptionProvider b;
    protected boolean busy;
    protected JTextComponent component;
    protected int caretPos;
    protected Vector<MisspelledWord> misspelledWords = new Vector();
    public boolean debug = false;
    protected Highlighter.HighlightPainter highlightPainter;
    protected PropSpellingSession sentry;
    protected EditableLexicon userDictionary;

    /*
     * WARNING - void declaration
     */
    public BackgroundChecker(JTextComponent component, PropSpellingSession sentry, Highlighter.HighlightPainter highlightPainter) {
        void var1_1;
        FileTextLexicon[] fileTextLexiconArray;
        void var3_3;
        this.component = component;
        this.sentry = sentry;
        this.highlightPainter = highlightPainter != null ? var3_3 : new ZigZagHighlightPainter(this, Color.red);
        fileTextLexiconArray = fileTextLexiconArray.getUserLexicons();
        this.userDictionary = fileTextLexiconArray != null ? fileTextLexiconArray[0] : null;
        this.caretPos = var1_1.getCaret().getDot();
        this.resume();
    }

    /*
     * WARNING - void declaration
     */
    public void setSpellExceptionProvider(SpellExceptionProvider exceptionProvider) {
        void var1_1;
        this.b = var1_1;
    }

    public SpellExceptionProvider getSpellExceptionProvider() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void setTextRanges(TreeMap<Integer, Integer> textRanges) {
        void var1_1;
        this.a = var1_1;
        this.misspelledWords.clear();
    }

    /*
     * WARNING - void declaration
     */
    public BackgroundChecker(JTextComponent component, PropSpellingSession sentry) {
        this((JTextComponent)var1_1, (PropSpellingSession)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addMisspelledWord(String word, int offset) throws BadLocationException {
        void var2_2;
        void var1_1;
        Object object = this.misspelledWords.elements();
        while (object.hasMoreElements()) {
            MisspelledWord misspelledWord = object.nextElement();
            if (offset < misspelledWord.getOffset() || offset >= misspelledWord.getOffset() + misspelledWord.getLen()) continue;
            misspelledWord.setLen(word.length());
            if (this.debug) {
                this.a("add.1");
            }
            return;
        }
        object = new MisspelledWord(this, (String)var1_1, (int)var2_2);
        this.misspelledWords.addElement((MisspelledWord)object);
        if (this.debug) {
            this.a("add.2");
        }
    }

    public List<MisspelledWord> getMisspelledWords() {
        return this.misspelledWords;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void caretUpdate(CaretEvent ev) {
        void var1_1;
        if (this.busy) {
            return;
        }
        this.busy = true;
        int n2 = var1_1.getDot();
        if (n2 == this.caretPos) {
            this.busy = false;
            return;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.getWordAt(this.caretPos, stringBuffer);
        if (n3 >= 0 && (n2 < n3 || n2 > n3 + stringBuffer.length())) {
            bl = true;
        }
        if (n2 == this.caretPos + 1) {
            String string = null;
            try {
                string = this.component.getDocument().getText(this.caretPos - 1, 2);
            }
            catch (BadLocationException badLocationException) {}
            if (string != null && this.isWordChar(string.charAt(0)) && !this.isWordChar(string.charAt(1))) {
                n3 = this.getWordAt(this.caretPos - 1, stringBuffer);
                bl = true;
            }
        }
        if (bl) {
            this.checkWord(stringBuffer.toString(), n3);
        }
        this.caretPos = n2;
        this.busy = false;
    }

    @Override
    public void changedUpdate(DocumentEvent junk) {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkWord(String word, int offset) {
        Map.Entry<Integer, Integer> entry;
        Integer n2 = 0;
        if (this.b != null && this.b.isSpellingAccepted(word)) {
            return false;
        }
        if (this.a != null) {
            entry = this.a.floorEntry(offset);
            if (entry == null) return false;
            if ((Integer)entry.getKey() <= offset && (Integer)entry.getValue() >= offset) {
                n2 = null;
            }
        }
        if (n2 == null) {
            entry = new StringBuffer();
            n2 = this.sentry.check(word, (StringBuffer)((Object)entry));
        }
        if ((n2 & 1) != 0) {
            n2 = n2 & 0xFFFFFFFE;
            n2 = n2 | 2;
        }
        if ((n2 & 0x10) == 0) {
            if ((n2 & 2) == 0) {
                void var2_2;
                void var1_1;
                if (n2 != 0) return false;
                if (!this.isInMisspelledWord(offset, offset + var1_1.length())) return false;
                this.removeMisspelledWord((int)var2_2);
                return false;
            }
        }
        try {
            this.addMisspelledWord(word, offset);
            return false;
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen!" + badLocationException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JPopupMenu createPopupMenu(int x, int y, int maxSuggestions, String ignoreAllLabel, String addLabel, String noSuggestionsLabel) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.isInWord(x, y)) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.fillPopupMenu(jPopupMenu, (int)var1_1, (int)var2_2, (int)var3_3, ignoreAllLabel, addLabel, noSuggestionsLabel);
        return jPopupMenu;
    }

    /*
     * WARNING - void declaration
     */
    public boolean fillPopupMenu(JPopupMenu menu, int x, int y, int maxSuggestions, String ignoreAllLabel, String addLabel, String noSuggestionsLabel2) {
        JMenuItem jMenuItem;
        void var3_5;
        void var2_2;
        TextUI textUI = this.component.getUI();
        Point point = new Point((int)var2_2, (int)var3_5);
        int n2 = textUI.viewToModel(this.component, point);
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 = this.getWordAt(n2, stringBuffer)) < 0) {
            return false;
        }
        SuggestionSet suggestionSet = new SuggestionSet(maxSuggestions);
        this.sentry.suggest(stringBuffer.toString(), this.sentry.getMinSuggestDepth(), this.sentry.getComparator(), suggestionSet);
        if (suggestionSet.size() > 0) {
            void var7_12;
            boolean noSuggestionsLabel2 = false;
            while (var7_12 < suggestionSet.size()) {
                menu.add(new c(this, suggestionSet.wordAt((int)var7_12), n2, stringBuffer.length()));
                ++var7_12;
            }
            menu.addSeparator();
        } else if (jMenuItem != null) {
            jMenuItem = new JMenuItem((String)((Object)jMenuItem));
            jMenuItem.setEnabled(false);
            menu.add(jMenuItem);
            menu.addSeparator();
        }
        if (ignoreAllLabel != null) {
            menu.add(new b(this, ignoreAllLabel, stringBuffer.toString()));
        }
        if (addLabel != null && this.userDictionary != null) {
            void var1_1;
            var1_1.add(new a(this, addLabel, stringBuffer.toString()));
        }
        return true;
    }

    public Color getZigZagColor() {
        if (this.highlightPainter instanceof ZigZagHighlightPainter) {
            return ((ZigZagHighlightPainter)this.highlightPainter).getColor();
        }
        return Color.black;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insertUpdate(DocumentEvent ev) {
        void var1_1;
        if (this.busy) {
            return;
        }
        this.busy = true;
        int c2 = ev.getLength();
        int n2 = var1_1.getOffset();
        if (c2 == 1) {
            int misspelledWord = n2 - c2;
            StringBuffer stringBuffer = new StringBuffer();
            char c3 = '\u0000';
            char c4 = '\u0000';
            try {
                c3 = this.component.getText(misspelledWord, 1).charAt(0);
                c4 = this.component.getText(n2, 1).charAt(0);
            }
            catch (BadLocationException badLocationException) {}
            c3 = (char)(this.isWordChar(c3) ? 1 : 0);
            c4 = (char)(this.isWordChar(c4) ? 1 : 0);
            boolean bl = false;
            int n3 = n2;
            if (c4 != '\u0000') {
                MisspelledWord misspelledWord2;
                if (this.isInMisspelledWord(misspelledWord, n2)) {
                    bl = true;
                } else if (!this.isInMisspelledWord(n2) && (misspelledWord2 = this.findMisspelledWord(n2 + 1)) != null) {
                    bl = true;
                    try {
                        misspelledWord2.setOffset(n2);
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println("Can't happen!: " + badLocationException);
                    }
                }
            } else if (c3 != '\u0000') {
                char c5;
                n3 = misspelledWord;
                bl = true;
                boolean bl2 = false;
                try {
                    c5 = this.component.getText(n2 + 1, 1).charAt(0);
                }
                catch (BadLocationException badLocationException) {}
                if (this.isWordChar(c5)) {
                    n2 = this.getWordAt(n2 + 1, stringBuffer);
                    this.checkWord(stringBuffer.toString(), n2);
                }
            }
            if (bl) {
                int n4 = this.getWordAt(n3, stringBuffer);
                this.checkWord(stringBuffer.toString(), n4);
            }
        } else {
            this.onInsertText(n2, c2);
        }
        this.busy = false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isInMisspelledWord(Point pt) {
        void var1_1;
        TextUI textUI = this.component.getUI();
        int n2 = textUI.viewToModel(this.component, (Point)var1_1);
        return this.isInMisspelledWord(n2);
    }

    public void recheckAll() {
        Object object;
        try {
            object = this.component.getDocument().getText(0, this.component.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen: " + badLocationException);
            return;
        }
        object = new StringWordParser((String)object, !this.sentry.getOption(4096));
        while (((StringWordParser)object).hasMoreElements()) {
            this.checkWord(((StringWordParser)object).getWord(), ((StringWordParser)object).getCursor());
            ((StringWordParser)object).nextWord();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeMisspelledWord(int offset) {
        boolean bl = false;
        Enumeration<MisspelledWord> enumeration = this.misspelledWords.elements();
        while (enumeration.hasMoreElements()) {
            MisspelledWord misspelledWord = enumeration.nextElement();
            int n2 = misspelledWord.getOffset();
            int n3 = misspelledWord.getLen();
            if (offset < n2 || offset >= n2 + n3) continue;
            misspelledWord.hide();
            this.misspelledWords.removeElement(misspelledWord);
            bl = true;
            break;
        }
        if (this.debug && !bl) {
            void var1_1;
            System.out.println("removeMisspelledWords: word at " + (int)var1_1 + " not found");
        }
        if (this.debug) {
            this.a("remove");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeUpdate(DocumentEvent ev) {
        void var1_1;
        if (this.busy) {
            return;
        }
        this.busy = true;
        ev.getLength();
        int n2 = var1_1.getOffset();
        int n3 = 0;
        int n4 = n2;
        if (this.isInMisspelledWord(n2)) {
            n3 = 1;
        }
        if (n2 > 0 && this.isInMisspelledWord(n2 - 1)) {
            n4 = n2 - 1;
            n3 = 1;
        }
        if (n3 != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n3 = this.getWordAt(n4, stringBuffer);
            this.checkWord(stringBuffer.toString(), n3);
        }
        this.busy = false;
    }

    public void resume() {
        this.component.getDocument().addDocumentListener(this);
        this.component.addCaretListener(this);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserDictionary(EditableLexicon lex) {
        void var1_1;
        this.userDictionary = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setZigZagColor(Color c2) {
        if (this.highlightPainter instanceof ZigZagHighlightPainter) {
            void var1_1;
            ((ZigZagHighlightPainter)this.highlightPainter).setColor((Color)var1_1);
        }
    }

    public void stop() {
        this.component.getDocument().removeDocumentListener(this);
        this.component.removeCaretListener(this);
    }

    protected MisspelledWord findMisspelledWord(int start, int end) {
        Enumeration<MisspelledWord> enumeration = this.misspelledWords.elements();
        while (enumeration.hasMoreElements()) {
            MisspelledWord misspelledWord = enumeration.nextElement();
            int n2 = misspelledWord.getOffset();
            int n3 = misspelledWord.getLen();
            if (!(start >= n2 && start < n2 + n3 || end >= n2 && end < n2 + n3 || n2 >= start && n2 <= end) && (n2 + n3 - 1 < start || n2 + n3 - 1 > end)) continue;
            return misspelledWord;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected MisspelledWord findMisspelledWord(int offset) {
        void var1_1;
        return this.findMisspelledWord(offset, (int)var1_1);
    }

    protected int getWordAt(int offset, StringBuffer word) {
        int n2;
        int n3;
        int n4;
        String string;
        if (offset < 0 || offset >= this.component.getDocument().getLength()) {
            return -1;
        }
        int n5 = Math.max(0, offset - 100);
        int n6 = Math.min(this.component.getDocument().getLength() - n5, 200);
        try {
            string = this.component.getText(n5, n6);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen: " + badLocationException);
            return -1;
        }
        word.setLength(0);
        if (!this.isWordChar(string.charAt(n4 -= n5))) {
            return -1;
        }
        while (n4 >= 0 && this.isWordChar(string.charAt(n4))) {
            --n4;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        while (n4 < string.length() && !UniCharacter.isLetterOrDigit(string.charAt(n4))) {
            ++n4;
        }
        boolean bl = false;
        for (n3 = n4; n3 < string.length() && this.isWordChar(string.charAt(n3)); ++n3) {
            n2 = string.charAt(n3);
            word.append((char)n2);
            if (n2 != 46 || n3 <= 0 || !UniCharacter.isLetterOrDigit(string.charAt(n3 - 1)) || n3 >= string.length() - 1 || !UniCharacter.isLetterOrDigit(string.charAt(n3 + 1))) continue;
            bl = true;
        }
        n3 = 0;
        if (bl) {
            n2 = 0;
            n3 = 1;
            for (int i2 = 0; i2 < word.length(); ++i2) {
                if (UniCharacter.isLetterOrDigit(word.charAt(i2))) {
                    if (++n2 <= 2) continue;
                    n3 = 0;
                    break;
                }
                n2 = 0;
            }
        }
        n2 = 1;
        while (n2 != 0 && word.length() > 0) {
            char c2 = word.charAt(word.length() - 1);
            n2 = 0;
            if (UniCharacter.isApostrophe(c2) && word.length() > 1 && Character.toLowerCase(word.charAt(word.length() - 2)) != 's') {
                word.setLength(word.length() - 1);
                n2 = 1;
            }
            if (c2 != '.' || n3 != 0) continue;
            word.setLength(word.length() - 1);
            n2 = 1;
        }
        return n4 + n5;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isInMisspelledWord(int start, int end) {
        void var2_2;
        void var1_1;
        return this.findMisspelledWord((int)var1_1, (int)var2_2) != null;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isInMisspelledWord(int offset) {
        void var1_1;
        return this.isInMisspelledWord(offset, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isInWord(int x, int y) {
        void var2_4;
        void var1_1;
        TextUI textUI = this.component.getUI();
        Point point = new Point((int)var1_1, (int)var2_4);
        int n2 = textUI.viewToModel(this.component, point);
        String string = null;
        try {
            string = this.component.getText(n2, 1);
        }
        catch (BadLocationException badLocationException) {}
        return string != null && string.length() != 0 && this.isWordChar(string.charAt(0));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isWordChar(char c2) {
        void var1_1;
        return UniCharacter.isLetterOrDigit(c2) || UniCharacter.isApostrophe(c2) || var1_1 == 46;
    }

    protected void onInsertText(int offset, int nChars) {
        Object object;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BackgroundChecker backgroundChecker = this;
        if (backgroundChecker.a != null) {
            backgroundChecker.a.clear();
        }
        int n3 = this.getWordAt(offset, stringBuffer);
        int n4 = this.getWordAt(offset + nChars - 1, stringBuffer2);
        int n5 = offset;
        n2 = offset + n2;
        if (n3 >= 0) {
            n5 = n3;
        }
        if (n4 >= 0) {
            n2 = n4 + stringBuffer2.length();
        }
        if (n3 >= 0 && n4 >= 0 && n3 == n4) {
            this.checkWord(stringBuffer.toString(), n3);
            return;
        }
        try {
            object = this.component.getText(n5, n2 - n5);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen! " + badLocationException);
            return;
        }
        object = new StringWordParser((String)object, !this.sentry.getOption(4096));
        stringBuffer = new StringBuffer();
        while (true) {
            if (this.sentry.check((WordParser)object, stringBuffer) == 8) break;
            this.checkWord(((StringWordParser)object).getWord(), offset + ((StringWordParser)object).getCursor());
            ((StringWordParser)object).nextWord();
        }
    }

    protected void recheckAll(String word) {
        String string;
        try {
            string = this.component.getDocument().getText(0, this.component.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen: " + badLocationException);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(word);
        while (n2 >= 0) {
            int n3 = this.getWordAt(n2, stringBuffer);
            this.checkWord(stringBuffer.toString(), n3);
            n2 = string.indexOf(word, n2 + word.length());
        }
    }

    private void a(String object) {
        System.out.print((String)object + "(" + this.misspelledWords.size() + "): ");
        object = this.misspelledWords.elements();
        while (object.hasMoreElements()) {
            MisspelledWord misspelledWord = (MisspelledWord)object.nextElement();
            System.out.print("[" + misspelledWord.getOffset() + "," + misspelledWord.getLen() + "] ");
        }
        System.out.println();
    }

    final class c
    extends AbstractAction {
        private int a;
        private int b;
        private /* synthetic */ BackgroundChecker c;

        public c(BackgroundChecker backgroundChecker, String string, int n2, int n3) {
            this.c = backgroundChecker;
            super(string);
            this.b = n2;
            this.a = n3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void actionPerformed(ActionEvent e2) {
            this.c.removeMisspelledWord(this.b);
            Object object = null;
            if (this.c.component.getDocument() instanceof StyledDocument) {
                object = ((StyledDocument)this.c.component.getDocument()).getCharacterElement(this.b);
                object = object.getAttributes();
            }
            try {
                void var1_1;
                this.c.component.getDocument().remove(this.b, this.a);
                this.c.component.getDocument().insertString(this.b, var1_1.getActionCommand(), (AttributeSet)object);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    final class b
    extends AbstractAction {
        private String a;
        private /* synthetic */ BackgroundChecker b;

        public b(BackgroundChecker backgroundChecker, String string, String string2) {
            this.b = backgroundChecker;
            super(string);
            this.a = string2;
        }

        @Override
        public final void actionPerformed(ActionEvent e2) {
            try {
                this.b.sentry.getTempLexicon().addWord(this.a);
            }
            catch (Exception exception) {
                System.err.println("Can't add " + this.a + ": " + exception);
            }
            this.b.recheckAll(this.a);
        }
    }

    final class a
    extends AbstractAction {
        private String a;
        private /* synthetic */ BackgroundChecker b;

        public a(BackgroundChecker backgroundChecker, String string, String string2) {
            this.b = backgroundChecker;
            super(string);
            this.a = string2;
        }

        @Override
        public final void actionPerformed(ActionEvent e2) {
            if (this.b.userDictionary == null) {
                return;
            }
            try {
                EditableLexicon cfr_ignored_0 = this.b.userDictionary;
                this.b.userDictionary.addWord(this.a, 105, null);
            }
            catch (Exception exception) {
                System.err.println("Can't add " + this.a + ": " + exception);
            }
            this.b.recheckAll(this.a);
        }
    }

    protected class ZigZagHighlightPainter
    implements Highlighter.HighlightPainter {
        protected Color color;

        /*
         * WARNING - void declaration
         */
        public ZigZagHighlightPainter(BackgroundChecker this$0, Color c2) {
            void var2_2;
            this.color = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public ZigZagHighlightPainter(BackgroundChecker this$0) {
            this((BackgroundChecker)var1_1, Color.red);
            void var1_1;
        }

        public Color getColor() {
            return this.color;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void paint(Graphics g2, int start, int end, Shape bounds, JTextComponent component) {
            TextUI textUI = component.getUI();
            try {
                void var3_4;
                void var2_2;
                Rectangle rectangle = textUI.modelToView(component, (int)var2_2);
                Rectangle rectangle2 = textUI.modelToView(component, (int)var3_4);
                Rectangle rectangle3 = bounds.getBounds();
                int n2 = rectangle.x;
                int n3 = rectangle2.x;
                int n4 = rectangle.y;
                int n5 = rectangle2.y;
                int n6 = n4 + rectangle.height - 3;
                int n7 = n5 + rectangle2.height - 3;
                g2.setColor(this.color);
                if (n4 != n5) {
                    void var1_1;
                    this.zigzag(g2, n2, rectangle3.x + rectangle3.width - n2, n6);
                    for (n2 = n6 + 1 + rectangle.height; n2 < n5; n2 += rectangle.height) {
                        this.zigzag(g2, rectangle3.x, rectangle3.x + rectangle3.width, n2 - 1);
                    }
                    this.zigzag((Graphics)var1_1, rectangle3.x, n3, n7);
                    return;
                }
                this.zigzag(g2, n2, n3, n6);
            }
            catch (BadLocationException badLocationException) {}
        }

        /*
         * WARNING - void declaration
         */
        public void setColor(Color c2) {
            void var1_1;
            this.color = var1_1;
        }

        protected void zigzag(Graphics g2, int xStart, int xEnd, int y) {
            for (int i2 = xStart; i2 < xEnd; i2 += 2) {
                g2.drawLine(i2, y, Math.min(i2 + 3 - 1, xEnd), y + 3 - 1);
                g2.drawLine(i2 += 2, y + 3 - 1, Math.min(i2 + 3 - 1, xEnd), y);
            }
        }
    }

    public class MisspelledWord
    implements AnnotationMark {
        protected int len;
        protected Position pos;
        protected Object tag;
        private /* synthetic */ BackgroundChecker a;

        /*
         * WARNING - void declaration
         */
        public MisspelledWord(BackgroundChecker this$0, String word, int offset) throws BadLocationException {
            void var2_2;
            void var1_1;
            void var3_3;
            this.a = this$0;
            this.pos = this$0.component.getDocument().createPosition(offset);
            this.tag = this$0.component.getHighlighter().addHighlight(offset, (int)(var3_3 + word.length()), var1_1.highlightPainter);
            this.len = var2_2.length();
        }

        public int getLen() {
            return this.len;
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public String getWord() {
            String string = "";
            try {
                string = this.a.component.getText(this.pos.getOffset(), this.len);
            }
            catch (BadLocationException badLocationException) {
                BadLocationException badLocationException2 = badLocationException;
                badLocationException.printStackTrace();
            }
            return string;
        }

        public void hide() {
            this.a.component.getHighlighter().removeHighlight(this.tag);
            this.len = 0;
        }

        /*
         * WARNING - void declaration
         */
        public void setLen(int len) throws BadLocationException {
            void var1_1;
            this.len = len;
            int n2 = this.getOffset();
            this.a.component.getHighlighter().changeHighlight(this.tag, n2, n2 + var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setOffset(int offset) throws BadLocationException {
            void var1_1;
            this.pos = this.a.component.getDocument().createPosition((int)var1_1);
        }

        @Override
        public int getStartLine() {
            Document document = this.a.component.getDocument();
            if (document instanceof SmiDocument) {
                return ((SmiDocument)document).getLineOfOffset(this.pos.getOffset());
            }
            return 0;
        }

        @Override
        public int getEndLine() {
            return this.getStartLine();
        }

        @Override
        public AnnotationMark.MarkSeverity getSeverity() {
            return AnnotationMark.MarkSeverity.warning;
        }

        @Override
        public int getPriority() {
            return this.getSeverity().ordinal();
        }

        @Override
        public String getDescription() {
            return "Spelling: " + this.getWord();
        }

        @Override
        public int getPosition() {
            return this.pos.getOffset();
        }

        @Override
        public int getEndPosition() {
            return this.pos.getOffset() + this.getWord().length();
        }

        public String toString() {
            return this.pos.getOffset() + "=" + this.getWord();
        }
    }
}

