/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.util;

import java.util.LinkedList;

public class LimitedHistory<E>
extends LinkedList<E> {
    private int maxSize = 10;

    public LimitedHistory(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E e2) {
        int pos = this.indexOf(e2);
        if (pos >= 0) {
            this.remove(pos);
        }
        while (this.size() >= this.maxSize) {
            super.removeLast();
        }
        super.addFirst(e2);
        return true;
    }

    @Override
    public void add(int index, E element) {
        while (this.size() >= this.maxSize) {
            super.removeLast();
        }
        super.add(index, element);
    }
}

