/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.snmp4j.smi.OctetString;

public class OctetStringField
extends JComponent {
    private JTextField octetStringTextField;
    private JComboBox formatComboBox;
    private JLabel asciiRepresentation;
    private JPanel panel;
    private EditMode mode;
    private int minLength;
    private int maxLength;
    private boolean emptyAllowed;

    public OctetStringField() {
        this.$$$setupUI$$$();
        this.mode = EditMode.Text;
        this.minLength = -1;
        this.maxLength = -1;
        this.octetStringTextField.setDocument(new MyTextDocument());
        this.setMode(EditMode.Text);
        this.formatComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    OctetStringField.this.setMode(EditMode.valueOf((String)e2.getItem()));
                }
            }
        });
        this.add(this.panel);
    }

    public JTextField getOctetStringTextField() {
        return this.octetStringTextField;
    }

    public void setMode(EditMode mode) {
        if (mode != null) {
            this.formatComboBox.setSelectedIndex(mode.ordinal());
            OctetString octetString = this.getOctetString();
            this.mode = mode;
            this.setOctetString(octetString);
        } else {
            this.mode = EditMode.Text;
        }
    }

    @Override
    public void setInputVerifier(InputVerifier inputVerifier) {
        this.octetStringTextField.setInputVerifier(new OctetStringInputVerifier(inputVerifier));
    }

    @Override
    public InputVerifier getInputVerifier() {
        return ((OctetStringInputVerifier)this.octetStringTextField.getInputVerifier()).proxy;
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.octetStringTextField.setEnabled(enabled);
        this.formatComboBox.setEnabled(enabled);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public EditMode getMode() {
        return this.mode;
    }

    public void setOctetString(OctetString octetString) {
        if (octetString == null) {
            this.octetStringTextField.setText(null);
        } else if (this.mode == EditMode.Text) {
            if (!octetString.isPrintable()) {
                this.mode = EditMode.Hex;
                this.formatComboBox.setSelectedIndex(this.mode.ordinal());
                this.octetStringTextField.setText(octetString.toString(this.mode.separator, this.mode.radix));
            } else {
                this.octetStringTextField.setText(new String(octetString.getValue()));
            }
        } else {
            this.octetStringTextField.setText(octetString.toString(this.mode.separator, this.mode.radix));
        }
    }

    public OctetString getOctetString() {
        String currentValue = this.octetStringTextField.getText();
        if (currentValue != null) {
            return this.mode == EditMode.Text ? new OctetString(currentValue) : OctetString.fromString(currentValue, this.mode.separator, this.mode.radix);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.octetStringTextField = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.formatComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Text");
        defaultComboBoxModel.addElement("Hex");
        defaultComboBoxModel.addElement("Octal");
        defaultComboBoxModel.addElement("Binary");
        defaultComboBoxModel.addElement("Decimal");
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setToolTipText("Select the text format for the input field on the left");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        jPanel.add(jComboBox, gridBagConstraints2);
        this.asciiRepresentation = jLabel = new JLabel();
        jLabel.setText("");
        jLabel.setToolTipText("Displays the ASCII representation of the field content below");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    public class OctetStringInputVerifier
    extends InputVerifier {
        private InputVerifier proxy;

        protected OctetStringInputVerifier(InputVerifier proxy) {
            this.proxy = proxy;
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            try {
                OctetString os = OctetStringField.this.getOctetString();
                if (!(!OctetStringField.this.emptyAllowed && OctetStringField.this.minLength > 0 || os != null && os.length() != 0)) {
                    ok = true;
                } else {
                    if (OctetStringField.this.minLength >= 0 && os.length() < OctetStringField.this.minLength) {
                        ok = false;
                    }
                    if (OctetStringField.this.maxLength >= 0 && os.length() > OctetStringField.this.maxLength) {
                        ok = false;
                    }
                }
            }
            catch (Exception ex) {
                ok = false;
            }
            if (ok && this.proxy != null) {
                ok = this.proxy.verify(input);
            }
            input.setBackground(ok ? Color.white : Color.pink);
            return ok;
        }
    }

    protected class MyTextDocument
    extends PlainDocument {
        protected MyTextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j2 = 0;
            if (source.length == 0) {
                return;
            }
            if (OctetStringField.this.mode.allowedCharacters.length() > 0) {
                for (int i2 = 0; i2 < result.length; ++i2) {
                    boolean ok;
                    boolean bl = ok = !Character.isISOControl(source[i2]) && OctetStringField.this.mode.allowedCharacters.indexOf(source[i2]) >= 0;
                    if (!ok) continue;
                    result[j2++] = source[i2];
                }
                super.insertString(offs, new String(result, 0, j2), a2);
            } else {
                super.insertString(offs, new String(source), a2);
            }
        }
    }

    public static enum EditMode {
        Text("", 0, ' '),
        Hex("abcdefABCDEF0123456789:", 16, ':'),
        Octal("01234567:", 8, ':'),
        Binary("01:", 2, ':'),
        Decimal("01234567890.", 10, '.');

        private String allowedCharacters;
        private int radix;
        private char separator;

        private EditMode(String allowedCharacters, int radix, char separator) {
            this.allowedCharacters = allowedCharacters;
            this.radix = radix;
            this.separator = separator;
        }
    }
}

