/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.commons.ui.InstantSearchListener;
import com.agentpp.commons.ui.ListSelectionPanel;
import com.agentpp.commons.util.LimitedHistory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;

public class InstantSearchPanel {
    private JPanel panel;
    private JButton buttonHistory;
    private JTextField textFieldSearch;
    private JButton buttonClear;
    private JButton buttonUp;
    private JButton buttonDown;
    private JPanel searchTextPanel;
    private JCheckBox checkBoxCaseSensitive;
    private InstantSearchListener searchListener;
    private ThreadPoolExecutor searcher;
    private BlockingQueue<Runnable> searchQueue;
    private Color textFieldBackground;
    private LimitedHistory<String> searchHistory;
    private Popup searchHistoryPopup;

    public InstantSearchPanel(final InstantSearchListener searchListener, int searchHistoryLimit) {
        this.$$$setupUI$$$();
        this.searchHistory = new LimitedHistory(searchHistoryLimit);
        this.textFieldBackground = this.textFieldSearch.getBackground();
        this.searchListener = searchListener;
        this.searchQueue = new LinkedBlockingQueue<Runnable>();
        this.searcher = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, this.searchQueue);
        this.textFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                final String searchString = InstantSearchPanel.this.textFieldSearch.getText();
                if (searchString != null && searchString.trim().length() > 0) {
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            if (searchListener.search(searchString, InstantSearchListener.Direction.down, InstantSearchPanel.this.checkBoxCaseSensitive.isSelected())) {
                                InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
                            } else {
                                InstantSearchPanel.this.textFieldSearch.setBackground(Color.pink);
                            }
                        }
                    };
                    InstantSearchPanel.this.searchQueue.clear();
                    InstantSearchPanel.this.searcher.execute(task);
                }
            }
        });
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String searchString = InstantSearchPanel.this.textFieldSearch.getText();
                InstantSearchPanel.this.searchHistory.add(searchString);
                if (searchListener.searchAgain(searchString, InstantSearchListener.Direction.down, InstantSearchPanel.this.checkBoxCaseSensitive.isSelected())) {
                    InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
                } else {
                    InstantSearchPanel.this.textFieldSearch.setBackground(Color.pink);
                }
            }
        });
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String searchString = InstantSearchPanel.this.textFieldSearch.getText();
                InstantSearchPanel.this.searchHistory.add(searchString);
                if (searchListener.searchAgain(searchString, InstantSearchListener.Direction.up, InstantSearchPanel.this.checkBoxCaseSensitive.isSelected())) {
                    InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
                } else {
                    InstantSearchPanel.this.textFieldSearch.setBackground(Color.pink);
                }
            }
        });
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                InstantSearchPanel.this.textFieldSearch.setText("");
                InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
            }
        });
        this.checkBoxCaseSensitive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        });
        this.buttonHistory.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (InstantSearchPanel.this.searchHistoryPopup != null) {
                    InstantSearchPanel.this.searchHistoryPopup.hide();
                    InstantSearchPanel.this.searchHistoryPopup = null;
                    return;
                }
                Point popupLocation = InstantSearchPanel.this.buttonHistory.getPopupLocation(e2);
                if (popupLocation == null) {
                    popupLocation = e2.getLocationOnScreen();
                }
                final ListSelectionPanel listSelectionPanel = new ListSelectionPanel();
                listSelectionPanel.setListData(InstantSearchPanel.this.searchHistory);
                InstantSearchPanel.this.searchHistoryPopup = PopupFactory.getSharedInstance().getPopup(InstantSearchPanel.this.panel, listSelectionPanel.getPanel(), popupLocation.x, popupLocation.y);
                listSelectionPanel.setListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e2) {
                        if (!e2.getValueIsAdjusting()) {
                            Popup popup = InstantSearchPanel.this.searchHistoryPopup;
                            if (popup != null) {
                                popup.hide();
                            }
                            InstantSearchPanel.this.textFieldSearch.setText(listSelectionPanel.getSelectedItem());
                        }
                    }
                });
                listSelectionPanel.getPanel().setFocusable(true);
                listSelectionPanel.setKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e2) {
                        Popup popup;
                        if (e2.getKeyCode() == 27 && (popup = InstantSearchPanel.this.searchHistoryPopup) != null) {
                            popup.hide();
                        }
                    }
                });
                InstantSearchPanel.this.textFieldSearch.setCaret(new DefaultCaret());
                InstantSearchPanel.this.searchHistoryPopup.show();
            }
        });
    }

    public void setSearchHistory(List<String> searchHistory) {
        this.searchHistory.addAll(searchHistory);
    }

    public List<String> getSearchHistory() {
        return this.searchHistory;
    }

    public void setText(String text) {
        this.textFieldSearch.setText(text);
    }

    public String getText() {
        return this.textFieldSearch.getText();
    }

    public void setMatchCase(boolean matchCase) {
        this.checkBoxCaseSensitive.setSelected(matchCase);
    }

    public boolean isMatchCase() {
        return this.checkBoxCaseSensitive.isSelected();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JTextField jTextField;
        JButton jButton4;
        JPanel jPanel;
        JPanel jPanel2;
        this.panel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.searchTextPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ((Component)jPanel).setBackground(UIManager.getColor("Button.background"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.buttonHistory = jButton4 = new JButton();
        jButton4.setBorderPainted(false);
        jButton4.setContentAreaFilled(false);
        jButton4.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/FindAgain16.gif")));
        jButton4.setText("");
        jButton4.setToolTipText("Search History");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        jPanel.add((Component)jButton4, gridBagConstraints2);
        this.textFieldSearch = jTextField = new JTextField();
        jTextField.setColumns(12);
        jTextField.setDropMode(DropMode.INSERT);
        jTextField.setFocusAccelerator('F');
        jTextField.setInheritsPopupMenu(false);
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jTextField.setMinimumSize(new Dimension(100, 20));
        jTextField.setOpaque(true);
        jTextField.setToolTipText("Enter search string");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        jPanel.add((Component)jTextField, gridBagConstraints3);
        this.buttonClear = jButton3 = new JButton();
        jButton3.setBorderPainted(false);
        jButton3.setContentAreaFilled(false);
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop16.gif")));
        jButton3.setText("");
        jButton3.setToolTipText("Clear Search Text");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.fill = 2;
        jPanel.add((Component)jButton3, gridBagConstraints4);
        this.buttonUp = jButton2 = new JButton();
        jButton2.setBorderPainted(false);
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif")));
        jButton2.setMargin(new Insets(2, 2, 2, 2));
        jButton2.setText("");
        jButton2.setToolTipText("Next Occurrence");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.fill = 2;
        jPanel2.add((Component)jButton2, gridBagConstraints5);
        this.buttonDown = jButton = new JButton();
        jButton.setBorderPainted(false);
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif")));
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setText("");
        jButton.setToolTipText("Previous Occurrence");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.fill = 2;
        jPanel2.add((Component)jButton, gridBagConstraints6);
        this.checkBoxCaseSensitive = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("MatchCase");
        jCheckBox.setLabel("Match Case");
        jCheckBox.setText("Match Case");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 3;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        jPanel2.add((Component)jCheckBox, gridBagConstraints7);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

