/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.commons.ui.InstantSearchPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class InstantSearchAction
extends AbstractAction
implements ActionListener {
    private InstantSearchPanel instantSearchPanel;
    protected JTextComponent comp = null;
    protected boolean matchCase = true;

    public InstantSearchAction(InstantSearchPanel instantSearchPanel, boolean matchCase) {
        super("popup-search-action-" + (matchCase ? "match" : "ignore") + "-case");
        this.matchCase = matchCase;
        this.instantSearchPanel = instantSearchPanel;
        int modifiers = 2;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, modifiers));
    }

    public InstantSearchPanel getInstantSearchPanel() {
        return this.instantSearchPanel;
    }

    public static void installActions(JComponent comp, Action[] actions, int condition) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(condition);
        for (Action action : actions) {
            String name = (String)action.getValue("Name");
            actionMap.put(name, action);
            inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), name);
        }
    }

    public static void installActions(JTextComponent comp, Action[] actions) {
        InstantSearchAction.installActions(comp, actions, 0);
    }

    public void setComponent(JTextComponent component) {
        this.comp = component;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String text = this.comp.getSelectedText();
        this.instantSearchPanel.setText(text);
        this.instantSearchPanel.getPanel().requestFocus();
    }
}

