/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.snmp.UserProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUserEditorPanel {
    private JLabel userNameLabel;
    private JTextField userProfileName;
    private JLabel securityNameLabel;
    private OctetStringField securityName;
    private JLabel authProtocolLabel;
    private JComboBox authProtocol;
    private JLabel authPassphraseLabel;
    private OctetStringField authPassphrase;
    private JLabel privProtocolLabel;
    private OctetStringField privPassphrase;
    private JLabel privPassphraseLabel;
    private JComboBox privProtocol;
    private JPanel panel;
    private JLabel principalLabel;
    private JCheckBox principal;
    private JLabel localizationEngineIdLabel;
    private OctetStringField localizationEngineId;
    private UserProfile userProfile;
    private UIObjectUpdateListener<UserProfile> updateListener;
    private UpdateInputVerifier updateInputVerifier = new UpdateInputVerifier();
    private volatile boolean updating;

    public UsmUserEditorPanel() {
        this.$$$setupUI$$$();
        this.userProfileName.setInputVerifier(this.updateInputVerifier);
        this.securityName.setInputVerifier(this.updateInputVerifier);
        this.authProtocol.setInputVerifier(this.updateInputVerifier);
        this.authPassphrase.setInputVerifier(this.updateInputVerifier);
        this.privProtocol.setInputVerifier(this.updateInputVerifier);
        this.privPassphrase.setInputVerifier(this.updateInputVerifier);
        this.localizationEngineId.setInputVerifier(this.updateInputVerifier);
        this.principal.setInputVerifier(this.updateInputVerifier);
        this.localizationEngineId.setMinLength(5);
        this.localizationEngineId.setMaxLength(32);
        this.localizationEngineId.setEmptyAllowed(true);
        this.authPassphrase.setEmptyAllowed(true);
        this.privPassphrase.setEmptyAllowed(true);
        this.securityName.setMinLength(1);
        this.securityName.setMaxLength(32);
        this.localizationEngineId.setMode(OctetStringField.EditMode.Hex);
        this.setEnabled(false);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.updating = true;
        if (userProfile != null) {
            this.userProfileName.setText(userProfile.getName());
            this.securityName.setOctetString(userProfile.getUser().getSecurityName());
            this.authProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(userProfile.getUser().getAuthenticationProtocol()));
            this.authPassphrase.setOctetString(userProfile.getUser().getAuthenticationPassphrase());
            this.privProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(userProfile.getUser().getPrivacyProtocol()));
            this.privPassphrase.setOctetString(userProfile.getUser().getPrivacyPassphrase());
            this.localizationEngineId.setOctetString(userProfile.getUser().getLocalizationEngineID());
            this.principal.setSelected(userProfile.isPrincipal());
            this.setEnabled(true);
        } else {
            this.userProfileName.setText("");
            this.securityName.setOctetString(new OctetString());
            this.authProtocol.setSelectedItem(null);
            this.authPassphrase.setOctetString(new OctetString());
            this.privProtocol.setSelectedItem(null);
            this.privPassphrase.setOctetString(new OctetString());
            this.localizationEngineId.setOctetString(new OctetString());
            this.principal.setSelected(false);
            this.setEnabled(false);
        }
        this.userProfile = userProfile;
        this.updating = false;
    }

    public UserProfile getUserProfile() {
        if (this.userProfile == null) {
            return null;
        }
        UserProfile userProfile = new UserProfile("", null);
        this.updateUserProfile(userProfile);
        return userProfile;
    }

    public void updateUserProfile() {
        this.updateUserProfile(this.userProfile);
    }

    private void updateUserProfile(UserProfile userProfile) {
        if (userProfile == null) {
            return;
        }
        userProfile.setName(this.userProfileName.getText());
        userProfile.setUser(new UsmUser(this.securityName.getOctetString(), UsmUserEditorPanel.getSecurityProtocol(this.authProtocol.getSelectedItem().toString()), this.nonEmpty(this.authPassphrase.getOctetString()), UsmUserEditorPanel.getSecurityProtocol(this.privProtocol.getSelectedItem().toString()), this.nonEmpty(this.privPassphrase.getOctetString()), this.nonEmpty(this.localizationEngineId.getOctetString())));
        userProfile.setPrincipal(this.principal.isSelected());
    }

    public UIObjectUpdateListener<UserProfile> getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(UIObjectUpdateListener<UserProfile> updateListener) {
        this.updateListener = updateListener;
    }

    private OctetString nonEmpty(OctetString octetString) {
        if (octetString == null || octetString.length() == 0) {
            return null;
        }
        return octetString;
    }

    public void setEnabled(boolean enabled) {
        this.userProfileName.setEnabled(enabled);
        this.securityName.setEnabled(enabled);
        this.authProtocol.setEnabled(enabled);
        this.authPassphrase.setEnabled(enabled);
        this.privProtocol.setEnabled(enabled);
        this.privPassphrase.setEnabled(enabled);
        this.localizationEngineId.setEnabled(enabled);
        this.principal.setEnabled(enabled);
    }

    public static String getSecurityProtocolName(OID secProtocolID) {
        if (secProtocolID == null) {
            return "";
        }
        if (AuthMD5.ID.equals(secProtocolID)) {
            return "MD5";
        }
        if (AuthSHA.ID.equals(secProtocolID)) {
            return "SHA-1";
        }
        if (AuthHMAC128SHA224.ID.equals(secProtocolID)) {
            return "SHA224";
        }
        if (AuthHMAC192SHA256.ID.equals(secProtocolID)) {
            return "SHA256";
        }
        if (AuthHMAC256SHA384.ID.equals(secProtocolID)) {
            return "SHA384";
        }
        if (AuthHMAC384SHA512.ID.equals(secProtocolID)) {
            return "SHA512";
        }
        if (PrivDES.ID.equals(secProtocolID)) {
            return "DES";
        }
        if (Priv3DES.ID.equals(secProtocolID)) {
            return "3DES";
        }
        if (PrivAES128.ID.equals(secProtocolID)) {
            return "AES128";
        }
        if (PrivAES192.ID.equals(secProtocolID)) {
            return "AES192";
        }
        if (PrivAES256.ID.equals(secProtocolID)) {
            return "AES256";
        }
        if (PrivAES192With3DESKeyExtension.ID.equals(secProtocolID)) {
            return "AES192-KeyExt3DES";
        }
        if (PrivAES256With3DESKeyExtension.ID.equals(secProtocolID)) {
            return "AES256-KeyExt3DES";
        }
        return null;
    }

    public static OID getSecurityProtocol(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.equals("MD5")) {
            return AuthMD5.ID;
        }
        if (name.equals("SHA") || name.equals("SHA-1")) {
            return AuthSHA.ID;
        }
        if (name.equals("SHA224")) {
            return AuthHMAC128SHA224.ID;
        }
        if (name.equals("SHA256")) {
            return AuthHMAC192SHA256.ID;
        }
        if (name.equals("SHA384")) {
            return AuthHMAC256SHA384.ID;
        }
        if (name.equals("SHA512")) {
            return AuthHMAC384SHA512.ID;
        }
        if (name.equals("DES")) {
            return PrivDES.ID;
        }
        if (name.equals("3DES")) {
            return Priv3DES.ID;
        }
        if (name.equals("AES128")) {
            return PrivAES128.ID;
        }
        if (name.equals("AES192")) {
            return PrivAES192.ID;
        }
        if (name.equals("AES256")) {
            return PrivAES256.ID;
        }
        if (name.equals("AES192-KeyExt3DES")) {
            return PrivAES192With3DESKeyExtension.ID;
        }
        if (name.equals("AES256-KeyExt3DES")) {
            return PrivAES256With3DESKeyExtension.ID;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        OctetStringField octetStringField;
        JLabel jLabel;
        OctetStringField octetStringField2;
        JLabel jLabel2;
        OctetStringField octetStringField3;
        JLabel jLabel3;
        JCheckBox jCheckBox;
        JLabel jLabel4;
        JComboBox jComboBox;
        JLabel jLabel5;
        JComboBox jComboBox2;
        JLabel jLabel6;
        OctetStringField octetStringField4;
        JLabel jLabel7;
        JTextField jTextField;
        JLabel jLabel8;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.userNameLabel = jLabel8 = new JLabel();
        jLabel8.setText("User Profile Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel8, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        JPanel jPanel3 = new JPanel();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.fill = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints3);
        this.userProfileName = jTextField = new JTextField();
        jTextField.setToolTipText("The unique name of the user profile");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridwidth = 3;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jTextField, gridBagConstraints4);
        this.securityNameLabel = jLabel7 = new JLabel();
        jLabel7.setText("Security Name:");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel7, gridBagConstraints5);
        this.securityName = octetStringField4 = new OctetStringField();
        JComponent jComponent = octetStringField4.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.gridwidth = 3;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent, gridBagConstraints6);
        this.authProtocolLabel = jLabel6 = new JLabel();
        jLabel6.setText("Authentication Protocol:");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel6, gridBagConstraints7);
        this.authProtocol = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("");
        defaultComboBoxModel.addElement("MD5");
        defaultComboBoxModel.addElement("SHA-1");
        defaultComboBoxModel.addElement("SHA224");
        defaultComboBoxModel.addElement("SHA256");
        defaultComboBoxModel.addElement("SHA384");
        defaultComboBoxModel.addElement("SHA512");
        jComboBox2.setModel(defaultComboBoxModel);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 2;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(10, 10, 10, 10);
        jPanel.add(jComboBox2, gridBagConstraints8);
        this.privProtocolLabel = jLabel5 = new JLabel();
        jLabel5.setText("Privacy Protocol:");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 3;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel5, gridBagConstraints9);
        this.privProtocol = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("");
        defaultComboBoxModel2.addElement("DES");
        defaultComboBoxModel2.addElement("3DES");
        defaultComboBoxModel2.addElement("AES128");
        defaultComboBoxModel2.addElement("AES192");
        defaultComboBoxModel2.addElement("AES256");
        defaultComboBoxModel2.addElement("AES192-KeyExt3DES");
        defaultComboBoxModel2.addElement("AES256-KeyExt3DES");
        jComboBox.setModel(defaultComboBoxModel2);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 2;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.insets = new Insets(10, 10, 10, 10);
        jPanel.add(jComboBox, gridBagConstraints10);
        this.principalLabel = jLabel4 = new JLabel();
        jLabel4.setText("Principal:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 4;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel4, gridBagConstraints11);
        this.principal = jCheckBox = new JCheckBox();
        jCheckBox.setText("Check to receive traps with this user profile");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 2;
        gridBagConstraints12.gridy = 4;
        gridBagConstraints12.gridwidth = 3;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jCheckBox, gridBagConstraints12);
        this.localizationEngineIdLabel = jLabel3 = new JLabel();
        jLabel3.setText("Localization Engine ID:");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 5;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel3, gridBagConstraints13);
        this.localizationEngineId = octetStringField3 = new OctetStringField();
        JComponent jComponent2 = octetStringField3.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 2;
        gridBagConstraints14.gridy = 5;
        gridBagConstraints14.gridwidth = 3;
        gridBagConstraints14.weightx = 1.0;
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent2, gridBagConstraints14);
        this.privPassphraseLabel = jLabel2 = new JLabel();
        jLabel2.setText("Privacy Passphrase:");
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 3;
        gridBagConstraints15.gridy = 3;
        gridBagConstraints15.anchor = 17;
        gridBagConstraints15.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints15);
        this.privPassphrase = octetStringField2 = new OctetStringField();
        JComponent jComponent3 = octetStringField2.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 4;
        gridBagConstraints16.gridy = 3;
        gridBagConstraints16.weightx = 1.0;
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent3, gridBagConstraints16);
        this.authPassphraseLabel = jLabel = new JLabel();
        jLabel.setText("Authentication Passphrase:");
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 3;
        gridBagConstraints17.gridy = 2;
        gridBagConstraints17.anchor = 17;
        gridBagConstraints17.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, gridBagConstraints17);
        this.authPassphrase = octetStringField = new OctetStringField();
        JComponent jComponent4 = octetStringField.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 4;
        gridBagConstraints18.gridy = 2;
        gridBagConstraints18.weightx = 1.0;
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent4, gridBagConstraints18);
        jLabel8.setLabelFor(jTextField);
        jLabel7.setLabelFor(octetStringField4);
        jLabel6.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jComboBox);
        jLabel2.setLabelFor(octetStringField2);
        jLabel.setLabelFor(octetStringField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class UpdateInputVerifier
    extends InputVerifier {
        private UpdateInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            if (!UsmUserEditorPanel.this.updating && UsmUserEditorPanel.this.userProfile != null && UsmUserEditorPanel.this.updateListener != null) {
                try {
                    UserProfile userProfile = UsmUserEditorPanel.this.getUserProfile();
                    if (userProfile == null || !UsmUserEditorPanel.this.updateListener.uiObjectVerification(UsmUserEditorPanel.this, userProfile, UsmUserEditorPanel.this.userProfile)) {
                        ok = false;
                    } else {
                        UsmUserEditorPanel.this.updateUserProfile();
                        UsmUserEditorPanel.this.updateListener.uiObjectUpdated(UsmUserEditorPanel.this, UsmUserEditorPanel.this.userProfile);
                    }
                }
                catch (IllegalArgumentException iax) {
                    ok = false;
                }
            }
            if (ok) {
                if (input.getBackground() == Color.pink) {
                    input.setBackground(Color.white);
                }
            } else if (input.getBackground() == Color.white) {
                input.setBackground(Color.pink);
            }
            return ok;
        }
    }
}

