/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.UserProfile;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.snmp4j.smi.OctetString;

public class TargetEditorPanel {
    private JLabel targetNameLabel;
    private JTextField targetNameField;
    private JLabel transportLabel;
    private JComboBox<String> transportComboBox;
    private JButton addressLabel;
    private JTextField addressTextField;
    private JLabel versionLabel;
    private JComboBox versionComboBox;
    private JLabel timeoutLabel;
    private JLabel retriesLabel;
    private JLabel mibSetLabel;
    private JComboBox<String> mibSetComboBox;
    private JPanel versionSpecificFieldPanel;
    private JPanel communityBasedPanel;
    private JLabel communityLabel;
    private JPanel userBasedPanel;
    private JLabel userLabel;
    private JComboBox<String> userComboBox;
    private JLabel contextNameLabel;
    private JLabel contextEngineIdLabel;
    private OctetStringField contextEngineID;
    private OctetStringField contextName;
    private JButton securityEngineIdLabel;
    private OctetStringField securityEngineID;
    private JSpinner timeout;
    private JSpinner retries;
    private OctetStringField community;
    private JPanel panel;
    private GenTarget target;
    private Map<String, UserProfile> userList = new HashMap<String, UserProfile>();
    private UIObjectUpdateListener<GenTarget> updateListener;
    private UpdateInputVerifier updateInputVerifier = new UpdateInputVerifier();
    private volatile boolean updating;

    public TargetEditorPanel() {
        this.$$$setupUI$$$();
        this.contextEngineID.setMode(OctetStringField.EditMode.Hex);
        this.securityEngineID.setMode(OctetStringField.EditMode.Hex);
        this.timeout.setModel(new SpinnerNumberModel((Number)5000, Integer.valueOf(1), null, (Number)1000));
        this.retries.setModel(new SpinnerNumberModel(1, 0, 100000, 1));
        this.targetNameField.setInputVerifier(this.updateInputVerifier);
        this.contextEngineID.setInputVerifier(this.updateInputVerifier);
        this.securityEngineID.setInputVerifier(this.updateInputVerifier);
        this.contextName.setInputVerifier(this.updateInputVerifier);
        this.community.setInputVerifier(this.updateInputVerifier);
        this.mibSetComboBox.setInputVerifier(this.updateInputVerifier);
        this.timeout.setInputVerifier(this.updateInputVerifier);
        this.retries.setInputVerifier(this.updateInputVerifier);
        this.addressTextField.setInputVerifier(this.updateInputVerifier);
        this.versionComboBox.setInputVerifier(this.updateInputVerifier);
        this.transportComboBox.setInputVerifier(this.updateInputVerifier);
        this.contextEngineID.setMinLength(5);
        this.contextEngineID.setMaxLength(32);
        this.contextEngineID.setEmptyAllowed(true);
        this.securityEngineID.setMinLength(5);
        this.securityEngineID.setMaxLength(32);
        this.securityEngineID.setEmptyAllowed(true);
        this.contextEngineID.setMode(OctetStringField.EditMode.Hex);
        this.securityEngineID.setMode(OctetStringField.EditMode.Hex);
        this.setEnabled(false);
        this.versionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    if (TargetEditorPanel.getSnmpVersionFromIndex(TargetEditorPanel.this.versionComboBox.getSelectedIndex()) == 3) {
                        TargetEditorPanel.this.showUserBased();
                    } else {
                        TargetEditorPanel.this.showCommunityBased();
                    }
                }
                TargetEditorPanel.this.updateInputVerifier.verify(TargetEditorPanel.this.versionComboBox);
            }
        });
        this.userComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    TargetEditorPanel.this.updateInputVerifier.verify(TargetEditorPanel.this.userComboBox);
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.targetNameField.setEnabled(enabled);
        this.contextEngineID.setEnabled(enabled);
        this.securityEngineID.setEnabled(enabled);
        this.contextName.setEnabled(enabled);
        this.community.setEnabled(enabled);
        this.mibSetComboBox.setEnabled(enabled);
        this.timeout.setEnabled(enabled);
        this.retries.setEnabled(enabled);
        this.addressTextField.setEnabled(enabled);
        this.versionComboBox.setEnabled(enabled);
        this.transportComboBox.setEnabled(enabled);
        this.userComboBox.setEnabled(enabled);
        this.addressLabel.setEnabled(enabled);
        this.securityEngineIdLabel.setEnabled(enabled);
    }

    public void setUserList(Collection<UserProfile> userList) {
        this.userComboBox.removeAllItems();
        this.userComboBox.addItem(null);
        this.userList.clear();
        for (UserProfile userProfile : userList) {
            this.userList.put(userProfile.getName(), userProfile);
        }
        ArrayList<String> sortedUserList = new ArrayList<String>(this.userList.keySet());
        Collections.sort(sortedUserList);
        for (String userName : sortedUserList) {
            this.userComboBox.addItem(userName);
        }
    }

    public void addActionListener(ActionListener l2) {
        this.securityEngineIdLabel.addActionListener(l2);
        this.addressLabel.addActionListener(l2);
    }

    public void setMibSetList(Collection<String> mibSetList) {
        this.mibSetComboBox.removeAllItems();
        for (String mibSet : mibSetList) {
            this.mibSetComboBox.addItem(mibSet);
        }
    }

    public void setTransportList(Collection<String> transportList) {
        this.transportComboBox.removeAllItems();
        for (String transportID : transportList) {
            this.transportComboBox.addItem(transportID);
        }
    }

    public void setTarget(GenTarget target) {
        this.updateFields(target);
        if (target == null || target.getVersion() == 3) {
            this.showUserBased();
        } else {
            this.showCommunityBased();
        }
        this.targetNameField.setBackground(Color.white);
        this.setEnabled(target != null);
    }

    private void showCommunityBased() {
        ((CardLayout)this.versionSpecificFieldPanel.getLayout()).show(this.versionSpecificFieldPanel, "Community Based");
    }

    private void showUserBased() {
        ((CardLayout)this.versionSpecificFieldPanel.getLayout()).show(this.versionSpecificFieldPanel, "User Based");
    }

    public UIObjectUpdateListener<GenTarget> getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(UIObjectUpdateListener<GenTarget> updateListener) {
        this.updateListener = updateListener;
    }

    public GenTarget getTarget() {
        if (this.target == null) {
            return null;
        }
        GenTarget target = new GenTarget(this.target);
        this.updateTarget(target);
        return target;
    }

    public GenTarget updateTarget() {
        this.updateTarget(this.target);
        return this.target;
    }

    private void updateTarget(GenTarget target) {
        target.setName(this.targetNameField.getText());
        target.setAddressString(this.addressTextField.getText());
        target.setAddressType((String)this.transportComboBox.getSelectedItem());
        target.setCommunity(this.community.getOctetString());
        target.setContext(this.contextName.getOctetString());
        target.setEngineID(this.securityEngineID.getOctetString());
        target.setMIBSet((String)this.mibSetComboBox.getSelectedItem());
        target.setContextEngineID(this.contextEngineID.getOctetString());
        target.setRetries((Integer)this.retries.getValue());
        target.setTimeout((Integer)this.timeout.getValue());
        target.setUser(this.userComboBox.getSelectedItem() == null ? null : this.userList.get((String)this.userComboBox.getSelectedItem()));
        target.setVersion(TargetEditorPanel.getSnmpVersionFromIndex(this.versionComboBox.getSelectedIndex()));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private static int getSnmpVersionIndex(int snmpVersion) {
        if (snmpVersion >= 3) {
            return snmpVersion - 1;
        }
        return snmpVersion;
    }

    private static int getSnmpVersionFromIndex(int snmpVersionIndex) {
        if (snmpVersionIndex >= 2) {
            return snmpVersionIndex + 1;
        }
        return snmpVersionIndex;
    }

    private void updateFields(GenTarget target) {
        this.updating = true;
        if (target != null) {
            this.userComboBox.setSelectedItem(target.getUser() == null ? null : target.getUser().getName());
            this.targetNameField.setText(target.getName());
            this.transportComboBox.setSelectedItem(target.getAddressType());
            this.addressTextField.setText(target.getAddressString());
            this.timeout.setValue(target.getTimeout());
            this.retries.setValue(target.getRetries());
            this.versionComboBox.setSelectedIndex(TargetEditorPanel.getSnmpVersionIndex(target.getVersion()));
            this.mibSetComboBox.setSelectedItem(target.getMIBSet());
            this.community.setOctetString(target.getCommunity());
            this.contextName.setOctetString(target.getContext());
            this.contextEngineID.setOctetString(target.getContextEngineID());
            this.securityEngineID.setOctetString(target.getEngineID());
        } else {
            this.userComboBox.setSelectedItem(null);
            this.targetNameField.setText("");
            this.transportComboBox.setSelectedItem(null);
            this.addressTextField.setText("");
            this.timeout.setValue(0);
            this.retries.setValue(0);
            this.versionComboBox.setSelectedIndex(TargetEditorPanel.getSnmpVersionIndex(3));
            this.mibSetComboBox.setSelectedItem(null);
            this.community.setOctetString(new OctetString());
            this.contextName.setOctetString(new OctetString());
            this.contextEngineID.setOctetString(new OctetString());
            this.securityEngineID.setOctetString(new OctetString());
        }
        this.target = target;
        this.updating = false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JTextField jTextField2;
        JButton jButton;
        JLabel jLabel4;
        JComboBox jComboBox;
        JLabel jLabel5;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        OctetStringField octetStringField;
        JLabel jLabel6;
        OctetStringField octetStringField2;
        JButton jButton2;
        OctetStringField octetStringField3;
        JLabel jLabel7;
        JLabel jLabel8;
        JPanel jPanel;
        JLabel jLabel9;
        OctetStringField octetStringField4;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel10;
        JPanel jPanel4;
        this.panel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.timeoutLabel = jLabel10 = new JLabel();
        jLabel10.setText("Timeout:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jLabel10, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        jPanel4.add((Component)jPanel5, gridBagConstraints2);
        this.versionSpecificFieldPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.gridwidth = 10;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        jPanel4.add((Component)jPanel3, gridBagConstraints3);
        this.communityBasedPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel2, "Community Based");
        JPanel jPanel6 = new JPanel();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.fill = 3;
        jPanel2.add((Component)jPanel6, gridBagConstraints4);
        this.community = octetStringField4 = new OctetStringField();
        JComponent jComponent = octetStringField4.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)jComponent, gridBagConstraints5);
        this.communityLabel = jLabel9 = new JLabel();
        jLabel9.setText("Community:");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)jLabel9, gridBagConstraints6);
        this.userBasedPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel, "User Based");
        this.userLabel = jLabel8 = new JLabel();
        jLabel8.setText("User:");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel8, gridBagConstraints7);
        JPanel jPanel7 = new JPanel();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints8);
        JComboBox jComboBox2 = new JComboBox();
        this.userComboBox = jComboBox2;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 0;
        gridBagConstraints9.weightx = 0.5;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.insets = new Insets(10, 10, 10, 10);
        jPanel.add(jComboBox2, gridBagConstraints9);
        this.contextNameLabel = jLabel7 = new JLabel();
        jLabel7.setText("Context:");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 1;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel7, gridBagConstraints10);
        this.contextName = octetStringField3 = new OctetStringField();
        JComponent jComponent2 = octetStringField3.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 2;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.weightx = 0.5;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent2, gridBagConstraints11);
        this.securityEngineIdLabel = jButton2 = new JButton();
        jButton2.setActionCommand("Discover Engine ID");
        jButton2.setText("Engine ID:");
        jButton2.setToolTipText("Discover engine ID from target address");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 3;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton2, gridBagConstraints12);
        this.securityEngineID = octetStringField2 = new OctetStringField();
        JComponent jComponent3 = octetStringField2.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 4;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.weightx = 0.5;
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent3, gridBagConstraints13);
        this.contextEngineIdLabel = jLabel6 = new JLabel();
        jLabel6.setText("Context Engine ID:");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 3;
        gridBagConstraints14.gridy = 1;
        gridBagConstraints14.anchor = 17;
        gridBagConstraints14.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel6, gridBagConstraints14);
        this.contextEngineID = octetStringField = new OctetStringField();
        JComponent jComponent4 = octetStringField.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 4;
        gridBagConstraints15.gridy = 1;
        gridBagConstraints15.weightx = 0.5;
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jComponent4, gridBagConstraints15);
        this.timeout = jSpinner2 = new JSpinner();
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 3;
        gridBagConstraints16.gridy = 2;
        gridBagConstraints16.gridwidth = 5;
        gridBagConstraints16.weightx = 0.5;
        gridBagConstraints16.anchor = 17;
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jSpinner2, gridBagConstraints16);
        this.retries = jSpinner = new JSpinner();
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 9;
        gridBagConstraints17.gridy = 2;
        gridBagConstraints17.anchor = 17;
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jSpinner, gridBagConstraints17);
        this.versionLabel = jLabel5 = new JLabel();
        jLabel5.setText("Version:");
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 2;
        gridBagConstraints18.anchor = 17;
        gridBagConstraints18.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jLabel5, gridBagConstraints18);
        this.versionComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("SNMPv1");
        defaultComboBoxModel.addElement("SNMPv2c");
        defaultComboBoxModel.addElement("SNMPv3");
        jComboBox.setModel(defaultComboBoxModel);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 1;
        gridBagConstraints19.gridy = 2;
        gridBagConstraints19.weightx = 0.5;
        gridBagConstraints19.anchor = 17;
        gridBagConstraints19.fill = 2;
        gridBagConstraints19.insets = new Insets(10, 10, 10, 10);
        jPanel4.add(jComboBox, gridBagConstraints19);
        this.transportLabel = jLabel4 = new JLabel();
        jLabel4.setText("Transport:");
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.gridx = 0;
        gridBagConstraints20.gridy = 1;
        gridBagConstraints20.anchor = 17;
        gridBagConstraints20.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jLabel4, gridBagConstraints20);
        JComboBox jComboBox3 = new JComboBox();
        this.transportComboBox = jComboBox3;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.gridy = 1;
        gridBagConstraints21.weightx = 0.5;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.insets = new Insets(10, 10, 10, 10);
        jPanel4.add(jComboBox3, gridBagConstraints21);
        this.addressLabel = jButton = new JButton();
        jButton.setActionCommand("Test Connectivity");
        jButton.setText("Address:");
        jButton.setToolTipText("Test connectivity");
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 2;
        gridBagConstraints22.gridy = 1;
        gridBagConstraints22.anchor = 17;
        gridBagConstraints22.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jButton, gridBagConstraints22);
        this.addressTextField = jTextField2 = new JTextField();
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.gridx = 3;
        gridBagConstraints23.gridy = 1;
        gridBagConstraints23.gridwidth = 7;
        gridBagConstraints23.weightx = 1.0;
        gridBagConstraints23.anchor = 17;
        gridBagConstraints23.fill = 2;
        gridBagConstraints23.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jTextField2, gridBagConstraints23);
        this.targetNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.gridx = 0;
        gridBagConstraints24.gridy = 0;
        gridBagConstraints24.anchor = 17;
        gridBagConstraints24.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jLabel3, gridBagConstraints24);
        this.targetNameField = jTextField = new JTextField();
        jTextField.setEditable(true);
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.gridx = 1;
        gridBagConstraints25.gridy = 0;
        gridBagConstraints25.gridwidth = 7;
        gridBagConstraints25.weightx = 1.0;
        gridBagConstraints25.anchor = 17;
        gridBagConstraints25.fill = 2;
        gridBagConstraints25.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jTextField, gridBagConstraints25);
        this.mibSetLabel = jLabel2 = new JLabel();
        jLabel2.setText("MIB Set:");
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.gridx = 8;
        gridBagConstraints26.gridy = 0;
        gridBagConstraints26.anchor = 17;
        gridBagConstraints26.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jLabel2, gridBagConstraints26);
        JComboBox jComboBox4 = new JComboBox();
        this.mibSetComboBox = jComboBox4;
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.gridx = 9;
        gridBagConstraints27.gridy = 0;
        gridBagConstraints27.weightx = 0.5;
        gridBagConstraints27.anchor = 17;
        gridBagConstraints27.fill = 2;
        gridBagConstraints27.insets = new Insets(10, 10, 10, 10);
        jPanel4.add(jComboBox4, gridBagConstraints27);
        this.retriesLabel = jLabel = new JLabel();
        jLabel.setText("Retries:");
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.gridx = 8;
        gridBagConstraints28.gridy = 2;
        gridBagConstraints28.anchor = 17;
        gridBagConstraints28.insets = new Insets(10, 10, 10, 10);
        jPanel4.add((Component)jLabel, gridBagConstraints28);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class UpdateInputVerifier
    extends InputVerifier {
        private UpdateInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            if (!TargetEditorPanel.this.updating && TargetEditorPanel.this.target != null && TargetEditorPanel.this.updateListener != null) {
                try {
                    GenTarget target = TargetEditorPanel.this.getTarget();
                    if (target == null || !TargetEditorPanel.this.updateListener.uiObjectVerification(TargetEditorPanel.this, target, TargetEditorPanel.this.target)) {
                        ok = false;
                    } else {
                        TargetEditorPanel.this.updateTarget();
                        TargetEditorPanel.this.updateListener.uiObjectUpdated(TargetEditorPanel.this, TargetEditorPanel.this.target);
                    }
                }
                catch (IllegalArgumentException iax) {
                    ok = false;
                }
            }
            if (ok) {
                if (input.getBackground() == Color.pink) {
                    input.setBackground(Color.white);
                }
            } else if (input.getBackground() == Color.white) {
                input.setBackground(Color.pink);
            }
            return ok;
        }
    }
}

