/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.common.table.TableUtils;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCTableModelDataSource;
import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiType;
import com.snmp4j.smibridge.SmiManagerBridge;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.ChangeSet;
import org.snmp4j.model.snmp.proxy.SnmpCommitListener;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyObject;
import org.snmp4j.model.snmp.proxy.SnmpTable;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectHelper;
import org.snmp4j.model.snmp.proxy.impl.SnmpTableImpl;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpCell;
import org.snmp4j.model.snmp.spi.SnmpCellUpdateListener;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpDataEditor
implements SnmpCommitListener,
SnmpCellUpdateListener {
    private JButton buttonCommit;
    private JButton buttonUndo;
    private JButton buttonReload;
    private JCTable table;
    private JPanel panel;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JButton buttonRedo;
    private SnmpProxyObject snmpProxyObject;
    private final VariableBindingMapper variableBindingMapper;
    private final SmiManagerBridge smiManager;
    private Stack<SnmpValuesChangeSet> redoStack = new Stack();
    private boolean isTable;
    private boolean editable;
    private JCCellStyle normalStyle;
    private JCCellStyle indexStyle;
    private JCCellStyle failureStyle;

    public SnmpDataEditor(final SmiManagerBridge smiManager, final VariableBindingMapper variableBindingMapper) {
        this.$$$setupUI$$$();
        this.smiManager = smiManager;
        this.variableBindingMapper = variableBindingMapper;
        this.table.setSelectionPolicy(3);
        this.normalStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this.indexStyle = new JCCellStyle(this.normalStyle);
        this.indexStyle.setEditable(false);
        this.indexStyle.setBackground(Color.lightGray);
        this.failureStyle = new JCCellStyle(this.normalStyle);
        this.failureStyle.setBackground(Color.red);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SnmpDataEditor.this.snmpProxyObject instanceof SnmpTableImpl) {
                    SnmpTableImpl snmpTable = (SnmpTableImpl)SnmpDataEditor.this.snmpProxyObject;
                    List<VariableBinding> indexVbs = SnmpTableImpl.getIndexVariableTemplates(snmpTable.getIndexColumns());
                    String indexString = smiManager.getIndexStringFromVariables(snmpTable.getOID(), indexVbs);
                    while (indexString != null) {
                        indexString = JOptionPane.showInputDialog(SnmpDataEditor.this.getPanel(), "Row index value:", indexString);
                        if (indexString == null) continue;
                        try {
                            SnmpColumn firstColumn = (SnmpColumn)snmpTable.getColumns().get(0);
                            OID indexOID = new OID(firstColumn.getOID() + "." + indexString);
                            indexOID = new OID(indexOID.getValue(), firstColumn.getOID().size(), indexOID.size() - firstColumn.getOID().size());
                            List<VariableBinding> indexVBs = snmpTable.getIndexVariableBindings(indexOID);
                            ArrayList<VariableBinding> initialVBs = new ArrayList<VariableBinding>();
                            for (SnmpColumn snmpColumn : snmpTable.getColumns()) {
                                OID cellOID = new OID(snmpColumn.getOID().getValue(), indexOID.getValue());
                                SmiObjectType objectType = (SmiObjectType)smiManager.findSmiObject(snmpColumn.getOID());
                                VariableBinding vb = new VariableBinding(cellOID, objectType.createNewVariable());
                                initialVBs.add(vb);
                            }
                            Object newRow = snmpTable.getRowFactory().createProxyRow(indexOID, SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, indexVBs, snmpTable.getIndexColumns()), SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, initialVBs, snmpTable.getColumns()));
                            if (snmpTable.getRowNumber(newRow.getIndex()) < 0 || snmpTable.isEmpty()) {
                                snmpTable.insertRow(newRow);
                                break;
                            }
                            JOptionPane.showMessageDialog(SnmpDataEditor.this.getPanel(), "A row with index '" + newRow.getIndex().toDottedString() + "' already exists.", "Duplicate Row Index", 2);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(SnmpDataEditor.this.getPanel(), "The given row index could not be parsed. Please try again.", "Row Index Error", 0);
                        }
                    }
                } else {
                    SnmpDataEditor.this.table.setDataSource(new JCTableModelDataSource(new DefaultTableModel()));
                }
            }
        });
        this.buttonCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SnmpDataEditor.this.commitChanges();
            }
        });
        this.buttonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SnmpDataEditor.this.undo();
            }
        });
        this.buttonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SnmpDataEditor.this.redo();
            }
        });
        this.buttonReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SnmpDataEditor.this.snmpProxyObject instanceof SnmpTable) {
                    SnmpTable snmpTable = (SnmpTable)SnmpDataEditor.this.snmpProxyObject;
                    boolean cancelReload = false;
                    if (snmpTable.getCommitter().getNumberOfPendingChanges() > 0 && JOptionPane.showConfirmDialog(SnmpDataEditor.this.getPanel(), "There are uncommitted changes. Do you want to commit them before reloading?", "Commit Changes?", 0) == 0) {
                        boolean bl = cancelReload = !SnmpDataEditor.this.commitChanges();
                    }
                    if (!cancelReload) {
                        SnmpDataEditor.this.reload(SnmpDataEditor.this.snmpProxyObject, variableBindingMapper);
                    } else {
                        JOptionPane.showMessageDialog(SnmpDataEditor.this.getPanel(), "Reload canceled because commit failed for at least one value", "Reload Canceled", 1);
                    }
                }
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SnmpDataEditor.this.isTable) {
                    int[] rows = TableUtils.getSelectedRows(SnmpDataEditor.this.table);
                    boolean yesToAll = false;
                    for (int i2 = rows.length - 1; i2 >= 0; --i2) {
                        SnmpTable snmpTable = (SnmpTable)SnmpDataEditor.this.snmpProxyObject;
                        OID rowIndex = snmpTable.getRowIndex(rows[i2]);
                        int choice = 0;
                        if (!yesToAll) {
                            choice = JOptionPane.showOptionDialog(SnmpDataEditor.this.getPanel(), "Do you really want to remove row " + SnmpDataEditor.this.getIndexString(snmpTable.getOID(), rowIndex) + "? ", "Confirm Row Delete", 1, 3, null, new String[]{"Yes", "Yes to All", "No"}, "No");
                        }
                        switch (choice) {
                            case 1: {
                                yesToAll = true;
                            }
                            case 0: {
                                SnmpDataEditor.this.removeRow(snmpTable.getOID(), rowIndex);
                            }
                        }
                    }
                    SnmpDataEditor.this.commitChanges();
                }
                SnmpDataEditor.this.reload(SnmpDataEditor.this.snmpProxyObject, variableBindingMapper);
            }
        });
        this.table.setRowLabelDisplay(false);
        this.enableTabularButtons(false);
        this.updateUndoButtons();
    }

    public void removeRow(OID table, OID rowIndex) {
    }

    private String getIndexString(OID tableEntry, OID index) {
        Variable[] variables = this.smiManager.getIndexVariables(tableEntry, index);
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < variables.length; ++i2) {
            buf.append(variables[i2].toString());
            if (i2 + 1 >= variables.length) continue;
            buf.append(";");
        }
        return buf.toString();
    }

    public void reload(SnmpProxyObject snmpProxy, VariableBindingMapper variableMapper) {
        if (this.snmpProxyObject instanceof SnmpTable) {
            int i2;
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            int indexOffset = snmpTable.getIndexColumns().size();
            for (i2 = 0; i2 < indexOffset; ++i2) {
                this.table.setCellStyle(-997, i2, this.indexStyle);
            }
            for (i2 = 0; i2 < snmpTable.getColumnCount(); ++i2) {
                this.table.setCellStyle(-997, indexOffset + i2, this.normalStyle);
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean commitChanges() {
        boolean success = false;
        if (this.snmpProxyObject instanceof SnmpTable) {
            EditorCommitListener commitListener = new EditorCommitListener();
            ((SnmpTable)this.snmpProxyObject).getCommitter().commitChanges(commitListener);
            success = commitListener.isSuccess();
            ((SnmpTable)this.snmpProxyObject).getCommitter().removeAllChanges(this.snmpProxyObject);
        }
        this.updateUndoButtons();
        return success;
    }

    @Override
    public void commitSuccess(List<SnmpValuesChangeSet> valuesChangeSets) {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            for (SnmpValuesChangeSet changeSet : valuesChangeSets) {
                for (SnmpValueChange change : changeSet.getChanges()) {
                    SnmpCell cell = snmpTable.getCell(change.getOid());
                    this.table.setCellStyle(cell.getRow(), cell.getColumn(), this.normalStyle);
                }
            }
        }
    }

    @Override
    public void commitFailure(List<SnmpValuesChangeSet> valuesChangeSets, SnmpErrorStatus errorStatus, int i2) {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            for (SnmpValuesChangeSet changeSet : valuesChangeSets) {
                for (SnmpValueChange change : changeSet.getChanges()) {
                    if (change.getChangeStatus() != ChangeSet.ChangeStatus.FAILURE) continue;
                    SnmpCell cell = snmpTable.getCell(change.getOid());
                    this.table.setCellStyle(cell.getRow(), cell.getColumn(), this.failureStyle);
                }
            }
        }
    }

    @Override
    public OctetString getContext() {
        return new OctetString();
    }

    @Override
    public void cellUpdated(int row, int col, SnmpValueChange change) {
        this.table.setCellStyle(row, col, this.normalStyle);
    }

    @Override
    public void cellUpdateFailed(int row, int col, SnmpValueChange change) {
        this.table.setCellStyle(row, col, this.failureStyle);
    }

    public void undo() {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            SnmpValuesChangeSet changeSet = snmpTable.getCommitter().removeLastChangeSet(snmpTable);
            if (changeSet != null && snmpTable.undoChange(changeSet)) {
                this.redoStack.add(changeSet);
                this.table.updateUI();
            }
            this.updateUndoButtons();
        }
    }

    public void redo() {
        if (this.snmpProxyObject instanceof SnmpTable && !this.redoStack.empty()) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            SnmpValuesChangeSet changeSet = this.redoStack.pop();
            if (changeSet != null && !snmpTable.doChange(changeSet)) {
                this.redoStack.add(changeSet);
            }
            this.updateUndoButtons();
        }
    }

    private void enableTabularButtons(boolean isTable) {
        boolean enabled = isTable && this.editable;
        this.buttonAdd.setEnabled(enabled);
        this.buttonReload.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonCommit.setEnabled(this.editable);
    }

    public SnmpProxyObject getSnmpProxyObject() {
        return this.snmpProxyObject;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public void setSnmpProxyObject(SnmpProxyObject snmpProxyObject) {
        this.redoStack.clear();
        this.snmpProxyObject = snmpProxyObject;
        if (snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)snmpProxyObject;
            snmpTable.setCellUpdateListener(this);
            JCTableModelDataSource tableModelDataSource = new JCTableModelDataSource(snmpTable);
            this.table.setDataSource(tableModelDataSource);
            ((SnmpTable)snmpProxyObject).addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e2) {
                    SnmpDataEditor.this.updateUndoButtons();
                }
            });
            SmiObject smiObject = this.smiManager.findSmiObject(snmpProxyObject.getOID());
            this.isTable = smiObject instanceof SmiObjectType && smiObject.getType().equals((Object)SmiType.OBJECT_TYPE_TABLE_ENTRY);
            this.enableButtons(true);
            this.enableTabularButtons(this.isTable);
            if (this.isTable) {
                int width;
                int c2 = 0;
                for (SnmpProxyColumn column : snmpTable.getIndexColumns()) {
                    width = Math.min(Math.max(column.getMaxWidth(), snmpTable.getColumnName(c2).length()), 20);
                    this.table.setPixelWidth(c2, -999);
                    this.table.setCharWidth(c2, width);
                    this.table.setCellStyle(-997, c2, this.indexStyle);
                    ++c2;
                }
                for (SnmpProxyColumn column : snmpTable.getColumns()) {
                    width = Math.min(Math.max(column.getMaxWidth(), snmpTable.getColumnName(c2).length()), 25);
                    this.table.setPixelWidth(c2, -999);
                    this.table.setCharWidth(c2, width);
                    this.table.setCellStyle(-997, c2, this.normalStyle);
                    ++c2;
                }
            } else {
                this.table.setPixelWidth(0, this.panel.getWidth() - 15);
                this.table.setCellStyle(0, 0, this.normalStyle);
            }
            tableModelDataSource.fireDataReset();
        } else {
            JCTableModelDataSource tableModelDataSource = new JCTableModelDataSource(new DefaultTableModel());
            this.table.setDataSource(tableModelDataSource);
            this.enableTabularButtons(false);
            tableModelDataSource.fireDataReset();
            this.enableButtons(false);
        }
    }

    private void enableButtons(boolean enabled) {
        this.buttonReload.setEnabled(enabled);
        this.buttonUndo.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonRedo.setEnabled(enabled);
        this.buttonCommit.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
    }

    private void updateUndoButtons() {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            boolean pendingChanges = snmpTable.getCommitter().getNumberOfPendingChanges() > 0;
            this.buttonUndo.setEnabled(pendingChanges);
            this.buttonRedo.setEnabled(!this.redoStack.empty());
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void createUIComponents() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JCTable jCTable;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.table = jCTable = new JCTable();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jCTable, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        this.buttonCommit = jButton6 = new JButton();
        jButton6.setText("Save");
        jButton6.setToolTipText("Commit changes to the agent and - if data synchronization is enabled - also to Properties");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton6, gridBagConstraints3);
        this.buttonUndo = jButton5 = new JButton();
        jButton5.setActionCommand("Undo");
        jButton5.setText("Undo");
        jButton5.setToolTipText("Undo the latest change of the simulation agent data ");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton5, gridBagConstraints4);
        this.buttonReload = jButton4 = new JButton();
        jButton4.setText("Reload");
        jButton4.setToolTipText("Reload data from the agent");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 6;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton4, gridBagConstraints5);
        this.buttonAdd = jButton3 = new JButton();
        jButton3.setText("Add Row");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton3, gridBagConstraints6);
        this.buttonRemove = jButton2 = new JButton();
        jButton2.setText("Remove Row");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 2;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton2, gridBagConstraints7);
        this.buttonRedo = jButton = new JButton();
        jButton.setText("Redo");
        jButton.setToolTipText("Redo an undone change");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 5;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton, gridBagConstraints8);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class EditorCommitListener
    implements SnmpCommitListener {
        private boolean success = true;

        private EditorCommitListener() {
        }

        @Override
        public void commitSuccess(List<SnmpValuesChangeSet> committedChanges) {
            SnmpDataEditor.this.commitSuccess(committedChanges);
        }

        @Override
        public void commitFailure(List<SnmpValuesChangeSet> failedChanges, SnmpErrorStatus errorStatus, int errorIndex) {
            this.success = false;
            SnmpDataEditor.this.commitFailure(failedChanges, errorStatus, errorIndex);
        }

        @Override
        public OctetString getContext() {
            return new OctetString();
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

