/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.commons.snmp.editor.OidCellEditor;
import com.agentpp.mib.MIBRepository;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.snmp4j.smi.OID;

public class SecurityProtocolOidMappingEditor {
    public static final int COL_LABEL = 0;
    public static final int COL_MAPPING_OID = 1;
    private static String[] COL_LABELS = new String[]{"Protocol", "Assigned Object ID*"};
    private ExtendedListTable mappingTable;
    private JPanel panel;
    private MIBRepository mibRepository;
    private JCEditableVectorDataSource mappingModel;

    public SecurityProtocolOidMappingEditor(MIBRepository mibRepository, Map<String, OID> nameToOidMap) {
        this.$$$setupUI$$$();
        this.mibRepository = mibRepository;
        this.mappingModel = new JCEditableVectorDataSource();
        this.mappingModel.setNumRows(nameToOidMap.size());
        this.mappingModel.setNumColumns(COL_LABELS.length);
        this.mappingModel.setColumnLabels(COL_LABELS);
        this.mappingTable.setVariableEstimateCount(nameToOidMap.size());
        JCCellStyle oidStyle = new JCCellStyle(this.mappingTable.getCellStyle(-997, 1));
        oidStyle.setCellEditor(new OidCellEditor(mibRepository));
        oidStyle.setEditable(true);
        JCCellStyle labelStyle = new JCCellStyle(this.mappingTable.getCellStyle(-997, 0));
        labelStyle.setEditable(false);
        this.mappingTable.setCellStyle(-997, 1, oidStyle);
        this.mappingTable.setCellStyle(-997, 0, labelStyle);
        int row = 0;
        for (Map.Entry<String, OID> entry : nameToOidMap.entrySet()) {
            this.mappingModel.setTableDataItem(entry.getKey(), row, 0);
            this.mappingModel.setTableDataItem(entry.getValue(), row++, 1);
        }
        this.mappingTable.setDataSource(this.mappingModel);
    }

    public Map<String, OID> getMapping() {
        HashMap<String, OID> oidMap = new HashMap<String, OID>();
        for (int i2 = 0; i2 < this.mappingModel.getNumRows(); ++i2) {
            String id = (String)this.mappingModel.getTableDataItem(i2, 0);
            OID oid = (OID)this.mappingModel.getTableDataItem(i2, 1);
            oidMap.put(id, oid);
        }
        return oidMap;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ExtendedListTable extendedListTable;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.mappingTable = extendedListTable = new ExtendedListTable();
        extendedListTable.setRowLabelDisplay(false);
        jPanel.add((Component)extendedListTable, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

