/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class JCValueConverter
extends ValueConverter
implements JCValidateListener,
Comparator,
Serializable {
    public static final long serialVersionUID = -9073989472934609617L;

    public JCValueConverter(ValueConverter other) {
        super(other);
    }

    public JCValueConverter(MIBObjectType objectType, MIBSyntax effectiveSyntax, String displayHint) {
        super(objectType, effectiveSyntax, displayHint);
    }

    public JCValueConverter(int smiSyntax) {
        super(smiSyntax);
    }

    private static int getSmiSyntax(Class snmpClass) {
        int smiSyntax = 0;
        smiSyntax = snmpClass.equals(Integer32.class) ? 0 : (snmpClass.equals(Counter32.class) ? 3 : (snmpClass.equals(Counter64.class) ? 6 : (snmpClass.equals(OctetString.class) ? 1 : (snmpClass.equals(OID.class) ? 2 : (snmpClass.equals(IpAddress.class) ? 9 : (snmpClass.equals(Gauge32.class) ? 4 : (snmpClass.equals(TimeTicks.class) ? 11 : 14)))))));
        return smiSyntax;
    }

    @Override
    public void stateIsInvalid(JCValidateEvent parm1) {
    }

    @Override
    public void valueChangedEnd(JCValidateEvent e2) {
    }

    @Override
    public void valueChangedBegin(JCValidateEvent e2) {
        Variable o2;
        BigDecimal bd;
        long l2;
        if (e2.getValue() == null) {
            e2.setValid(false);
            e2.setBeep(true);
            return;
        }
        if (!e2.isValid()) {
            return;
        }
        if (e2.getValue() instanceof Long && (l2 = ((Long)e2.getValue()).longValue()) < 0L) {
            e2.setBeep(true);
            e2.setValid(false);
            return;
        }
        if (e2.getValue() instanceof BigDecimal && (bd = (BigDecimal)e2.getValue()).compareTo(new BigDecimal("18446744073709551616")) >= 0) {
            e2.setBeep(true);
            e2.setValid(false);
            return;
        }
        if (e2.getValue() instanceof String) {
            switch (this.smiSyntax) {
                case 2: {
                    ObjectID id = new ObjectID(e2.getValue().toString());
                    if (id.isValid()) break;
                    e2.setBeep(true);
                    e2.setValid(false);
                    return;
                }
                case 9: {
                    ComparableIpAddress id = new ComparableIpAddress(e2.getValue().toString());
                    if (id.isValid()) break;
                    e2.setBeep(true);
                    e2.setValid(false);
                    return;
                }
                case 12: {
                    String s = e2.getValue().toString();
                    if (s.indexOf(123) >= 0 && s.indexOf(125) == s.length() - 1) {
                        byte[] v = this.getEffectiveSyntax().getBitsEnum(s);
                        if (v != null) break;
                        e2.setBeep(true);
                        e2.setValid(false);
                        return;
                    }
                    for (int i2 = 0; i2 < s.length(); ++i2) {
                        char c2 = s.charAt(i2);
                        if (c2 == '1' || c2 == '0' || c2 == ' ') continue;
                        e2.setBeep(true);
                        e2.setValid(false);
                        return;
                    }
                    break;
                }
            }
        }
        if ((o2 = this.fromNative(e2.getValue())) == null) {
            e2.setBeep(true);
            e2.setValid(false);
            return;
        }
        e2.setValid(true);
    }
}

