/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib.editor;

import com.agentpp.commons.mib.editor.SmiEditorPanel;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.TablePopupMenu;
import com.snmp4j.smi.SmiCompiler;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class SmiEditorDialog
extends JDialog {
    private static final String ACTION_EXPORT_SELECTED_ERRORS = "Save selected errors...";
    private SmiEditorPanel editorPanel;
    private JMenuBar menuBar;
    private JFrame myFrame;
    private int preferredWidth;
    private int preferredHeight;

    public SmiEditorDialog(JFrame frame, int width, int height) {
        super(frame);
        this.preferredWidth = width;
        this.preferredHeight = height;
        super.setDefaultCloseOperation(2);
        this.myFrame = frame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TablePopupMenu menu = this.editorPanel.getErrorTable().getPopupMenu();
        menu.addItem(ACTION_EXPORT_SELECTED_ERRORS, this.editorPanel.createExportSelectedErrorsAction(ACTION_EXPORT_SELECTED_ERRORS, true));
        this.editorPanel.getErrorTable().setPopupMenuEnabled(true);
    }

    public SmiEditorDialog(JFrame f2, int width, int height, File file) {
        this(f2, width, height);
        this.editorPanel.loadFile(file, 1, 1, 0);
    }

    private void jbInit() {
        this.editorPanel = new SmiEditorPanel(this.myFrame, ResourceBundle.getBundle("com.agentpp.commons.mib.editor.SmiEditorDialog", Locale.getDefault())){

            @Override
            public void doExit() {
                super.doExit();
                SmiEditorDialog.this.setVisible(false);
            }
        };
        this.getContentPane().setLayout(new BorderLayout());
        this.menuBar = this.editorPanel.createMenubar();
        this.getContentPane().add("North", this.menuBar);
        this.getContentPane().add("Center", this.editorPanel);
        this.editorPanel.setPreferredSize(new Dimension(this.preferredWidth, this.preferredHeight));
        this.pack();
    }

    public void setImporter(SmiCompiler newImporter) {
        this.editorPanel.setImporter(newImporter);
    }

    public void setConfig(UserConfigFile config) {
        this.editorPanel.setConfig(config);
    }

    public boolean isDefaultCompileLenient() {
        return this.editorPanel.isDefaultCompileLenient();
    }

    public void setDefaultCompileLenient(boolean defaultCompileLenient) {
        this.editorPanel.setDefaultCompileLenient(defaultCompileLenient);
    }

    public boolean isBackgroundChecksEnabled() {
        return this.editorPanel.isBackgroundChecksEnabled();
    }

    public void setBackgroundChecksEnabled(boolean backgroundChecksEnabled) {
        this.editorPanel.setBackgroundChecksEnabled(backgroundChecksEnabled);
    }

    public SmiEditorPanel getEditorPanel() {
        return this.editorPanel;
    }
}

