/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib.editor;

import com.agentpp.commons.mib.editor.AnnotationBarDataModel;
import com.agentpp.commons.mib.editor.AnnotationMark;
import com.agentpp.commons.mib.editor.AnnotationMarkListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class AnnotationBar
extends JComponent
implements MouseListener {
    private static final int STATUS_BOX_SIZE = 7;
    private static final int THICKNESS = 13;
    private static final int PIXELS_FOR_MARK = 3;
    private static final int LINE_SEPARATOR_SIZE = 1;
    private static final int HEIGHT_OFFSET = 20;
    private static final int UPPER_HANDLE = 4;
    private static final int LOWER_HANDLE = 4;
    private static final Color STATUS_UP_PART_COLOR = Color.WHITE;
    private static final Color STATUS_DOWN_PART_COLOR = new Color(13486779);
    private static final Color COLOR_RED = new Color(16722460);
    private static final Color COLOR_YELLOW = new Color(14788122);
    private static final Color COLOR_GREEN = new Color(7522424);
    private final JTextComponent textComponent;
    private Insets scrollBar;
    private final AnnotationBarDataModel model;
    private final AnnotationMarkListener annotationMarkListener;
    private int[] modelToViewCache = null;
    private int lines = -1;
    private int height = -1;
    private int rowCount = -1;
    private boolean statusUpdateInProgress = true;

    public AnnotationBar(JTextComponent textComponent, AnnotationBarDataModel model, AnnotationMarkListener listener) {
        this.textComponent = textComponent;
        this.model = model;
        this.annotationMarkListener = listener;
        this.scrollBar = new Insets(18, 0, 18, 0);
        this.addMouseListener(this);
        this.setOpaque(true);
        this.setToolTipText("Error stripe");
    }

    public boolean isStatusUpdateInProgress() {
        return this.statusUpdateInProgress;
    }

    public void setStatusUpdateInProgress(boolean statusUpdateInProgress) {
        this.statusUpdateInProgress = statusUpdateInProgress;
    }

    public void resetCache() {
        this.modelToViewCache = null;
        this.rowCount = -1;
        if (!SwingUtilities.isEventDispatchThread()) {
            this.rowCount = this.getRowCount();
        }
    }

    public boolean isCacheInvalidated() {
        return this.modelToViewCache == null;
    }

    private void drawOneColorGlobalStatus(Graphics g2, Color color) {
        g2.setColor(color);
        int x = 3;
        int y = (this.topOffset() - 7) / 2;
        g2.fillRect(x, y, 7, 7);
        g2.setColor(STATUS_DOWN_PART_COLOR);
        g2.drawLine(x - 1, y - 1, x + 7, y - 1);
        g2.drawLine(x - 1, y - 1, x - 1, y + 7);
        g2.setColor(STATUS_UP_PART_COLOR);
        g2.drawLine(x - 1, y + 7, x + 7, y + 7);
        g2.drawLine(x + 7, y - 1, x + 7, y + 7);
    }

    int topOffset() {
        if (this.scrollBar == null) {
            return 20;
        }
        return (20 > this.scrollBar.top ? 20 : this.scrollBar.top) + 3;
    }

    private Color getSeverityColor(AnnotationMark.MarkSeverity severity) {
        switch (severity) {
            case error: {
                return COLOR_RED;
            }
            case warning: {
                return COLOR_YELLOW;
            }
        }
        return COLOR_GREEN;
    }

    private void drawGlobalStatus(Graphics g2) {
        this.drawOneColorGlobalStatus(g2, this.statusUpdateInProgress ? STATUS_DOWN_PART_COLOR : this.getSeverityColor(this.model.getStatus()));
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Color oldColor = g2.getColor();
        Color backColor = UIManager.getColor("Panel.background");
        g2.setColor(backColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        Iterator<AnnotationMark> markIterator = this.model.iterator();
        while (markIterator.hasNext()) {
            AnnotationMark mark = markIterator.next();
            double start = this.modelToView(mark);
            g2.setColor(this.getSeverityColor(mark.getSeverity()));
            g2.fillRect(1, (int)start, 11, 3);
        }
        this.drawGlobalStatus(g2);
        g2.setColor(oldColor);
    }

    private double modelToView(AnnotationMark mark) {
        return this.modelToView(mark, this.getComponentHeight(), this.getUsableHeight());
    }

    private double getComponentHeight() {
        final double[] ret = new double[1];
        this.textComponent.getDocument().render(new Runnable(){

            @Override
            public void run() {
                ret[0] = AnnotationBar.this.textComponent.getUI().getRootView(AnnotationBar.this.textComponent).getPreferredSpan(1);
            }
        });
        return ret[0];
    }

    double getUsableHeight() {
        Container scrollPaneCandidade = this.textComponent.getParent();
        if (scrollPaneCandidade != null && !(scrollPaneCandidade instanceof JScrollPane)) {
            scrollPaneCandidade = scrollPaneCandidade.getParent();
        }
        if (scrollPaneCandidade == null || !(scrollPaneCandidade instanceof JScrollPane) || this.scrollBar == null) {
            return this.getHeight() - 20;
        }
        JScrollPane scrollPane = (JScrollPane)scrollPaneCandidade;
        int visibleHeight = scrollPane.getViewport().getExtentSize().height;
        int topButton = this.topOffset();
        int bottomButton = this.scrollBar.bottom;
        return visibleHeight - topButton - bottomButton;
    }

    private double modelToView(AnnotationMark mark, double componentHeight, double usableHeight) {
        try {
            int r2 = this.modelToViewImpl(mark);
            if (r2 == -1) {
                return -1.0;
            }
            if (componentHeight <= usableHeight) {
                return r2 + this.topOffset();
            }
            double position = (double)r2 / componentHeight;
            int blocksCount = (int)(usableHeight / 4.0);
            int block = (int)(position * (double)blocksCount);
            return block * 4 + this.topOffset();
        }
        catch (BadLocationException e2) {
            return -1.0;
        }
    }

    private synchronized int modelToViewImpl(AnnotationMark mark) throws BadLocationException {
        int docLines = this.getRowCount();
        int[] modelToViewCache = this.modelToViewCache;
        if (modelToViewCache == null || this.height != this.textComponent.getHeight() || this.lines != docLines) {
            this.modelToViewCache = modelToViewCache = new int[docLines + 2];
            this.lines = docLines;
            this.height = this.textComponent.getHeight();
        }
        if (mark.getStartLine() >= docLines) {
            return -1;
        }
        if (mark.getStartLine() + 1 < 0) {
            return -1;
        }
        int result = modelToViewCache[mark.getStartLine() + 1];
        if (result == 0) {
            modelToViewCache[mark.getStartLine() + 1] = result = this.getYFromPos(mark.getPosition());
        }
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    private int getYFromPos(int offset) throws BadLocationException {
        int result;
        Rectangle r2 = this.textComponent.modelToView(offset = Math.max(offset, 0));
        int n2 = result = r2 != null ? r2.y : 0;
        if (result == 0) {
            return -1;
        }
        return result;
    }

    private int getRowCount() {
        if (this.rowCount >= 0) {
            return this.rowCount;
        }
        int totalCharacters = this.textComponent.getDocument().getLength();
        if (totalCharacters == 0) {
            this.rowCount = 1;
            return this.rowCount;
        }
        this.rowCount = 0;
        try {
            int offset = totalCharacters;
            while (offset > 0) {
                offset = Utilities.getRowStart(this.textComponent, offset) - 1;
                ++this.rowCount;
            }
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
        }
        return this.rowCount;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int y = event.getY();
        if (y <= this.topOffset()) {
            Map<AnnotationMark.MarkSeverity, Integer> counters = this.model.getAnnotationCounts();
            int errors = counters.get((Object)AnnotationMark.MarkSeverity.error);
            int warnings = counters.get((Object)AnnotationMark.MarkSeverity.warning);
            if (errors == 0 && warnings == 0) {
                return "No errors";
            }
            if (errors == 0 && warnings != 0) {
                return MessageFormat.format("{0} {0,choice,0#warnings|1#warning|1<warnings}", warnings);
            }
            if (warnings == 0) {
                return MessageFormat.format("{0} {0,choice,0#errors|1#error|1<errors}", errors);
            }
            return MessageFormat.format("{0} {0,choice,0#errors|1#error|1<errors}, {1} {1,choice,0#warnings|1#warning|1<warnings}", errors, warnings);
        }
        AnnotationMark mark = this.getMarkForPoint(y);
        if (mark != null) {
            return mark.getDescription();
        }
        return null;
    }

    private int viewToModelPosition(double offset) {
        try {
            int positionOffset;
            if (this.getComponentHeight() <= this.getUsableHeight()) {
                int positionOffset2 = this.textComponent.viewToModel(new Point(1, (int)(offset - (double)this.topOffset())));
                if (positionOffset2 == -1) {
                    return -1;
                }
                return Utilities.getRowStart(this.textComponent, positionOffset2);
            }
            int blocksCount = (int)(this.getUsableHeight() / 4.0);
            int block = (int)((offset - (double)this.topOffset()) / 4.0);
            double yPos = this.getComponentHeight() * (double)block / (double)blocksCount;
            if (yPos == (double)((int)yPos)) {
                yPos -= 1.0;
            }
            if ((positionOffset = this.textComponent.viewToModel(new Point(0, (int)yPos))) == -1) {
                return -1;
            }
            return Utilities.getRowStart(this.textComponent, positionOffset);
        }
        catch (BadLocationException e2) {
            return -1;
        }
    }

    private AnnotationMark getMarkForPointImpl(double point) {
        int position = this.viewToModelPosition(point);
        if (position < 0) {
            return null;
        }
        return this.model.getTopLevelMarkForPosition(position);
    }

    private AnnotationMark getMarkForPoint(double point) {
        point = (int)(point / 4.0) * 4;
        AnnotationMark mark = this.getMarkForPointImpl(point);
        int relativeMax = Math.max(5, 5);
        for (int relative = 1; relative < relativeMax && mark == null; relative = (int)((short)(relative + 1))) {
            if (relative <= 4) {
                mark = this.getMarkForPointImpl(point + (double)relative);
            }
            if (relative > 4 || mark != null) continue;
            mark = this.getMarkForPointImpl(point - (double)relative);
        }
        return mark;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        AnnotationMark mark;
        if (this.annotationMarkListener != null && (mark = this.getMarkForPoint(e2.getPoint().getY())) != null) {
            this.annotationMarkListener.annotationMarkSelected(mark);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(13, Integer.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(13, Integer.MIN_VALUE);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(13, Integer.MIN_VALUE);
    }
}

