/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib;

import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.mib.editor.SmiEditorPanel;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.TableDataModel;
import com.snmp4j.smi.CompilationResult;
import com.snmp4j.smi.SmiCompiler;
import com.snmp4j.smi.SmiError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class SmiParserLogPanel
extends JPanel {
    private static final String[] COL_LABEL = new String[]{" #", "File", "Errors", "MIB Modules", "Path"};
    private static final int BUF_SIZE = 16535;
    private PopupListTable fileTable = new PopupListTable();
    private SmiEditorPanel smiEditorPanel;
    private JSplitPane splitPane;
    private List<CompilationResult> compilationResults;

    public SmiParserLogPanel(JFrame frame, UserConfigFile config) {
        this.setLayout(new BorderLayout());
        this.smiEditorPanel = new SmiEditorPanel(frame);
        this.smiEditorPanel.setConfig(config);
        this.splitPane = new JSplitPane(1);
        this.splitPane.add((Component)this.fileTable, "left");
        this.splitPane.add((Component)this.smiEditorPanel, "right");
        this.smiEditorPanel.setBackgroundChecksEnabled(true);
        this.splitPane.setDividerLocation(0.4);
        this.add((Component)this.splitPane, "Center");
        this.fileTable.setSelectionPolicy(2);
        this.fileTable.setVertSBDisplay(1);
        this.fileTable.setHorizSBDisplay(0);
        this.fileTable.setPixelWidth(-997, 33002);
        this.fileTable.setVisibleRows(30);
        this.fileTable.setRowLabelDisplay(false);
        this.fileTable.setVariableEstimateCount(110);
        this.fileTable.addSelectListener(new JCSelectListener(){

            @Override
            public void beforeSelect(JCSelectEvent jcSelectEvent) {
                jcSelectEvent.setCancelled(false);
            }

            @Override
            public void select(JCSelectEvent jcSelectEvent) {
                jcSelectEvent.setCancelled(false);
            }

            @Override
            public void afterSelect(JCSelectEvent jcSelectEvent) {
                JCTable s = (JCTable)jcSelectEvent.getSource();
                s.addRowSelection(jcSelectEvent.getStartRow(), jcSelectEvent.getEndRow());
                int row = TableUtils.getFirstSelectedRow(SmiParserLogPanel.this.fileTable);
                if (row < SmiParserLogPanel.this.compilationResults.size()) {
                    CompilationResult result = (CompilationResult)SmiParserLogPanel.this.compilationResults.get(row);
                    SmiParserLogPanel.this.updateEditor(result);
                }
            }
        });
    }

    private static byte[] getFileContent(InputStream inputStream) throws IOException {
        int read;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16535];
        while ((read = bis.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, read);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEditor(CompilationResult compilationResult) {
        String filePath = compilationResult.getFileName();
        InputStream is = null;
        try {
            if (compilationResult.getZipFileName() != null) {
                ZipEntry zipEntry;
                ZipInputStream zis = new ZipInputStream(new FileInputStream(compilationResult.getZipFileName()));
                is = zis;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    if (!zipEntry.getName().equals(compilationResult.getFileName())) continue;
                    is = zis;
                    break;
                }
            } else {
                is = new FileInputStream(filePath);
            }
            byte[] content = SmiParserLogPanel.getFileContent(is);
            is.close();
            int row = 1;
            int col = 1;
            int sel = 0;
            if (compilationResult.hasErrors()) {
                SmiError smiError = compilationResult.getSmiErrorList().get(0);
                row = smiError.getRow();
                col = smiError.getColumn();
                sel = smiError.getDefectiveText() != null ? smiError.getDefectiveText().length() : 1;
            }
            this.smiEditorPanel.setText(new String(content), row, col, sel);
        }
        catch (FileNotFoundException fnfe) {
            this.smiEditorPanel.setText("File '" + filePath + "' not found! Could not load SMI text.", 1, 1, 0);
        }
        catch (IOException iox) {
            this.smiEditorPanel.setText("Failed to load '" + filePath + "': " + iox.getMessage(), 1, 1, 0);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException fnfe) {}
            }
        }
        this.smiEditorPanel.setErrors(compilationResult, true, null);
    }

    public void setImporter(SmiCompiler compiler) {
        this.smiEditorPanel.setImporter(compiler);
    }

    public void setCompilationResults(List<CompilationResult> compilationResults) {
        this.compilationResults = compilationResults;
        this.reloadTable();
    }

    public List<CompilationResult> getCompilationResults() {
        return this.compilationResults;
    }

    public void reloadTable() {
        CompilationResultDataSource dataSource = new CompilationResultDataSource(this.compilationResults);
        this.fileTable.setDataSource(dataSource);
    }

    public static String toString(List<?> list, String separator) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            stringBuilder.append(it.next());
            if (!it.hasNext()) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

    protected class CompilationResultDataSource
    implements TableDataModel {
        private List<CompilationResult> data;

        public CompilationResultDataSource(List<CompilationResult> data) {
            this.data = data;
        }

        @Override
        public Object getTableDataItem(int row, int col) {
            CompilationResult result = this.data.get(row);
            if (result == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return new File(result.getFileName()).getName();
                }
                case 2: {
                    return result.hasErrors() && result.getSmiErrorList() != null ? result.getSmiErrorList().size() : 0;
                }
                case 3: {
                    return SmiParserLogPanel.toString(result.getModuleNames(), ", ");
                }
                case 4: {
                    return result.getZipFileName() != null ? result.getZipFileName() : new File(result.getFileName()).getParent();
                }
            }
            return null;
        }

        @Override
        public int getNumRows() {
            return this.data.size();
        }

        @Override
        public int getNumColumns() {
            return 4;
        }

        @Override
        public Object getTableRowLabel(int i2) {
            return i2 + 1;
        }

        @Override
        public Object getTableColumnLabel(int i2) {
            return COL_LABEL[i2];
        }

        @Override
        public void addTableDataListener(JCTableDataListener jcTableDataListener) {
        }

        @Override
        public void removeTableDataListener(JCTableDataListener jcTableDataListener) {
        }
    }
}

