/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib;

import com.agentpp.common.ProgressWatcher;
import com.agentpp.commons.ui.ComboBoxPopupFindAction;
import com.agentpp.commons.ui.PopupFindAction;
import com.agentpp.commons.ui.PopupSearchKeyListener;
import com.agentpp.mib.MIBModule;
import com.agentpp.repository.DefaultRepositoryManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MIBSelectionDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelCenter = new JPanel();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonSave = new JButton();
    JButton jButtonCancel = new JButton();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    DefaultRepositoryManager repMan = null;
    MIBModule[] availModules = new MIBModule[0];
    String result = null;
    Frame myFrame = null;
    JLabel jLabelSelectionText = new JLabel();
    JComboBox<String> jComboBoxModules = new JComboBox();
    Border border5;
    GridLayout gridLayout1 = new GridLayout();
    private List<String> exceptionList = new ArrayList<String>();
    private List<MIBModule> selectionList = null;
    private boolean initialized;

    public MIBSelectionDialog(DefaultRepositoryManager repMan, Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.myFrame = frame;
        this.repMan = repMan;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initialized = this.init();
    }

    public MIBSelectionDialog(List<MIBModule> selectionList, Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.myFrame = frame;
        this.selectionList = selectionList;
        this.repMan = null;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jComboBoxModules.removeAllItems();
        for (MIBModule mibModule : selectionList) {
            this.jComboBoxModules.addItem(mibModule.getModuleName());
        }
    }

    public MIBSelectionDialog(DefaultRepositoryManager repMan, Frame frame, String title, boolean modal, List<String> exceptionList) {
        super(frame, title, modal);
        this.exceptionList = exceptionList;
        this.myFrame = frame;
        this.repMan = repMan;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initialized = this.init();
    }

    public boolean init() {
        try {
            ProgressWatcher pw = new ProgressWatcher(this, "Scanning available MIB modules...");
            this.availModules = this.repMan.getModules(true, pw);
            pw.close();
            if (this.availModules == null) {
                return false;
            }
            this.jComboBoxModules.removeAllItems();
            for (MIBModule availModule : this.availModules) {
                if (this.exceptionList.contains(availModule.getModuleName())) continue;
                this.jComboBoxModules.addItem(availModule.getModuleName());
            }
            return true;
        }
        catch (IOException iox) {
            return false;
        }
    }

    public MIBSelectionDialog() {
        this(new DefaultRepositoryManager(), null, "", false);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), "Object Definition");
        this.border2 = BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), "Imported Modules"), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        this.titledBorder2 = new TitledBorder(this.border3, "Imported Objects ");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border5 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.panel1.setLayout(this.borderLayout1);
        this.jPanelSouth.setLayout(this.borderLayout2);
        this.jPanel1.setLayout(this.flowLayout1);
        this.jButtonSave.setText("OK");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MIBSelectionDialog.this.jButtonSave_actionPerformed(e2);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MIBSelectionDialog.this.jButtonCancel_actionPerformed(e2);
            }
        });
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(10);
        this.flowLayout1.setVgap(10);
        this.jPanelCenter.setLayout(this.gridLayout1);
        this.panel1.setPreferredSize(new Dimension(400, 140));
        this.jLabelSelectionText.setToolTipText("");
        this.jLabelSelectionText.setText("Please select a MIB module:");
        this.jComboBoxModules.setPreferredSize(new Dimension(250, 26));
        this.setModal(true);
        this.jPanelCenter.setBorder(this.border5);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setVgap(5);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jButtonSave, null);
        this.jPanel1.add((Component)this.jButtonCancel, null);
        this.panel1.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jLabelSelectionText, null);
        this.jPanelCenter.add(this.jComboBoxModules, null);
        this.getRootPane().setDefaultButton(this.jButtonSave);
        ComboBoxPopupFindAction findAction = new ComboBoxPopupFindAction(false);
        PopupFindAction.installActions(this.jComboBoxModules, new Action[]{new ComboBoxPopupFindAction(false), findAction});
        this.jComboBoxModules.addKeyListener(new PopupSearchKeyListener(findAction));
    }

    void jButtonSave_actionPerformed(ActionEvent e2) {
        this.result = (String)this.jComboBoxModules.getSelectedItem();
        this.dispose();
    }

    void jButtonCancel_actionPerformed(ActionEvent e2) {
        this.dispose();
    }

    public String getModule() {
        return this.result;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

