/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.velocity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class TemplateLoader
extends ResourceLoader {
    @Override
    public long getLastModified(Resource resource) {
        File file = new File(resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }

    @Override
    public void init(ExtProperties parm1) {
    }

    @Override
    public Reader getResourceReader(String name, String encoding) throws ResourceNotFoundException {
        Reader reader = this.findTemplate(name);
        if (reader == null) {
            throw new ResourceNotFoundException(name);
        }
        return reader;
    }

    private Reader findTemplate(String path) {
        try {
            File file = new File(path);
            if (file.canRead()) {
                return new BufferedReader(new FileReader(file));
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        File file = new File(resource.getName());
        if (file.canRead()) {
            return file.lastModified() != resource.getLastModified();
        }
        return true;
    }
}

