/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.print;

import com.agentpp.common.table.print.DocumentFlow;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTemplate;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.PageArea;
import com.klg.jclass.page.adobe.pdf.JCPDFPrinter;
import com.klg.jclass.page.adobe.postscript.JCPostScriptPrinter;
import com.klg.jclass.page.awt.JCAWTPreviewer;
import com.klg.jclass.page.awt.JCAWTPrinter;
import com.klg.jclass.page.awt.JCAWTScreenPrinter;
import com.klg.jclass.page.html.JCHTMLPrinter;
import com.klg.jclass.page.pcl.JCPCLPrinter;
import com.klg.jclass.util.swing.JCFontChooser;
import com.klg.jclass.util.swing.JCFontChooserPane;
import com.klg.jclass.util.swing.JCSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PrintActionPanel
extends JPanel {
    protected JCPrinter previewPrinter;
    protected JCPrinter flowPrinter;
    protected boolean landscape;
    static final Rectangle2D.Double letter = new Rectangle2D.Double(0.0, 0.0, 612.0, 792.0);
    static final Rectangle2D.Double legal = new Rectangle2D.Double(0.0, 0.0, 612.0, 1008.0);
    static final Rectangle2D.Double executive = new Rectangle2D.Double(0.0, 0.0, 522.0, 756.0);
    static final Rectangle2D.Double ledger = new Rectangle2D.Double(0.0, 0.0, 792.0, 1224.0);
    static final Rectangle2D.Double a4 = new Rectangle2D.Double(0.0, 0.0, 595.3, 841.9);
    static final Rectangle2D.Double a3 = new Rectangle2D.Double(0.0, 0.0, 841.9, 1190.6);
    protected Rectangle2D pageSize;
    static String template = "<?xml version=\"1.0\"?><!DOCTYPE JCPAGETEMPLATE SYSTEM \"JCPageTemplate.dtd\">\n<JCPAGETEMPLATE TITLE=\"8p5x11\">\n    <PAGE NAME=\"8p5x11\" UNIT=\"inches\">        <LOCATION X=\"0\" Y=\"0\"/>        <SIZE WIDTH=\"8.5\"  HEIGHT=\"11\"/>        <FRAME NAME=\"header\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"0.25\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"0.75\"/>        </FRAME>        <FRAME NAME=\"body\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"1\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"9\"/>        </FRAME>        <FRAME NAME=\"footer\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"10.25\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"0.75\"/>        </FRAME>        <FLOWFRAME NAME=\"body\"/>        <FLOWPAGE NAME=\"8p5x11\"/>        <FLOWSECTION NAME=\"8p5x11\"/>    </PAGE></JCPAGETEMPLATE>\n";
    protected static String DEFAULT_FILENAME = "Report";
    public static String[] OUTPUT_TYPES = new String[]{"PDF", "PS", "HTML", "PCL", "Printer", "Screen"};
    public static String[] PAPER_TYPES = new String[]{"Letter", "Legal", "Executive", "A4", "A3"};
    DocumentFlow documentFlow;
    PaperSizePanel paperSizePanel;
    ActionPanel actionPanel;
    FontPanel fontPanel;
    TablePanel tablePanel;
    JFrame myFrame;

    public PrintActionPanel() {
        this(new JFrame(), "Report", false, false);
    }

    public PrintActionPanel(JFrame f2, String fname) {
        this(f2, fname, true, true);
    }

    public PrintActionPanel(JFrame f2, String fname, boolean fontSelection, boolean tableSettings) {
        this.flowPrinter = this.previewPrinter = new JCAWTScreenPrinter();
        this.landscape = false;
        this.pageSize = letter;
        this.myFrame = f2;
        this.setLayout(new BorderLayout());
        JPanel p2 = new JPanel(new BorderLayout());
        this.paperSizePanel = new PaperSizePanel();
        p2.add((Component)this.paperSizePanel, "North");
        if (tableSettings) {
            this.tablePanel = new TablePanel();
            p2.add((Component)this.tablePanel, "South");
        }
        this.add((Component)p2, "North");
        if (fontSelection) {
            this.fontPanel = new FontPanel();
            this.add((Component)this.fontPanel, "Center");
        }
        this.actionPanel = new ActionPanel(fname);
        this.add((Component)this.actionPanel, "South");
    }

    public ActionPanel getActionPanel() {
        return this.actionPanel;
    }

    public void setDocumentFlow(DocumentFlow flow) {
        this.documentFlow = flow;
        JCFrame body = null;
        List templates = this.documentFlow.getTemplates();
        if (templates != null) {
            String name = this.documentFlow.getFlowPage();
            PageArea found = null;
            for (JCPage page : templates) {
                if (!page.getName().equals(name)) continue;
                found = page;
                break;
            }
            if (found != null) {
                try {
                    body = found.stringToFrame("body");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        JCSwingUtilities.setEnabled(this.paperSizePanel, body != null);
    }

    public DocumentFlow setDocumentFlow() {
        return this.documentFlow;
    }

    protected boolean printDocument(JCPrinter printer, boolean preview) {
        List templates;
        boolean toOutput = false;
        if (this.documentFlow == null) {
            System.out.println("No Document flow configured");
            return false;
        }
        if (this.fontPanel != null) {
            this.documentFlow.setDefaultFont(this.fontPanel.getSelectedFont());
        }
        if (this.tablePanel != null) {
            this.documentFlow.setFitToPage(this.tablePanel.isFitToPage());
            this.documentFlow.setWrapNextPage(this.tablePanel.isWrapNext());
        }
        if ((templates = this.documentFlow.getTemplates()) == null) {
            try {
                templates = JCPageTemplate.loadTemplates(new StringReader(template));
            }
            catch (Exception e2) {
                System.err.println("Error loading template = " + e2);
            }
        }
        JCDocument document = new JCDocument(printer, templates);
        JCPage page = document.stringToTemplate(this.documentFlow.getFlowPage());
        this.layoutDocument(document, page);
        this.documentFlow.flow(document, page);
        JCPrinter jCPrinter = this.flowPrinter = preview ? this.previewPrinter : printer;
        if (this.flowPrinter instanceof JCAWTScreenPrinter) {
            JCAWTPreviewer previewer = new JCAWTPreviewer("Print Preview", this.myFrame, document);
            try {
                previewer.setVisible(true);
            }
            catch (IllegalArgumentException iex) {
                JOptionPane.showMessageDialog(this, "Could not write to output file!", "I/O Error", 0);
            }
        } else {
            document.print();
            toOutput = true;
        }
        return toOutput;
    }

    protected void layoutDocument(JCDocument document, JCPage template) {
        JCUnit.Point point;
        JCUnit.Dimension box;
        boolean gotHeader = false;
        boolean gotFooter = false;
        JCUnit.Dimension pageDimension = this.getPageDimensions(this.landscape, this.pageSize);
        template.setSize(pageDimension);
        JCFrame headerFrame = null;
        try {
            headerFrame = template.stringToFrame("header");
            gotHeader = headerFrame != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gotHeader) {
            box = new JCUnit.Dimension(JCUnit.INCHES, pageDimension.getWidth().getAs(JCUnit.INCHES) - 2.0, 0.75);
            headerFrame.setSize(box);
        }
        JCFrame footerFrame = null;
        try {
            footerFrame = template.stringToFrame("footer");
            gotFooter = footerFrame != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gotFooter) {
            box = new JCUnit.Dimension(JCUnit.INCHES, pageDimension.getWidth().getAs(JCUnit.INCHES) - 2.0, 0.75);
            footerFrame.setSize(box);
            point = new JCUnit.Point(JCUnit.INCHES, 1.0, pageDimension.getHeight().getAs(JCUnit.INCHES) - 0.75);
            footerFrame.setLocation(point);
        }
        JCFrame frameTemplate = null;
        try {
            frameTemplate = template.stringToFrame("body");
            int leeway = 0;
            if (gotHeader) {
                point = new JCUnit.Point(JCUnit.INCHES, 1.0, 1.0);
                frameTemplate.setLocation(point);
                ++leeway;
            }
            if (gotFooter) {
                ++leeway;
            }
            box = new JCUnit.Dimension(JCUnit.INCHES, pageDimension.getWidth().getAs(JCUnit.INCHES) - 2.0, pageDimension.getHeight().getAs(JCUnit.INCHES) - (double)leeway);
            frameTemplate.setSize(box);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JCUnit.Dimension getPageDimensions(boolean landscape, Rectangle2D pageSize) {
        JCUnit.Dimension pageDimension = new JCUnit.Dimension();
        pageDimension = landscape ? new JCUnit.Dimension(JCUnit.POINTS, pageSize.getHeight(), pageSize.getWidth()) : new JCUnit.Dimension(JCUnit.POINTS, pageSize.getWidth(), pageSize.getHeight());
        return pageDimension;
    }

    public class ActionPanel
    extends JPanel
    implements ActionListener {
        protected JComboBox comboBox;
        protected JTextField nameField;
        protected JLabel messageField;
        protected String selectedType = OUTPUT_TYPES[0];
        protected String fileName = DEFAULT_FILENAME;

        public ActionPanel() {
            this(DEFAULT_FILENAME);
        }

        public ActionPanel(String fname) {
            this.setLayout(new BorderLayout());
            JPanel controls = new JPanel();
            controls.setBorder(new TitledBorder("Output Options"));
            controls.add(new JLabel(" Output Type:"));
            this.comboBox = new JComboBox<String>(OUTPUT_TYPES);
            this.comboBox.addActionListener(this);
            controls.add(this.comboBox);
            JButton button = new JButton("Preview");
            controls.add(button);
            button.addActionListener(this);
            controls.add(new JLabel(" File:"));
            if (fname == null) {
                fname = this.fileName;
            }
            this.nameField = new JTextField(fname, 8);
            controls.add(this.nameField);
            this.add("North", new JLabel(" "));
            this.add("Center", controls);
            this.messageField = new JLabel(" ");
            this.add("South", this.messageField);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCPrinter printer = null;
            String command = event.getActionCommand();
            boolean toOutput = false;
            int typeIndex = this.comboBox.getSelectedIndex();
            this.selectedType = OUTPUT_TYPES[typeIndex];
            if (PrintActionPanel.this.flowPrinter instanceof JCAWTPrinter) {
                ((JCAWTPrinter)PrintActionPanel.this.flowPrinter).cancel();
            }
            if (command.equals("Preview") || command.equals("Print")) {
                printer = this.getPrinter(this.nameField.getText());
            }
            if (printer != null) {
                toOutput = PrintActionPanel.this.printDocument(printer, command.equals("Preview"));
            }
            if (toOutput) {
                this.nameField.setText(this.fileName);
                this.messageField.setText(" Wrote output to: " + this.fileName);
                try {
                    printer.getOutputStream().flush();
                    printer.getOutputStream().close();
                }
                catch (IOException iOException) {}
            } else {
                this.messageField.setText(" ");
                try {
                    if (printer != null) {
                        printer.getOutputStream().close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected JCPrinter getPrinter(String name) {
            JCPrinter printer = null;
            int dotIndex = name.lastIndexOf(".");
            if (dotIndex > 0) {
                name = name.substring(0, dotIndex);
            }
            if (this.selectedType.equals("PDF")) {
                this.fileName = name + ".pdf";
                try {
                    printer = new JCPDFPrinter(new FileOutputStream(this.fileName));
                }
                catch (IOException iOException) {}
            } else if (this.selectedType.equals("PS")) {
                this.fileName = name + ".ps";
                try {
                    printer = new JCPostScriptPrinter(new FileOutputStream(this.fileName));
                }
                catch (IOException iOException) {}
            } else if (this.selectedType.equals("PCL")) {
                this.fileName = name + ".pcl";
                try {
                    printer = new JCPCLPrinter(new FileOutputStream(this.fileName));
                }
                catch (IOException iOException) {}
            } else if (this.selectedType.equals("HTML")) {
                this.fileName = name + ".html";
                try {
                    printer = new JCHTMLPrinter(new FileOutputStream(this.fileName));
                }
                catch (IOException iOException) {}
            } else if (this.selectedType.equals("Printer")) {
                JCAWTPrinter tempPrinter = null;
                Paper p2 = new Paper();
                p2.setImageableArea(PrintActionPanel.this.pageSize.getX(), PrintActionPanel.this.pageSize.getY(), PrintActionPanel.this.pageSize.getWidth(), PrintActionPanel.this.pageSize.getHeight());
                PageFormat pf = new PageFormat();
                pf.setPaper(p2);
                try {
                    tempPrinter = new JCAWTPrinter(pf);
                }
                catch (JCAWTPrinter.PrinterJobCancelledException e2) {
                    e2.printStackTrace();
                }
                catch (PrinterException pe) {
                    pe.printStackTrace();
                }
                printer = tempPrinter;
            } else if (this.selectedType.equals("Screen")) {
                printer = PrintActionPanel.this.previewPrinter;
            }
            return printer;
        }
    }

    class PaperSizePanel
    extends JPanel
    implements ActionListener {
        protected JComboBox paperCombo;

        public PaperSizePanel() {
            this.setBorder(new TitledBorder("Page Options"));
            this.add(new JLabel(" Paper:"));
            this.paperCombo = new JComboBox<String>(PAPER_TYPES);
            this.paperCombo.addActionListener(this);
            this.add(this.paperCombo);
            this.add(new JLabel(" Orientation:"));
            ButtonGroup group = new ButtonGroup();
            JRadioButton button = new JRadioButton("Portrait");
            group.add(button);
            this.add(button);
            button.setSelected(true);
            button.addActionListener(this);
            button = new JRadioButton("Landscape");
            group.add(button);
            this.add(button);
            button.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("Portrait")) {
                PrintActionPanel.this.landscape = false;
            } else if (command.equals("Landscape")) {
                PrintActionPanel.this.landscape = true;
            } else {
                int typeIndex = this.paperCombo.getSelectedIndex();
                String selectedType = PAPER_TYPES[typeIndex];
                if (selectedType.equals("Letter")) {
                    PrintActionPanel.this.pageSize = letter;
                } else if (selectedType.equals("Legal")) {
                    PrintActionPanel.this.pageSize = legal;
                } else if (selectedType.equals("Executive")) {
                    PrintActionPanel.this.pageSize = executive;
                } else if (selectedType.equals("A4")) {
                    PrintActionPanel.this.pageSize = a4;
                } else if (selectedType.equals("A3")) {
                    PrintActionPanel.this.pageSize = a3;
                }
            }
        }
    }

    class FontPanel
    extends JPanel {
        protected JCFontChooser fontChooser;

        public FontPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder("Font"));
            this.fontChooser = new JCFontChooserPane(new Font("TimesRoman", 0, 10));
            this.add((Component)this.fontChooser, "Center");
        }

        public Font getSelectedFont() {
            return this.fontChooser.getSelectedFont();
        }
    }

    class TablePanel
    extends JPanel {
        protected JCheckBox fitToPage = new JCheckBox("Fit table to page", true);
        protected JCheckBox wrapNext = new JCheckBox("Wrap Columns on Next Page", true);

        public TablePanel() {
            this.setLayout(new FlowLayout());
            this.setBorder(new TitledBorder("Tables"));
            this.add(this.fitToPage);
            this.add(this.wrapNext);
        }

        public boolean isFitToPage() {
            return this.fitToPage.isSelected();
        }

        public boolean isWrapNext() {
            return this.wrapNext.isSelected();
        }
    }
}

