/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.klg.jclass.table.JCResizeCellEvent;
import com.klg.jclass.table.JCResizeCellMotionListener;
import com.klg.jclass.table.JCTable;

public class JTableColumnResizeEmulator
implements JCResizeCellMotionListener {
    public static final int OFF = 0;
    public static final int NEXT_COLUMN = 1;
    public static final int SUBSEQUENT_COLUMNS = 2;
    public static final int LAST_COLUMN = 3;
    public static final int ALL_COLUMNS = 4;
    private int autoResizeMode = 0;
    private JCTable table;
    private int resizedColumn;
    private int tableColumns;
    private int oldWidth;
    private int newWidth;
    private int minWidth;
    private int widthChange;
    private int adjustmentColumns;
    private int columnAdjustment;
    private int leftoverAdjustment;
    private int leftoverStartColumn;
    private int[] adjustedWidths;

    public JTableColumnResizeEmulator(int mode) {
        this.setAutoResizeMode(mode);
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setAutoResizeMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.autoResizeMode = mode;
            }
        }
    }

    @Override
    public void resizeCellDragged(JCResizeCellEvent ev) {
        int j2;
        int i2;
        if (this.autoResizeMode == 0) {
            return;
        }
        this.resizedColumn = ev.getColumn();
        if (this.resizedColumn == -999) {
            return;
        }
        this.table = (JCTable)ev.getSource();
        this.tableColumns = this.table.getNumColumns();
        if (this.table.isResizeEven()) {
            return;
        }
        if (this.autoResizeMode != 4) {
            for (i2 = this.tableColumns - 1; i2 >= this.resizedColumn; --i2) {
                if (this.resizedColumn == i2) {
                    return;
                }
                if (!this.table.isColumnHidden(i2)) break;
            }
        }
        this.oldWidth = this.table.getColumnPixelWidth(this.resizedColumn);
        this.newWidth = ev.getNewColumnWidth();
        this.widthChange = this.newWidth - this.oldWidth;
        if (this.widthChange == 0) {
            return;
        }
        this.adjustedWidths = new int[this.tableColumns];
        switch (this.autoResizeMode) {
            case 1: {
                int i3;
                this.adjustmentColumns = 1;
                boolean done = false;
                for (i3 = 0; i3 < this.tableColumns; ++i3) {
                    this.adjustedWidths[i3] = this.table.getColumnPixelWidth(i3);
                    if (i3 <= this.resizedColumn || done || this.table.isColumnHidden(i3) || this.widthChange > 0 && this.adjustedWidths[i3] <= this.table.getMinWidth(i3)) {
                        this.adjustedWidths[i3] = 0;
                        continue;
                    }
                    done = true;
                }
                if (done) break;
                return;
            }
            case 2: {
                this.adjustmentColumns = this.tableColumns;
                for (i2 = 0; i2 < this.tableColumns; ++i2) {
                    this.adjustedWidths[i2] = this.table.getColumnPixelWidth(i2);
                    if (i2 > this.resizedColumn && !this.table.isColumnHidden(i2) && (this.widthChange <= 0 || this.adjustedWidths[i2] > this.table.getMinWidth(i2))) continue;
                    this.adjustedWidths[i2] = 0;
                    --this.adjustmentColumns;
                }
                if (this.adjustmentColumns != 0) break;
                return;
            }
            case 3: {
                int i3;
                this.adjustmentColumns = 1;
                boolean done = false;
                for (i3 = this.tableColumns - 1; i3 >= 0; --i3) {
                    this.adjustedWidths[i3] = this.table.getColumnPixelWidth(i3);
                    if (i3 <= this.resizedColumn || done || this.table.isColumnHidden(i3) || this.widthChange > 0 && this.adjustedWidths[i3] <= this.table.getMinWidth(i3)) {
                        this.adjustedWidths[i3] = 0;
                        continue;
                    }
                    done = true;
                }
                if (done) break;
                return;
            }
            case 4: {
                this.adjustmentColumns = this.tableColumns;
                for (i2 = 0; i2 < this.tableColumns; ++i2) {
                    this.adjustedWidths[i2] = this.table.getColumnPixelWidth(i2);
                    if (i2 != this.resizedColumn && !this.table.isColumnHidden(i2) && (this.widthChange <= 0 || this.adjustedWidths[i2] > this.table.getMinWidth(i2))) continue;
                    this.adjustedWidths[i2] = 0;
                    --this.adjustmentColumns;
                }
                if (this.adjustmentColumns != 0) break;
                return;
            }
        }
        this.columnAdjustment = this.widthChange / this.adjustmentColumns;
        this.leftoverAdjustment = this.widthChange % this.adjustmentColumns;
        block15: for (i2 = 0; i2 < this.adjustedWidths.length; ++i2) {
            if (this.adjustedWidths[i2] == 0) continue;
            int n2 = i2;
            this.adjustedWidths[n2] = this.adjustedWidths[n2] - this.columnAdjustment;
            this.minWidth = this.table.getMinWidth(i2);
            if (this.adjustedWidths[i2] < this.minWidth) {
                this.leftoverAdjustment += this.minWidth - this.adjustedWidths[i2];
                this.adjustedWidths[i2] = this.minWidth;
            }
            if (this.leftoverAdjustment <= 0) continue;
            switch (this.autoResizeMode) {
                case 1: {
                    j2 = 1;
                    while (i2 + j2 < this.adjustedWidths.length) {
                        if (!this.table.isColumnHidden(i2 + j2)) {
                            this.adjustedWidths[i2 + j2] = this.table.getColumnPixelWidth(i2 + j2);
                            this.columnAdjustment = this.leftoverAdjustment;
                            break;
                        }
                        ++j2;
                    }
                    this.leftoverAdjustment = 0;
                    continue block15;
                }
                case 3: {
                    j2 = 1;
                    while (i2 - j2 > this.resizedColumn && this.adjustedWidths[i2 - j2] == 0) {
                        if (!this.table.isColumnHidden(i2 - j2)) {
                            this.adjustedWidths[i2 - j2] = this.table.getColumnPixelWidth(i2 - j2);
                            this.columnAdjustment = this.leftoverAdjustment;
                            i2 -= j2 + 1;
                            break;
                        }
                        ++j2;
                    }
                    this.leftoverAdjustment = 0;
                }
            }
        }
        if (this.leftoverAdjustment != 0) {
            i2 = this.leftoverStartColumn = (int)(Math.random() * (double)this.tableColumns) % this.tableColumns;
            j2 = this.leftoverStartColumn % this.adjustedWidths.length;
            while (i2 < this.adjustedWidths.length + this.leftoverStartColumn && this.leftoverAdjustment != 0) {
                if (this.adjustedWidths[j2] != 0) {
                    if (this.leftoverAdjustment > 0) {
                        if (this.adjustedWidths[j2] > this.table.getMinWidth(j2)) {
                            int n3 = j2;
                            this.adjustedWidths[n3] = this.adjustedWidths[n3] - 1;
                            --this.leftoverAdjustment;
                        }
                    } else if (this.leftoverAdjustment < 0) {
                        int n4 = j2;
                        this.adjustedWidths[n4] = this.adjustedWidths[n4] + 1;
                        ++this.leftoverAdjustment;
                    }
                }
                j2 = ++i2 % this.adjustedWidths.length;
            }
        }
        for (i2 = 0; i2 < this.adjustedWidths.length; ++i2) {
            if (this.adjustedWidths[i2] == 0) continue;
            this.table.setPixelWidth(i2, this.adjustedWidths[i2]);
        }
    }
}

