/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.font.FontStyle;
import com.agentpp.common.font.FontStylePanel;
import com.agentpp.common.smi.editor.SmiContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SyntaxHighlightingConfigPanel
extends JPanel
implements TreeSelectionListener {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTree tree = new JTree();
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Options");
    private DefaultTreeModel model = new DefaultTreeModel(this.root);
    private JPanel panel = new JPanel();
    private JPanel cardPanel = new JPanel();
    private JPanel generalPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel jLabelDescr = new JLabel();
    private JLabel currentLabel;
    private FontStylePanel fontStyle = new FontStylePanel();
    private CardLayout cardLayout = new CardLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox enabled = new JCheckBox();
    private static final String GENERAL = "General";
    JLabel jLabelDefaults = new JLabel();
    JButton jButtonDefaults = new JButton();

    public SyntaxHighlightingConfigPanel() {
        this.initTree();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.cardLayout.show(this.cardPanel, GENERAL);
        this.tree.addTreeSelectionListener(this);
    }

    private void initTree() {
        Vector v = SmiContext.getDefaultStyles();
        for (int i2 = 0; i2 < v.size(); ++i2) {
            FontStyle fs = (FontStyle)v.elementAt(i2);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fs);
            this.model.insertNodeInto(node, this.root, i2);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tree.setModel(this.model);
        this.panel.setLayout(this.gridBagLayout1);
        this.currentLabel = new JLabel("General Options");
        this.currentLabel.setHorizontalAlignment(2);
        this.currentLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        this.generalPanel.setLayout(this.gridBagLayout2);
        this.enabled.setHorizontalTextPosition(11);
        this.enabled.setText("Enable syntax highlighting in MIB file editor");
        this.jLabelDefaults.setText("Set default colors and text styles:");
        this.jButtonDefaults.setText("Set Defaults");
        this.jButtonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SyntaxHighlightingConfigPanel.this.jButtonDefaults_actionPerformed(e2);
            }
        });
        this.generalPanel.add((Component)this.currentLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.1, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.generalPanel.add((Component)this.enabled, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.1, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.generalPanel.add((Component)this.jLabelDefaults, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.8, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.jLabelDescr.setText("Font Style For Selected Category");
        this.jLabelDescr.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        this.add((Component)this.tree, "West");
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)this.generalPanel, GENERAL);
        this.cardPanel.add((Component)this.panel, "FontStyle");
        this.add((Component)this.cardPanel, "Center");
        this.panel.add((Component)this.jLabelDescr, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.panel.add((Component)this.fontStyle, new GridBagConstraints(0, 1, 1, 1, 0.8, 1.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.generalPanel.add((Component)this.jButtonDefaults, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.8, 18, 0, new Insets(5, 10, 5, 10), 0, 0));
    }

    public final void setFontStyles(Vector v) {
        for (int i2 = 0; i2 < v.size() && i2 < SmiContext.STYLE_CLASS_NAMES.length; ++i2) {
            FontStyle fs = (FontStyle)v.elementAt(i2);
            fs.setName(SmiContext.STYLE_CLASS_NAMES[i2]);
            ((DefaultMutableTreeNode)this.root.getChildAt(i2)).setUserObject(fs);
        }
    }

    public final Vector getFontStyles() {
        this.tree.clearSelection();
        Vector<Object> v = new Vector<Object>(this.root.getChildCount());
        for (int i2 = 0; i2 < this.root.getChildCount(); ++i2) {
            v.add(((DefaultMutableTreeNode)this.root.getChildAt(i2)).getUserObject());
        }
        return v;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        FontStyle fs2;
        DefaultMutableTreeNode node;
        TreePath p2 = e2.getOldLeadSelectionPath();
        if (p2 != null) {
            try {
                node = (DefaultMutableTreeNode)p2.getLastPathComponent();
                fs2 = this.fontStyle.getFontStyle();
                fs2.setName(((FontStyle)node.getUserObject()).getName());
                node.setUserObject(fs2);
            }
            catch (ClassCastException fs2) {
                // empty catch block
            }
        }
        try {
            p2 = e2.getNewLeadSelectionPath();
            if (p2 == null) {
                return;
            }
            node = (DefaultMutableTreeNode)p2.getLastPathComponent();
            fs2 = (FontStyle)node.getUserObject();
            this.fontStyle.setFontStyle(fs2);
            this.cardLayout.show(this.cardPanel, "FontStyle");
        }
        catch (ClassCastException ex) {
            this.cardLayout.show(this.cardPanel, GENERAL);
        }
    }

    public void setSyntaxHighlighting(boolean syntaxHighlighting) {
        this.enabled.setSelected(syntaxHighlighting);
    }

    public boolean isSyntaxHighlighting() {
        return this.enabled.isSelected();
    }

    void jButtonDefaults_actionPerformed(ActionEvent e2) {
        this.setFontStyles(SmiContext.getDefaultStyles());
    }
}

