/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.Token;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.smiparser.SMIParserTokenManager;
import com.agentpp.smiparser.SimpleCharStream;
import com.agentpp.smiparser.TokenMgrError;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class SmiDocument
extends PlainDocument {
    private boolean updated;

    public SmiDocument() {
        super(new GapContent(65535));
    }

    public Scanner createScanner() {
        Scanner s;
        try {
            s = new Scanner();
        }
        catch (IOException e2) {
            s = null;
        }
        return s;
    }

    public int getLineOfOffset(int offset) {
        return super.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineLength(int line) {
        Element l2 = super.getDefaultRootElement().getElement(line);
        return l2.getEndOffset() - l2.getStartOffset();
    }

    public int getLineCount() {
        return super.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getStartOffset();
    }

    public int getLineEndOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getEndOffset();
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (chng.getOffset() + chng.getLength() + 1 < chng.getDocument().getEndPosition().getOffset()) {
            this.updated = true;
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        this.updated = true;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    class DocumentInputStream
    extends InputStream {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentInputStream(int p0, int p1) {
            this.p0 = p0;
            this.p1 = Math.min(SmiDocument.this.getLength(), p1);
            this.pos = p0;
            try {
                this.loadSegment();
            }
            catch (IOException ioe) {
                throw new Error("unexpected: " + ioe);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        void loadSegment() throws IOException {
            try {
                int n2 = Math.min(4096, this.p1 - this.pos);
                SmiDocument.this.getText(this.pos, n2, this.segment);
                this.pos += n2;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e2) {
                throw new IOException("Bad location");
            }
        }
    }

    public class Scanner {
        private SMIParserTokenManager tokenManager;
        private SimpleCharStream stream;
        private Token[] tokens;
        private com.agentpp.smiparser.Token lastToken;
        private com.agentpp.smiparser.Token specialToken;
        private TreeSet<Integer> tokenStarts = new TreeSet();
        int p0;

        Scanner() throws IOException {
            this.setupHash();
            this.stream = new SimpleCharStream(new DocumentInputStream(0, SmiDocument.this.getLength()));
            this.tokenManager = new SMIParserTokenManager(this.stream);
        }

        private void setupHash() {
            this.tokens = new Token[SMIParserConstants.tokenImage.length];
            block0: for (int i2 = 0; i2 < this.tokens.length; ++i2) {
                for (int j2 = 0; j2 < Token.all.length; ++j2) {
                    if (Token.all[j2].getScanValue() != i2) continue;
                    this.tokens[i2] = Token.all[j2];
                    continue block0;
                }
            }
        }

        public void setRange(int p0, int p1) throws IOException {
            this.stream = new SimpleCharStream(new DocumentInputStream(p0, p1), 0, 0, 4096, p0);
            this.tokenManager.ReInit(this.stream);
            this.lastToken = null;
            this.specialToken = null;
            this.p0 = p0;
            Integer i0 = new Integer(p0);
            this.tokenStarts.tailSet(i0).clear();
        }

        public final int getEndOffset() {
            if (this.lastToken == null) {
                this.getNextToken();
                if (this.lastToken == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this.specialToken != null) {
                return this.specialToken.endPos;
            }
            return this.lastToken.endPos;
        }

        public int getTokenLength() {
            return this.getEndOffset() - this.getBeginOffset();
        }

        public final int getBeginOffset() {
            if (this.lastToken == null) {
                this.getNextToken();
                if (this.lastToken == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this.specialToken != null) {
                return this.specialToken.endPos - this.specialToken.image.length();
            }
            return this.lastToken.endPos - this.lastToken.image.length();
        }

        public final Token getToken() {
            if (this.lastToken == null) {
                return this.getNextToken();
            }
            Token t = this.specialToken != null ? this.tokens[this.specialToken.kind] : this.tokens[this.lastToken.kind];
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }

        private void putPosition(int pos) {
            Integer p2 = new Integer(pos);
            this.tokenStarts.add(p2);
        }

        public int getScannerStart(int p2) {
            Integer floor = this.tokenStarts.floor(p2);
            if (floor == null) {
                return 0;
            }
            return floor;
        }

        public int getScannerEnd(int p2) {
            Integer ceiling = this.tokenStarts.ceiling(p2);
            if (ceiling == null) {
                return Math.min(SmiDocument.this.getLength(), p2 + 65535);
            }
            return Math.min(SmiDocument.this.getLength(), ceiling + 65535);
        }

        public final Token getNextToken() {
            Token t = null;
            if (this.specialToken != null) {
                t = this.tokens[this.specialToken.kind];
                this.specialToken = this.specialToken.next;
                return t;
            }
            try {
                this.lastToken = this.tokenManager.getNextToken();
                this.specialToken = this.lastToken.specialToken;
                if (this.specialToken != null) {
                    while (this.specialToken.specialToken != null) {
                        this.specialToken = this.specialToken.specialToken;
                    }
                    t = this.tokens[this.specialToken.kind];
                } else {
                    t = this.tokens[this.lastToken.kind];
                }
                this.putPosition(this.lastToken.endPos - this.lastToken.image.length());
            }
            catch (TokenMgrError error) {
                this.lastToken = null;
                return Token.ERROR;
            }
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }
    }
}

