/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi;

import com.agentpp.common.MIBCompiler;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.io.FileFilterPanel;
import com.agentpp.common.smi.ExtractSMI;
import com.agentpp.util.ThreadPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class SmiFromRfcExtractor {
    public static void main(String[] args) {
        SmiFromRfcExtractor smifromrfcextractor = new SmiFromRfcExtractor();
    }

    public static String[] extractGUI(JFrame frame, String sourcePath, String targetPath, int minSkipLines) {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        JSlider minSkipRows = new JSlider(1, 10);
        minSkipRows.setSnapToTicks(true);
        minSkipRows.setPaintTicks(true);
        minSkipRows.setPaintLabels(true);
        minSkipRows.setMajorTickSpacing(1);
        JLabel minSkipRowsLabel = new JLabel("Minium number of page break rows:");
        minSkipRows.setValue(minSkipLines);
        optionsPanel.add((Component)minSkipRowsLabel, "North");
        optionsPanel.add((Component)minSkipRows, "Center");
        FileFilterPanel ffp = new FileFilterPanel(optionsPanel);
        ffp.getSourceFilePanel().setPath(sourcePath);
        ffp.getTargetFilePanel().setPath(targetPath);
        ffp.getSourceFilePanel().setToolTipText("File or directory with RFC files to extract SMI modules from");
        ffp.getSourceFilePanel().setLabelText("Source RFC File or Directory:");
        ffp.getTargetFilePanel().setLabelText("Target SMI File or Directory:");
        ffp.getTargetFilePanel().setToolTipText("File or directory with where to store extracted SMI files");
        StandardDialog sd = new StandardDialog((Frame)frame, "Extract SMI Modules from RFC Files", true, true);
        sd.setPreferredSize(new Dimension(600, 400));
        sd.setCenterPanel(ffp);
        sd.setLocationRelativeTo(frame);
        sd.setVisible(true);
        if (sd.getResult() == 0 && ffp.getSourcePath() != null) {
            minSkipLines = minSkipRows.getValue();
            File source = new File(ffp.getSourcePath());
            File target = new File(ffp.getTargetPath() == null ? source.getPath() + File.separator + ".smi" : ffp.getTargetPath());
            if (source.exists() && target.getParentFile() != null && target.getParentFile().exists()) {
                ArrayList<File> files = new ArrayList<File>();
                if (source.isDirectory()) {
                    FileFilter fileFilter = new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.canRead();
                        }
                    };
                    File[] fileArray = source.listFiles(fileFilter);
                    if (fileArray != null) {
                        files.addAll(Arrays.asList(fileArray));
                    }
                } else {
                    files.add(source);
                }
                ProgressMonitor pm = null;
                if (frame != null) {
                    pm = new ProgressMonitor(frame, "Extracting SMI text...", ((File)files.get(0)).getPath(), 0, files.size());
                }
                int j2 = 0;
                int[] count = new int[2];
                ThreadPool threadPool = ThreadPool.create("RFC-Extractor", Runtime.getRuntime().availableProcessors());
                threadPool.setRespawnThreads(false);
                for (File f2 : files) {
                    if (frame != null) {
                        SwingUtilities.invokeLater(new MIBCompiler.ProgressUpdater(pm, j2++, f2.getPath()));
                        if (pm.isCanceled() || count[1] > 0) break;
                    }
                    File tf = null;
                    if (target.isDirectory()) {
                        tf = new File(target, f2.getName());
                        int suffix = -1;
                        while (tf.exists() && suffix++ < 1000) {
                            tf = new File(target, f2.getName() + (suffix > 0 ? "-" + suffix : "") + ".smi");
                        }
                    } else {
                        tf = target;
                    }
                    FileOutputStream fos = null;
                    try {
                        if (!tf.exists()) {
                            count[0] = count[0] + 1;
                        }
                        fos = new FileOutputStream(tf, tf.exists());
                        PrintStream ps = new PrintStream(fos);
                        FileInputStream fis = new FileInputStream(f2);
                        ExtractSMI extractor = new ExtractSMI(fis, ps, minSkipLines, 12);
                        Extraction extraction = new Extraction(frame, extractor, fos, tf, count);
                        threadPool.execute(extraction);
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(frame, new String[]{"File not found: " + ex.getMessage()}, "File Not Found", 0);
                        break;
                    }
                }
                threadPool.stop();
                if (pm != null) {
                    SwingUtilities.invokeLater(new MIBCompiler.EventTrigger(pm));
                }
                JOptionPane.showMessageDialog(frame, new String[]{"Read " + j2 + " file" + (j2 != 1 ? "s" : "") + " and created " + count[0] + " file" + (count[0] != 1 ? "s" : "") + " in", target.getPath()}, "SMI Extraction Finished", 1);
                return new String[]{source.getPath(), target.getPath(), "" + minSkipLines};
            }
            JOptionPane.showMessageDialog(frame, new String[]{"Source or target file does not exists!", "Nothing to do."}, "File Not Found", 2);
        }
        return null;
    }

    private static class Extraction
    implements Runnable {
        private JFrame frame;
        private ExtractSMI extractSMI;
        private FileOutputStream fileOutputStream;
        private File target;
        private volatile int[] count;

        public Extraction(JFrame frame, ExtractSMI extractSMI, FileOutputStream fileOutputStream, File target, int[] count) {
            this.frame = frame;
            this.extractSMI = extractSMI;
            this.fileOutputStream = fileOutputStream;
            this.target = target;
            this.count = count;
        }

        @Override
        public void run() {
            this.extractSMI.run();
            try {
                this.extractSMI.getInputStream().close();
                this.fileOutputStream.close();
            }
            catch (IOException iox) {
                JOptionPane.showMessageDialog(this.frame, new String[]{"IO exception: " + iox.getMessage()}, "IO Error", 0);
                this.count[1] = this.count[1] + 1;
            }
            this.extractSMI.getOutputStream().close();
            if (this.target.length() == 0L && this.target.delete()) {
                this.count[0] = this.count[0] - 1;
            }
        }
    }
}

