/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class ExtractSMI
implements Runnable {
    private InputStream is;
    private PrintStream os;
    private int maxSkip = 12;
    private int minSkip = 8;

    public ExtractSMI(InputStream is, PrintStream os) {
        this(is, os, 8, 12);
    }

    public ExtractSMI(InputStream is, PrintStream os, int minSkipping, int maxSkipping) {
        this.is = is;
        this.os = os;
        this.minSkip = minSkipping;
        this.maxSkip = maxSkipping;
    }

    public static void main(String[] args) {
        try {
            ExtractSMI extractsmi = new ExtractSMI(new FileInputStream(args[0]), System.out);
            extractsmi.run();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        ArrayList<String> emptyLines = new ArrayList<String>();
        Scanner scanner = new Scanner(this.is);
        scanner.useDelimiter("[\n,\r]");
        String moduleBegin = null;
        while ((moduleBegin = scanner.findWithinHorizon("[A-Za-z0-9-]*[\\s]+(PIB-)?DEFINITIONS[\\s]+(::=)?[\\s]*BEGIN", 0)) != null) {
            this.os.println(moduleBegin);
            int skipping = 0;
            int inMacro = 0;
            while (inMacro > 0 || !scanner.hasNext("[\\s]*END[\\s]*")) {
                String nextLine;
                if (inMacro > 0 && scanner.hasNext("[\\s]*END[\\s]*")) {
                    skipping = 0;
                    --inMacro;
                    scanner.nextLine();
                    continue;
                }
                if (skipping > 0 && scanner.hasNext("[\\s]*RFC\\s.*")) {
                    skipping = 0;
                    emptyLines.clear();
                    scanner.nextLine();
                    continue;
                }
                String pageBreak = scanner.findInLine(".*\\[[pP]age [iv0-9]*\\].*");
                if (pageBreak != null) {
                    emptyLines.clear();
                    skipping = 1;
                } else {
                    String macro = scanner.findInLine("[A-Za-z0-9-]*[\\s]+MACRO[\\s]+::=");
                    if (macro != null) {
                        ++inMacro;
                        skipping = 0;
                        continue;
                    }
                }
                try {
                    nextLine = scanner.nextLine();
                }
                catch (NoSuchElementException nse) {
                    return;
                }
                if (inMacro > 0) continue;
                if (skipping > 0) {
                    if (++skipping > this.maxSkip) {
                        skipping = 0;
                        emptyLines.clear();
                        this.appendBufferText(emptyLines, nextLine);
                        continue;
                    }
                    if (nextLine.matches("[\\s]*")) {
                        emptyLines.add(nextLine);
                        continue;
                    }
                    if (skipping <= this.minSkip) continue;
                    emptyLines.clear();
                    skipping = 0;
                    this.appendBufferText(emptyLines, nextLine);
                    continue;
                }
                this.os.println(nextLine);
            }
            String moduleEnd = scanner.findWithinHorizon("[\\s]*END[\\s]*", 0);
            this.os.println(moduleEnd);
        }
    }

    private void appendBufferText(List<String> emptyLines, String nextLine) {
        for (String line : emptyLines) {
            this.os.println(line);
        }
        emptyLines.clear();
        this.os.println(nextLine);
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public PrintStream getOutputStream() {
        return this.os;
    }
}

