/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.setup;

import com.agentpp.common.ConfirmCallback;
import com.agentpp.repository.ProgressCallback;
import com.agentpp.util.BaseConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JARInstaller {
    private static final int BUFFER_SIZE = 65535;
    private static final String SHA_256_DIGEST_ATTR_NAME = "SHA-256-Digest";
    private BaseConfig config;
    private String propertyPrefix;
    private ClassLoader classLoader;
    private String jarName = "install.jar";
    private boolean fileNamesOnly;
    public static final String INSTALLATION_DIR = "installedPath";
    public static final String INSTALLATION_VERSION = "installedVersion";
    private static final String MANIFEST_VERSION_ATTR = "Implementation-Version";
    private static final String META_INF_DIR = "META-INF/";
    public static final int IO_ERROR = -1;
    public static final int NO_INSTALL = 0;
    public static final int INSTALL_NEW = 1;
    public static final int UPDATE_EXISTING = 2;

    public JARInstaller(BaseConfig config, String propertyPrefix, ClassLoader classLoader) {
        this.config = config;
        this.propertyPrefix = propertyPrefix;
        this.classLoader = classLoader;
    }

    public JARInstaller(BaseConfig config, String propertyPrefix, ClassLoader classLoader, String jarName) {
        this.config = config;
        this.propertyPrefix = propertyPrefix;
        this.classLoader = classLoader;
        this.jarName = jarName;
    }

    public JARInstaller(BaseConfig config, String propertyPrefix, ClassLoader classLoader, String jarName, boolean fileNamesOnly) {
        this.config = config;
        this.propertyPrefix = propertyPrefix;
        this.classLoader = classLoader;
        this.jarName = jarName;
        this.fileNamesOnly = fileNamesOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int needInstallation() {
        InputStream is = this.classLoader.getResourceAsStream(this.jarName);
        if (is == null) {
            return 0;
        }
        try {
            JarInputStream jis = new JarInputStream(is, false);
            Manifest manifest = jis.getManifest();
            String version = this.getVersion(manifest);
            if (version == null) {
                System.err.println("No manifest/version info in " + this.jarName + " -> no installation");
                int n2 = 0;
                return n2;
            }
            String installed = this.config.get(this.propertyPrefix + INSTALLATION_VERSION, null);
            File installDir = this.getInstallationDirectory();
            if (installed == null || installDir == null || !installDir.exists()) {
                int n3 = 1;
                return n3;
            }
            if (version.compareTo(installed) != 0) {
                System.out.println("Installation files version is '" + installed + "', available is '" + version + "', requesting update...");
                int n4 = 2;
                return n4;
            }
            int n5 = 0;
            return n5;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int n6 = -1;
            return n6;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    public File getInstallationDirectory() {
        String installDir = this.config.get(this.propertyPrefix + INSTALLATION_DIR, null);
        if (installDir == null) {
            return null;
        }
        return new File(installDir);
    }

    private String getVersion(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue(MANIFEST_VERSION_ATTR);
    }

    public boolean install(File installPath, ProgressCallback progress, ConfirmCallback confirmCallback) {
        InputStream is = this.classLoader.getResourceAsStream(this.jarName);
        return this.install(is, installPath, progress, confirmCallback);
    }

    /*
     * Exception decompiling
     */
    public boolean install(InputStream is, File installPath, ProgressCallback progress, ConfirmCallback confirmCallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public String getJarName() {
        return this.jarName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] computeSHA256(InputStream is) {
        byte[] buffer = new byte[65535];
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        try {
            try {
                int read;
                while ((read = is.read(buffer)) != -1) {
                    md.update(buffer, 0, read);
                }
            }
            catch (IOException ex1) {
                byte[] byArray = null;
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return byArray;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return md.digest();
    }
}

