/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.log;

import com.agentpp.common.PropertiesEditor;
import com.agentpp.common.log.AppenderConfigPanel;
import com.agentpp.common.log.CategoryTreeCellRenderer;
import com.agentpp.common.log.LogAppender;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogPreferencesPanel
extends JPanel
implements TreeSelectionListener,
ItemListener {
    public static final String CFG_MAX_LOG_RECORDS = "com.agentpp.log.maxrecords";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelCenter = new JPanel();
    JPanel jPanelNorth = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelMaxRecords = new JLabel();
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    private UserConfigFile config;
    private String[] categories;
    GridLayout gridLayout1 = new GridLayout();
    JCSpinField maxRecords = new JCSpinField();
    JSplitPane jSplitPane = new JSplitPane();
    JTree tree = new JTree();
    JScrollPane jScrollPane = new JScrollPane();
    JComboBox jComboBoxPriority = new JComboBox();
    JLabel jLabelPriority = new JLabel();
    JLabel jLabelChainedPriority = new JLabel();
    JTextField jTextFieldCategory = new JTextField();
    JLabel jLabelCategory = new JLabel();
    JTextField jTextFieldChainedPriority = new JTextField();
    JPanel jPanelSettings = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel jPanel1 = new JPanel();
    private AppenderConfigPanel appenderConfigPanel1;
    private BorderLayout borderLayout2 = new BorderLayout();
    private Border border5;
    private TitledBorder titledBorder3;
    private LogAppender localAppender;
    private boolean enableExtendedLogging = true;

    public LogPreferencesPanel() {
        this.appenderConfigPanel1 = new AppenderConfigPanel(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LogPreferencesPanel(UserConfigFile config, String[] categories, LogAppender appender) {
        this(config, categories, appender, true);
    }

    public LogPreferencesPanel(UserConfigFile config, String[] categories, LogAppender appender, boolean extendedLogging) {
        this.config = config;
        this.categories = categories;
        this.localAppender = appender;
        this.enableExtendedLogging = extendedLogging;
        this.appenderConfigPanel1 = new AppenderConfigPanel(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jComboBoxPriority.addItem("none");
        this.jComboBoxPriority.addItem(Level.OFF);
        this.jComboBoxPriority.addItem(Level.FATAL);
        this.jComboBoxPriority.addItem(Level.ERROR);
        this.jComboBoxPriority.addItem(Level.WARN);
        this.jComboBoxPriority.addItem(Level.INFO);
        this.jComboBoxPriority.addItem(Level.DEBUG);
        this.load();
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(new CategoryTreeCellRenderer());
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.jComboBoxPriority.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        if (e2.getStateChange() == 1) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (n2 == null) {
                return;
            }
            Logger c2 = (Logger)n2.getUserObject();
            if (e2.getItem() instanceof String) {
                if (c2.getRootLogger().equals(c2)) {
                    c2.setLevel(Level.FATAL);
                } else {
                    c2.setLevel(null);
                }
            } else {
                c2.setLevel((Level)e2.getItem());
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        TreePath p2 = e2.getNewLeadSelectionPath();
        if (p2 == null) {
            this.jTextFieldCategory.setText(null);
            this.jComboBoxPriority.setEnabled(false);
            this.jComboBoxPriority.setSelectedIndex(0);
            return;
        }
        DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)p2.getLastPathComponent();
        Category c2 = (Category)n2.getUserObject();
        this.jTextFieldCategory.setText(c2.getName());
        this.jTextFieldChainedPriority.setText(c2.getEffectiveLevel().toString());
        if (c2.getLevel() != null) {
            this.jComboBoxPriority.setSelectedItem(c2.getLevel());
        } else {
            this.jComboBoxPriority.setSelectedItem("none");
        }
        this.jComboBoxPriority.setEnabled(true);
    }

    private void buildRoot() {
        if (this.root != null) {
            this.root.removeAllChildren();
        }
        this.root = new DefaultMutableTreeNode(Logger.getRootLogger());
        this.treeModel = new DefaultTreeModel(this.root, false);
        this.tree.setModel(this.treeModel);
        this.tree.treeDidChange();
    }

    private String pathToString(Vector path) {
        StringBuffer buf = new StringBuffer();
        Enumeration en = path.elements();
        while (en.hasMoreElements()) {
            buf.append(en.nextElement());
            if (!en.hasMoreElements()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private void addPath(Vector path, String category, DefaultMutableTreeNode parent) {
        boolean found = false;
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)en.nextElement();
            if (!((Category)n2.getUserObject()).getName().endsWith(path.firstElement().toString())) continue;
            found = true;
            path.removeElementAt(0);
            if (path.size() <= 0) break;
            this.addPath(path, category, n2);
            break;
        }
        if (!found) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(Logger.getLogger(category));
            this.treeModel.insertNodeInto(child, parent, parent.getChildCount());
        }
    }

    public void load() {
        this.buildRoot();
        for (int i2 = 0; i2 < this.categories.length; ++i2) {
            String s = this.categories[i2];
            StringTokenizer st = new StringTokenizer(s, ".");
            Vector<String> path = new Vector<String>(st.countTokens() + 1);
            while (st.hasMoreTokens()) {
                path.addElement(st.nextToken());
            }
            this.addPath(path, s, this.root);
        }
        Hashtable h2 = PropertiesEditor.filterProperties(this.config.properties);
        PropertyConfigurator.configure(this.config.properties);
        this.config.properties.putAll((Map<?, ?>)h2);
        if (this.config.get("log4j.rootCategory", null) == null && this.config.get("log4j.rootLogger", null) == null) {
            Logger.getRootLogger().setLevel(Level.OFF);
        }
        this.maxRecords.setValue(new Integer(this.config.get(CFG_MAX_LOG_RECORDS, "100")));
        this.appenderConfigPanel1.setConfig(this.config);
        this.appenderConfigPanel1.load();
    }

    public int getMaxLogRecords() {
        return ((Number)this.maxRecords.getValue()).intValue();
    }

    public void reloadConfiguration() {
        BasicConfigurator.resetConfiguration();
        Hashtable h2 = PropertiesEditor.filterProperties(this.config.properties);
        PropertyConfigurator.configure(this.config.properties);
        this.config.properties.putAll((Map<?, ?>)h2);
        Logger.getRootLogger().addAppender(this.localAppender);
    }

    public void cancel() {
        this.reloadConfiguration();
    }

    public void save() {
        String oldRoot = this.config.get("log4j.rootCategory", null);
        if (oldRoot == null) {
            oldRoot = this.config.get("log4j.rootLogger", "");
        }
        oldRoot = oldRoot.indexOf(44) >= 0 ? oldRoot.substring(oldRoot.indexOf(44)) : "";
        if (this.appenderConfigPanel1 != null) {
            oldRoot = this.appenderConfigPanel1.updateAppenderConfig("root", oldRoot);
        }
        this.config.put("log4j.rootLogger", Logger.getRootLogger().getLevel().toString() + oldRoot);
        this.config.remove("log4j.rootCategory");
        Enumeration<TreeNode> en = this.root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            String old;
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)en.nextElement();
            Category c2 = (Category)n2.getUserObject();
            if (c2.getName().equals("root")) continue;
            if (c2.getLevel() == null) {
                old = this.appenderConfigPanel1.updateAppenderConfig(c2.getName(), "");
                if (old.length() == 0) {
                    this.config.put("log4j.logger." + c2.getName(), null);
                    continue;
                }
                this.config.put("log4j.logger." + c2.getName(), "INHERITED" + old);
                continue;
            }
            old = this.config.get("log4j.logger." + c2.getName(), "");
            old = old.indexOf(44) >= 0 ? old.substring(old.indexOf(44)) : "";
            old = this.appenderConfigPanel1.updateAppenderConfig(c2.getName(), old);
            this.config.put("log4j.logger." + c2.getName(), c2.getLevel().toString() + old);
        }
        this.config.put(CFG_MAX_LOG_RECORDS, "" + this.maxRecords.getValue());
        this.appenderConfigPanel1.save();
        this.reloadConfiguration();
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Categories");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border3 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border3, "Output Properties");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border5 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder3 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "External Logging");
        this.setLayout(this.borderLayout1);
        this.jPanelCenter.setLayout(this.gridLayout1);
        this.jPanelCenter.setBorder(this.border2);
        this.jPanelNorth.setBorder(this.border4);
        this.jPanelNorth.setLayout(this.gridBagLayout2);
        this.jLabelMaxRecords.setText("Maximum number of log records:");
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(5);
        this.maxRecords.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(0), new Integer(Integer.MAX_VALUE), null, false, null, new Integer(10), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(100)), new MutableValueModel(Integer.class, new Integer("100")), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.jLabelPriority.setText("Assigned Priority:");
        this.jLabelChainedPriority.setText("Inherited Priority:");
        this.jTextFieldCategory.setEnabled(false);
        this.jTextFieldCategory.setEditable(false);
        this.jTextFieldCategory.setColumns(20);
        this.jLabelCategory.setText("Category:");
        this.jTextFieldChainedPriority.setEnabled(false);
        this.jTextFieldChainedPriority.setToolTipText("Shows the priority inherited from parent nodes on the path to the root category");
        this.jPanelSettings.setLayout(this.gridBagLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder3);
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jSplitPane, null);
        this.jSplitPane.add((Component)this.jScrollPane, "left");
        this.jSplitPane.add((Component)this.jPanelSettings, "right");
        this.jPanelSettings.add((Component)this.jLabelCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldCategory, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelPriority, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jComboBoxPriority, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelChainedPriority, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldChainedPriority, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jScrollPane.getViewport().add((Component)this.tree, null);
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jLabelMaxRecords, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.jPanelNorth.add((Component)this.maxRecords, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        if (this.isEnableExtendedLogging()) {
            this.add((Component)this.jPanel1, "South");
            this.jPanel1.add((Component)this.appenderConfigPanel1, "Center");
        }
        this.jSplitPane.setDividerLocation(150);
    }

    public void setLocalAppender(LogAppender localAppender) {
        this.localAppender = localAppender;
    }

    public LogAppender getLocalAppender() {
        return this.localAppender;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public Integer getCategoryOfAppender(String appender) {
        String c2 = this.config.get("log4j.rootLogger", null);
        for (int i2 = -1; i2 < this.categories.length; ++i2) {
            if (i2 >= 0) {
                c2 = this.config.get("log4j.logger." + this.categories[i2], null);
            }
            if (c2 == null) continue;
            StringTokenizer st = new StringTokenizer(c2, ",", false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().trim().equals(appender)) continue;
                return new Integer(i2);
            }
        }
        return null;
    }

    public boolean isEnableExtendedLogging() {
        return this.enableExtendedLogging;
    }
}

