/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.help;

import com.agentpp.common.help.Browser;
import com.agentpp.common.help.HelpViewer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowListener;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;

public class HelpViewerJFX
implements HelpViewer {
    static final LogAdapter LOGGER = LogFactory.getLogger(HelpViewerJFX.class);
    private String frameTitle;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private String[] urls;
    private JFrame frame;
    private String toolBarColor = "#666970";
    private String toolBarStylesheet = "com/agentpp/common/help/BrowserToolbar.css";

    public HelpViewerJFX(String frameTitle, int posX, int posY, int width, int height, String[] urls) {
        this.frameTitle = frameTitle;
        this.width = width;
        this.height = height;
        this.posX = posX;
        this.posY = posY;
        this.urls = urls;
    }

    @Override
    public void initAndShowGUI(WindowListener windowListener) {
        this.frame = new JFrame(this.frameTitle);
        this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        final JFXPanel fxPanel = new JFXPanel();
        this.frame.add((Component)fxPanel);
        this.frame.setPreferredSize(new Dimension(this.width, this.height));
        this.frame.setLocation(this.posX, this.posY);
        this.frame.pack();
        this.frame.setVisible(true);
        if (windowListener != null) {
            this.frame.removeWindowListener(windowListener);
            this.frame.addWindowListener(windowListener);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HelpViewerJFX.this.initFX(fxPanel);
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.frame != null;
    }

    private void initFX(JFXPanel fxPanel) {
        Scene scene = this.createScene();
        fxPanel.setScene(scene);
    }

    @Override
    public String getToolBarColor() {
        return this.toolBarColor;
    }

    @Override
    public void setToolBarColor(String toolBarColor) {
        this.toolBarColor = toolBarColor;
    }

    @Override
    public String getToolBarStylesheet() {
        return this.toolBarStylesheet;
    }

    @Override
    public void setToolBarStylesheet(String toolBarStylesheet) {
        this.toolBarStylesheet = toolBarStylesheet;
    }

    public Scene createScene() {
        Scene scene = new Scene((Parent)new Browser(this.urls), (double)this.width, (double)this.height, (Paint)Color.web((String)this.toolBarColor));
        scene.getStylesheets().add((Object)this.toolBarStylesheet);
        return scene;
    }

    @Override
    public Point getLocation() {
        return this.frame.getLocation();
    }

    @Override
    public Dimension getSize() {
        return this.frame.getSize();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpViewerJFX helpViewer = new HelpViewerJFX("Help Viewer", 50, 50, 950, 750, new String[]{"index.htm"});
                helpViewer.initAndShowGUI(null);
            }
        });
    }
}

