/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.help;

import com.agentpp.common.help.HelpViewerJFX;
import com.agentpp.common.help.JavaBridge;
import java.io.Serializable;
import java.net.URL;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;

class Browser
extends Region {
    private final HBox toolBar;
    final WebView browser = new WebView();
    final WebEngine webEngine = this.browser.getEngine();
    final ComboBox comboBox = new ComboBox();

    public Browser(String[] urls) {
        this.getStyleClass().add((Object)"browser");
        this.comboBox.setPrefWidth(60.0);
        this.toolBar = new HBox();
        this.toolBar.setAlignment(Pos.CENTER);
        this.toolBar.getStyleClass().add((Object)"browser-toolbar");
        this.toolBar.getChildren().add((Object)this.comboBox);
        this.toolBar.getChildren().add((Object)this.createSpacer());
        WebHistory history = this.webEngine.getHistory();
        history.getEntries().addListener(c2 -> {
            c2.next();
            c2.getRemoved().stream().forEach(e2 -> this.comboBox.getItems().remove((Object)e2.getUrl()));
            c2.getAddedSubList().stream().forEach(e2 -> this.comboBox.getItems().add((Object)e2.getUrl()));
        });
        this.comboBox.setOnAction(ev -> {
            int offset = this.comboBox.getSelectionModel().getSelectedIndex() - history.getCurrentIndex();
            history.go(offset);
        });
        this.webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            JSObject window = (JSObject)this.webEngine.executeScript("window");
            JavaBridge bridge = new JavaBridge();
            window.setMember("java", bridge);
            this.webEngine.executeScript("console.log = function(message)\n{\n    java.log(message);\n};");
        });
        for (String url : urls) {
            try {
                if (url.startsWith("https:") || url.startsWith("file:")) {
                    this.webEngine.load(url);
                    break;
                }
                URL resource = HelpViewerJFX.class.getResource(url);
                if (resource == null) {
                    System.err.println("Help resource '" + url + "' not found");
                    continue;
                }
                this.webEngine.load(resource.toExternalForm());
                break;
            }
            catch (Exception ex) {
                HelpViewerJFX.LOGGER.debug((Serializable)((Object)("Failed to load help URL '" + url + "': " + ex.getMessage())));
            }
        }
        this.getChildren().add((Object)this.toolBar);
        this.getChildren().add((Object)this.browser);
    }

    private Node createSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h2 = this.getHeight();
        double tbHeight = this.toolBar.prefHeight(w);
        this.layoutInArea((Node)this.browser, 0.0, 0.0, w, h2 - tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea((Node)this.toolBar, 0.0, h2 - tbHeight, w, tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }
}

