/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.grid;

import com.klg.jclass.higrid.GridScrollbar;
import com.klg.jclass.higrid.HiGrid;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class GridMouseWheelListener
implements MouseWheelListener {
    protected HiGrid grid;

    public GridMouseWheelListener(HiGrid grid) {
        this.grid = grid;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (e2.getScrollType() == 1) {
            int direction = e2.getWheelRotation() > 0 ? 1 : -1;
            this.scrollByBlock(this.grid.getVerticalScrollbar(), direction);
        } else {
            this.scrollByUnits(this.grid.getVerticalScrollbar(), e2.getUnitsToScroll());
        }
    }

    protected void scrollByBlock(GridScrollbar scrollBar, int direction) {
        int newValue = scrollBar.getValue() + scrollBar.getBlockIncrement() * direction;
        if (newValue >= scrollBar.getMinimum() && newValue <= scrollBar.getMaximum()) {
            scrollBar.setValue(newValue);
        }
    }

    protected void scrollByUnits(GridScrollbar scrollBar, int units) {
        int newValue = scrollBar.getValue() + scrollBar.getUnitIncrement() * units;
        if (newValue >= scrollBar.getMinimum() && newValue <= scrollBar.getMaximum()) {
            scrollBar.setValue(newValue);
        }
    }

    public void setTable(HiGrid grid) {
        this.grid = grid;
    }

    public HiGrid getTable() {
        return this.grid;
    }
}

