/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.exec;

import com.agentpp.common.exec.ProcessEvent;
import com.agentpp.common.exec.ProcessListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ProcessReader
extends Thread {
    private Process p;
    public StringBuffer stdout = new StringBuffer();
    public StringBuffer stderr = new StringBuffer();
    public volatile boolean stop = false;
    private transient Vector processListeners;

    public ProcessReader(Process p2) {
        this.p = p2;
    }

    @Override
    public void run() {
        try {
            InputStream is = this.p.getInputStream();
            InputStream es = this.p.getErrorStream();
            while (!this.stop || is.available() > 0 || es.available() > 0) {
                byte[] b2;
                int l2;
                if (is.available() > 0 && (l2 = is.read(b2 = new byte[is.available()])) > 0) {
                    this.stdout.append(new String(b2, 0, l2));
                    this.fireProcessUpdate(new ProcessEvent(this, 0, this.stdout, this.stdout.length() - l2, l2));
                }
                if (es.available() > 0 && (l2 = es.read(b2 = new byte[es.available()])) > 0) {
                    this.stderr.append(new String(b2, 0, l2));
                    this.fireProcessUpdate(new ProcessEvent(this, 1, this.stderr, this.stderr.length() - l2, l2));
                }
                if (this.stop) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void removeProcessListener(ProcessListener l2) {
        if (this.processListeners != null && this.processListeners.contains(l2)) {
            Vector v = (Vector)this.processListeners.clone();
            v.removeElement(l2);
            this.processListeners = v;
        }
    }

    public synchronized void addProcessListener(ProcessListener l2) {
        Vector v;
        Vector vector = v = this.processListeners == null ? new Vector(2) : (Vector)this.processListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.processListeners = v;
        }
    }

    protected void fireProcessUpdate(ProcessEvent e2) {
        if (this.processListeners != null) {
            Vector listeners = this.processListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ProcessListener)listeners.elementAt(i2)).processUpdate(e2);
            }
        }
    }
}

