/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.base.io;

import com.agentpp.common.base.io.StreamEvent;
import com.agentpp.common.base.io.StreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class MonitoredInputStream
extends InputStream {
    private InputStream inputStream;
    private transient Vector streamListeners;

    public MonitoredInputStream() {
    }

    public MonitoredInputStream(InputStream is) {
        this.inputStream = is;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.fireStreamEvent(new StreamEvent(this, -2L));
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        int i2 = this.inputStream.read();
        this.fireStreamEvent(new StreamEvent(this, 1L));
        return i2;
    }

    @Override
    public int read(byte[] b2, int offset, int len) throws IOException {
        int i2 = this.inputStream.read(b2, offset, len);
        this.fireStreamEvent(new StreamEvent(this, i2));
        return i2;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int i2 = this.inputStream.read(b2);
        this.fireStreamEvent(new StreamEvent(this, i2));
        return i2;
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
        this.fireStreamEvent(new StreamEvent(this, -1L));
    }

    @Override
    public long skip(long n2) throws IOException {
        long s = this.inputStream.skip(n2);
        this.fireStreamEvent(new StreamEvent(this, n2));
        return s;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public synchronized void removeStreamListener(StreamListener l2) {
        if (this.streamListeners != null && this.streamListeners.contains(l2)) {
            Vector v = (Vector)this.streamListeners.clone();
            v.removeElement(l2);
            this.streamListeners = v;
        }
    }

    public synchronized void addStreamListener(StreamListener l2) {
        Vector v;
        Vector vector = v = this.streamListeners == null ? new Vector(2) : (Vector)this.streamListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.streamListeners = v;
        }
    }

    protected void fireStreamEvent(StreamEvent e2) {
        if (this.streamListeners != null) {
            Vector listeners = this.streamListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((StreamListener)listeners.elementAt(i2)).streamEvent(e2);
            }
        }
    }
}

