/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.base.io;

import java.io.File;
import java.text.DecimalFormat;

public class FileHistory {
    private DecimalFormat df = new DecimalFormat("000");

    public final void addFile2History(File file, int maxHistoryFiles) {
        if (maxHistoryFiles <= 0) {
            return;
        }
        this.moveAway(file, 1, maxHistoryFiles);
        File d2 = this.getHistoryFileName(file, 1);
        file.renameTo(d2);
    }

    private boolean moveAway(File file, int index, int maxIndex) {
        File f2 = this.getHistoryFileName(file, index);
        if (f2.exists()) {
            if (index >= maxIndex) {
                f2.delete();
            } else {
                this.moveAway(file, index + 1, maxIndex);
                File d2 = this.getHistoryFileName(file, index + 1);
                f2.renameTo(d2);
            }
            return true;
        }
        return false;
    }

    private File getHistoryFileName(File file, int index) {
        String suffix = this.df.format(index);
        File f2 = new File(file.getParentFile(), file.getName() + "." + suffix);
        return f2;
    }
}

