/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.base.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteFilterInputStream
extends InputStream {
    private static final byte[] prefixAbstractDataSource = new String("com.klg.jclass.table.data.AbstractDataSource").getBytes();
    private static final byte[] oldSerialVersionUID = new byte[]{124, -81, 108, -20, 114, 114, 64, -96};
    private static final byte[] newSerialVersionUID = new byte[]{62, 71, -114, -96, 1, 17, -30, 17};
    public static byte[] serialVersionUIDPatternLiveTable5 = new byte[prefixAbstractDataSource.length + oldSerialVersionUID.length];
    public static byte[] serialVersionUIDPatternLiveTable62;
    private InputStream inputStream;
    private byte[] buffer;
    private byte[] searchPattern;
    private byte[] replacement;
    private int count = 0;

    public ByteFilterInputStream(InputStream is, byte[] searchPattern, byte[] replacement) {
        this.inputStream = is;
        this.buffer = new byte[searchPattern.length + replacement.length];
        this.searchPattern = searchPattern;
        this.replacement = replacement;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available() + this.count;
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    private boolean fillBuffer() throws IOException {
        int read = this.inputStream.read(this.buffer, this.count, this.buffer.length - this.count);
        if (read < 0) {
            return false;
        }
        this.count += read;
        return true;
    }

    private boolean replaceBuffer() {
        boolean matched = true;
        for (int j2 = 0; j2 < this.count - this.searchPattern.length; ++j2) {
            for (int i2 = 0; i2 < this.searchPattern.length; ++i2) {
                if (this.buffer[j2 + i2] == this.searchPattern[i2]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            System.arraycopy(this.replacement, 0, this.buffer, j2, this.replacement.length);
            this.count += this.replacement.length - this.searchPattern.length;
            if (this.replacement.length >= this.searchPattern.length) continue;
            System.arraycopy(this.buffer, this.searchPattern.length + j2, this.buffer, this.replacement.length, this.replacement.length - this.searchPattern.length);
        }
        return matched;
    }

    private int readBuffer(byte[] buf, int pos, int len) throws IOException {
        if (this.count < len && !this.fillBuffer()) {
            return -1;
        }
        if (this.count < len) {
            len = this.count;
        }
        this.replaceBuffer();
        System.arraycopy(this.buffer, 0, buf, pos, len);
        if (this.count - len > 0) {
            System.arraycopy(this.buffer, len, this.buffer, 0, this.count - len);
        }
        this.count -= len;
        return len;
    }

    @Override
    public int read() throws IOException {
        byte[] b2 = new byte[1];
        if (this.readBuffer(b2, 0, 1) < 1) {
            return -1;
        }
        return b2[0];
    }

    @Override
    public int read(byte[] b2, int offset, int len) throws IOException {
        int i2 = this.readBuffer(b2, offset, len);
        return i2;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int i2 = this.readBuffer(b2, 0, b2.length);
        return i2;
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
        this.count = 0;
    }

    @Override
    public long skip(long n2) throws IOException {
        if (n2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value n for FilterInputStream.skip(n) too large: " + n2);
        }
        byte[] b2 = new byte[(int)n2];
        long s = this.read(b2);
        return s;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    static {
        System.arraycopy(prefixAbstractDataSource, 0, serialVersionUIDPatternLiveTable5, 0, prefixAbstractDataSource.length);
        System.arraycopy(oldSerialVersionUID, 0, serialVersionUIDPatternLiveTable5, prefixAbstractDataSource.length, oldSerialVersionUID.length);
        serialVersionUIDPatternLiveTable62 = new byte[prefixAbstractDataSource.length + newSerialVersionUID.length];
        System.arraycopy(prefixAbstractDataSource, 0, serialVersionUIDPatternLiveTable62, 0, prefixAbstractDataSource.length);
        System.arraycopy(newSerialVersionUID, 0, serialVersionUIDPatternLiveTable62, prefixAbstractDataSource.length, newSerialVersionUID.length);
    }
}

