/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.Regex;
import com.agentpp.util.ThreadPool;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SearchMIBRepository
extends JPanel
implements Runnable,
JCCellDisplayListener {
    private static final String[] COLUMNS = new String[]{"MIB Module", "Object Name", "OID", "Type"};
    private static final int COL_OID = 2;
    private static final int COL_NAME = 1;
    private static final int COL_MODULE = 0;
    private SearchConfig searchPanel;
    private Regex regex;
    private String moduleScope = null;
    private JFrame myFrame;
    private RepositoryManager repositoryManager;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanelResult = new JPanel();
    private JPanel jPanelProgress = new JPanel();
    private JProgressBar progressBar = new JProgressBar();
    private JLabel jLabelSearchProgress = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ExtendedListTable table = new ExtendedListTable();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JCVectorDataSource model = new JCVectorDataSource();
    public volatile boolean cancel = false;
    private JLabel jLabelSearch = new JLabel();
    private JLabel current = new JLabel();
    private int matches = 0;
    private JLabel jLabelMatches = new JLabel();
    private JLabel found = new JLabel();
    private Runnable finishCallback;
    private boolean useSwingInvokeLater = true;

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel) {
        this(frame, repMan, searchExpression, searchPanel, null);
    }

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel, String moduleScope) {
        this.myFrame = frame;
        this.repositoryManager = repMan;
        this.searchPanel = searchPanel;
        this.regex = searchExpression;
        this.moduleScope = moduleScope;
        this.model.setNumColumns(COLUMNS.length);
        this.model.setColumnLabels(COLUMNS);
        this.model.setNumRows(10);
        this.table.setDataSource(this.model);
        this.table.setPopupMenuEnabled(false);
        this.table.setCharWidth(-1, 5);
        this.table.setTraverseCycle(false);
        this.table.addCellDisplayListener(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFinishCallback(Runnable finishCallback) {
        this.finishCallback = finishCallback;
    }

    public void setUseSwingInvokeLater(boolean invokeLater) {
        this.useSwingInvokeLater = invokeLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadPool threadPool = ThreadPool.create("SearchMIBRepository", Runtime.getRuntime().availableProcessors());
        this.matches = 0;
        this.model.setNumRows(0);
        Object[] modules = null;
        try {
            modules = this.repositoryManager.getModuleNames();
        }
        catch (IOException ex) {
            this.current.setText("Failed to access MIB repository: " + ex.getMessage());
            return;
        }
        this.progressBar.setMaximum(0);
        this.progressBar.setMaximum(modules.length - 1);
        this.progressBar.setStringPainted(true);
        Arrays.sort(modules);
        for (int i2 = 0; i2 < modules.length && !this.cancel; ++i2) {
            this.current.setText((String)modules[i2]);
            this.progressBar.setValue(i2);
            Object moduleName = modules[i2];
            threadPool.execute(new Runnable((String)moduleName){
                final /* synthetic */ String val$moduleName;
                {
                    this.val$moduleName = string;
                }

                @Override
                public void run() {
                    try {
                        MIBObject[] objects = SearchMIBRepository.this.repositoryManager.getObjects(this.val$moduleName);
                        MIBRepository rep = new MIBRepository(objects);
                        objects = SearchMIBRepository.this.repositoryManager.getImportedObjects(this.val$moduleName);
                        rep.addAllObjects(objects);
                        SearchMIBRepository.this.searchMIBRepository(this.val$moduleName, rep);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            });
        }
        while (!threadPool.isIdle()) {
            try {
                ThreadPool threadPool2 = threadPool;
                synchronized (threadPool2) {
                    threadPool.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        threadPool.stop();
        this.current.setText("Search complete!");
        if (this.finishCallback != null) {
            if (this.useSwingInvokeLater) {
                SwingUtilities.invokeLater(this.finishCallback);
            } else {
                this.finishCallback.run();
            }
        }
    }

    public TreeMap getSelectedObjects() {
        int[] rows = TableUtils.getSelectedRows(this.table);
        TreeMap<Object, Object> h2 = new TreeMap<Object, Object>();
        for (int i2 = 0; i2 < rows.length; ++i2) {
            h2.put(this.model.getTableDataItem(rows[i2], 1), this.model.getTableDataItem(rows[i2], 0));
        }
        return h2;
    }

    public int getMatchCount() {
        return this.model.getNumRows();
    }

    private synchronized boolean matchObject(MIBRepository rep, Regex expression, MIBObject o2, boolean[] flags) {
        MIBModule module;
        if (flags[0] && (module = rep.getModule(o2.getModuleID())) != null && expression.match(o2.toSMI(1, module.getSMIVersion(), rep, "\n"))) {
            return true;
        }
        if ((flags[0] || flags[2]) && o2.getName() != null && expression.match(o2.getName())) {
            return true;
        }
        if ((flags[0] || flags[1]) && o2.getOid() != null && expression.match(o2.getOid().toString())) {
            return true;
        }
        if ((flags[0] || flags[3]) && o2.getDescription() != null && expression.match(o2.getDescription())) {
            return true;
        }
        if (flags[0] || flags.length > 4 && flags[4]) {
            List refs = this.getReferences(rep, o2);
            for (String ref : refs) {
                if (!expression.match(ref)) continue;
                return true;
            }
        }
        return false;
    }

    private List getReferences(MIBRepository rep, MIBObject o2) {
        LinkedList<String> refs;
        block10: {
            MIBAgentCaps ac;
            block11: {
                block9: {
                    refs = new LinkedList<String>();
                    if (!(o2 instanceof MIBModule)) break block9;
                    MIBModule m2 = (MIBModule)o2;
                    if (!m2.hasImports()) break block10;
                    for (int i2 = 0; i2 < m2.getImportsVector().size(); ++i2) {
                        MIBImport imp = m2.getImportsVector().get(i2);
                        if (this.moduleScope != null && !imp.getSource().equals(this.moduleScope)) continue;
                        refs.addAll(imp.getImportsVector());
                    }
                    break block10;
                }
                if (!(o2 instanceof MIBCompliance)) break block11;
                MIBCompliance c2 = (MIBCompliance)o2;
                if (c2.getModules() == null) break block10;
                for (MIBComplianceModule cm : c2.getModules()) {
                    String moduleName = cm.getModuleName();
                    if (!cm.hasModuleName()) {
                        moduleName = rep.getModuleName(o2.getModuleID());
                    }
                    if (this.moduleScope != null && !moduleName.equals(this.moduleScope)) continue;
                    if (cm.hasMandatory()) {
                        refs.addAll(cm.getMandatoryVector());
                    }
                    if (!cm.hasVariations()) continue;
                    for (MIBVariation var : cm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
                break block10;
            }
            if (o2 instanceof MIBAgentCaps && (ac = (MIBAgentCaps)o2).getModules() != null) {
                for (MIBSupportedModule sm : ac.getModules()) {
                    String moduleName = sm.getSupports();
                    if (sm.getSupports() == null) {
                        moduleName = rep.getModuleName(o2.getModuleID());
                    }
                    if (this.moduleScope != null && !moduleName.equals(this.moduleScope) || !sm.hasVariations()) continue;
                    for (MIBVariation var : sm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchMIBRepository(String moduleName, MIBRepository rep) {
        Integer moduleID = null;
        if (rep.getModule(moduleName) != null) {
            moduleID = rep.getModule(moduleName).getModuleID();
        }
        Enumeration<? extends MIBObject> en = rep.objectsByName();
        while (en.hasMoreElements()) {
            MIBObject o2 = en.nextElement();
            if (!o2.getModuleID().equals(moduleID) || !this.matchObject(rep, this.regex, o2, this.searchPanel.getSearchOptions())) continue;
            ++this.matches;
            if (this.matches == 1) {
                this.found.setText("" + this.matches + " match.");
            } else {
                this.found.setText("" + this.matches + " matches.");
            }
            final Vector<Object> row = new Vector<Object>();
            row.add(moduleName);
            row.add(o2);
            row.add(o2.getOid());
            row.add(o2.getTypeString());
            if (this.useSwingInvokeLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchMIBRepository.this.model.addRow(Integer.MAX_VALUE, new Integer(SearchMIBRepository.this.model.getNumRows() + 1), row);
                    }
                });
                continue;
            }
            JCVectorDataSource jCVectorDataSource = this.model;
            synchronized (jCVectorDataSource) {
                this.model.addRow(Integer.MAX_VALUE, new Integer(this.model.getNumRows() + 1), row);
            }
        }
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public SearchMIBRepository() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabelSearchProgress.setText("Progress:");
        this.jPanelProgress.setLayout(this.gridBagLayout1);
        this.progressBar.setStringPainted(true);
        this.jPanelResult.setLayout(this.borderLayout2);
        this.jLabelSearch.setText("Searching:");
        this.jLabelMatches.setText("Found:");
        this.found.setText("0 matches.");
        this.add((Component)this.jPanelResult, "Center");
        this.jPanelResult.add((Component)this.table, "Center");
        this.add((Component)this.jPanelProgress, "North");
        this.jPanelProgress.add((Component)this.jLabelSearchProgress, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelProgress.add((Component)this.progressBar, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.jPanelProgress.add((Component)this.jLabelSearch, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelProgress.add((Component)this.current, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelProgress.add((Component)this.jLabelMatches, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.jPanelProgress.add((Component)this.found, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent e2) {
        if (e2.getColumn() == 1 && e2.getCellData() instanceof MIBObject) {
            MIBObject o2 = (MIBObject)e2.getDisplayData();
            e2.setDisplayData(o2.getName());
        }
    }
}

